var fetchinterceptor = (function() {
  "use strict";
  function defineUnlistedScript(arg) {
    if (arg == null || typeof arg === "function") return { main: arg };
    return arg;
  }
  const definition = defineUnlistedScript(() => {
    console.log("[LazyFrog] Installing fetch interceptor in page context");
    const originalFetch = window.fetch;
    window.fetch = async function(...args) {
      const [resource, config] = args;
      const url = typeof resource === "string" ? resource : resource instanceof Request ? resource.url : resource.toString();
      if (url.includes("CustomPost/RenderPostContent")) {
        let headers = config?.headers || {};
        if (headers instanceof Headers) {
          const plainHeaders = {};
          headers.forEach((value, key) => {
            plainHeaders[key] = value;
          });
          headers = plainHeaders;
        }
        const postId = headers["devvit-post"];
        const response = await originalFetch.apply(this, args);
        const clonedResponse = response.clone();
        if (postId) {
          clonedResponse.arrayBuffer().then((buffer) => {
            window.dispatchEvent(
              new CustomEvent("autosupper:raw-mission-data", {
                detail: {
                  postId,
                  arrayBuffer: buffer
                }
              })
            );
          }).catch((err) => {
            console.error("[LazyFrog] Failed to get response buffer:", err);
          });
        }
        return response;
      }
      return originalFetch.apply(this, args);
    };
    console.log("[LazyFrog] Fetch interceptor installed successfully");
  });
  function initPlugins() {
  }
  function print(method, ...args) {
    return;
  }
  const logger = {
    debug: (...args) => print(console.debug, ...args),
    log: (...args) => print(console.log, ...args),
    warn: (...args) => print(console.warn, ...args),
    error: (...args) => print(console.error, ...args)
  };
  const result = (async () => {
    try {
      initPlugins();
      return await definition.main();
    } catch (err) {
      logger.error(
        `The unlisted script "${"fetchInterceptor"}" crashed on startup!`,
        err
      );
      throw err;
    }
  })();
  return result;
})();
fetchinterceptor;