import { c as createLucideIcon, r as reactExports, j as jsxRuntimeExports, B as Bug, S as Settings, _ as __vitePreload, a as requireReactDom, b as requireReact, C as ChevronRight, d as ChevronDown, V as VERSION, g as getMission, s as saveMissionsBatch, e as STORAGE_KEYS, f as getAllMissions, i as importMissions, h as getAllUserProgress, k as ChartColumn, l as Star, P as Play, m as clientExports } from "./missions-CTZOI1oz.js";
var commonjsGlobal = typeof globalThis !== "undefined" ? globalThis : typeof window !== "undefined" ? window : typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : {};
function getDefaultExportFromCjs(x) {
  return x && x.__esModule && Object.prototype.hasOwnProperty.call(x, "default") ? x["default"] : x;
}
/**
 * @license lucide-react v0.546.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const __iconNode$s = [
  ["path", { d: "M12 5v14", key: "s699le" }],
  ["path", { d: "m19 12-7 7-7-7", key: "1idqje" }]
];
const ArrowDown = createLucideIcon("arrow-down", __iconNode$s);
/**
 * @license lucide-react v0.546.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const __iconNode$r = [
  ["path", { d: "m5 12 7-7 7 7", key: "hav0vg" }],
  ["path", { d: "M12 19V5", key: "x0mq9r" }]
];
const ArrowUp = createLucideIcon("arrow-up", __iconNode$r);
/**
 * @license lucide-react v0.546.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const __iconNode$q = [["path", { d: "M20 6 9 17l-5-5", key: "1gmf2c" }]];
const Check = createLucideIcon("check", __iconNode$q);
/**
 * @license lucide-react v0.546.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const __iconNode$p = [["path", { d: "m18 15-6-6-6 6", key: "153udz" }]];
const ChevronUp = createLucideIcon("chevron-up", __iconNode$p);
/**
 * @license lucide-react v0.546.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const __iconNode$o = [
  ["circle", { cx: "12", cy: "12", r: "10", key: "1mglay" }],
  ["line", { x1: "12", x2: "12", y1: "8", y2: "12", key: "1pkeuh" }],
  ["line", { x1: "12", x2: "12.01", y1: "16", y2: "16", key: "4dfq90" }]
];
const CircleAlert = createLucideIcon("circle-alert", __iconNode$o);
/**
 * @license lucide-react v0.546.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const __iconNode$n = [
  ["path", { d: "M21.801 10A10 10 0 1 1 17 3.335", key: "yps3ct" }],
  ["path", { d: "m9 11 3 3L22 4", key: "1pflzl" }]
];
const CircleCheckBig = createLucideIcon("circle-check-big", __iconNode$n);
/**
 * @license lucide-react v0.546.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const __iconNode$m = [
  ["circle", { cx: "12", cy: "12", r: "10", key: "1mglay" }],
  ["path", { d: "m15 9-6 6", key: "1uzhvr" }],
  ["path", { d: "m9 9 6 6", key: "z0biqf" }]
];
const CircleX = createLucideIcon("circle-x", __iconNode$m);
/**
 * @license lucide-react v0.546.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const __iconNode$l = [
  ["path", { d: "m16 18 6-6-6-6", key: "eg8j8" }],
  ["path", { d: "m8 6-6 6 6 6", key: "ppft3o" }]
];
const Code = createLucideIcon("code", __iconNode$l);
/**
 * @license lucide-react v0.546.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const __iconNode$k = [
  ["rect", { width: "14", height: "14", x: "8", y: "8", rx: "2", ry: "2", key: "17jyea" }],
  ["path", { d: "M4 16c-1.1 0-2-.9-2-2V4c0-1.1.9-2 2-2h10c1.1 0 2 .9 2 2", key: "zix9uf" }]
];
const Copy = createLucideIcon("copy", __iconNode$k);
/**
 * @license lucide-react v0.546.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const __iconNode$j = [
  ["ellipse", { cx: "12", cy: "5", rx: "9", ry: "3", key: "msslwz" }],
  ["path", { d: "M3 5V19A9 3 0 0 0 21 19V5", key: "1wlel7" }],
  ["path", { d: "M3 12A9 3 0 0 0 21 12", key: "mv7ke4" }]
];
const Database = createLucideIcon("database", __iconNode$j);
/**
 * @license lucide-react v0.546.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const __iconNode$i = [
  ["path", { d: "M12 15V3", key: "m9g1x1" }],
  ["path", { d: "M21 15v4a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2v-4", key: "ih7n3h" }],
  ["path", { d: "m7 10 5 5 5-5", key: "brsn70" }]
];
const Download = createLucideIcon("download", __iconNode$i);
/**
 * @license lucide-react v0.546.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const __iconNode$h = [
  [
    "path",
    {
      d: "M2.062 12.348a1 1 0 0 1 0-.696 10.75 10.75 0 0 1 19.876 0 1 1 0 0 1 0 .696 10.75 10.75 0 0 1-19.876 0",
      key: "1nclc0"
    }
  ],
  ["circle", { cx: "12", cy: "12", r: "3", key: "1v7zrd" }]
];
const Eye = createLucideIcon("eye", __iconNode$h);
/**
 * @license lucide-react v0.546.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const __iconNode$g = [
  [
    "path",
    {
      d: "M15 22v-4a4.8 4.8 0 0 0-1-3.5c3 0 6-2 6-5.5.08-1.25-.27-2.48-1-3.5.28-1.15.28-2.35 0-3.5 0 0-1 0-3 1.5-2.64-.5-5.36-.5-8 0C6 2 5 2 5 2c-.3 1.15-.3 2.35 0 3.5A5.403 5.403 0 0 0 4 9c0 3.5 3 5.5 6 5.5-.39.49-.68 1.05-.85 1.65-.17.6-.22 1.23-.15 1.85v4",
      key: "tonef"
    }
  ],
  ["path", { d: "M9 18c-4.51 2-5-2-7-2", key: "9comsn" }]
];
const Github = createLucideIcon("github", __iconNode$g);
/**
 * @license lucide-react v0.546.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const __iconNode$f = [
  ["circle", { cx: "9", cy: "12", r: "1", key: "1vctgf" }],
  ["circle", { cx: "9", cy: "5", r: "1", key: "hp0tcf" }],
  ["circle", { cx: "9", cy: "19", r: "1", key: "fkjjf6" }],
  ["circle", { cx: "15", cy: "12", r: "1", key: "1tmaij" }],
  ["circle", { cx: "15", cy: "5", r: "1", key: "19l28e" }],
  ["circle", { cx: "15", cy: "19", r: "1", key: "f4zoj3" }]
];
const GripVertical = createLucideIcon("grip-vertical", __iconNode$f);
/**
 * @license lucide-react v0.546.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const __iconNode$e = [
  ["circle", { cx: "12", cy: "12", r: "10", key: "1mglay" }],
  ["path", { d: "M12 16v-4", key: "1dtifu" }],
  ["path", { d: "M12 8h.01", key: "e9boi3" }]
];
const Info = createLucideIcon("info", __iconNode$e);
/**
 * @license lucide-react v0.546.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const __iconNode$d = [
  ["path", { d: "M10 13a5 5 0 0 0 7.54.54l3-3a5 5 0 0 0-7.07-7.07l-1.72 1.71", key: "1cjeqo" }],
  ["path", { d: "M14 11a5 5 0 0 0-7.54-.54l-3 3a5 5 0 0 0 7.07 7.07l1.71-1.71", key: "19qd67" }]
];
const Link = createLucideIcon("link", __iconNode$d);
/**
 * @license lucide-react v0.546.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const __iconNode$c = [
  ["path", { d: "M12 2v4", key: "3427ic" }],
  ["path", { d: "m16.2 7.8 2.9-2.9", key: "r700ao" }],
  ["path", { d: "M18 12h4", key: "wj9ykh" }],
  ["path", { d: "m16.2 16.2 2.9 2.9", key: "1bxg5t" }],
  ["path", { d: "M12 18v4", key: "jadmvz" }],
  ["path", { d: "m4.9 19.1 2.9-2.9", key: "bwix9q" }],
  ["path", { d: "M2 12h4", key: "j09sii" }],
  ["path", { d: "m4.9 4.9 2.9 2.9", key: "giyufr" }]
];
const Loader = createLucideIcon("loader", __iconNode$c);
/**
 * @license lucide-react v0.546.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const __iconNode$b = [
  ["path", { d: "M5 12h14", key: "1ays0h" }],
  ["path", { d: "M12 5v14", key: "s699le" }]
];
const Plus = createLucideIcon("plus", __iconNode$b);
/**
 * @license lucide-react v0.546.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const __iconNode$a = [
  ["path", { d: "M3 12a9 9 0 0 1 9-9 9.75 9.75 0 0 1 6.74 2.74L21 8", key: "v9h5vc" }],
  ["path", { d: "M21 3v5h-5", key: "1q7to0" }],
  ["path", { d: "M21 12a9 9 0 0 1-9 9 9.75 9.75 0 0 1-6.74-2.74L3 16", key: "3uifl3" }],
  ["path", { d: "M8 16H3v5", key: "1cv678" }]
];
const RefreshCw = createLucideIcon("refresh-cw", __iconNode$a);
/**
 * @license lucide-react v0.546.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const __iconNode$9 = [
  [
    "path",
    {
      d: "M4.5 16.5c-1.5 1.26-2 5-2 5s3.74-.5 5-2c.71-.84.7-2.13-.09-2.91a2.18 2.18 0 0 0-2.91-.09z",
      key: "m3kijz"
    }
  ],
  [
    "path",
    {
      d: "m12 15-3-3a22 22 0 0 1 2-3.95A12.88 12.88 0 0 1 22 2c0 2.72-.78 7.5-6 11a22.35 22.35 0 0 1-4 2z",
      key: "1fmvmk"
    }
  ],
  ["path", { d: "M9 12H4s.55-3.03 2-4c1.62-1.08 5 0 5 0", key: "1f8sc4" }],
  ["path", { d: "M12 15v5s3.03-.55 4-2c1.08-1.62 0-5 0-5", key: "qeys4" }]
];
const Rocket = createLucideIcon("rocket", __iconNode$9);
/**
 * @license lucide-react v0.546.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const __iconNode$8 = [
  ["path", { d: "m21 21-4.34-4.34", key: "14j7rj" }],
  ["circle", { cx: "11", cy: "11", r: "8", key: "4ej97u" }]
];
const Search = createLucideIcon("search", __iconNode$8);
/**
 * @license lucide-react v0.546.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const __iconNode$7 = [
  [
    "path",
    {
      d: "M11.017 2.814a1 1 0 0 1 1.966 0l1.051 5.558a2 2 0 0 0 1.594 1.594l5.558 1.051a1 1 0 0 1 0 1.966l-5.558 1.051a2 2 0 0 0-1.594 1.594l-1.051 5.558a1 1 0 0 1-1.966 0l-1.051-5.558a2 2 0 0 0-1.594-1.594l-5.558-1.051a1 1 0 0 1 0-1.966l5.558-1.051a2 2 0 0 0 1.594-1.594z",
      key: "1s2grr"
    }
  ],
  ["path", { d: "M20 2v4", key: "1rf3ol" }],
  ["path", { d: "M22 4h-4", key: "gwowj6" }],
  ["circle", { cx: "4", cy: "20", r: "2", key: "6kqj1y" }]
];
const Sparkles = createLucideIcon("sparkles", __iconNode$7);
/**
 * @license lucide-react v0.546.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const __iconNode$6 = [
  ["polyline", { points: "14.5 17.5 3 6 3 3 6 3 17.5 14.5", key: "1hfsw2" }],
  ["line", { x1: "13", x2: "19", y1: "19", y2: "13", key: "1vrmhu" }],
  ["line", { x1: "16", x2: "20", y1: "16", y2: "20", key: "1bron3" }],
  ["line", { x1: "19", x2: "21", y1: "21", y2: "19", key: "13pww6" }],
  ["polyline", { points: "14.5 6.5 18 3 21 3 21 6 17.5 9.5", key: "hbey2j" }],
  ["line", { x1: "5", x2: "9", y1: "14", y2: "18", key: "1hf58s" }],
  ["line", { x1: "7", x2: "4", y1: "17", y2: "20", key: "pidxm4" }],
  ["line", { x1: "3", x2: "5", y1: "19", y2: "21", key: "1pehsh" }]
];
const Swords = createLucideIcon("swords", __iconNode$6);
/**
 * @license lucide-react v0.546.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const __iconNode$5 = [
  ["circle", { cx: "12", cy: "12", r: "10", key: "1mglay" }],
  ["circle", { cx: "12", cy: "12", r: "6", key: "1vlfrh" }],
  ["circle", { cx: "12", cy: "12", r: "2", key: "1c9p78" }]
];
const Target = createLucideIcon("target", __iconNode$5);
/**
 * @license lucide-react v0.546.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const __iconNode$4 = [
  ["path", { d: "M12 19h8", key: "baeox8" }],
  ["path", { d: "m4 17 6-6-6-6", key: "1yngyt" }]
];
const Terminal = createLucideIcon("terminal", __iconNode$4);
/**
 * @license lucide-react v0.546.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const __iconNode$3 = [
  ["path", { d: "M10 11v6", key: "nco0om" }],
  ["path", { d: "M14 11v6", key: "outv1u" }],
  ["path", { d: "M19 6v14a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2V6", key: "miytrc" }],
  ["path", { d: "M3 6h18", key: "d0wm0j" }],
  ["path", { d: "M8 6V4a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v2", key: "e791ji" }]
];
const Trash2 = createLucideIcon("trash-2", __iconNode$3);
/**
 * @license lucide-react v0.546.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const __iconNode$2 = [
  [
    "path",
    {
      d: "m21.73 18-8-14a2 2 0 0 0-3.48 0l-8 14A2 2 0 0 0 4 21h16a2 2 0 0 0 1.73-3",
      key: "wmoenq"
    }
  ],
  ["path", { d: "M12 9v4", key: "juzpu7" }],
  ["path", { d: "M12 17h.01", key: "p32p05" }]
];
const TriangleAlert = createLucideIcon("triangle-alert", __iconNode$2);
/**
 * @license lucide-react v0.546.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const __iconNode$1 = [
  ["path", { d: "M12 3v12", key: "1x0j5s" }],
  ["path", { d: "m17 8-5-5-5 5", key: "7q97r8" }],
  ["path", { d: "M21 15v4a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2v-4", key: "ih7n3h" }]
];
const Upload = createLucideIcon("upload", __iconNode$1);
/**
 * @license lucide-react v0.546.0 - ISC
 *
 * This source code is licensed under the ISC license.
 * See the LICENSE file in the root directory of this source tree.
 */
const __iconNode = [
  ["path", { d: "M18 6 6 18", key: "1bl5f8" }],
  ["path", { d: "m6 6 12 12", key: "d8bk6v" }]
];
const X = createLucideIcon("x", __iconNode);
const PriorityListCard = ({
  title,
  icon: Icon,
  description,
  matchingHint,
  items,
  discoveredItems,
  inputPlaceholder,
  emptyMessage,
  accentColor,
  onItemsChange
}) => {
  const [newItem, setNewItem] = reactExports.useState("");
  const handleDragStart = (e, index) => {
    e.dataTransfer.effectAllowed = "move";
    e.dataTransfer.setData("text/plain", index.toString());
  };
  const handleDragOver = (e) => {
    e.preventDefault();
    e.dataTransfer.dropEffect = "move";
  };
  const handleDrop = (e, dropIndex) => {
    e.preventDefault();
    const dragIndex = parseInt(e.dataTransfer.getData("text/plain"));
    if (dragIndex === dropIndex) return;
    const newList = [...items];
    const [draggedItem] = newList.splice(dragIndex, 1);
    newList.splice(dropIndex, 0, draggedItem);
    onItemsChange(newList);
  };
  const handleAddItem = () => {
    const trimmed = newItem.trim();
    if (trimmed && !items.includes(trimmed)) {
      onItemsChange([...items, trimmed]);
      setNewItem("");
    }
  };
  const handleAddDiscoveredItem = (item) => {
    if (!items.includes(item)) {
      onItemsChange([...items, item]);
    }
  };
  const handleRemoveItem = (index) => {
    const newList = [...items];
    newList.splice(index, 1);
    onItemsChange(newList);
  };
  return /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "card", children: [
    /* @__PURE__ */ jsxRuntimeExports.jsxs("h2", { children: [
      /* @__PURE__ */ jsxRuntimeExports.jsx(Icon, { size: 20, style: { display: "inline-block", marginRight: "8px", verticalAlign: "middle" } }),
      title
    ] }),
    /* @__PURE__ */ jsxRuntimeExports.jsxs("p", { style: { color: "#a1a1aa", marginBottom: "16px", fontSize: "14px" }, children: [
      description,
      /* @__PURE__ */ jsxRuntimeExports.jsx("br", {}),
      /* @__PURE__ */ jsxRuntimeExports.jsx("span", { style: { fontSize: "13px", color: "#71717a" }, children: matchingHint })
    ] }),
    /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { style: { marginBottom: "16px", display: "flex", gap: "8px" }, children: [
      /* @__PURE__ */ jsxRuntimeExports.jsx(
        "input",
        {
          type: "text",
          value: newItem,
          onChange: (e) => setNewItem(e.target.value),
          onKeyPress: (e) => e.key === "Enter" && handleAddItem(),
          placeholder: inputPlaceholder,
          style: {
            flex: 1,
            padding: "8px 12px",
            background: "#171717",
            border: "1px solid #27272a",
            borderRadius: "6px",
            color: "#e5e5e5",
            fontSize: "14px"
          }
        }
      ),
      /* @__PURE__ */ jsxRuntimeExports.jsxs(
        "button",
        {
          onClick: handleAddItem,
          style: {
            padding: "8px 16px",
            background: accentColor,
            border: "none",
            borderRadius: "6px",
            color: "white",
            cursor: "pointer",
            display: "flex",
            alignItems: "center",
            gap: "6px",
            fontSize: "14px",
            fontWeight: "500"
          },
          children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(Plus, { size: 16 }),
            "Add"
          ]
        }
      )
    ] }),
    discoveredItems.length > 0 && /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { style: { marginBottom: "16px", padding: "12px", background: "#18181b", borderRadius: "8px", border: "1px solid #27272a" }, children: [
      /* @__PURE__ */ jsxRuntimeExports.jsx("div", { style: { fontSize: "13px", color: "#a1a1aa", marginBottom: "8px" }, children: "Discovered items (click to add to pick order):" }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("div", { style: { display: "flex", flexWrap: "wrap", gap: "6px" }, children: discoveredItems.filter((item) => !items.includes(item)).map((item, index) => /* @__PURE__ */ jsxRuntimeExports.jsxs(
        "button",
        {
          onClick: () => handleAddDiscoveredItem(item),
          style: {
            padding: "4px 10px",
            background: "#27272a",
            border: "1px solid #3f3f46",
            borderRadius: "6px",
            color: "#a1a1aa",
            cursor: "pointer",
            fontSize: "13px",
            transition: "all 0.2s"
          },
          onMouseEnter: (e) => {
            e.currentTarget.style.background = "#3f3f46";
            e.currentTarget.style.color = "#e5e5e5";
          },
          onMouseLeave: (e) => {
            e.currentTarget.style.background = "#27272a";
            e.currentTarget.style.color = "#a1a1aa";
          },
          children: [
            "+ ",
            item
          ]
        },
        index
      )) })
    ] }),
    items.length === 0 ? /* @__PURE__ */ jsxRuntimeExports.jsx("p", { style: { color: "#71717a", fontSize: "14px", fontStyle: "italic" }, children: emptyMessage }) : /* @__PURE__ */ jsxRuntimeExports.jsx("div", { style: { display: "flex", flexDirection: "column", gap: "8px" }, children: items.map((item, index) => /* @__PURE__ */ jsxRuntimeExports.jsxs(
      "div",
      {
        draggable: true,
        onDragStart: (e) => handleDragStart(e, index),
        onDragOver: handleDragOver,
        onDrop: (e) => handleDrop(e, index),
        style: {
          display: "flex",
          alignItems: "center",
          gap: "12px",
          padding: "12px",
          background: "#171717",
          border: "1px solid #1a1a1a",
          borderRadius: "8px",
          cursor: "move",
          transition: "all 0.2s"
        },
        onMouseEnter: (e) => e.currentTarget.style.background = "#1f1f1f",
        onMouseLeave: (e) => e.currentTarget.style.background = "#171717",
        children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(GripVertical, { size: 16, style: { color: "#71717a" } }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("span", { style: { fontSize: "14px", fontWeight: "600", color: accentColor, minWidth: "30px" }, children: index + 1 }),
          /* @__PURE__ */ jsxRuntimeExports.jsx("span", { style: { fontSize: "14px", color: "#e5e5e5", flex: 1 }, children: item }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(
            "button",
            {
              onClick: () => handleRemoveItem(index),
              style: {
                padding: "4px",
                background: "transparent",
                border: "none",
                color: "#71717a",
                cursor: "pointer",
                display: "flex",
                alignItems: "center",
                transition: "color 0.2s"
              },
              onMouseEnter: (e) => e.currentTarget.style.color = "#ef4444",
              onMouseLeave: (e) => e.currentTarget.style.color = "#71717a",
              children: /* @__PURE__ */ jsxRuntimeExports.jsx(X, { size: 16 })
            }
          )
        ]
      },
      index
    )) })
  ] });
};
const AutomationTab = () => {
  const [config, setConfig] = reactExports.useState({
    abilityTierList: [],
    blessingStatPriority: [],
    skillBargainStrategy: "positive-only",
    crossroadsStrategy: "fight"
  });
  const [discoveredAbilities, setDiscoveredAbilities] = reactExports.useState([]);
  const [discoveredBlessingStats, setDiscoveredBlessingStats] = reactExports.useState([]);
  reactExports.useEffect(() => {
    chrome.storage.local.get(["automationConfig", "discoveredAbilities", "discoveredBlessingStats"], (result) => {
      if (result.automationConfig) {
        setConfig({
          abilityTierList: result.automationConfig.abilityTierList || [],
          blessingStatPriority: result.automationConfig.blessingStatPriority || [],
          skillBargainStrategy: result.automationConfig.skillBargainStrategy || "positive-only",
          crossroadsStrategy: result.automationConfig.crossroadsStrategy || "fight"
        });
      }
      setDiscoveredAbilities(result.discoveredAbilities || []);
      setDiscoveredBlessingStats(result.discoveredBlessingStats || []);
    });
  }, []);
  reactExports.useEffect(() => {
    chrome.storage.local.get(["automationConfig"], (result) => {
      const fullConfig = {
        ...result.automationConfig,
        abilityTierList: config.abilityTierList,
        blessingStatPriority: config.blessingStatPriority,
        skillBargainStrategy: config.skillBargainStrategy,
        crossroadsStrategy: config.crossroadsStrategy
      };
      chrome.storage.local.set({ automationConfig: fullConfig });
    });
  }, [config]);
  const handleAbilityListChange = (newList) => {
    setConfig((prev) => ({ ...prev, abilityTierList: newList }));
  };
  const handleBlessingStatListChange = (newList) => {
    setConfig((prev) => ({ ...prev, blessingStatPriority: newList }));
  };
  return /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
    /* @__PURE__ */ jsxRuntimeExports.jsx(
      PriorityListCard,
      {
        title: "Ability Pick Order",
        icon: Target,
        description: "Drag to reorder. Abilities will be selected in this order of preference when given a choice in missions.",
        matchingHint: 'The automation matches using partial text (case-insensitive). E.g., "Ice" matches "Ice Knife" ability.',
        items: config.abilityTierList,
        discoveredItems: discoveredAbilities,
        inputPlaceholder: "Add ability name...",
        emptyMessage: "No abilities in pick order. Add abilities above or play missions to discover them!",
        accentColor: "#3b82f6",
        onItemsChange: handleAbilityListChange
      }
    ),
    /* @__PURE__ */ jsxRuntimeExports.jsx(
      PriorityListCard,
      {
        title: "Blessing Stat Pick Order",
        icon: Sparkles,
        description: "Drag to reorder. Stats will be prioritized in this order when choosing blessings during missions.",
        matchingHint: 'The automation matches using partial text (case-insensitive). E.g., "Speed" matches "Increase Speed by 10%".',
        items: config.blessingStatPriority,
        discoveredItems: discoveredBlessingStats,
        inputPlaceholder: "Add blessing stat name...",
        emptyMessage: "No blessing stats in pick order. Add stats above or play missions to discover them!",
        accentColor: "#22c55e",
        onItemsChange: handleBlessingStatListChange
      }
    ),
    /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "card", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs("h2", { children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(Swords, { size: 20, style: { display: "inline-block", marginRight: "8px", verticalAlign: "middle" } }),
        "Combat Strategies"
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "form-group", style: { marginBottom: "20px" }, children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("label", { children: "Skill Bargain Strategy:" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("p", { style: { color: "#a1a1aa", fontSize: "13px", marginTop: "4px", marginBottom: "8px" }, children: "When to accept skill bargains (trade-offs between stats)." }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs(
          "select",
          {
            value: config.skillBargainStrategy,
            onChange: (e) => setConfig((prev) => ({ ...prev, skillBargainStrategy: e.target.value })),
            children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx("option", { value: "always", children: "Always Accept" }),
              /* @__PURE__ */ jsxRuntimeExports.jsx("option", { value: "positive-only", children: "Accept if Positive > Negative" }),
              /* @__PURE__ */ jsxRuntimeExports.jsx("option", { value: "never", children: "Never Accept" })
            ]
          }
        )
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "form-group", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("label", { children: "Crossroads Strategy:" }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("p", { style: { color: "#a1a1aa", fontSize: "13px", marginTop: "4px", marginBottom: "8px" }, children: "What to do at miniboss encounters (crossroads)." }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs(
          "select",
          {
            value: config.crossroadsStrategy,
            onChange: (e) => setConfig((prev) => ({ ...prev, crossroadsStrategy: e.target.value })),
            children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx("option", { value: "fight", children: "Fight Miniboss" }),
              /* @__PURE__ */ jsxRuntimeExports.jsx("option", { value: "skip", children: "Skip Miniboss" })
            ]
          }
        )
      ] })
    ] })
  ] });
};
const SettingsTab = () => {
  const fileInputRef = reactExports.useRef(null);
  const [settings, setSettings] = reactExports.useState({
    showNextMissions: true,
    nextMissionsCount: 5,
    debugMode: false,
    showStepByStepControls: false,
    debugVisuals: true
  });
  const [userOptions, setUserOptions] = reactExports.useState({});
  reactExports.useEffect(() => {
    chrome.storage.local.get(["automationConfig", "userOptions"], (result) => {
      if (result.automationConfig) {
        setSettings({
          showNextMissions: result.automationConfig.showNextMissions !== false,
          nextMissionsCount: result.automationConfig.nextMissionsCount || 5,
          debugMode: result.automationConfig.debugMode || false,
          showStepByStepControls: result.automationConfig.showStepByStepControls || false,
          debugVisuals: result.automationConfig.debugVisuals !== false
          // Default to true
        });
      }
      if (result.userOptions) {
        setUserOptions(result.userOptions);
      }
    });
  }, []);
  reactExports.useEffect(() => {
    chrome.storage.local.get(["automationConfig"], (result) => {
      const fullConfig = {
        ...result.automationConfig,
        showNextMissions: settings.showNextMissions,
        nextMissionsCount: settings.nextMissionsCount,
        debugMode: settings.debugMode,
        showStepByStepControls: settings.showStepByStepControls,
        debugVisuals: settings.debugVisuals
      };
      chrome.storage.local.set({ automationConfig: fullConfig });
    });
  }, [settings]);
  reactExports.useEffect(() => {
    chrome.storage.local.set({ userOptions });
  }, [userOptions]);
  const handleClearMissions = async () => {
    if (window.confirm(
      "Are you sure you want to clear ALL missions from the database? This cannot be undone."
    )) {
      const { clearAllMissions } = await __vitePreload(async () => {
        const { clearAllMissions: clearAllMissions2 } = await import("./missions-CTZOI1oz.js").then((n) => n.p);
        return { clearAllMissions: clearAllMissions2 };
      }, true ? [] : void 0);
      await clearAllMissions();
      alert("All missions cleared!");
    }
  };
  const handleClearAllData = async () => {
    if (window.confirm(
      "Are you sure you want to clear ALL DATA? This will delete all missions, settings, and filters, resetting the extension to default state. This cannot be undone."
    )) {
      await chrome.storage.local.clear();
      alert(
        "All data cleared! The extension has been reset to default state. Please reload the extension."
      );
    }
  };
  const handleMarkAllIncomplete = async () => {
    if (window.confirm(
      "Mark ALL missions as incomplete? This will reset cleared status on every mission."
    )) {
      const { markAllMissionsIncomplete } = await __vitePreload(async () => {
        const { markAllMissionsIncomplete: markAllMissionsIncomplete2 } = await import("./missions-CTZOI1oz.js").then((n) => n.p);
        return { markAllMissionsIncomplete: markAllMissionsIncomplete2 };
      }, true ? [] : void 0);
      await markAllMissionsIncomplete();
      alert("All missions marked as incomplete.");
    }
  };
  const handleExportUserProgress = async () => {
    try {
      const { exportUserProgress } = await __vitePreload(async () => {
        const { exportUserProgress: exportUserProgress2 } = await import("./missions-CTZOI1oz.js").then((n) => n.o);
        return { exportUserProgress: exportUserProgress2 };
      }, true ? [] : void 0);
      const { getCurrentRedditUser } = await __vitePreload(async () => {
        const { getCurrentRedditUser: getCurrentRedditUser2 } = await import("./missions-CTZOI1oz.js").then((n) => n.u);
        return { getCurrentRedditUser: getCurrentRedditUser2 };
      }, true ? [] : void 0);
      const username = await getCurrentRedditUser();
      const jsonData = await exportUserProgress();
      const blob = new Blob([jsonData], { type: "application/json" });
      const url = URL.createObjectURL(blob);
      const a = document.createElement("a");
      a.href = url;
      a.download = `lazyfrog-progress-${username}-${Date.now()}.json`;
      document.body.appendChild(a);
      a.click();
      document.body.removeChild(a);
      URL.revokeObjectURL(url);
    } catch (error) {
      alert(`Failed to export user progress: ${error}`);
    }
  };
  const handleImportUserProgress = () => {
    fileInputRef.current?.click();
  };
  const handleFileSelected = async (e) => {
    const file = e.target.files?.[0];
    if (!file) return;
    try {
      const text2 = await file.text();
      const { importUserProgress } = await __vitePreload(async () => {
        const { importUserProgress: importUserProgress2 } = await import("./missions-CTZOI1oz.js").then((n) => n.o);
        return { importUserProgress: importUserProgress2 };
      }, true ? [] : void 0);
      await importUserProgress(text2);
      alert("User progress imported successfully!");
    } catch (error) {
      alert(`Failed to import user progress: ${error}`);
    }
    if (fileInputRef.current) {
      fileInputRef.current.value = "";
    }
  };
  return /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
    /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "card", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs("h2", { children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(
          Bug,
          {
            size: 20,
            style: {
              display: "inline-block",
              marginRight: "8px",
              verticalAlign: "middle"
            }
          }
        ),
        "Developer Mode"
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "form-group", style: { marginBottom: "20px" }, children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs(
          "label",
          {
            style: {
              display: "flex",
              alignItems: "center",
              gap: "8px",
              cursor: "pointer"
            },
            children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(
                "input",
                {
                  type: "checkbox",
                  checked: userOptions.debugMode || false,
                  onChange: (e) => setUserOptions((prev) => ({
                    ...prev,
                    debugMode: e.target.checked
                  })),
                  style: { cursor: "pointer" }
                }
              ),
              /* @__PURE__ */ jsxRuntimeExports.jsx("span", { children: "Enable Debug Tab" })
            ]
          }
        ),
        /* @__PURE__ */ jsxRuntimeExports.jsx(
          "p",
          {
            style: {
              color: "#a1a1aa",
              fontSize: "13px",
              marginTop: "8px",
              marginLeft: "28px"
            },
            children: "Enables the Debug tab with developer tools for testing mission data fetching and other advanced features."
          }
        )
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "form-group", style: { marginBottom: "20px" }, children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs(
          "label",
          {
            style: {
              display: "flex",
              alignItems: "center",
              gap: "8px",
              cursor: "pointer"
            },
            children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(
                "input",
                {
                  type: "checkbox",
                  checked: settings.debugMode,
                  onChange: (e) => setSettings((prev) => ({
                    ...prev,
                    debugMode: e.target.checked
                  })),
                  style: { cursor: "pointer" }
                }
              ),
              /* @__PURE__ */ jsxRuntimeExports.jsx("span", { children: "Enable Debug Logging" })
            ]
          }
        ),
        /* @__PURE__ */ jsxRuntimeExports.jsx(
          "p",
          {
            style: {
              color: "#a1a1aa",
              fontSize: "13px",
              marginTop: "8px",
              marginLeft: "28px"
            },
            children: "Enables additional debug logging and features throughout the extension. Useful for troubleshooting issues or understanding extension behavior."
          }
        )
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "form-group", style: { marginBottom: "20px" }, children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs(
          "label",
          {
            style: {
              display: "flex",
              alignItems: "center",
              gap: "8px",
              cursor: "pointer"
            },
            children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(
                "input",
                {
                  type: "checkbox",
                  checked: settings.showStepByStepControls,
                  onChange: (e) => setSettings((prev) => ({
                    ...prev,
                    showStepByStepControls: e.target.checked
                  })),
                  style: { cursor: "pointer" }
                }
              ),
              /* @__PURE__ */ jsxRuntimeExports.jsx("span", { children: "Show Step-by-Step Controls" })
            ]
          }
        ),
        /* @__PURE__ */ jsxRuntimeExports.jsx(
          "p",
          {
            style: {
              color: "#a1a1aa",
              fontSize: "13px",
              marginTop: "8px",
              marginLeft: "28px"
            },
            children: "Shows step-by-step automation controls in the popup (1. Navigate, 2. Open, 3. Play). Useful for debugging automation flow or manually controlling each step."
          }
        )
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "form-group", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs(
          "label",
          {
            style: {
              display: "flex",
              alignItems: "center",
              gap: "8px",
              cursor: "pointer"
            },
            children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(
                "input",
                {
                  type: "checkbox",
                  checked: settings.debugVisuals,
                  onChange: (e) => setSettings((prev) => ({
                    ...prev,
                    debugVisuals: e.target.checked
                  })),
                  style: { cursor: "pointer" }
                }
              ),
              /* @__PURE__ */ jsxRuntimeExports.jsx("span", { children: "Show Debug Visual Indicators" })
            ]
          }
        ),
        /* @__PURE__ */ jsxRuntimeExports.jsx(
          "p",
          {
            style: {
              color: "#a1a1aa",
              fontSize: "13px",
              marginTop: "8px",
              marginLeft: "28px"
            },
            children: "Highlights buttons that the bot wants to click with a red outline. Useful for visually debugging automation decisions and understanding what the bot is doing."
          }
        )
      ] })
    ] }),
    /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "card", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs("h2", { children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(
          Settings,
          {
            size: 20,
            style: {
              display: "inline-block",
              marginRight: "8px",
              verticalAlign: "middle"
            }
          }
        ),
        "Display Settings"
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "form-group", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs(
          "label",
          {
            style: {
              display: "flex",
              alignItems: "center",
              gap: "8px",
              cursor: "pointer"
            },
            children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(
                "input",
                {
                  type: "checkbox",
                  checked: settings.showNextMissions,
                  onChange: (e) => setSettings((prev) => ({
                    ...prev,
                    showNextMissions: e.target.checked
                  })),
                  style: { cursor: "pointer" }
                }
              ),
              /* @__PURE__ */ jsxRuntimeExports.jsx("span", { children: "Show Mission Queue" })
            ]
          }
        ),
        /* @__PURE__ */ jsxRuntimeExports.jsx(
          "p",
          {
            style: {
              color: "#a1a1aa",
              fontSize: "13px",
              marginTop: "8px",
              marginLeft: "28px"
            },
            children: "Shows the queue of upcoming missions in the popup that match your current filters."
          }
        ),
        settings.showNextMissions && /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { style: { marginTop: "12px", marginLeft: "28px" }, children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(
            "label",
            {
              style: {
                display: "block",
                fontSize: "13px",
                color: "#e5e5e5",
                marginBottom: "8px"
              },
              children: "Number of missions to show:"
            }
          ),
          /* @__PURE__ */ jsxRuntimeExports.jsx(
            "input",
            {
              type: "number",
              min: "1",
              max: "20",
              value: settings.nextMissionsCount,
              onChange: (e) => setSettings((prev) => ({
                ...prev,
                nextMissionsCount: parseInt(e.target.value) || 5
              })),
              style: {
                padding: "6px 12px",
                background: "#171717",
                border: "1px solid #1a1a1a",
                borderRadius: "6px",
                color: "#e5e5e5",
                fontSize: "13px",
                width: "80px"
              }
            }
          )
        ] })
      ] })
    ] }),
    /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "card", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs("h2", { children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(
          CircleCheckBig,
          {
            size: 20,
            style: {
              display: "inline-block",
              marginRight: "8px",
              verticalAlign: "middle"
            }
          }
        ),
        "Progress Data Management"
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { style: { marginBottom: "16px" }, children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("p", { style: { color: "#a1a1aa", fontSize: "14px", marginBottom: "12px" }, children: "Export or import your user progress (cleared missions, disabled missions, and loot)." }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { style: { display: "flex", gap: "12px", flexWrap: "wrap" }, children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs(
            "button",
            {
              className: "button",
              onClick: handleExportUserProgress,
              style: { display: "flex", alignItems: "center", gap: "8px" },
              children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx(Download, { size: 16 }),
                "Export User Progress"
              ]
            }
          ),
          /* @__PURE__ */ jsxRuntimeExports.jsxs(
            "button",
            {
              className: "button",
              onClick: handleImportUserProgress,
              style: { display: "flex", alignItems: "center", gap: "8px" },
              children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx(Upload, { size: 16 }),
                "Import User Progress"
              ]
            }
          )
        ] })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("p", { style: { color: "#a1a1aa", fontSize: "14px", marginBottom: "12px" }, children: "Mark all missions as incomplete. This preserves mission entries but resets their cleared status." }),
        /* @__PURE__ */ jsxRuntimeExports.jsx(
          "button",
          {
            className: "button",
            onClick: handleMarkAllIncomplete,
            style: { display: "flex", alignItems: "center", gap: "8px" },
            children: "Mark All Missions Incomplete"
          }
        )
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsx(
        "input",
        {
          ref: fileInputRef,
          type: "file",
          accept: ".json,application/json",
          style: { display: "none" },
          onChange: handleFileSelected
        }
      )
    ] }),
    /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "card", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs("h2", { children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(
          Trash2,
          {
            size: 20,
            style: {
              display: "inline-block",
              marginRight: "8px",
              verticalAlign: "middle"
            }
          }
        ),
        "Mission Data Management"
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { style: { marginBottom: "16px" }, children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("p", { style: { color: "#a1a1aa", fontSize: "14px", marginBottom: "12px" }, children: "Clear all mission data from the database. This action cannot be undone." }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs(
          "button",
          {
            className: "button danger",
            onClick: handleClearMissions,
            style: { display: "flex", alignItems: "center", gap: "8px" },
            children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(Trash2, { size: 16 }),
              "Clear All Missions"
            ]
          }
        )
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("p", { style: { color: "#a1a1aa", fontSize: "14px", marginBottom: "12px" }, children: "Clear all data including missions, settings, and filters. Resets the extension to default state. This action cannot be undone." }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs(
          "button",
          {
            className: "button danger",
            onClick: handleClearAllData,
            style: { display: "flex", alignItems: "center", gap: "8px" },
            children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(Trash2, { size: 16 }),
              "Clear All Data"
            ]
          }
        )
      ] })
    ] })
  ] });
};
const DEFAULT_MAX_STORED_LOGS = 5e3;
const BATCH_WRITE_INTERVAL = 1e4;
const BATCH_SIZE_THRESHOLD = 50;
const _Logger = class _Logger {
  constructor(context, config, parentContext) {
    this.parentContext = parentContext;
    this.config = {
      context,
      remoteLogging: config?.remoteLogging ?? true,
      remoteUrl: config?.remoteUrl ?? "http://localhost:7856/log",
      consoleLogging: config?.consoleLogging ?? true,
      storeLogs: config?.storeLogs ?? true,
      maxStoredLogs: config?.maxStoredLogs ?? DEFAULT_MAX_STORED_LOGS
    };
    if (typeof chrome !== "undefined" && chrome.storage) {
      chrome.storage.local.get(["automationConfig"], (result) => {
        if (result.automationConfig?.remoteLogging !== void 0) {
          this.config.remoteLogging = result.automationConfig.remoteLogging;
        }
        if (result.automationConfig?.storeLogs !== void 0) {
          this.config.storeLogs = result.automationConfig.storeLogs;
        }
        if (result.automationConfig?.maxStoredLogs !== void 0) {
          this.config.maxStoredLogs = result.automationConfig.maxStoredLogs;
        }
      });
      chrome.storage.onChanged.addListener((changes, areaName) => {
        if (areaName === "local" && changes.automationConfig?.newValue) {
          const newConfig = changes.automationConfig.newValue;
          if (newConfig.remoteLogging !== void 0) {
            this.config.remoteLogging = newConfig.remoteLogging;
          }
          if (newConfig.storeLogs !== void 0) {
            this.config.storeLogs = newConfig.storeLogs;
          }
          if (newConfig.maxStoredLogs !== void 0) {
            this.config.maxStoredLogs = newConfig.maxStoredLogs;
          }
        }
      });
    }
  }
  /**
   * Send log to remote server
   */
  async sendToRemote(entry) {
    if (!this.config.remoteLogging) return;
    try {
      await fetch(this.config.remoteUrl, {
        method: "POST",
        headers: {
          "Content-Type": "application/json"
        },
        body: JSON.stringify(entry)
      }).catch(() => {
      });
    } catch (error) {
    }
  }
  /**
   * Flush buffered logs to chrome.storage
   * This is called periodically or when buffer reaches threshold
   */
  static async flushLogsToStorage() {
    if (typeof chrome === "undefined" || !chrome.storage) return;
    if (_Logger.logBuffer.length === 0) return;
    if (_Logger.flushTimer) {
      clearTimeout(_Logger.flushTimer);
      _Logger.flushTimer = null;
    }
    _Logger.isFlushScheduled = false;
    const logsToFlush = [..._Logger.logBuffer];
    _Logger.logBuffer = [];
    try {
      const result = await chrome.storage.local.get(["debugLogs", "automationConfig"]);
      const existingLogs = result.debugLogs || [];
      const maxLogs = result.automationConfig?.maxStoredLogs ?? DEFAULT_MAX_STORED_LOGS;
      const allLogs = [...existingLogs, ...logsToFlush];
      if (allLogs.length > maxLogs) {
        allLogs.splice(0, allLogs.length - maxLogs);
      }
      await chrome.storage.local.set({ debugLogs: allLogs });
    } catch (error) {
      _Logger.logBuffer.unshift(...logsToFlush);
      console.error("[LF] Failed to flush logs:", error);
    }
    if (_Logger.logBuffer.length > 0) {
      _Logger.scheduleFlush();
    }
  }
  /**
   * Schedule a flush to happen after the interval
   */
  static scheduleFlush() {
    if (_Logger.isFlushScheduled) return;
    _Logger.isFlushScheduled = true;
    _Logger.flushTimer = setTimeout(() => {
      _Logger.flushLogsToStorage();
    }, BATCH_WRITE_INTERVAL);
  }
  /**
   * Store log entry in buffer (will be flushed periodically)
   */
  storeLog(entry) {
    if (!this.config.storeLogs) return;
    if (typeof chrome === "undefined" || !chrome.storage) return;
    try {
      _Logger.logBuffer.push(entry);
      if (_Logger.logBuffer.length >= BATCH_SIZE_THRESHOLD) {
        _Logger.flushLogsToStorage();
      } else {
        _Logger.scheduleFlush();
      }
    } catch (error) {
      console.error("[LF] Failed to buffer log:", error);
    }
  }
  /**
   * Format message with prefix
   */
  formatMessage(message) {
    const fullContext = this.parentContext ? `${this.parentContext}][${this.config.context}` : this.config.context;
    return `[LF][${fullContext}] ${message}`;
  }
  /**
   * Serialize data for logging
   */
  serializeData(data) {
    if (data === void 0) return void 0;
    try {
      return JSON.parse(JSON.stringify(data));
    } catch (error) {
      return String(data);
    }
  }
  /**
   * Core logging function
   */
  logInternal(level, ...args) {
    const message = args.map((arg) => {
      if (typeof arg === "string") return arg;
      if (typeof arg === "object") {
        try {
          return JSON.stringify(arg);
        } catch (error) {
          return "[Circular Reference]";
        }
      }
      return String(arg);
    }).join(" ");
    const entry = {
      timestamp: (/* @__PURE__ */ new Date()).toISOString(),
      context: this.config.context,
      level,
      message,
      data: args.length > 1 ? this.serializeData(args.slice(1)) : void 0
    };
    if (this.config.consoleLogging) {
      const consoleMethod = console[level] || console.log;
      const fullContext = this.parentContext ? `${this.parentContext}][${this.config.context}` : this.config.context;
      consoleMethod(`[LF][${fullContext}]`, ...args);
    }
    this.storeLog(entry);
    this.sendToRemote(entry);
  }
  /**
   * Public logging methods - support unlimited parameters like console.log()
   */
  log(...args) {
    this.logInternal("log", ...args);
  }
  info(...args) {
    this.logInternal("info", ...args);
  }
  warn(...args) {
    this.logInternal("warn", ...args);
  }
  error(...args) {
    this.logInternal("error", ...args);
  }
  debug(...args) {
    this.logInternal("debug", ...args);
  }
  /**
   * Update logger configuration
   */
  setConfig(config) {
    this.config = { ...this.config, ...config };
  }
  /**
   * Enable/disable remote logging
   */
  setRemoteLogging(enabled) {
    this.config.remoteLogging = enabled;
  }
  /**
   * Enable/disable console logging
   */
  setConsoleLogging(enabled) {
    this.config.consoleLogging = enabled;
  }
  /**
   * Create a nested logger with additional context
   */
  createNestedLogger(nestedContext) {
    const fullContext = this.parentContext ? `${this.parentContext}][${this.config.context}` : this.config.context;
    return new _Logger(
      nestedContext,
      {
        remoteLogging: this.config.remoteLogging,
        remoteUrl: this.config.remoteUrl,
        consoleLogging: this.config.consoleLogging
      },
      fullContext
    );
  }
  /**
   * Flush all buffered logs to storage immediately
   * Call this before extension unload to prevent log loss
   */
  static async flushLogs() {
    return _Logger.flushLogsToStorage();
  }
};
_Logger.logBuffer = [];
_Logger.flushTimer = null;
_Logger.isFlushScheduled = false;
let Logger = _Logger;
function createLogger(context, config, parentContext) {
  return new Logger(context, config, parentContext);
}
async function exportLogs() {
  if (typeof chrome === "undefined" || !chrome.storage) {
    throw new Error("Chrome storage not available");
  }
  const result = await chrome.storage.local.get(["debugLogs"]);
  const logs = result.debugLogs || [];
  return JSON.stringify(
    {
      exportDate: (/* @__PURE__ */ new Date()).toISOString(),
      logCount: logs.length,
      logs
    },
    null,
    2
  );
}
async function clearLogs() {
  if (typeof chrome === "undefined" || !chrome.storage) {
    throw new Error("Chrome storage not available");
  }
  await chrome.storage.local.set({ debugLogs: [] });
}
async function getLogStats() {
  if (typeof chrome === "undefined" || !chrome.storage) {
    return { count: 0 };
  }
  const result = await chrome.storage.local.get(["debugLogs"]);
  const logs = result.debugLogs || [];
  return {
    count: logs.length,
    oldestLog: logs.length > 0 ? logs[0].timestamp : void 0,
    newestLog: logs.length > 0 ? logs[logs.length - 1].timestamp : void 0
  };
}
createLogger("POPUP");
createLogger("SW");
const redditLogger = createLogger("REDDIT");
createLogger("DEVVIT");
createLogger("DEVVIT-GIAE");
/**
   * table-core
   *
   * Copyright (c) TanStack
   *
   * This source code is licensed under the MIT license found in the
   * LICENSE.md file in the root directory of this source tree.
   *
   * @license MIT
   */
function functionalUpdate(updater, input) {
  return typeof updater === "function" ? updater(input) : updater;
}
function makeStateUpdater(key, instance) {
  return (updater) => {
    instance.setState((old) => {
      return {
        ...old,
        [key]: functionalUpdate(updater, old[key])
      };
    });
  };
}
function isFunction(d) {
  return d instanceof Function;
}
function isNumberArray(d) {
  return Array.isArray(d) && d.every((val) => typeof val === "number");
}
function flattenBy(arr, getChildren) {
  const flat = [];
  const recurse = (subArr) => {
    subArr.forEach((item) => {
      flat.push(item);
      const children = getChildren(item);
      if (children != null && children.length) {
        recurse(children);
      }
    });
  };
  recurse(arr);
  return flat;
}
function memo$1(getDeps, fn, opts) {
  let deps = [];
  let result;
  return (depArgs) => {
    let depTime;
    if (opts.key && opts.debug) depTime = Date.now();
    const newDeps = getDeps(depArgs);
    const depsChanged = newDeps.length !== deps.length || newDeps.some((dep, index) => deps[index] !== dep);
    if (!depsChanged) {
      return result;
    }
    deps = newDeps;
    let resultTime;
    if (opts.key && opts.debug) resultTime = Date.now();
    result = fn(...newDeps);
    opts == null || opts.onChange == null || opts.onChange(result);
    if (opts.key && opts.debug) {
      if (opts != null && opts.debug()) {
        const depEndTime = Math.round((Date.now() - depTime) * 100) / 100;
        const resultEndTime = Math.round((Date.now() - resultTime) * 100) / 100;
        const resultFpsPercentage = resultEndTime / 16;
        const pad = (str, num) => {
          str = String(str);
          while (str.length < num) {
            str = " " + str;
          }
          return str;
        };
        console.info(`%c⏱ ${pad(resultEndTime, 5)} /${pad(depEndTime, 5)} ms`, `
            font-size: .6rem;
            font-weight: bold;
            color: hsl(${Math.max(0, Math.min(120 - 120 * resultFpsPercentage, 120))}deg 100% 31%);`, opts == null ? void 0 : opts.key);
      }
    }
    return result;
  };
}
function getMemoOptions(tableOptions, debugLevel, key, onChange) {
  return {
    debug: () => {
      var _tableOptions$debugAl;
      return (_tableOptions$debugAl = tableOptions == null ? void 0 : tableOptions.debugAll) != null ? _tableOptions$debugAl : tableOptions[debugLevel];
    },
    key: false,
    onChange
  };
}
function createCell(table, row, column, columnId) {
  const getRenderValue = () => {
    var _cell$getValue;
    return (_cell$getValue = cell.getValue()) != null ? _cell$getValue : table.options.renderFallbackValue;
  };
  const cell = {
    id: `${row.id}_${column.id}`,
    row,
    column,
    getValue: () => row.getValue(columnId),
    renderValue: getRenderValue,
    getContext: memo$1(() => [table, column, row, cell], (table2, column2, row2, cell2) => ({
      table: table2,
      column: column2,
      row: row2,
      cell: cell2,
      getValue: cell2.getValue,
      renderValue: cell2.renderValue
    }), getMemoOptions(table.options, "debugCells"))
  };
  table._features.forEach((feature) => {
    feature.createCell == null || feature.createCell(cell, column, row, table);
  }, {});
  return cell;
}
function createColumn(table, columnDef, depth, parent) {
  var _ref, _resolvedColumnDef$id;
  const defaultColumn = table._getDefaultColumnDef();
  const resolvedColumnDef = {
    ...defaultColumn,
    ...columnDef
  };
  const accessorKey = resolvedColumnDef.accessorKey;
  let id = (_ref = (_resolvedColumnDef$id = resolvedColumnDef.id) != null ? _resolvedColumnDef$id : accessorKey ? typeof String.prototype.replaceAll === "function" ? accessorKey.replaceAll(".", "_") : accessorKey.replace(/\./g, "_") : void 0) != null ? _ref : typeof resolvedColumnDef.header === "string" ? resolvedColumnDef.header : void 0;
  let accessorFn;
  if (resolvedColumnDef.accessorFn) {
    accessorFn = resolvedColumnDef.accessorFn;
  } else if (accessorKey) {
    if (accessorKey.includes(".")) {
      accessorFn = (originalRow) => {
        let result = originalRow;
        for (const key of accessorKey.split(".")) {
          var _result;
          result = (_result = result) == null ? void 0 : _result[key];
        }
        return result;
      };
    } else {
      accessorFn = (originalRow) => originalRow[resolvedColumnDef.accessorKey];
    }
  }
  if (!id) {
    throw new Error();
  }
  let column = {
    id: `${String(id)}`,
    accessorFn,
    parent,
    depth,
    columnDef: resolvedColumnDef,
    columns: [],
    getFlatColumns: memo$1(() => [true], () => {
      var _column$columns;
      return [column, ...(_column$columns = column.columns) == null ? void 0 : _column$columns.flatMap((d) => d.getFlatColumns())];
    }, getMemoOptions(table.options, "debugColumns")),
    getLeafColumns: memo$1(() => [table._getOrderColumnsFn()], (orderColumns2) => {
      var _column$columns2;
      if ((_column$columns2 = column.columns) != null && _column$columns2.length) {
        let leafColumns = column.columns.flatMap((column2) => column2.getLeafColumns());
        return orderColumns2(leafColumns);
      }
      return [column];
    }, getMemoOptions(table.options, "debugColumns"))
  };
  for (const feature of table._features) {
    feature.createColumn == null || feature.createColumn(column, table);
  }
  return column;
}
const debug = "debugHeaders";
function createHeader(table, column, options) {
  var _options$id;
  const id = (_options$id = options.id) != null ? _options$id : column.id;
  let header = {
    id,
    column,
    index: options.index,
    isPlaceholder: !!options.isPlaceholder,
    placeholderId: options.placeholderId,
    depth: options.depth,
    subHeaders: [],
    colSpan: 0,
    rowSpan: 0,
    headerGroup: null,
    getLeafHeaders: () => {
      const leafHeaders = [];
      const recurseHeader = (h) => {
        if (h.subHeaders && h.subHeaders.length) {
          h.subHeaders.map(recurseHeader);
        }
        leafHeaders.push(h);
      };
      recurseHeader(header);
      return leafHeaders;
    },
    getContext: () => ({
      table,
      header,
      column
    })
  };
  table._features.forEach((feature) => {
    feature.createHeader == null || feature.createHeader(header, table);
  });
  return header;
}
const Headers = {
  createTable: (table) => {
    table.getHeaderGroups = memo$1(() => [table.getAllColumns(), table.getVisibleLeafColumns(), table.getState().columnPinning.left, table.getState().columnPinning.right], (allColumns, leafColumns, left, right) => {
      var _left$map$filter, _right$map$filter;
      const leftColumns = (_left$map$filter = left == null ? void 0 : left.map((columnId) => leafColumns.find((d) => d.id === columnId)).filter(Boolean)) != null ? _left$map$filter : [];
      const rightColumns = (_right$map$filter = right == null ? void 0 : right.map((columnId) => leafColumns.find((d) => d.id === columnId)).filter(Boolean)) != null ? _right$map$filter : [];
      const centerColumns = leafColumns.filter((column) => !(left != null && left.includes(column.id)) && !(right != null && right.includes(column.id)));
      const headerGroups = buildHeaderGroups(allColumns, [...leftColumns, ...centerColumns, ...rightColumns], table);
      return headerGroups;
    }, getMemoOptions(table.options, debug));
    table.getCenterHeaderGroups = memo$1(() => [table.getAllColumns(), table.getVisibleLeafColumns(), table.getState().columnPinning.left, table.getState().columnPinning.right], (allColumns, leafColumns, left, right) => {
      leafColumns = leafColumns.filter((column) => !(left != null && left.includes(column.id)) && !(right != null && right.includes(column.id)));
      return buildHeaderGroups(allColumns, leafColumns, table, "center");
    }, getMemoOptions(table.options, debug));
    table.getLeftHeaderGroups = memo$1(() => [table.getAllColumns(), table.getVisibleLeafColumns(), table.getState().columnPinning.left], (allColumns, leafColumns, left) => {
      var _left$map$filter2;
      const orderedLeafColumns = (_left$map$filter2 = left == null ? void 0 : left.map((columnId) => leafColumns.find((d) => d.id === columnId)).filter(Boolean)) != null ? _left$map$filter2 : [];
      return buildHeaderGroups(allColumns, orderedLeafColumns, table, "left");
    }, getMemoOptions(table.options, debug));
    table.getRightHeaderGroups = memo$1(() => [table.getAllColumns(), table.getVisibleLeafColumns(), table.getState().columnPinning.right], (allColumns, leafColumns, right) => {
      var _right$map$filter2;
      const orderedLeafColumns = (_right$map$filter2 = right == null ? void 0 : right.map((columnId) => leafColumns.find((d) => d.id === columnId)).filter(Boolean)) != null ? _right$map$filter2 : [];
      return buildHeaderGroups(allColumns, orderedLeafColumns, table, "right");
    }, getMemoOptions(table.options, debug));
    table.getFooterGroups = memo$1(() => [table.getHeaderGroups()], (headerGroups) => {
      return [...headerGroups].reverse();
    }, getMemoOptions(table.options, debug));
    table.getLeftFooterGroups = memo$1(() => [table.getLeftHeaderGroups()], (headerGroups) => {
      return [...headerGroups].reverse();
    }, getMemoOptions(table.options, debug));
    table.getCenterFooterGroups = memo$1(() => [table.getCenterHeaderGroups()], (headerGroups) => {
      return [...headerGroups].reverse();
    }, getMemoOptions(table.options, debug));
    table.getRightFooterGroups = memo$1(() => [table.getRightHeaderGroups()], (headerGroups) => {
      return [...headerGroups].reverse();
    }, getMemoOptions(table.options, debug));
    table.getFlatHeaders = memo$1(() => [table.getHeaderGroups()], (headerGroups) => {
      return headerGroups.map((headerGroup) => {
        return headerGroup.headers;
      }).flat();
    }, getMemoOptions(table.options, debug));
    table.getLeftFlatHeaders = memo$1(() => [table.getLeftHeaderGroups()], (left) => {
      return left.map((headerGroup) => {
        return headerGroup.headers;
      }).flat();
    }, getMemoOptions(table.options, debug));
    table.getCenterFlatHeaders = memo$1(() => [table.getCenterHeaderGroups()], (left) => {
      return left.map((headerGroup) => {
        return headerGroup.headers;
      }).flat();
    }, getMemoOptions(table.options, debug));
    table.getRightFlatHeaders = memo$1(() => [table.getRightHeaderGroups()], (left) => {
      return left.map((headerGroup) => {
        return headerGroup.headers;
      }).flat();
    }, getMemoOptions(table.options, debug));
    table.getCenterLeafHeaders = memo$1(() => [table.getCenterFlatHeaders()], (flatHeaders) => {
      return flatHeaders.filter((header) => {
        var _header$subHeaders;
        return !((_header$subHeaders = header.subHeaders) != null && _header$subHeaders.length);
      });
    }, getMemoOptions(table.options, debug));
    table.getLeftLeafHeaders = memo$1(() => [table.getLeftFlatHeaders()], (flatHeaders) => {
      return flatHeaders.filter((header) => {
        var _header$subHeaders2;
        return !((_header$subHeaders2 = header.subHeaders) != null && _header$subHeaders2.length);
      });
    }, getMemoOptions(table.options, debug));
    table.getRightLeafHeaders = memo$1(() => [table.getRightFlatHeaders()], (flatHeaders) => {
      return flatHeaders.filter((header) => {
        var _header$subHeaders3;
        return !((_header$subHeaders3 = header.subHeaders) != null && _header$subHeaders3.length);
      });
    }, getMemoOptions(table.options, debug));
    table.getLeafHeaders = memo$1(() => [table.getLeftHeaderGroups(), table.getCenterHeaderGroups(), table.getRightHeaderGroups()], (left, center, right) => {
      var _left$0$headers, _left$, _center$0$headers, _center$, _right$0$headers, _right$;
      return [...(_left$0$headers = (_left$ = left[0]) == null ? void 0 : _left$.headers) != null ? _left$0$headers : [], ...(_center$0$headers = (_center$ = center[0]) == null ? void 0 : _center$.headers) != null ? _center$0$headers : [], ...(_right$0$headers = (_right$ = right[0]) == null ? void 0 : _right$.headers) != null ? _right$0$headers : []].map((header) => {
        return header.getLeafHeaders();
      }).flat();
    }, getMemoOptions(table.options, debug));
  }
};
function buildHeaderGroups(allColumns, columnsToGroup, table, headerFamily) {
  var _headerGroups$0$heade, _headerGroups$;
  let maxDepth = 0;
  const findMaxDepth = function(columns, depth) {
    if (depth === void 0) {
      depth = 1;
    }
    maxDepth = Math.max(maxDepth, depth);
    columns.filter((column) => column.getIsVisible()).forEach((column) => {
      var _column$columns;
      if ((_column$columns = column.columns) != null && _column$columns.length) {
        findMaxDepth(column.columns, depth + 1);
      }
    }, 0);
  };
  findMaxDepth(allColumns);
  let headerGroups = [];
  const createHeaderGroup = (headersToGroup, depth) => {
    const headerGroup = {
      depth,
      id: [headerFamily, `${depth}`].filter(Boolean).join("_"),
      headers: []
    };
    const pendingParentHeaders = [];
    headersToGroup.forEach((headerToGroup) => {
      const latestPendingParentHeader = [...pendingParentHeaders].reverse()[0];
      const isLeafHeader = headerToGroup.column.depth === headerGroup.depth;
      let column;
      let isPlaceholder = false;
      if (isLeafHeader && headerToGroup.column.parent) {
        column = headerToGroup.column.parent;
      } else {
        column = headerToGroup.column;
        isPlaceholder = true;
      }
      if (latestPendingParentHeader && (latestPendingParentHeader == null ? void 0 : latestPendingParentHeader.column) === column) {
        latestPendingParentHeader.subHeaders.push(headerToGroup);
      } else {
        const header = createHeader(table, column, {
          id: [headerFamily, depth, column.id, headerToGroup == null ? void 0 : headerToGroup.id].filter(Boolean).join("_"),
          isPlaceholder,
          placeholderId: isPlaceholder ? `${pendingParentHeaders.filter((d) => d.column === column).length}` : void 0,
          depth,
          index: pendingParentHeaders.length
        });
        header.subHeaders.push(headerToGroup);
        pendingParentHeaders.push(header);
      }
      headerGroup.headers.push(headerToGroup);
      headerToGroup.headerGroup = headerGroup;
    });
    headerGroups.push(headerGroup);
    if (depth > 0) {
      createHeaderGroup(pendingParentHeaders, depth - 1);
    }
  };
  const bottomHeaders = columnsToGroup.map((column, index) => createHeader(table, column, {
    depth: maxDepth,
    index
  }));
  createHeaderGroup(bottomHeaders, maxDepth - 1);
  headerGroups.reverse();
  const recurseHeadersForSpans = (headers) => {
    const filteredHeaders = headers.filter((header) => header.column.getIsVisible());
    return filteredHeaders.map((header) => {
      let colSpan = 0;
      let rowSpan = 0;
      let childRowSpans = [0];
      if (header.subHeaders && header.subHeaders.length) {
        childRowSpans = [];
        recurseHeadersForSpans(header.subHeaders).forEach((_ref) => {
          let {
            colSpan: childColSpan,
            rowSpan: childRowSpan
          } = _ref;
          colSpan += childColSpan;
          childRowSpans.push(childRowSpan);
        });
      } else {
        colSpan = 1;
      }
      const minChildRowSpan = Math.min(...childRowSpans);
      rowSpan = rowSpan + minChildRowSpan;
      header.colSpan = colSpan;
      header.rowSpan = rowSpan;
      return {
        colSpan,
        rowSpan
      };
    });
  };
  recurseHeadersForSpans((_headerGroups$0$heade = (_headerGroups$ = headerGroups[0]) == null ? void 0 : _headerGroups$.headers) != null ? _headerGroups$0$heade : []);
  return headerGroups;
}
const createRow = (table, id, original, rowIndex, depth, subRows, parentId) => {
  let row = {
    id,
    index: rowIndex,
    original,
    depth,
    parentId,
    _valuesCache: {},
    _uniqueValuesCache: {},
    getValue: (columnId) => {
      if (row._valuesCache.hasOwnProperty(columnId)) {
        return row._valuesCache[columnId];
      }
      const column = table.getColumn(columnId);
      if (!(column != null && column.accessorFn)) {
        return void 0;
      }
      row._valuesCache[columnId] = column.accessorFn(row.original, rowIndex);
      return row._valuesCache[columnId];
    },
    getUniqueValues: (columnId) => {
      if (row._uniqueValuesCache.hasOwnProperty(columnId)) {
        return row._uniqueValuesCache[columnId];
      }
      const column = table.getColumn(columnId);
      if (!(column != null && column.accessorFn)) {
        return void 0;
      }
      if (!column.columnDef.getUniqueValues) {
        row._uniqueValuesCache[columnId] = [row.getValue(columnId)];
        return row._uniqueValuesCache[columnId];
      }
      row._uniqueValuesCache[columnId] = column.columnDef.getUniqueValues(row.original, rowIndex);
      return row._uniqueValuesCache[columnId];
    },
    renderValue: (columnId) => {
      var _row$getValue;
      return (_row$getValue = row.getValue(columnId)) != null ? _row$getValue : table.options.renderFallbackValue;
    },
    subRows: [],
    getLeafRows: () => flattenBy(row.subRows, (d) => d.subRows),
    getParentRow: () => row.parentId ? table.getRow(row.parentId, true) : void 0,
    getParentRows: () => {
      let parentRows = [];
      let currentRow = row;
      while (true) {
        const parentRow = currentRow.getParentRow();
        if (!parentRow) break;
        parentRows.push(parentRow);
        currentRow = parentRow;
      }
      return parentRows.reverse();
    },
    getAllCells: memo$1(() => [table.getAllLeafColumns()], (leafColumns) => {
      return leafColumns.map((column) => {
        return createCell(table, row, column, column.id);
      });
    }, getMemoOptions(table.options, "debugRows")),
    _getAllCellsByColumnId: memo$1(() => [row.getAllCells()], (allCells) => {
      return allCells.reduce((acc, cell) => {
        acc[cell.column.id] = cell;
        return acc;
      }, {});
    }, getMemoOptions(table.options, "debugRows"))
  };
  for (let i = 0; i < table._features.length; i++) {
    const feature = table._features[i];
    feature == null || feature.createRow == null || feature.createRow(row, table);
  }
  return row;
};
const ColumnFaceting = {
  createColumn: (column, table) => {
    column._getFacetedRowModel = table.options.getFacetedRowModel && table.options.getFacetedRowModel(table, column.id);
    column.getFacetedRowModel = () => {
      if (!column._getFacetedRowModel) {
        return table.getPreFilteredRowModel();
      }
      return column._getFacetedRowModel();
    };
    column._getFacetedUniqueValues = table.options.getFacetedUniqueValues && table.options.getFacetedUniqueValues(table, column.id);
    column.getFacetedUniqueValues = () => {
      if (!column._getFacetedUniqueValues) {
        return /* @__PURE__ */ new Map();
      }
      return column._getFacetedUniqueValues();
    };
    column._getFacetedMinMaxValues = table.options.getFacetedMinMaxValues && table.options.getFacetedMinMaxValues(table, column.id);
    column.getFacetedMinMaxValues = () => {
      if (!column._getFacetedMinMaxValues) {
        return void 0;
      }
      return column._getFacetedMinMaxValues();
    };
  }
};
const includesString = (row, columnId, filterValue) => {
  var _filterValue$toString, _row$getValue;
  const search = filterValue == null || (_filterValue$toString = filterValue.toString()) == null ? void 0 : _filterValue$toString.toLowerCase();
  return Boolean((_row$getValue = row.getValue(columnId)) == null || (_row$getValue = _row$getValue.toString()) == null || (_row$getValue = _row$getValue.toLowerCase()) == null ? void 0 : _row$getValue.includes(search));
};
includesString.autoRemove = (val) => testFalsey(val);
const includesStringSensitive = (row, columnId, filterValue) => {
  var _row$getValue2;
  return Boolean((_row$getValue2 = row.getValue(columnId)) == null || (_row$getValue2 = _row$getValue2.toString()) == null ? void 0 : _row$getValue2.includes(filterValue));
};
includesStringSensitive.autoRemove = (val) => testFalsey(val);
const equalsString = (row, columnId, filterValue) => {
  var _row$getValue3;
  return ((_row$getValue3 = row.getValue(columnId)) == null || (_row$getValue3 = _row$getValue3.toString()) == null ? void 0 : _row$getValue3.toLowerCase()) === (filterValue == null ? void 0 : filterValue.toLowerCase());
};
equalsString.autoRemove = (val) => testFalsey(val);
const arrIncludes = (row, columnId, filterValue) => {
  var _row$getValue4;
  return (_row$getValue4 = row.getValue(columnId)) == null ? void 0 : _row$getValue4.includes(filterValue);
};
arrIncludes.autoRemove = (val) => testFalsey(val);
const arrIncludesAll = (row, columnId, filterValue) => {
  return !filterValue.some((val) => {
    var _row$getValue5;
    return !((_row$getValue5 = row.getValue(columnId)) != null && _row$getValue5.includes(val));
  });
};
arrIncludesAll.autoRemove = (val) => testFalsey(val) || !(val != null && val.length);
const arrIncludesSome = (row, columnId, filterValue) => {
  return filterValue.some((val) => {
    var _row$getValue6;
    return (_row$getValue6 = row.getValue(columnId)) == null ? void 0 : _row$getValue6.includes(val);
  });
};
arrIncludesSome.autoRemove = (val) => testFalsey(val) || !(val != null && val.length);
const equals = (row, columnId, filterValue) => {
  return row.getValue(columnId) === filterValue;
};
equals.autoRemove = (val) => testFalsey(val);
const weakEquals = (row, columnId, filterValue) => {
  return row.getValue(columnId) == filterValue;
};
weakEquals.autoRemove = (val) => testFalsey(val);
const inNumberRange = (row, columnId, filterValue) => {
  let [min2, max2] = filterValue;
  const rowValue = row.getValue(columnId);
  return rowValue >= min2 && rowValue <= max2;
};
inNumberRange.resolveFilterValue = (val) => {
  let [unsafeMin, unsafeMax] = val;
  let parsedMin = typeof unsafeMin !== "number" ? parseFloat(unsafeMin) : unsafeMin;
  let parsedMax = typeof unsafeMax !== "number" ? parseFloat(unsafeMax) : unsafeMax;
  let min2 = unsafeMin === null || Number.isNaN(parsedMin) ? -Infinity : parsedMin;
  let max2 = unsafeMax === null || Number.isNaN(parsedMax) ? Infinity : parsedMax;
  if (min2 > max2) {
    const temp = min2;
    min2 = max2;
    max2 = temp;
  }
  return [min2, max2];
};
inNumberRange.autoRemove = (val) => testFalsey(val) || testFalsey(val[0]) && testFalsey(val[1]);
const filterFns = {
  includesString,
  includesStringSensitive,
  equalsString,
  arrIncludes,
  arrIncludesAll,
  arrIncludesSome,
  equals,
  weakEquals,
  inNumberRange
};
function testFalsey(val) {
  return val === void 0 || val === null || val === "";
}
const ColumnFiltering = {
  getDefaultColumnDef: () => {
    return {
      filterFn: "auto"
    };
  },
  getInitialState: (state) => {
    return {
      columnFilters: [],
      ...state
    };
  },
  getDefaultOptions: (table) => {
    return {
      onColumnFiltersChange: makeStateUpdater("columnFilters", table),
      filterFromLeafRows: false,
      maxLeafRowFilterDepth: 100
    };
  },
  createColumn: (column, table) => {
    column.getAutoFilterFn = () => {
      const firstRow = table.getCoreRowModel().flatRows[0];
      const value = firstRow == null ? void 0 : firstRow.getValue(column.id);
      if (typeof value === "string") {
        return filterFns.includesString;
      }
      if (typeof value === "number") {
        return filterFns.inNumberRange;
      }
      if (typeof value === "boolean") {
        return filterFns.equals;
      }
      if (value !== null && typeof value === "object") {
        return filterFns.equals;
      }
      if (Array.isArray(value)) {
        return filterFns.arrIncludes;
      }
      return filterFns.weakEquals;
    };
    column.getFilterFn = () => {
      var _table$options$filter, _table$options$filter2;
      return isFunction(column.columnDef.filterFn) ? column.columnDef.filterFn : column.columnDef.filterFn === "auto" ? column.getAutoFilterFn() : (
        // @ts-ignore
        (_table$options$filter = (_table$options$filter2 = table.options.filterFns) == null ? void 0 : _table$options$filter2[column.columnDef.filterFn]) != null ? _table$options$filter : filterFns[column.columnDef.filterFn]
      );
    };
    column.getCanFilter = () => {
      var _column$columnDef$ena, _table$options$enable, _table$options$enable2;
      return ((_column$columnDef$ena = column.columnDef.enableColumnFilter) != null ? _column$columnDef$ena : true) && ((_table$options$enable = table.options.enableColumnFilters) != null ? _table$options$enable : true) && ((_table$options$enable2 = table.options.enableFilters) != null ? _table$options$enable2 : true) && !!column.accessorFn;
    };
    column.getIsFiltered = () => column.getFilterIndex() > -1;
    column.getFilterValue = () => {
      var _table$getState$colum;
      return (_table$getState$colum = table.getState().columnFilters) == null || (_table$getState$colum = _table$getState$colum.find((d) => d.id === column.id)) == null ? void 0 : _table$getState$colum.value;
    };
    column.getFilterIndex = () => {
      var _table$getState$colum2, _table$getState$colum3;
      return (_table$getState$colum2 = (_table$getState$colum3 = table.getState().columnFilters) == null ? void 0 : _table$getState$colum3.findIndex((d) => d.id === column.id)) != null ? _table$getState$colum2 : -1;
    };
    column.setFilterValue = (value) => {
      table.setColumnFilters((old) => {
        const filterFn = column.getFilterFn();
        const previousFilter = old == null ? void 0 : old.find((d) => d.id === column.id);
        const newFilter = functionalUpdate(value, previousFilter ? previousFilter.value : void 0);
        if (shouldAutoRemoveFilter(filterFn, newFilter, column)) {
          var _old$filter;
          return (_old$filter = old == null ? void 0 : old.filter((d) => d.id !== column.id)) != null ? _old$filter : [];
        }
        const newFilterObj = {
          id: column.id,
          value: newFilter
        };
        if (previousFilter) {
          var _old$map;
          return (_old$map = old == null ? void 0 : old.map((d) => {
            if (d.id === column.id) {
              return newFilterObj;
            }
            return d;
          })) != null ? _old$map : [];
        }
        if (old != null && old.length) {
          return [...old, newFilterObj];
        }
        return [newFilterObj];
      });
    };
  },
  createRow: (row, _table) => {
    row.columnFilters = {};
    row.columnFiltersMeta = {};
  },
  createTable: (table) => {
    table.setColumnFilters = (updater) => {
      const leafColumns = table.getAllLeafColumns();
      const updateFn = (old) => {
        var _functionalUpdate;
        return (_functionalUpdate = functionalUpdate(updater, old)) == null ? void 0 : _functionalUpdate.filter((filter) => {
          const column = leafColumns.find((d) => d.id === filter.id);
          if (column) {
            const filterFn = column.getFilterFn();
            if (shouldAutoRemoveFilter(filterFn, filter.value, column)) {
              return false;
            }
          }
          return true;
        });
      };
      table.options.onColumnFiltersChange == null || table.options.onColumnFiltersChange(updateFn);
    };
    table.resetColumnFilters = (defaultState) => {
      var _table$initialState$c, _table$initialState;
      table.setColumnFilters(defaultState ? [] : (_table$initialState$c = (_table$initialState = table.initialState) == null ? void 0 : _table$initialState.columnFilters) != null ? _table$initialState$c : []);
    };
    table.getPreFilteredRowModel = () => table.getCoreRowModel();
    table.getFilteredRowModel = () => {
      if (!table._getFilteredRowModel && table.options.getFilteredRowModel) {
        table._getFilteredRowModel = table.options.getFilteredRowModel(table);
      }
      if (table.options.manualFiltering || !table._getFilteredRowModel) {
        return table.getPreFilteredRowModel();
      }
      return table._getFilteredRowModel();
    };
  }
};
function shouldAutoRemoveFilter(filterFn, value, column) {
  return (filterFn && filterFn.autoRemove ? filterFn.autoRemove(value, column) : false) || typeof value === "undefined" || typeof value === "string" && !value;
}
const sum = (columnId, _leafRows, childRows) => {
  return childRows.reduce((sum2, next) => {
    const nextValue = next.getValue(columnId);
    return sum2 + (typeof nextValue === "number" ? nextValue : 0);
  }, 0);
};
const min = (columnId, _leafRows, childRows) => {
  let min2;
  childRows.forEach((row) => {
    const value = row.getValue(columnId);
    if (value != null && (min2 > value || min2 === void 0 && value >= value)) {
      min2 = value;
    }
  });
  return min2;
};
const max = (columnId, _leafRows, childRows) => {
  let max2;
  childRows.forEach((row) => {
    const value = row.getValue(columnId);
    if (value != null && (max2 < value || max2 === void 0 && value >= value)) {
      max2 = value;
    }
  });
  return max2;
};
const extent = (columnId, _leafRows, childRows) => {
  let min2;
  let max2;
  childRows.forEach((row) => {
    const value = row.getValue(columnId);
    if (value != null) {
      if (min2 === void 0) {
        if (value >= value) min2 = max2 = value;
      } else {
        if (min2 > value) min2 = value;
        if (max2 < value) max2 = value;
      }
    }
  });
  return [min2, max2];
};
const mean = (columnId, leafRows) => {
  let count2 = 0;
  let sum2 = 0;
  leafRows.forEach((row) => {
    let value = row.getValue(columnId);
    if (value != null && (value = +value) >= value) {
      ++count2, sum2 += value;
    }
  });
  if (count2) return sum2 / count2;
  return;
};
const median = (columnId, leafRows) => {
  if (!leafRows.length) {
    return;
  }
  const values = leafRows.map((row) => row.getValue(columnId));
  if (!isNumberArray(values)) {
    return;
  }
  if (values.length === 1) {
    return values[0];
  }
  const mid = Math.floor(values.length / 2);
  const nums = values.sort((a, b) => a - b);
  return values.length % 2 !== 0 ? nums[mid] : (nums[mid - 1] + nums[mid]) / 2;
};
const unique = (columnId, leafRows) => {
  return Array.from(new Set(leafRows.map((d) => d.getValue(columnId))).values());
};
const uniqueCount = (columnId, leafRows) => {
  return new Set(leafRows.map((d) => d.getValue(columnId))).size;
};
const count = (_columnId, leafRows) => {
  return leafRows.length;
};
const aggregationFns = {
  sum,
  min,
  max,
  extent,
  mean,
  median,
  unique,
  uniqueCount,
  count
};
const ColumnGrouping = {
  getDefaultColumnDef: () => {
    return {
      aggregatedCell: (props) => {
        var _toString, _props$getValue;
        return (_toString = (_props$getValue = props.getValue()) == null || _props$getValue.toString == null ? void 0 : _props$getValue.toString()) != null ? _toString : null;
      },
      aggregationFn: "auto"
    };
  },
  getInitialState: (state) => {
    return {
      grouping: [],
      ...state
    };
  },
  getDefaultOptions: (table) => {
    return {
      onGroupingChange: makeStateUpdater("grouping", table),
      groupedColumnMode: "reorder"
    };
  },
  createColumn: (column, table) => {
    column.toggleGrouping = () => {
      table.setGrouping((old) => {
        if (old != null && old.includes(column.id)) {
          return old.filter((d) => d !== column.id);
        }
        return [...old != null ? old : [], column.id];
      });
    };
    column.getCanGroup = () => {
      var _column$columnDef$ena, _table$options$enable;
      return ((_column$columnDef$ena = column.columnDef.enableGrouping) != null ? _column$columnDef$ena : true) && ((_table$options$enable = table.options.enableGrouping) != null ? _table$options$enable : true) && (!!column.accessorFn || !!column.columnDef.getGroupingValue);
    };
    column.getIsGrouped = () => {
      var _table$getState$group;
      return (_table$getState$group = table.getState().grouping) == null ? void 0 : _table$getState$group.includes(column.id);
    };
    column.getGroupedIndex = () => {
      var _table$getState$group2;
      return (_table$getState$group2 = table.getState().grouping) == null ? void 0 : _table$getState$group2.indexOf(column.id);
    };
    column.getToggleGroupingHandler = () => {
      const canGroup = column.getCanGroup();
      return () => {
        if (!canGroup) return;
        column.toggleGrouping();
      };
    };
    column.getAutoAggregationFn = () => {
      const firstRow = table.getCoreRowModel().flatRows[0];
      const value = firstRow == null ? void 0 : firstRow.getValue(column.id);
      if (typeof value === "number") {
        return aggregationFns.sum;
      }
      if (Object.prototype.toString.call(value) === "[object Date]") {
        return aggregationFns.extent;
      }
    };
    column.getAggregationFn = () => {
      var _table$options$aggreg, _table$options$aggreg2;
      if (!column) {
        throw new Error();
      }
      return isFunction(column.columnDef.aggregationFn) ? column.columnDef.aggregationFn : column.columnDef.aggregationFn === "auto" ? column.getAutoAggregationFn() : (_table$options$aggreg = (_table$options$aggreg2 = table.options.aggregationFns) == null ? void 0 : _table$options$aggreg2[column.columnDef.aggregationFn]) != null ? _table$options$aggreg : aggregationFns[column.columnDef.aggregationFn];
    };
  },
  createTable: (table) => {
    table.setGrouping = (updater) => table.options.onGroupingChange == null ? void 0 : table.options.onGroupingChange(updater);
    table.resetGrouping = (defaultState) => {
      var _table$initialState$g, _table$initialState;
      table.setGrouping(defaultState ? [] : (_table$initialState$g = (_table$initialState = table.initialState) == null ? void 0 : _table$initialState.grouping) != null ? _table$initialState$g : []);
    };
    table.getPreGroupedRowModel = () => table.getFilteredRowModel();
    table.getGroupedRowModel = () => {
      if (!table._getGroupedRowModel && table.options.getGroupedRowModel) {
        table._getGroupedRowModel = table.options.getGroupedRowModel(table);
      }
      if (table.options.manualGrouping || !table._getGroupedRowModel) {
        return table.getPreGroupedRowModel();
      }
      return table._getGroupedRowModel();
    };
  },
  createRow: (row, table) => {
    row.getIsGrouped = () => !!row.groupingColumnId;
    row.getGroupingValue = (columnId) => {
      if (row._groupingValuesCache.hasOwnProperty(columnId)) {
        return row._groupingValuesCache[columnId];
      }
      const column = table.getColumn(columnId);
      if (!(column != null && column.columnDef.getGroupingValue)) {
        return row.getValue(columnId);
      }
      row._groupingValuesCache[columnId] = column.columnDef.getGroupingValue(row.original);
      return row._groupingValuesCache[columnId];
    };
    row._groupingValuesCache = {};
  },
  createCell: (cell, column, row, table) => {
    cell.getIsGrouped = () => column.getIsGrouped() && column.id === row.groupingColumnId;
    cell.getIsPlaceholder = () => !cell.getIsGrouped() && column.getIsGrouped();
    cell.getIsAggregated = () => {
      var _row$subRows;
      return !cell.getIsGrouped() && !cell.getIsPlaceholder() && !!((_row$subRows = row.subRows) != null && _row$subRows.length);
    };
  }
};
function orderColumns(leafColumns, grouping, groupedColumnMode) {
  if (!(grouping != null && grouping.length) || !groupedColumnMode) {
    return leafColumns;
  }
  const nonGroupingColumns = leafColumns.filter((col) => !grouping.includes(col.id));
  if (groupedColumnMode === "remove") {
    return nonGroupingColumns;
  }
  const groupingColumns = grouping.map((g) => leafColumns.find((col) => col.id === g)).filter(Boolean);
  return [...groupingColumns, ...nonGroupingColumns];
}
const ColumnOrdering = {
  getInitialState: (state) => {
    return {
      columnOrder: [],
      ...state
    };
  },
  getDefaultOptions: (table) => {
    return {
      onColumnOrderChange: makeStateUpdater("columnOrder", table)
    };
  },
  createColumn: (column, table) => {
    column.getIndex = memo$1((position) => [_getVisibleLeafColumns(table, position)], (columns) => columns.findIndex((d) => d.id === column.id), getMemoOptions(table.options, "debugColumns"));
    column.getIsFirstColumn = (position) => {
      var _columns$;
      const columns = _getVisibleLeafColumns(table, position);
      return ((_columns$ = columns[0]) == null ? void 0 : _columns$.id) === column.id;
    };
    column.getIsLastColumn = (position) => {
      var _columns;
      const columns = _getVisibleLeafColumns(table, position);
      return ((_columns = columns[columns.length - 1]) == null ? void 0 : _columns.id) === column.id;
    };
  },
  createTable: (table) => {
    table.setColumnOrder = (updater) => table.options.onColumnOrderChange == null ? void 0 : table.options.onColumnOrderChange(updater);
    table.resetColumnOrder = (defaultState) => {
      var _table$initialState$c;
      table.setColumnOrder(defaultState ? [] : (_table$initialState$c = table.initialState.columnOrder) != null ? _table$initialState$c : []);
    };
    table._getOrderColumnsFn = memo$1(() => [table.getState().columnOrder, table.getState().grouping, table.options.groupedColumnMode], (columnOrder, grouping, groupedColumnMode) => (columns) => {
      let orderedColumns = [];
      if (!(columnOrder != null && columnOrder.length)) {
        orderedColumns = columns;
      } else {
        const columnOrderCopy = [...columnOrder];
        const columnsCopy = [...columns];
        while (columnsCopy.length && columnOrderCopy.length) {
          const targetColumnId = columnOrderCopy.shift();
          const foundIndex = columnsCopy.findIndex((d) => d.id === targetColumnId);
          if (foundIndex > -1) {
            orderedColumns.push(columnsCopy.splice(foundIndex, 1)[0]);
          }
        }
        orderedColumns = [...orderedColumns, ...columnsCopy];
      }
      return orderColumns(orderedColumns, grouping, groupedColumnMode);
    }, getMemoOptions(table.options, "debugTable"));
  }
};
const getDefaultColumnPinningState = () => ({
  left: [],
  right: []
});
const ColumnPinning = {
  getInitialState: (state) => {
    return {
      columnPinning: getDefaultColumnPinningState(),
      ...state
    };
  },
  getDefaultOptions: (table) => {
    return {
      onColumnPinningChange: makeStateUpdater("columnPinning", table)
    };
  },
  createColumn: (column, table) => {
    column.pin = (position) => {
      const columnIds = column.getLeafColumns().map((d) => d.id).filter(Boolean);
      table.setColumnPinning((old) => {
        var _old$left3, _old$right3;
        if (position === "right") {
          var _old$left, _old$right;
          return {
            left: ((_old$left = old == null ? void 0 : old.left) != null ? _old$left : []).filter((d) => !(columnIds != null && columnIds.includes(d))),
            right: [...((_old$right = old == null ? void 0 : old.right) != null ? _old$right : []).filter((d) => !(columnIds != null && columnIds.includes(d))), ...columnIds]
          };
        }
        if (position === "left") {
          var _old$left2, _old$right2;
          return {
            left: [...((_old$left2 = old == null ? void 0 : old.left) != null ? _old$left2 : []).filter((d) => !(columnIds != null && columnIds.includes(d))), ...columnIds],
            right: ((_old$right2 = old == null ? void 0 : old.right) != null ? _old$right2 : []).filter((d) => !(columnIds != null && columnIds.includes(d)))
          };
        }
        return {
          left: ((_old$left3 = old == null ? void 0 : old.left) != null ? _old$left3 : []).filter((d) => !(columnIds != null && columnIds.includes(d))),
          right: ((_old$right3 = old == null ? void 0 : old.right) != null ? _old$right3 : []).filter((d) => !(columnIds != null && columnIds.includes(d)))
        };
      });
    };
    column.getCanPin = () => {
      const leafColumns = column.getLeafColumns();
      return leafColumns.some((d) => {
        var _d$columnDef$enablePi, _ref, _table$options$enable;
        return ((_d$columnDef$enablePi = d.columnDef.enablePinning) != null ? _d$columnDef$enablePi : true) && ((_ref = (_table$options$enable = table.options.enableColumnPinning) != null ? _table$options$enable : table.options.enablePinning) != null ? _ref : true);
      });
    };
    column.getIsPinned = () => {
      const leafColumnIds = column.getLeafColumns().map((d) => d.id);
      const {
        left,
        right
      } = table.getState().columnPinning;
      const isLeft = leafColumnIds.some((d) => left == null ? void 0 : left.includes(d));
      const isRight = leafColumnIds.some((d) => right == null ? void 0 : right.includes(d));
      return isLeft ? "left" : isRight ? "right" : false;
    };
    column.getPinnedIndex = () => {
      var _table$getState$colum, _table$getState$colum2;
      const position = column.getIsPinned();
      return position ? (_table$getState$colum = (_table$getState$colum2 = table.getState().columnPinning) == null || (_table$getState$colum2 = _table$getState$colum2[position]) == null ? void 0 : _table$getState$colum2.indexOf(column.id)) != null ? _table$getState$colum : -1 : 0;
    };
  },
  createRow: (row, table) => {
    row.getCenterVisibleCells = memo$1(() => [row._getAllVisibleCells(), table.getState().columnPinning.left, table.getState().columnPinning.right], (allCells, left, right) => {
      const leftAndRight = [...left != null ? left : [], ...right != null ? right : []];
      return allCells.filter((d) => !leftAndRight.includes(d.column.id));
    }, getMemoOptions(table.options, "debugRows"));
    row.getLeftVisibleCells = memo$1(() => [row._getAllVisibleCells(), table.getState().columnPinning.left], (allCells, left) => {
      const cells = (left != null ? left : []).map((columnId) => allCells.find((cell) => cell.column.id === columnId)).filter(Boolean).map((d) => ({
        ...d,
        position: "left"
      }));
      return cells;
    }, getMemoOptions(table.options, "debugRows"));
    row.getRightVisibleCells = memo$1(() => [row._getAllVisibleCells(), table.getState().columnPinning.right], (allCells, right) => {
      const cells = (right != null ? right : []).map((columnId) => allCells.find((cell) => cell.column.id === columnId)).filter(Boolean).map((d) => ({
        ...d,
        position: "right"
      }));
      return cells;
    }, getMemoOptions(table.options, "debugRows"));
  },
  createTable: (table) => {
    table.setColumnPinning = (updater) => table.options.onColumnPinningChange == null ? void 0 : table.options.onColumnPinningChange(updater);
    table.resetColumnPinning = (defaultState) => {
      var _table$initialState$c, _table$initialState;
      return table.setColumnPinning(defaultState ? getDefaultColumnPinningState() : (_table$initialState$c = (_table$initialState = table.initialState) == null ? void 0 : _table$initialState.columnPinning) != null ? _table$initialState$c : getDefaultColumnPinningState());
    };
    table.getIsSomeColumnsPinned = (position) => {
      var _pinningState$positio;
      const pinningState = table.getState().columnPinning;
      if (!position) {
        var _pinningState$left, _pinningState$right;
        return Boolean(((_pinningState$left = pinningState.left) == null ? void 0 : _pinningState$left.length) || ((_pinningState$right = pinningState.right) == null ? void 0 : _pinningState$right.length));
      }
      return Boolean((_pinningState$positio = pinningState[position]) == null ? void 0 : _pinningState$positio.length);
    };
    table.getLeftLeafColumns = memo$1(() => [table.getAllLeafColumns(), table.getState().columnPinning.left], (allColumns, left) => {
      return (left != null ? left : []).map((columnId) => allColumns.find((column) => column.id === columnId)).filter(Boolean);
    }, getMemoOptions(table.options, "debugColumns"));
    table.getRightLeafColumns = memo$1(() => [table.getAllLeafColumns(), table.getState().columnPinning.right], (allColumns, right) => {
      return (right != null ? right : []).map((columnId) => allColumns.find((column) => column.id === columnId)).filter(Boolean);
    }, getMemoOptions(table.options, "debugColumns"));
    table.getCenterLeafColumns = memo$1(() => [table.getAllLeafColumns(), table.getState().columnPinning.left, table.getState().columnPinning.right], (allColumns, left, right) => {
      const leftAndRight = [...left != null ? left : [], ...right != null ? right : []];
      return allColumns.filter((d) => !leftAndRight.includes(d.id));
    }, getMemoOptions(table.options, "debugColumns"));
  }
};
function safelyAccessDocument(_document) {
  return _document || (typeof document !== "undefined" ? document : null);
}
const defaultColumnSizing = {
  size: 150,
  minSize: 20,
  maxSize: Number.MAX_SAFE_INTEGER
};
const getDefaultColumnSizingInfoState = () => ({
  startOffset: null,
  startSize: null,
  deltaOffset: null,
  deltaPercentage: null,
  isResizingColumn: false,
  columnSizingStart: []
});
const ColumnSizing = {
  getDefaultColumnDef: () => {
    return defaultColumnSizing;
  },
  getInitialState: (state) => {
    return {
      columnSizing: {},
      columnSizingInfo: getDefaultColumnSizingInfoState(),
      ...state
    };
  },
  getDefaultOptions: (table) => {
    return {
      columnResizeMode: "onEnd",
      columnResizeDirection: "ltr",
      onColumnSizingChange: makeStateUpdater("columnSizing", table),
      onColumnSizingInfoChange: makeStateUpdater("columnSizingInfo", table)
    };
  },
  createColumn: (column, table) => {
    column.getSize = () => {
      var _column$columnDef$min, _ref, _column$columnDef$max;
      const columnSize = table.getState().columnSizing[column.id];
      return Math.min(Math.max((_column$columnDef$min = column.columnDef.minSize) != null ? _column$columnDef$min : defaultColumnSizing.minSize, (_ref = columnSize != null ? columnSize : column.columnDef.size) != null ? _ref : defaultColumnSizing.size), (_column$columnDef$max = column.columnDef.maxSize) != null ? _column$columnDef$max : defaultColumnSizing.maxSize);
    };
    column.getStart = memo$1((position) => [position, _getVisibleLeafColumns(table, position), table.getState().columnSizing], (position, columns) => columns.slice(0, column.getIndex(position)).reduce((sum2, column2) => sum2 + column2.getSize(), 0), getMemoOptions(table.options, "debugColumns"));
    column.getAfter = memo$1((position) => [position, _getVisibleLeafColumns(table, position), table.getState().columnSizing], (position, columns) => columns.slice(column.getIndex(position) + 1).reduce((sum2, column2) => sum2 + column2.getSize(), 0), getMemoOptions(table.options, "debugColumns"));
    column.resetSize = () => {
      table.setColumnSizing((_ref2) => {
        let {
          [column.id]: _,
          ...rest
        } = _ref2;
        return rest;
      });
    };
    column.getCanResize = () => {
      var _column$columnDef$ena, _table$options$enable;
      return ((_column$columnDef$ena = column.columnDef.enableResizing) != null ? _column$columnDef$ena : true) && ((_table$options$enable = table.options.enableColumnResizing) != null ? _table$options$enable : true);
    };
    column.getIsResizing = () => {
      return table.getState().columnSizingInfo.isResizingColumn === column.id;
    };
  },
  createHeader: (header, table) => {
    header.getSize = () => {
      let sum2 = 0;
      const recurse = (header2) => {
        if (header2.subHeaders.length) {
          header2.subHeaders.forEach(recurse);
        } else {
          var _header$column$getSiz;
          sum2 += (_header$column$getSiz = header2.column.getSize()) != null ? _header$column$getSiz : 0;
        }
      };
      recurse(header);
      return sum2;
    };
    header.getStart = () => {
      if (header.index > 0) {
        const prevSiblingHeader = header.headerGroup.headers[header.index - 1];
        return prevSiblingHeader.getStart() + prevSiblingHeader.getSize();
      }
      return 0;
    };
    header.getResizeHandler = (_contextDocument) => {
      const column = table.getColumn(header.column.id);
      const canResize = column == null ? void 0 : column.getCanResize();
      return (e) => {
        if (!column || !canResize) {
          return;
        }
        e.persist == null || e.persist();
        if (isTouchStartEvent(e)) {
          if (e.touches && e.touches.length > 1) {
            return;
          }
        }
        const startSize = header.getSize();
        const columnSizingStart = header ? header.getLeafHeaders().map((d) => [d.column.id, d.column.getSize()]) : [[column.id, column.getSize()]];
        const clientX = isTouchStartEvent(e) ? Math.round(e.touches[0].clientX) : e.clientX;
        const newColumnSizing = {};
        const updateOffset = (eventType, clientXPos) => {
          if (typeof clientXPos !== "number") {
            return;
          }
          table.setColumnSizingInfo((old) => {
            var _old$startOffset, _old$startSize;
            const deltaDirection = table.options.columnResizeDirection === "rtl" ? -1 : 1;
            const deltaOffset = (clientXPos - ((_old$startOffset = old == null ? void 0 : old.startOffset) != null ? _old$startOffset : 0)) * deltaDirection;
            const deltaPercentage = Math.max(deltaOffset / ((_old$startSize = old == null ? void 0 : old.startSize) != null ? _old$startSize : 0), -0.999999);
            old.columnSizingStart.forEach((_ref3) => {
              let [columnId, headerSize] = _ref3;
              newColumnSizing[columnId] = Math.round(Math.max(headerSize + headerSize * deltaPercentage, 0) * 100) / 100;
            });
            return {
              ...old,
              deltaOffset,
              deltaPercentage
            };
          });
          if (table.options.columnResizeMode === "onChange" || eventType === "end") {
            table.setColumnSizing((old) => ({
              ...old,
              ...newColumnSizing
            }));
          }
        };
        const onMove = (clientXPos) => updateOffset("move", clientXPos);
        const onEnd = (clientXPos) => {
          updateOffset("end", clientXPos);
          table.setColumnSizingInfo((old) => ({
            ...old,
            isResizingColumn: false,
            startOffset: null,
            startSize: null,
            deltaOffset: null,
            deltaPercentage: null,
            columnSizingStart: []
          }));
        };
        const contextDocument = safelyAccessDocument(_contextDocument);
        const mouseEvents = {
          moveHandler: (e2) => onMove(e2.clientX),
          upHandler: (e2) => {
            contextDocument == null || contextDocument.removeEventListener("mousemove", mouseEvents.moveHandler);
            contextDocument == null || contextDocument.removeEventListener("mouseup", mouseEvents.upHandler);
            onEnd(e2.clientX);
          }
        };
        const touchEvents = {
          moveHandler: (e2) => {
            if (e2.cancelable) {
              e2.preventDefault();
              e2.stopPropagation();
            }
            onMove(e2.touches[0].clientX);
            return false;
          },
          upHandler: (e2) => {
            var _e$touches$;
            contextDocument == null || contextDocument.removeEventListener("touchmove", touchEvents.moveHandler);
            contextDocument == null || contextDocument.removeEventListener("touchend", touchEvents.upHandler);
            if (e2.cancelable) {
              e2.preventDefault();
              e2.stopPropagation();
            }
            onEnd((_e$touches$ = e2.touches[0]) == null ? void 0 : _e$touches$.clientX);
          }
        };
        const passiveIfSupported = passiveEventSupported() ? {
          passive: false
        } : false;
        if (isTouchStartEvent(e)) {
          contextDocument == null || contextDocument.addEventListener("touchmove", touchEvents.moveHandler, passiveIfSupported);
          contextDocument == null || contextDocument.addEventListener("touchend", touchEvents.upHandler, passiveIfSupported);
        } else {
          contextDocument == null || contextDocument.addEventListener("mousemove", mouseEvents.moveHandler, passiveIfSupported);
          contextDocument == null || contextDocument.addEventListener("mouseup", mouseEvents.upHandler, passiveIfSupported);
        }
        table.setColumnSizingInfo((old) => ({
          ...old,
          startOffset: clientX,
          startSize,
          deltaOffset: 0,
          deltaPercentage: 0,
          columnSizingStart,
          isResizingColumn: column.id
        }));
      };
    };
  },
  createTable: (table) => {
    table.setColumnSizing = (updater) => table.options.onColumnSizingChange == null ? void 0 : table.options.onColumnSizingChange(updater);
    table.setColumnSizingInfo = (updater) => table.options.onColumnSizingInfoChange == null ? void 0 : table.options.onColumnSizingInfoChange(updater);
    table.resetColumnSizing = (defaultState) => {
      var _table$initialState$c;
      table.setColumnSizing(defaultState ? {} : (_table$initialState$c = table.initialState.columnSizing) != null ? _table$initialState$c : {});
    };
    table.resetHeaderSizeInfo = (defaultState) => {
      var _table$initialState$c2;
      table.setColumnSizingInfo(defaultState ? getDefaultColumnSizingInfoState() : (_table$initialState$c2 = table.initialState.columnSizingInfo) != null ? _table$initialState$c2 : getDefaultColumnSizingInfoState());
    };
    table.getTotalSize = () => {
      var _table$getHeaderGroup, _table$getHeaderGroup2;
      return (_table$getHeaderGroup = (_table$getHeaderGroup2 = table.getHeaderGroups()[0]) == null ? void 0 : _table$getHeaderGroup2.headers.reduce((sum2, header) => {
        return sum2 + header.getSize();
      }, 0)) != null ? _table$getHeaderGroup : 0;
    };
    table.getLeftTotalSize = () => {
      var _table$getLeftHeaderG, _table$getLeftHeaderG2;
      return (_table$getLeftHeaderG = (_table$getLeftHeaderG2 = table.getLeftHeaderGroups()[0]) == null ? void 0 : _table$getLeftHeaderG2.headers.reduce((sum2, header) => {
        return sum2 + header.getSize();
      }, 0)) != null ? _table$getLeftHeaderG : 0;
    };
    table.getCenterTotalSize = () => {
      var _table$getCenterHeade, _table$getCenterHeade2;
      return (_table$getCenterHeade = (_table$getCenterHeade2 = table.getCenterHeaderGroups()[0]) == null ? void 0 : _table$getCenterHeade2.headers.reduce((sum2, header) => {
        return sum2 + header.getSize();
      }, 0)) != null ? _table$getCenterHeade : 0;
    };
    table.getRightTotalSize = () => {
      var _table$getRightHeader, _table$getRightHeader2;
      return (_table$getRightHeader = (_table$getRightHeader2 = table.getRightHeaderGroups()[0]) == null ? void 0 : _table$getRightHeader2.headers.reduce((sum2, header) => {
        return sum2 + header.getSize();
      }, 0)) != null ? _table$getRightHeader : 0;
    };
  }
};
let passiveSupported = null;
function passiveEventSupported() {
  if (typeof passiveSupported === "boolean") return passiveSupported;
  let supported = false;
  try {
    const options = {
      get passive() {
        supported = true;
        return false;
      }
    };
    const noop2 = () => {
    };
    window.addEventListener("test", noop2, options);
    window.removeEventListener("test", noop2);
  } catch (err) {
    supported = false;
  }
  passiveSupported = supported;
  return passiveSupported;
}
function isTouchStartEvent(e) {
  return e.type === "touchstart";
}
const ColumnVisibility = {
  getInitialState: (state) => {
    return {
      columnVisibility: {},
      ...state
    };
  },
  getDefaultOptions: (table) => {
    return {
      onColumnVisibilityChange: makeStateUpdater("columnVisibility", table)
    };
  },
  createColumn: (column, table) => {
    column.toggleVisibility = (value) => {
      if (column.getCanHide()) {
        table.setColumnVisibility((old) => ({
          ...old,
          [column.id]: value != null ? value : !column.getIsVisible()
        }));
      }
    };
    column.getIsVisible = () => {
      var _ref, _table$getState$colum;
      const childColumns = column.columns;
      return (_ref = childColumns.length ? childColumns.some((c) => c.getIsVisible()) : (_table$getState$colum = table.getState().columnVisibility) == null ? void 0 : _table$getState$colum[column.id]) != null ? _ref : true;
    };
    column.getCanHide = () => {
      var _column$columnDef$ena, _table$options$enable;
      return ((_column$columnDef$ena = column.columnDef.enableHiding) != null ? _column$columnDef$ena : true) && ((_table$options$enable = table.options.enableHiding) != null ? _table$options$enable : true);
    };
    column.getToggleVisibilityHandler = () => {
      return (e) => {
        column.toggleVisibility == null || column.toggleVisibility(e.target.checked);
      };
    };
  },
  createRow: (row, table) => {
    row._getAllVisibleCells = memo$1(() => [row.getAllCells(), table.getState().columnVisibility], (cells) => {
      return cells.filter((cell) => cell.column.getIsVisible());
    }, getMemoOptions(table.options, "debugRows"));
    row.getVisibleCells = memo$1(() => [row.getLeftVisibleCells(), row.getCenterVisibleCells(), row.getRightVisibleCells()], (left, center, right) => [...left, ...center, ...right], getMemoOptions(table.options, "debugRows"));
  },
  createTable: (table) => {
    const makeVisibleColumnsMethod = (key, getColumns) => {
      return memo$1(() => [getColumns(), getColumns().filter((d) => d.getIsVisible()).map((d) => d.id).join("_")], (columns) => {
        return columns.filter((d) => d.getIsVisible == null ? void 0 : d.getIsVisible());
      }, getMemoOptions(table.options, "debugColumns"));
    };
    table.getVisibleFlatColumns = makeVisibleColumnsMethod("getVisibleFlatColumns", () => table.getAllFlatColumns());
    table.getVisibleLeafColumns = makeVisibleColumnsMethod("getVisibleLeafColumns", () => table.getAllLeafColumns());
    table.getLeftVisibleLeafColumns = makeVisibleColumnsMethod("getLeftVisibleLeafColumns", () => table.getLeftLeafColumns());
    table.getRightVisibleLeafColumns = makeVisibleColumnsMethod("getRightVisibleLeafColumns", () => table.getRightLeafColumns());
    table.getCenterVisibleLeafColumns = makeVisibleColumnsMethod("getCenterVisibleLeafColumns", () => table.getCenterLeafColumns());
    table.setColumnVisibility = (updater) => table.options.onColumnVisibilityChange == null ? void 0 : table.options.onColumnVisibilityChange(updater);
    table.resetColumnVisibility = (defaultState) => {
      var _table$initialState$c;
      table.setColumnVisibility(defaultState ? {} : (_table$initialState$c = table.initialState.columnVisibility) != null ? _table$initialState$c : {});
    };
    table.toggleAllColumnsVisible = (value) => {
      var _value;
      value = (_value = value) != null ? _value : !table.getIsAllColumnsVisible();
      table.setColumnVisibility(table.getAllLeafColumns().reduce((obj, column) => ({
        ...obj,
        [column.id]: !value ? !(column.getCanHide != null && column.getCanHide()) : value
      }), {}));
    };
    table.getIsAllColumnsVisible = () => !table.getAllLeafColumns().some((column) => !(column.getIsVisible != null && column.getIsVisible()));
    table.getIsSomeColumnsVisible = () => table.getAllLeafColumns().some((column) => column.getIsVisible == null ? void 0 : column.getIsVisible());
    table.getToggleAllColumnsVisibilityHandler = () => {
      return (e) => {
        var _target;
        table.toggleAllColumnsVisible((_target = e.target) == null ? void 0 : _target.checked);
      };
    };
  }
};
function _getVisibleLeafColumns(table, position) {
  return !position ? table.getVisibleLeafColumns() : position === "center" ? table.getCenterVisibleLeafColumns() : position === "left" ? table.getLeftVisibleLeafColumns() : table.getRightVisibleLeafColumns();
}
const GlobalFaceting = {
  createTable: (table) => {
    table._getGlobalFacetedRowModel = table.options.getFacetedRowModel && table.options.getFacetedRowModel(table, "__global__");
    table.getGlobalFacetedRowModel = () => {
      if (table.options.manualFiltering || !table._getGlobalFacetedRowModel) {
        return table.getPreFilteredRowModel();
      }
      return table._getGlobalFacetedRowModel();
    };
    table._getGlobalFacetedUniqueValues = table.options.getFacetedUniqueValues && table.options.getFacetedUniqueValues(table, "__global__");
    table.getGlobalFacetedUniqueValues = () => {
      if (!table._getGlobalFacetedUniqueValues) {
        return /* @__PURE__ */ new Map();
      }
      return table._getGlobalFacetedUniqueValues();
    };
    table._getGlobalFacetedMinMaxValues = table.options.getFacetedMinMaxValues && table.options.getFacetedMinMaxValues(table, "__global__");
    table.getGlobalFacetedMinMaxValues = () => {
      if (!table._getGlobalFacetedMinMaxValues) {
        return;
      }
      return table._getGlobalFacetedMinMaxValues();
    };
  }
};
const GlobalFiltering = {
  getInitialState: (state) => {
    return {
      globalFilter: void 0,
      ...state
    };
  },
  getDefaultOptions: (table) => {
    return {
      onGlobalFilterChange: makeStateUpdater("globalFilter", table),
      globalFilterFn: "auto",
      getColumnCanGlobalFilter: (column) => {
        var _table$getCoreRowMode;
        const value = (_table$getCoreRowMode = table.getCoreRowModel().flatRows[0]) == null || (_table$getCoreRowMode = _table$getCoreRowMode._getAllCellsByColumnId()[column.id]) == null ? void 0 : _table$getCoreRowMode.getValue();
        return typeof value === "string" || typeof value === "number";
      }
    };
  },
  createColumn: (column, table) => {
    column.getCanGlobalFilter = () => {
      var _column$columnDef$ena, _table$options$enable, _table$options$enable2, _table$options$getCol;
      return ((_column$columnDef$ena = column.columnDef.enableGlobalFilter) != null ? _column$columnDef$ena : true) && ((_table$options$enable = table.options.enableGlobalFilter) != null ? _table$options$enable : true) && ((_table$options$enable2 = table.options.enableFilters) != null ? _table$options$enable2 : true) && ((_table$options$getCol = table.options.getColumnCanGlobalFilter == null ? void 0 : table.options.getColumnCanGlobalFilter(column)) != null ? _table$options$getCol : true) && !!column.accessorFn;
    };
  },
  createTable: (table) => {
    table.getGlobalAutoFilterFn = () => {
      return filterFns.includesString;
    };
    table.getGlobalFilterFn = () => {
      var _table$options$filter, _table$options$filter2;
      const {
        globalFilterFn
      } = table.options;
      return isFunction(globalFilterFn) ? globalFilterFn : globalFilterFn === "auto" ? table.getGlobalAutoFilterFn() : (_table$options$filter = (_table$options$filter2 = table.options.filterFns) == null ? void 0 : _table$options$filter2[globalFilterFn]) != null ? _table$options$filter : filterFns[globalFilterFn];
    };
    table.setGlobalFilter = (updater) => {
      table.options.onGlobalFilterChange == null || table.options.onGlobalFilterChange(updater);
    };
    table.resetGlobalFilter = (defaultState) => {
      table.setGlobalFilter(defaultState ? void 0 : table.initialState.globalFilter);
    };
  }
};
const RowExpanding = {
  getInitialState: (state) => {
    return {
      expanded: {},
      ...state
    };
  },
  getDefaultOptions: (table) => {
    return {
      onExpandedChange: makeStateUpdater("expanded", table),
      paginateExpandedRows: true
    };
  },
  createTable: (table) => {
    let registered = false;
    let queued = false;
    table._autoResetExpanded = () => {
      var _ref, _table$options$autoRe;
      if (!registered) {
        table._queue(() => {
          registered = true;
        });
        return;
      }
      if ((_ref = (_table$options$autoRe = table.options.autoResetAll) != null ? _table$options$autoRe : table.options.autoResetExpanded) != null ? _ref : !table.options.manualExpanding) {
        if (queued) return;
        queued = true;
        table._queue(() => {
          table.resetExpanded();
          queued = false;
        });
      }
    };
    table.setExpanded = (updater) => table.options.onExpandedChange == null ? void 0 : table.options.onExpandedChange(updater);
    table.toggleAllRowsExpanded = (expanded) => {
      if (expanded != null ? expanded : !table.getIsAllRowsExpanded()) {
        table.setExpanded(true);
      } else {
        table.setExpanded({});
      }
    };
    table.resetExpanded = (defaultState) => {
      var _table$initialState$e, _table$initialState;
      table.setExpanded(defaultState ? {} : (_table$initialState$e = (_table$initialState = table.initialState) == null ? void 0 : _table$initialState.expanded) != null ? _table$initialState$e : {});
    };
    table.getCanSomeRowsExpand = () => {
      return table.getPrePaginationRowModel().flatRows.some((row) => row.getCanExpand());
    };
    table.getToggleAllRowsExpandedHandler = () => {
      return (e) => {
        e.persist == null || e.persist();
        table.toggleAllRowsExpanded();
      };
    };
    table.getIsSomeRowsExpanded = () => {
      const expanded = table.getState().expanded;
      return expanded === true || Object.values(expanded).some(Boolean);
    };
    table.getIsAllRowsExpanded = () => {
      const expanded = table.getState().expanded;
      if (typeof expanded === "boolean") {
        return expanded === true;
      }
      if (!Object.keys(expanded).length) {
        return false;
      }
      if (table.getRowModel().flatRows.some((row) => !row.getIsExpanded())) {
        return false;
      }
      return true;
    };
    table.getExpandedDepth = () => {
      let maxDepth = 0;
      const rowIds = table.getState().expanded === true ? Object.keys(table.getRowModel().rowsById) : Object.keys(table.getState().expanded);
      rowIds.forEach((id) => {
        const splitId = id.split(".");
        maxDepth = Math.max(maxDepth, splitId.length);
      });
      return maxDepth;
    };
    table.getPreExpandedRowModel = () => table.getSortedRowModel();
    table.getExpandedRowModel = () => {
      if (!table._getExpandedRowModel && table.options.getExpandedRowModel) {
        table._getExpandedRowModel = table.options.getExpandedRowModel(table);
      }
      if (table.options.manualExpanding || !table._getExpandedRowModel) {
        return table.getPreExpandedRowModel();
      }
      return table._getExpandedRowModel();
    };
  },
  createRow: (row, table) => {
    row.toggleExpanded = (expanded) => {
      table.setExpanded((old) => {
        var _expanded;
        const exists = old === true ? true : !!(old != null && old[row.id]);
        let oldExpanded = {};
        if (old === true) {
          Object.keys(table.getRowModel().rowsById).forEach((rowId) => {
            oldExpanded[rowId] = true;
          });
        } else {
          oldExpanded = old;
        }
        expanded = (_expanded = expanded) != null ? _expanded : !exists;
        if (!exists && expanded) {
          return {
            ...oldExpanded,
            [row.id]: true
          };
        }
        if (exists && !expanded) {
          const {
            [row.id]: _,
            ...rest
          } = oldExpanded;
          return rest;
        }
        return old;
      });
    };
    row.getIsExpanded = () => {
      var _table$options$getIsR;
      const expanded = table.getState().expanded;
      return !!((_table$options$getIsR = table.options.getIsRowExpanded == null ? void 0 : table.options.getIsRowExpanded(row)) != null ? _table$options$getIsR : expanded === true || (expanded == null ? void 0 : expanded[row.id]));
    };
    row.getCanExpand = () => {
      var _table$options$getRow, _table$options$enable, _row$subRows;
      return (_table$options$getRow = table.options.getRowCanExpand == null ? void 0 : table.options.getRowCanExpand(row)) != null ? _table$options$getRow : ((_table$options$enable = table.options.enableExpanding) != null ? _table$options$enable : true) && !!((_row$subRows = row.subRows) != null && _row$subRows.length);
    };
    row.getIsAllParentsExpanded = () => {
      let isFullyExpanded = true;
      let currentRow = row;
      while (isFullyExpanded && currentRow.parentId) {
        currentRow = table.getRow(currentRow.parentId, true);
        isFullyExpanded = currentRow.getIsExpanded();
      }
      return isFullyExpanded;
    };
    row.getToggleExpandedHandler = () => {
      const canExpand = row.getCanExpand();
      return () => {
        if (!canExpand) return;
        row.toggleExpanded();
      };
    };
  }
};
const defaultPageIndex = 0;
const defaultPageSize = 10;
const getDefaultPaginationState = () => ({
  pageIndex: defaultPageIndex,
  pageSize: defaultPageSize
});
const RowPagination = {
  getInitialState: (state) => {
    return {
      ...state,
      pagination: {
        ...getDefaultPaginationState(),
        ...state == null ? void 0 : state.pagination
      }
    };
  },
  getDefaultOptions: (table) => {
    return {
      onPaginationChange: makeStateUpdater("pagination", table)
    };
  },
  createTable: (table) => {
    let registered = false;
    let queued = false;
    table._autoResetPageIndex = () => {
      var _ref, _table$options$autoRe;
      if (!registered) {
        table._queue(() => {
          registered = true;
        });
        return;
      }
      if ((_ref = (_table$options$autoRe = table.options.autoResetAll) != null ? _table$options$autoRe : table.options.autoResetPageIndex) != null ? _ref : !table.options.manualPagination) {
        if (queued) return;
        queued = true;
        table._queue(() => {
          table.resetPageIndex();
          queued = false;
        });
      }
    };
    table.setPagination = (updater) => {
      const safeUpdater = (old) => {
        let newState = functionalUpdate(updater, old);
        return newState;
      };
      return table.options.onPaginationChange == null ? void 0 : table.options.onPaginationChange(safeUpdater);
    };
    table.resetPagination = (defaultState) => {
      var _table$initialState$p;
      table.setPagination(defaultState ? getDefaultPaginationState() : (_table$initialState$p = table.initialState.pagination) != null ? _table$initialState$p : getDefaultPaginationState());
    };
    table.setPageIndex = (updater) => {
      table.setPagination((old) => {
        let pageIndex = functionalUpdate(updater, old.pageIndex);
        const maxPageIndex = typeof table.options.pageCount === "undefined" || table.options.pageCount === -1 ? Number.MAX_SAFE_INTEGER : table.options.pageCount - 1;
        pageIndex = Math.max(0, Math.min(pageIndex, maxPageIndex));
        return {
          ...old,
          pageIndex
        };
      });
    };
    table.resetPageIndex = (defaultState) => {
      var _table$initialState$p2, _table$initialState;
      table.setPageIndex(defaultState ? defaultPageIndex : (_table$initialState$p2 = (_table$initialState = table.initialState) == null || (_table$initialState = _table$initialState.pagination) == null ? void 0 : _table$initialState.pageIndex) != null ? _table$initialState$p2 : defaultPageIndex);
    };
    table.resetPageSize = (defaultState) => {
      var _table$initialState$p3, _table$initialState2;
      table.setPageSize(defaultState ? defaultPageSize : (_table$initialState$p3 = (_table$initialState2 = table.initialState) == null || (_table$initialState2 = _table$initialState2.pagination) == null ? void 0 : _table$initialState2.pageSize) != null ? _table$initialState$p3 : defaultPageSize);
    };
    table.setPageSize = (updater) => {
      table.setPagination((old) => {
        const pageSize = Math.max(1, functionalUpdate(updater, old.pageSize));
        const topRowIndex = old.pageSize * old.pageIndex;
        const pageIndex = Math.floor(topRowIndex / pageSize);
        return {
          ...old,
          pageIndex,
          pageSize
        };
      });
    };
    table.setPageCount = (updater) => table.setPagination((old) => {
      var _table$options$pageCo;
      let newPageCount = functionalUpdate(updater, (_table$options$pageCo = table.options.pageCount) != null ? _table$options$pageCo : -1);
      if (typeof newPageCount === "number") {
        newPageCount = Math.max(-1, newPageCount);
      }
      return {
        ...old,
        pageCount: newPageCount
      };
    });
    table.getPageOptions = memo$1(() => [table.getPageCount()], (pageCount) => {
      let pageOptions = [];
      if (pageCount && pageCount > 0) {
        pageOptions = [...new Array(pageCount)].fill(null).map((_, i) => i);
      }
      return pageOptions;
    }, getMemoOptions(table.options, "debugTable"));
    table.getCanPreviousPage = () => table.getState().pagination.pageIndex > 0;
    table.getCanNextPage = () => {
      const {
        pageIndex
      } = table.getState().pagination;
      const pageCount = table.getPageCount();
      if (pageCount === -1) {
        return true;
      }
      if (pageCount === 0) {
        return false;
      }
      return pageIndex < pageCount - 1;
    };
    table.previousPage = () => {
      return table.setPageIndex((old) => old - 1);
    };
    table.nextPage = () => {
      return table.setPageIndex((old) => {
        return old + 1;
      });
    };
    table.firstPage = () => {
      return table.setPageIndex(0);
    };
    table.lastPage = () => {
      return table.setPageIndex(table.getPageCount() - 1);
    };
    table.getPrePaginationRowModel = () => table.getExpandedRowModel();
    table.getPaginationRowModel = () => {
      if (!table._getPaginationRowModel && table.options.getPaginationRowModel) {
        table._getPaginationRowModel = table.options.getPaginationRowModel(table);
      }
      if (table.options.manualPagination || !table._getPaginationRowModel) {
        return table.getPrePaginationRowModel();
      }
      return table._getPaginationRowModel();
    };
    table.getPageCount = () => {
      var _table$options$pageCo2;
      return (_table$options$pageCo2 = table.options.pageCount) != null ? _table$options$pageCo2 : Math.ceil(table.getRowCount() / table.getState().pagination.pageSize);
    };
    table.getRowCount = () => {
      var _table$options$rowCou;
      return (_table$options$rowCou = table.options.rowCount) != null ? _table$options$rowCou : table.getPrePaginationRowModel().rows.length;
    };
  }
};
const getDefaultRowPinningState = () => ({
  top: [],
  bottom: []
});
const RowPinning = {
  getInitialState: (state) => {
    return {
      rowPinning: getDefaultRowPinningState(),
      ...state
    };
  },
  getDefaultOptions: (table) => {
    return {
      onRowPinningChange: makeStateUpdater("rowPinning", table)
    };
  },
  createRow: (row, table) => {
    row.pin = (position, includeLeafRows, includeParentRows) => {
      const leafRowIds = includeLeafRows ? row.getLeafRows().map((_ref) => {
        let {
          id
        } = _ref;
        return id;
      }) : [];
      const parentRowIds = includeParentRows ? row.getParentRows().map((_ref2) => {
        let {
          id
        } = _ref2;
        return id;
      }) : [];
      const rowIds = /* @__PURE__ */ new Set([...parentRowIds, row.id, ...leafRowIds]);
      table.setRowPinning((old) => {
        var _old$top3, _old$bottom3;
        if (position === "bottom") {
          var _old$top, _old$bottom;
          return {
            top: ((_old$top = old == null ? void 0 : old.top) != null ? _old$top : []).filter((d) => !(rowIds != null && rowIds.has(d))),
            bottom: [...((_old$bottom = old == null ? void 0 : old.bottom) != null ? _old$bottom : []).filter((d) => !(rowIds != null && rowIds.has(d))), ...Array.from(rowIds)]
          };
        }
        if (position === "top") {
          var _old$top2, _old$bottom2;
          return {
            top: [...((_old$top2 = old == null ? void 0 : old.top) != null ? _old$top2 : []).filter((d) => !(rowIds != null && rowIds.has(d))), ...Array.from(rowIds)],
            bottom: ((_old$bottom2 = old == null ? void 0 : old.bottom) != null ? _old$bottom2 : []).filter((d) => !(rowIds != null && rowIds.has(d)))
          };
        }
        return {
          top: ((_old$top3 = old == null ? void 0 : old.top) != null ? _old$top3 : []).filter((d) => !(rowIds != null && rowIds.has(d))),
          bottom: ((_old$bottom3 = old == null ? void 0 : old.bottom) != null ? _old$bottom3 : []).filter((d) => !(rowIds != null && rowIds.has(d)))
        };
      });
    };
    row.getCanPin = () => {
      var _ref3;
      const {
        enableRowPinning,
        enablePinning
      } = table.options;
      if (typeof enableRowPinning === "function") {
        return enableRowPinning(row);
      }
      return (_ref3 = enableRowPinning != null ? enableRowPinning : enablePinning) != null ? _ref3 : true;
    };
    row.getIsPinned = () => {
      const rowIds = [row.id];
      const {
        top,
        bottom
      } = table.getState().rowPinning;
      const isTop = rowIds.some((d) => top == null ? void 0 : top.includes(d));
      const isBottom = rowIds.some((d) => bottom == null ? void 0 : bottom.includes(d));
      return isTop ? "top" : isBottom ? "bottom" : false;
    };
    row.getPinnedIndex = () => {
      var _ref4, _visiblePinnedRowIds$;
      const position = row.getIsPinned();
      if (!position) return -1;
      const visiblePinnedRowIds = (_ref4 = position === "top" ? table.getTopRows() : table.getBottomRows()) == null ? void 0 : _ref4.map((_ref5) => {
        let {
          id
        } = _ref5;
        return id;
      });
      return (_visiblePinnedRowIds$ = visiblePinnedRowIds == null ? void 0 : visiblePinnedRowIds.indexOf(row.id)) != null ? _visiblePinnedRowIds$ : -1;
    };
  },
  createTable: (table) => {
    table.setRowPinning = (updater) => table.options.onRowPinningChange == null ? void 0 : table.options.onRowPinningChange(updater);
    table.resetRowPinning = (defaultState) => {
      var _table$initialState$r, _table$initialState;
      return table.setRowPinning(defaultState ? getDefaultRowPinningState() : (_table$initialState$r = (_table$initialState = table.initialState) == null ? void 0 : _table$initialState.rowPinning) != null ? _table$initialState$r : getDefaultRowPinningState());
    };
    table.getIsSomeRowsPinned = (position) => {
      var _pinningState$positio;
      const pinningState = table.getState().rowPinning;
      if (!position) {
        var _pinningState$top, _pinningState$bottom;
        return Boolean(((_pinningState$top = pinningState.top) == null ? void 0 : _pinningState$top.length) || ((_pinningState$bottom = pinningState.bottom) == null ? void 0 : _pinningState$bottom.length));
      }
      return Boolean((_pinningState$positio = pinningState[position]) == null ? void 0 : _pinningState$positio.length);
    };
    table._getPinnedRows = (visibleRows, pinnedRowIds, position) => {
      var _table$options$keepPi;
      const rows = ((_table$options$keepPi = table.options.keepPinnedRows) != null ? _table$options$keepPi : true) ? (
        //get all rows that are pinned even if they would not be otherwise visible
        //account for expanded parent rows, but not pagination or filtering
        (pinnedRowIds != null ? pinnedRowIds : []).map((rowId) => {
          const row = table.getRow(rowId, true);
          return row.getIsAllParentsExpanded() ? row : null;
        })
      ) : (
        //else get only visible rows that are pinned
        (pinnedRowIds != null ? pinnedRowIds : []).map((rowId) => visibleRows.find((row) => row.id === rowId))
      );
      return rows.filter(Boolean).map((d) => ({
        ...d,
        position
      }));
    };
    table.getTopRows = memo$1(() => [table.getRowModel().rows, table.getState().rowPinning.top], (allRows, topPinnedRowIds) => table._getPinnedRows(allRows, topPinnedRowIds, "top"), getMemoOptions(table.options, "debugRows"));
    table.getBottomRows = memo$1(() => [table.getRowModel().rows, table.getState().rowPinning.bottom], (allRows, bottomPinnedRowIds) => table._getPinnedRows(allRows, bottomPinnedRowIds, "bottom"), getMemoOptions(table.options, "debugRows"));
    table.getCenterRows = memo$1(() => [table.getRowModel().rows, table.getState().rowPinning.top, table.getState().rowPinning.bottom], (allRows, top, bottom) => {
      const topAndBottom = /* @__PURE__ */ new Set([...top != null ? top : [], ...bottom != null ? bottom : []]);
      return allRows.filter((d) => !topAndBottom.has(d.id));
    }, getMemoOptions(table.options, "debugRows"));
  }
};
const RowSelection = {
  getInitialState: (state) => {
    return {
      rowSelection: {},
      ...state
    };
  },
  getDefaultOptions: (table) => {
    return {
      onRowSelectionChange: makeStateUpdater("rowSelection", table),
      enableRowSelection: true,
      enableMultiRowSelection: true,
      enableSubRowSelection: true
      // enableGroupingRowSelection: false,
      // isAdditiveSelectEvent: (e: unknown) => !!e.metaKey,
      // isInclusiveSelectEvent: (e: unknown) => !!e.shiftKey,
    };
  },
  createTable: (table) => {
    table.setRowSelection = (updater) => table.options.onRowSelectionChange == null ? void 0 : table.options.onRowSelectionChange(updater);
    table.resetRowSelection = (defaultState) => {
      var _table$initialState$r;
      return table.setRowSelection(defaultState ? {} : (_table$initialState$r = table.initialState.rowSelection) != null ? _table$initialState$r : {});
    };
    table.toggleAllRowsSelected = (value) => {
      table.setRowSelection((old) => {
        value = typeof value !== "undefined" ? value : !table.getIsAllRowsSelected();
        const rowSelection = {
          ...old
        };
        const preGroupedFlatRows = table.getPreGroupedRowModel().flatRows;
        if (value) {
          preGroupedFlatRows.forEach((row) => {
            if (!row.getCanSelect()) {
              return;
            }
            rowSelection[row.id] = true;
          });
        } else {
          preGroupedFlatRows.forEach((row) => {
            delete rowSelection[row.id];
          });
        }
        return rowSelection;
      });
    };
    table.toggleAllPageRowsSelected = (value) => table.setRowSelection((old) => {
      const resolvedValue = typeof value !== "undefined" ? value : !table.getIsAllPageRowsSelected();
      const rowSelection = {
        ...old
      };
      table.getRowModel().rows.forEach((row) => {
        mutateRowIsSelected(rowSelection, row.id, resolvedValue, true, table);
      });
      return rowSelection;
    });
    table.getPreSelectedRowModel = () => table.getCoreRowModel();
    table.getSelectedRowModel = memo$1(() => [table.getState().rowSelection, table.getCoreRowModel()], (rowSelection, rowModel) => {
      if (!Object.keys(rowSelection).length) {
        return {
          rows: [],
          flatRows: [],
          rowsById: {}
        };
      }
      return selectRowsFn(table, rowModel);
    }, getMemoOptions(table.options, "debugTable"));
    table.getFilteredSelectedRowModel = memo$1(() => [table.getState().rowSelection, table.getFilteredRowModel()], (rowSelection, rowModel) => {
      if (!Object.keys(rowSelection).length) {
        return {
          rows: [],
          flatRows: [],
          rowsById: {}
        };
      }
      return selectRowsFn(table, rowModel);
    }, getMemoOptions(table.options, "debugTable"));
    table.getGroupedSelectedRowModel = memo$1(() => [table.getState().rowSelection, table.getSortedRowModel()], (rowSelection, rowModel) => {
      if (!Object.keys(rowSelection).length) {
        return {
          rows: [],
          flatRows: [],
          rowsById: {}
        };
      }
      return selectRowsFn(table, rowModel);
    }, getMemoOptions(table.options, "debugTable"));
    table.getIsAllRowsSelected = () => {
      const preGroupedFlatRows = table.getFilteredRowModel().flatRows;
      const {
        rowSelection
      } = table.getState();
      let isAllRowsSelected = Boolean(preGroupedFlatRows.length && Object.keys(rowSelection).length);
      if (isAllRowsSelected) {
        if (preGroupedFlatRows.some((row) => row.getCanSelect() && !rowSelection[row.id])) {
          isAllRowsSelected = false;
        }
      }
      return isAllRowsSelected;
    };
    table.getIsAllPageRowsSelected = () => {
      const paginationFlatRows = table.getPaginationRowModel().flatRows.filter((row) => row.getCanSelect());
      const {
        rowSelection
      } = table.getState();
      let isAllPageRowsSelected = !!paginationFlatRows.length;
      if (isAllPageRowsSelected && paginationFlatRows.some((row) => !rowSelection[row.id])) {
        isAllPageRowsSelected = false;
      }
      return isAllPageRowsSelected;
    };
    table.getIsSomeRowsSelected = () => {
      var _table$getState$rowSe;
      const totalSelected = Object.keys((_table$getState$rowSe = table.getState().rowSelection) != null ? _table$getState$rowSe : {}).length;
      return totalSelected > 0 && totalSelected < table.getFilteredRowModel().flatRows.length;
    };
    table.getIsSomePageRowsSelected = () => {
      const paginationFlatRows = table.getPaginationRowModel().flatRows;
      return table.getIsAllPageRowsSelected() ? false : paginationFlatRows.filter((row) => row.getCanSelect()).some((d) => d.getIsSelected() || d.getIsSomeSelected());
    };
    table.getToggleAllRowsSelectedHandler = () => {
      return (e) => {
        table.toggleAllRowsSelected(e.target.checked);
      };
    };
    table.getToggleAllPageRowsSelectedHandler = () => {
      return (e) => {
        table.toggleAllPageRowsSelected(e.target.checked);
      };
    };
  },
  createRow: (row, table) => {
    row.toggleSelected = (value, opts) => {
      const isSelected = row.getIsSelected();
      table.setRowSelection((old) => {
        var _opts$selectChildren;
        value = typeof value !== "undefined" ? value : !isSelected;
        if (row.getCanSelect() && isSelected === value) {
          return old;
        }
        const selectedRowIds = {
          ...old
        };
        mutateRowIsSelected(selectedRowIds, row.id, value, (_opts$selectChildren = opts == null ? void 0 : opts.selectChildren) != null ? _opts$selectChildren : true, table);
        return selectedRowIds;
      });
    };
    row.getIsSelected = () => {
      const {
        rowSelection
      } = table.getState();
      return isRowSelected(row, rowSelection);
    };
    row.getIsSomeSelected = () => {
      const {
        rowSelection
      } = table.getState();
      return isSubRowSelected(row, rowSelection) === "some";
    };
    row.getIsAllSubRowsSelected = () => {
      const {
        rowSelection
      } = table.getState();
      return isSubRowSelected(row, rowSelection) === "all";
    };
    row.getCanSelect = () => {
      var _table$options$enable;
      if (typeof table.options.enableRowSelection === "function") {
        return table.options.enableRowSelection(row);
      }
      return (_table$options$enable = table.options.enableRowSelection) != null ? _table$options$enable : true;
    };
    row.getCanSelectSubRows = () => {
      var _table$options$enable2;
      if (typeof table.options.enableSubRowSelection === "function") {
        return table.options.enableSubRowSelection(row);
      }
      return (_table$options$enable2 = table.options.enableSubRowSelection) != null ? _table$options$enable2 : true;
    };
    row.getCanMultiSelect = () => {
      var _table$options$enable3;
      if (typeof table.options.enableMultiRowSelection === "function") {
        return table.options.enableMultiRowSelection(row);
      }
      return (_table$options$enable3 = table.options.enableMultiRowSelection) != null ? _table$options$enable3 : true;
    };
    row.getToggleSelectedHandler = () => {
      const canSelect = row.getCanSelect();
      return (e) => {
        var _target;
        if (!canSelect) return;
        row.toggleSelected((_target = e.target) == null ? void 0 : _target.checked);
      };
    };
  }
};
const mutateRowIsSelected = (selectedRowIds, id, value, includeChildren, table) => {
  var _row$subRows;
  const row = table.getRow(id, true);
  if (value) {
    if (!row.getCanMultiSelect()) {
      Object.keys(selectedRowIds).forEach((key) => delete selectedRowIds[key]);
    }
    if (row.getCanSelect()) {
      selectedRowIds[id] = true;
    }
  } else {
    delete selectedRowIds[id];
  }
  if (includeChildren && (_row$subRows = row.subRows) != null && _row$subRows.length && row.getCanSelectSubRows()) {
    row.subRows.forEach((row2) => mutateRowIsSelected(selectedRowIds, row2.id, value, includeChildren, table));
  }
};
function selectRowsFn(table, rowModel) {
  const rowSelection = table.getState().rowSelection;
  const newSelectedFlatRows = [];
  const newSelectedRowsById = {};
  const recurseRows = function(rows, depth) {
    return rows.map((row) => {
      var _row$subRows2;
      const isSelected = isRowSelected(row, rowSelection);
      if (isSelected) {
        newSelectedFlatRows.push(row);
        newSelectedRowsById[row.id] = row;
      }
      if ((_row$subRows2 = row.subRows) != null && _row$subRows2.length) {
        row = {
          ...row,
          subRows: recurseRows(row.subRows)
        };
      }
      if (isSelected) {
        return row;
      }
    }).filter(Boolean);
  };
  return {
    rows: recurseRows(rowModel.rows),
    flatRows: newSelectedFlatRows,
    rowsById: newSelectedRowsById
  };
}
function isRowSelected(row, selection) {
  var _selection$row$id;
  return (_selection$row$id = selection[row.id]) != null ? _selection$row$id : false;
}
function isSubRowSelected(row, selection, table) {
  var _row$subRows3;
  if (!((_row$subRows3 = row.subRows) != null && _row$subRows3.length)) return false;
  let allChildrenSelected = true;
  let someSelected = false;
  row.subRows.forEach((subRow) => {
    if (someSelected && !allChildrenSelected) {
      return;
    }
    if (subRow.getCanSelect()) {
      if (isRowSelected(subRow, selection)) {
        someSelected = true;
      } else {
        allChildrenSelected = false;
      }
    }
    if (subRow.subRows && subRow.subRows.length) {
      const subRowChildrenSelected = isSubRowSelected(subRow, selection);
      if (subRowChildrenSelected === "all") {
        someSelected = true;
      } else if (subRowChildrenSelected === "some") {
        someSelected = true;
        allChildrenSelected = false;
      } else {
        allChildrenSelected = false;
      }
    }
  });
  return allChildrenSelected ? "all" : someSelected ? "some" : false;
}
const reSplitAlphaNumeric = /([0-9]+)/gm;
const alphanumeric = (rowA, rowB, columnId) => {
  return compareAlphanumeric(toString(rowA.getValue(columnId)).toLowerCase(), toString(rowB.getValue(columnId)).toLowerCase());
};
const alphanumericCaseSensitive = (rowA, rowB, columnId) => {
  return compareAlphanumeric(toString(rowA.getValue(columnId)), toString(rowB.getValue(columnId)));
};
const text = (rowA, rowB, columnId) => {
  return compareBasic(toString(rowA.getValue(columnId)).toLowerCase(), toString(rowB.getValue(columnId)).toLowerCase());
};
const textCaseSensitive = (rowA, rowB, columnId) => {
  return compareBasic(toString(rowA.getValue(columnId)), toString(rowB.getValue(columnId)));
};
const datetime = (rowA, rowB, columnId) => {
  const a = rowA.getValue(columnId);
  const b = rowB.getValue(columnId);
  return a > b ? 1 : a < b ? -1 : 0;
};
const basic = (rowA, rowB, columnId) => {
  return compareBasic(rowA.getValue(columnId), rowB.getValue(columnId));
};
function compareBasic(a, b) {
  return a === b ? 0 : a > b ? 1 : -1;
}
function toString(a) {
  if (typeof a === "number") {
    if (isNaN(a) || a === Infinity || a === -Infinity) {
      return "";
    }
    return String(a);
  }
  if (typeof a === "string") {
    return a;
  }
  return "";
}
function compareAlphanumeric(aStr, bStr) {
  const a = aStr.split(reSplitAlphaNumeric).filter(Boolean);
  const b = bStr.split(reSplitAlphaNumeric).filter(Boolean);
  while (a.length && b.length) {
    const aa = a.shift();
    const bb = b.shift();
    const an = parseInt(aa, 10);
    const bn = parseInt(bb, 10);
    const combo = [an, bn].sort();
    if (isNaN(combo[0])) {
      if (aa > bb) {
        return 1;
      }
      if (bb > aa) {
        return -1;
      }
      continue;
    }
    if (isNaN(combo[1])) {
      return isNaN(an) ? -1 : 1;
    }
    if (an > bn) {
      return 1;
    }
    if (bn > an) {
      return -1;
    }
  }
  return a.length - b.length;
}
const sortingFns = {
  alphanumeric,
  alphanumericCaseSensitive,
  text,
  textCaseSensitive,
  datetime,
  basic
};
const RowSorting = {
  getInitialState: (state) => {
    return {
      sorting: [],
      ...state
    };
  },
  getDefaultColumnDef: () => {
    return {
      sortingFn: "auto",
      sortUndefined: 1
    };
  },
  getDefaultOptions: (table) => {
    return {
      onSortingChange: makeStateUpdater("sorting", table),
      isMultiSortEvent: (e) => {
        return e.shiftKey;
      }
    };
  },
  createColumn: (column, table) => {
    column.getAutoSortingFn = () => {
      const firstRows = table.getFilteredRowModel().flatRows.slice(10);
      let isString = false;
      for (const row of firstRows) {
        const value = row == null ? void 0 : row.getValue(column.id);
        if (Object.prototype.toString.call(value) === "[object Date]") {
          return sortingFns.datetime;
        }
        if (typeof value === "string") {
          isString = true;
          if (value.split(reSplitAlphaNumeric).length > 1) {
            return sortingFns.alphanumeric;
          }
        }
      }
      if (isString) {
        return sortingFns.text;
      }
      return sortingFns.basic;
    };
    column.getAutoSortDir = () => {
      const firstRow = table.getFilteredRowModel().flatRows[0];
      const value = firstRow == null ? void 0 : firstRow.getValue(column.id);
      if (typeof value === "string") {
        return "asc";
      }
      return "desc";
    };
    column.getSortingFn = () => {
      var _table$options$sortin, _table$options$sortin2;
      if (!column) {
        throw new Error();
      }
      return isFunction(column.columnDef.sortingFn) ? column.columnDef.sortingFn : column.columnDef.sortingFn === "auto" ? column.getAutoSortingFn() : (_table$options$sortin = (_table$options$sortin2 = table.options.sortingFns) == null ? void 0 : _table$options$sortin2[column.columnDef.sortingFn]) != null ? _table$options$sortin : sortingFns[column.columnDef.sortingFn];
    };
    column.toggleSorting = (desc, multi) => {
      const nextSortingOrder = column.getNextSortingOrder();
      const hasManualValue = typeof desc !== "undefined" && desc !== null;
      table.setSorting((old) => {
        const existingSorting = old == null ? void 0 : old.find((d) => d.id === column.id);
        const existingIndex = old == null ? void 0 : old.findIndex((d) => d.id === column.id);
        let newSorting = [];
        let sortAction;
        let nextDesc = hasManualValue ? desc : nextSortingOrder === "desc";
        if (old != null && old.length && column.getCanMultiSort() && multi) {
          if (existingSorting) {
            sortAction = "toggle";
          } else {
            sortAction = "add";
          }
        } else {
          if (old != null && old.length && existingIndex !== old.length - 1) {
            sortAction = "replace";
          } else if (existingSorting) {
            sortAction = "toggle";
          } else {
            sortAction = "replace";
          }
        }
        if (sortAction === "toggle") {
          if (!hasManualValue) {
            if (!nextSortingOrder) {
              sortAction = "remove";
            }
          }
        }
        if (sortAction === "add") {
          var _table$options$maxMul;
          newSorting = [...old, {
            id: column.id,
            desc: nextDesc
          }];
          newSorting.splice(0, newSorting.length - ((_table$options$maxMul = table.options.maxMultiSortColCount) != null ? _table$options$maxMul : Number.MAX_SAFE_INTEGER));
        } else if (sortAction === "toggle") {
          newSorting = old.map((d) => {
            if (d.id === column.id) {
              return {
                ...d,
                desc: nextDesc
              };
            }
            return d;
          });
        } else if (sortAction === "remove") {
          newSorting = old.filter((d) => d.id !== column.id);
        } else {
          newSorting = [{
            id: column.id,
            desc: nextDesc
          }];
        }
        return newSorting;
      });
    };
    column.getFirstSortDir = () => {
      var _ref, _column$columnDef$sor;
      const sortDescFirst = (_ref = (_column$columnDef$sor = column.columnDef.sortDescFirst) != null ? _column$columnDef$sor : table.options.sortDescFirst) != null ? _ref : column.getAutoSortDir() === "desc";
      return sortDescFirst ? "desc" : "asc";
    };
    column.getNextSortingOrder = (multi) => {
      var _table$options$enable, _table$options$enable2;
      const firstSortDirection = column.getFirstSortDir();
      const isSorted = column.getIsSorted();
      if (!isSorted) {
        return firstSortDirection;
      }
      if (isSorted !== firstSortDirection && ((_table$options$enable = table.options.enableSortingRemoval) != null ? _table$options$enable : true) && // If enableSortRemove, enable in general
      (multi ? (_table$options$enable2 = table.options.enableMultiRemove) != null ? _table$options$enable2 : true : true)) {
        return false;
      }
      return isSorted === "desc" ? "asc" : "desc";
    };
    column.getCanSort = () => {
      var _column$columnDef$ena, _table$options$enable3;
      return ((_column$columnDef$ena = column.columnDef.enableSorting) != null ? _column$columnDef$ena : true) && ((_table$options$enable3 = table.options.enableSorting) != null ? _table$options$enable3 : true) && !!column.accessorFn;
    };
    column.getCanMultiSort = () => {
      var _ref2, _column$columnDef$ena2;
      return (_ref2 = (_column$columnDef$ena2 = column.columnDef.enableMultiSort) != null ? _column$columnDef$ena2 : table.options.enableMultiSort) != null ? _ref2 : !!column.accessorFn;
    };
    column.getIsSorted = () => {
      var _table$getState$sorti;
      const columnSort = (_table$getState$sorti = table.getState().sorting) == null ? void 0 : _table$getState$sorti.find((d) => d.id === column.id);
      return !columnSort ? false : columnSort.desc ? "desc" : "asc";
    };
    column.getSortIndex = () => {
      var _table$getState$sorti2, _table$getState$sorti3;
      return (_table$getState$sorti2 = (_table$getState$sorti3 = table.getState().sorting) == null ? void 0 : _table$getState$sorti3.findIndex((d) => d.id === column.id)) != null ? _table$getState$sorti2 : -1;
    };
    column.clearSorting = () => {
      table.setSorting((old) => old != null && old.length ? old.filter((d) => d.id !== column.id) : []);
    };
    column.getToggleSortingHandler = () => {
      const canSort = column.getCanSort();
      return (e) => {
        if (!canSort) return;
        e.persist == null || e.persist();
        column.toggleSorting == null || column.toggleSorting(void 0, column.getCanMultiSort() ? table.options.isMultiSortEvent == null ? void 0 : table.options.isMultiSortEvent(e) : false);
      };
    };
  },
  createTable: (table) => {
    table.setSorting = (updater) => table.options.onSortingChange == null ? void 0 : table.options.onSortingChange(updater);
    table.resetSorting = (defaultState) => {
      var _table$initialState$s, _table$initialState;
      table.setSorting(defaultState ? [] : (_table$initialState$s = (_table$initialState = table.initialState) == null ? void 0 : _table$initialState.sorting) != null ? _table$initialState$s : []);
    };
    table.getPreSortedRowModel = () => table.getGroupedRowModel();
    table.getSortedRowModel = () => {
      if (!table._getSortedRowModel && table.options.getSortedRowModel) {
        table._getSortedRowModel = table.options.getSortedRowModel(table);
      }
      if (table.options.manualSorting || !table._getSortedRowModel) {
        return table.getPreSortedRowModel();
      }
      return table._getSortedRowModel();
    };
  }
};
const builtInFeatures = [
  Headers,
  ColumnVisibility,
  ColumnOrdering,
  ColumnPinning,
  ColumnFaceting,
  ColumnFiltering,
  GlobalFaceting,
  //depends on ColumnFaceting
  GlobalFiltering,
  //depends on ColumnFiltering
  RowSorting,
  ColumnGrouping,
  //depends on RowSorting
  RowExpanding,
  RowPagination,
  RowPinning,
  RowSelection,
  ColumnSizing
];
function createTable(options) {
  var _options$_features, _options$initialState;
  const _features = [...builtInFeatures, ...(_options$_features = options._features) != null ? _options$_features : []];
  let table = {
    _features
  };
  const defaultOptions = table._features.reduce((obj, feature) => {
    return Object.assign(obj, feature.getDefaultOptions == null ? void 0 : feature.getDefaultOptions(table));
  }, {});
  const mergeOptions = (options2) => {
    if (table.options.mergeOptions) {
      return table.options.mergeOptions(defaultOptions, options2);
    }
    return {
      ...defaultOptions,
      ...options2
    };
  };
  const coreInitialState = {};
  let initialState = {
    ...coreInitialState,
    ...(_options$initialState = options.initialState) != null ? _options$initialState : {}
  };
  table._features.forEach((feature) => {
    var _feature$getInitialSt;
    initialState = (_feature$getInitialSt = feature.getInitialState == null ? void 0 : feature.getInitialState(initialState)) != null ? _feature$getInitialSt : initialState;
  });
  const queued = [];
  let queuedTimeout = false;
  const coreInstance = {
    _features,
    options: {
      ...defaultOptions,
      ...options
    },
    initialState,
    _queue: (cb) => {
      queued.push(cb);
      if (!queuedTimeout) {
        queuedTimeout = true;
        Promise.resolve().then(() => {
          while (queued.length) {
            queued.shift()();
          }
          queuedTimeout = false;
        }).catch((error) => setTimeout(() => {
          throw error;
        }));
      }
    },
    reset: () => {
      table.setState(table.initialState);
    },
    setOptions: (updater) => {
      const newOptions = functionalUpdate(updater, table.options);
      table.options = mergeOptions(newOptions);
    },
    getState: () => {
      return table.options.state;
    },
    setState: (updater) => {
      table.options.onStateChange == null || table.options.onStateChange(updater);
    },
    _getRowId: (row, index, parent) => {
      var _table$options$getRow;
      return (_table$options$getRow = table.options.getRowId == null ? void 0 : table.options.getRowId(row, index, parent)) != null ? _table$options$getRow : `${parent ? [parent.id, index].join(".") : index}`;
    },
    getCoreRowModel: () => {
      if (!table._getCoreRowModel) {
        table._getCoreRowModel = table.options.getCoreRowModel(table);
      }
      return table._getCoreRowModel();
    },
    // The final calls start at the bottom of the model,
    // expanded rows, which then work their way up
    getRowModel: () => {
      return table.getPaginationRowModel();
    },
    //in next version, we should just pass in the row model as the optional 2nd arg
    getRow: (id, searchAll) => {
      let row = (searchAll ? table.getPrePaginationRowModel() : table.getRowModel()).rowsById[id];
      if (!row) {
        row = table.getCoreRowModel().rowsById[id];
        if (!row) {
          throw new Error();
        }
      }
      return row;
    },
    _getDefaultColumnDef: memo$1(() => [table.options.defaultColumn], (defaultColumn) => {
      var _defaultColumn;
      defaultColumn = (_defaultColumn = defaultColumn) != null ? _defaultColumn : {};
      return {
        header: (props) => {
          const resolvedColumnDef = props.header.column.columnDef;
          if (resolvedColumnDef.accessorKey) {
            return resolvedColumnDef.accessorKey;
          }
          if (resolvedColumnDef.accessorFn) {
            return resolvedColumnDef.id;
          }
          return null;
        },
        // footer: props => props.header.column.id,
        cell: (props) => {
          var _props$renderValue$to, _props$renderValue;
          return (_props$renderValue$to = (_props$renderValue = props.renderValue()) == null || _props$renderValue.toString == null ? void 0 : _props$renderValue.toString()) != null ? _props$renderValue$to : null;
        },
        ...table._features.reduce((obj, feature) => {
          return Object.assign(obj, feature.getDefaultColumnDef == null ? void 0 : feature.getDefaultColumnDef());
        }, {}),
        ...defaultColumn
      };
    }, getMemoOptions(options, "debugColumns")),
    _getColumnDefs: () => table.options.columns,
    getAllColumns: memo$1(() => [table._getColumnDefs()], (columnDefs) => {
      const recurseColumns = function(columnDefs2, parent, depth) {
        if (depth === void 0) {
          depth = 0;
        }
        return columnDefs2.map((columnDef) => {
          const column = createColumn(table, columnDef, depth, parent);
          const groupingColumnDef = columnDef;
          column.columns = groupingColumnDef.columns ? recurseColumns(groupingColumnDef.columns, column, depth + 1) : [];
          return column;
        });
      };
      return recurseColumns(columnDefs);
    }, getMemoOptions(options, "debugColumns")),
    getAllFlatColumns: memo$1(() => [table.getAllColumns()], (allColumns) => {
      return allColumns.flatMap((column) => {
        return column.getFlatColumns();
      });
    }, getMemoOptions(options, "debugColumns")),
    _getAllFlatColumnsById: memo$1(() => [table.getAllFlatColumns()], (flatColumns) => {
      return flatColumns.reduce((acc, column) => {
        acc[column.id] = column;
        return acc;
      }, {});
    }, getMemoOptions(options, "debugColumns")),
    getAllLeafColumns: memo$1(() => [table.getAllColumns(), table._getOrderColumnsFn()], (allColumns, orderColumns2) => {
      let leafColumns = allColumns.flatMap((column) => column.getLeafColumns());
      return orderColumns2(leafColumns);
    }, getMemoOptions(options, "debugColumns")),
    getColumn: (columnId) => {
      const column = table._getAllFlatColumnsById()[columnId];
      return column;
    }
  };
  Object.assign(table, coreInstance);
  for (let index = 0; index < table._features.length; index++) {
    const feature = table._features[index];
    feature == null || feature.createTable == null || feature.createTable(table);
  }
  return table;
}
function getCoreRowModel() {
  return (table) => memo$1(() => [table.options.data], (data) => {
    const rowModel = {
      rows: [],
      flatRows: [],
      rowsById: {}
    };
    const accessRows = function(originalRows, depth, parentRow) {
      if (depth === void 0) {
        depth = 0;
      }
      const rows = [];
      for (let i = 0; i < originalRows.length; i++) {
        const row = createRow(table, table._getRowId(originalRows[i], i, parentRow), originalRows[i], i, depth, void 0, parentRow == null ? void 0 : parentRow.id);
        rowModel.flatRows.push(row);
        rowModel.rowsById[row.id] = row;
        rows.push(row);
        if (table.options.getSubRows) {
          var _row$originalSubRows;
          row.originalSubRows = table.options.getSubRows(originalRows[i], i);
          if ((_row$originalSubRows = row.originalSubRows) != null && _row$originalSubRows.length) {
            row.subRows = accessRows(row.originalSubRows, depth + 1, row);
          }
        }
      }
      return rows;
    };
    rowModel.rows = accessRows(data);
    return rowModel;
  }, getMemoOptions(table.options, "debugTable", "getRowModel", () => table._autoResetPageIndex()));
}
function filterRows(rows, filterRowImpl, table) {
  if (table.options.filterFromLeafRows) {
    return filterRowModelFromLeafs(rows, filterRowImpl, table);
  }
  return filterRowModelFromRoot(rows, filterRowImpl, table);
}
function filterRowModelFromLeafs(rowsToFilter, filterRow, table) {
  var _table$options$maxLea;
  const newFilteredFlatRows = [];
  const newFilteredRowsById = {};
  const maxDepth = (_table$options$maxLea = table.options.maxLeafRowFilterDepth) != null ? _table$options$maxLea : 100;
  const recurseFilterRows = function(rowsToFilter2, depth) {
    if (depth === void 0) {
      depth = 0;
    }
    const rows = [];
    for (let i = 0; i < rowsToFilter2.length; i++) {
      var _row$subRows;
      let row = rowsToFilter2[i];
      const newRow = createRow(table, row.id, row.original, row.index, row.depth, void 0, row.parentId);
      newRow.columnFilters = row.columnFilters;
      if ((_row$subRows = row.subRows) != null && _row$subRows.length && depth < maxDepth) {
        newRow.subRows = recurseFilterRows(row.subRows, depth + 1);
        row = newRow;
        if (filterRow(row) && !newRow.subRows.length) {
          rows.push(row);
          newFilteredRowsById[row.id] = row;
          newFilteredFlatRows.push(row);
          continue;
        }
        if (filterRow(row) || newRow.subRows.length) {
          rows.push(row);
          newFilteredRowsById[row.id] = row;
          newFilteredFlatRows.push(row);
          continue;
        }
      } else {
        row = newRow;
        if (filterRow(row)) {
          rows.push(row);
          newFilteredRowsById[row.id] = row;
          newFilteredFlatRows.push(row);
        }
      }
    }
    return rows;
  };
  return {
    rows: recurseFilterRows(rowsToFilter),
    flatRows: newFilteredFlatRows,
    rowsById: newFilteredRowsById
  };
}
function filterRowModelFromRoot(rowsToFilter, filterRow, table) {
  var _table$options$maxLea2;
  const newFilteredFlatRows = [];
  const newFilteredRowsById = {};
  const maxDepth = (_table$options$maxLea2 = table.options.maxLeafRowFilterDepth) != null ? _table$options$maxLea2 : 100;
  const recurseFilterRows = function(rowsToFilter2, depth) {
    if (depth === void 0) {
      depth = 0;
    }
    const rows = [];
    for (let i = 0; i < rowsToFilter2.length; i++) {
      let row = rowsToFilter2[i];
      const pass = filterRow(row);
      if (pass) {
        var _row$subRows2;
        if ((_row$subRows2 = row.subRows) != null && _row$subRows2.length && depth < maxDepth) {
          const newRow = createRow(table, row.id, row.original, row.index, row.depth, void 0, row.parentId);
          newRow.subRows = recurseFilterRows(row.subRows, depth + 1);
          row = newRow;
        }
        rows.push(row);
        newFilteredFlatRows.push(row);
        newFilteredRowsById[row.id] = row;
      }
    }
    return rows;
  };
  return {
    rows: recurseFilterRows(rowsToFilter),
    flatRows: newFilteredFlatRows,
    rowsById: newFilteredRowsById
  };
}
function getFilteredRowModel() {
  return (table) => memo$1(() => [table.getPreFilteredRowModel(), table.getState().columnFilters, table.getState().globalFilter], (rowModel, columnFilters, globalFilter) => {
    if (!rowModel.rows.length || !(columnFilters != null && columnFilters.length) && !globalFilter) {
      for (let i = 0; i < rowModel.flatRows.length; i++) {
        rowModel.flatRows[i].columnFilters = {};
        rowModel.flatRows[i].columnFiltersMeta = {};
      }
      return rowModel;
    }
    const resolvedColumnFilters = [];
    const resolvedGlobalFilters = [];
    (columnFilters != null ? columnFilters : []).forEach((d) => {
      var _filterFn$resolveFilt;
      const column = table.getColumn(d.id);
      if (!column) {
        return;
      }
      const filterFn = column.getFilterFn();
      if (!filterFn) {
        return;
      }
      resolvedColumnFilters.push({
        id: d.id,
        filterFn,
        resolvedValue: (_filterFn$resolveFilt = filterFn.resolveFilterValue == null ? void 0 : filterFn.resolveFilterValue(d.value)) != null ? _filterFn$resolveFilt : d.value
      });
    });
    const filterableIds = (columnFilters != null ? columnFilters : []).map((d) => d.id);
    const globalFilterFn = table.getGlobalFilterFn();
    const globallyFilterableColumns = table.getAllLeafColumns().filter((column) => column.getCanGlobalFilter());
    if (globalFilter && globalFilterFn && globallyFilterableColumns.length) {
      filterableIds.push("__global__");
      globallyFilterableColumns.forEach((column) => {
        var _globalFilterFn$resol;
        resolvedGlobalFilters.push({
          id: column.id,
          filterFn: globalFilterFn,
          resolvedValue: (_globalFilterFn$resol = globalFilterFn.resolveFilterValue == null ? void 0 : globalFilterFn.resolveFilterValue(globalFilter)) != null ? _globalFilterFn$resol : globalFilter
        });
      });
    }
    let currentColumnFilter;
    let currentGlobalFilter;
    for (let j = 0; j < rowModel.flatRows.length; j++) {
      const row = rowModel.flatRows[j];
      row.columnFilters = {};
      if (resolvedColumnFilters.length) {
        for (let i = 0; i < resolvedColumnFilters.length; i++) {
          currentColumnFilter = resolvedColumnFilters[i];
          const id = currentColumnFilter.id;
          row.columnFilters[id] = currentColumnFilter.filterFn(row, id, currentColumnFilter.resolvedValue, (filterMeta) => {
            row.columnFiltersMeta[id] = filterMeta;
          });
        }
      }
      if (resolvedGlobalFilters.length) {
        for (let i = 0; i < resolvedGlobalFilters.length; i++) {
          currentGlobalFilter = resolvedGlobalFilters[i];
          const id = currentGlobalFilter.id;
          if (currentGlobalFilter.filterFn(row, id, currentGlobalFilter.resolvedValue, (filterMeta) => {
            row.columnFiltersMeta[id] = filterMeta;
          })) {
            row.columnFilters.__global__ = true;
            break;
          }
        }
        if (row.columnFilters.__global__ !== true) {
          row.columnFilters.__global__ = false;
        }
      }
    }
    const filterRowsImpl = (row) => {
      for (let i = 0; i < filterableIds.length; i++) {
        if (row.columnFilters[filterableIds[i]] === false) {
          return false;
        }
      }
      return true;
    };
    return filterRows(rowModel.rows, filterRowsImpl, table);
  }, getMemoOptions(table.options, "debugTable", "getFilteredRowModel", () => table._autoResetPageIndex()));
}
function getSortedRowModel() {
  return (table) => memo$1(() => [table.getState().sorting, table.getPreSortedRowModel()], (sorting, rowModel) => {
    if (!rowModel.rows.length || !(sorting != null && sorting.length)) {
      return rowModel;
    }
    const sortingState = table.getState().sorting;
    const sortedFlatRows = [];
    const availableSorting = sortingState.filter((sort) => {
      var _table$getColumn;
      return (_table$getColumn = table.getColumn(sort.id)) == null ? void 0 : _table$getColumn.getCanSort();
    });
    const columnInfoById = {};
    availableSorting.forEach((sortEntry) => {
      const column = table.getColumn(sortEntry.id);
      if (!column) return;
      columnInfoById[sortEntry.id] = {
        sortUndefined: column.columnDef.sortUndefined,
        invertSorting: column.columnDef.invertSorting,
        sortingFn: column.getSortingFn()
      };
    });
    const sortData = (rows) => {
      const sortedData = rows.map((row) => ({
        ...row
      }));
      sortedData.sort((rowA, rowB) => {
        for (let i = 0; i < availableSorting.length; i += 1) {
          var _sortEntry$desc;
          const sortEntry = availableSorting[i];
          const columnInfo = columnInfoById[sortEntry.id];
          const sortUndefined = columnInfo.sortUndefined;
          const isDesc = (_sortEntry$desc = sortEntry == null ? void 0 : sortEntry.desc) != null ? _sortEntry$desc : false;
          let sortInt = 0;
          if (sortUndefined) {
            const aValue = rowA.getValue(sortEntry.id);
            const bValue = rowB.getValue(sortEntry.id);
            const aUndefined = aValue === void 0;
            const bUndefined = bValue === void 0;
            if (aUndefined || bUndefined) {
              if (sortUndefined === "first") return aUndefined ? -1 : 1;
              if (sortUndefined === "last") return aUndefined ? 1 : -1;
              sortInt = aUndefined && bUndefined ? 0 : aUndefined ? sortUndefined : -sortUndefined;
            }
          }
          if (sortInt === 0) {
            sortInt = columnInfo.sortingFn(rowA, rowB, sortEntry.id);
          }
          if (sortInt !== 0) {
            if (isDesc) {
              sortInt *= -1;
            }
            if (columnInfo.invertSorting) {
              sortInt *= -1;
            }
            return sortInt;
          }
        }
        return rowA.index - rowB.index;
      });
      sortedData.forEach((row) => {
        var _row$subRows;
        sortedFlatRows.push(row);
        if ((_row$subRows = row.subRows) != null && _row$subRows.length) {
          row.subRows = sortData(row.subRows);
        }
      });
      return sortedData;
    };
    return {
      rows: sortData(rowModel.rows),
      flatRows: sortedFlatRows,
      rowsById: rowModel.rowsById
    };
  }, getMemoOptions(table.options, "debugTable", "getSortedRowModel", () => table._autoResetPageIndex()));
}
/**
   * react-table
   *
   * Copyright (c) TanStack
   *
   * This source code is licensed under the MIT license found in the
   * LICENSE.md file in the root directory of this source tree.
   *
   * @license MIT
   */
function flexRender(Comp, props) {
  return !Comp ? null : isReactComponent(Comp) ? /* @__PURE__ */ reactExports.createElement(Comp, props) : Comp;
}
function isReactComponent(component) {
  return isClassComponent(component) || typeof component === "function" || isExoticComponent(component);
}
function isClassComponent(component) {
  return typeof component === "function" && (() => {
    const proto = Object.getPrototypeOf(component);
    return proto.prototype && proto.prototype.isReactComponent;
  })();
}
function isExoticComponent(component) {
  return typeof component === "object" && typeof component.$$typeof === "symbol" && ["react.memo", "react.forward_ref"].includes(component.$$typeof.description);
}
function useReactTable(options) {
  const resolvedOptions = {
    state: {},
    // Dummy state
    onStateChange: () => {
    },
    // noop
    renderFallbackValue: null,
    ...options
  };
  const [tableRef] = reactExports.useState(() => ({
    current: createTable(resolvedOptions)
  }));
  const [state, setState] = reactExports.useState(() => tableRef.current.initialState);
  tableRef.current.setOptions((prev) => ({
    ...prev,
    ...options,
    state: {
      ...state,
      ...options.state
    },
    // Similarly, we'll maintain both our internal state and any user-provided
    // state.
    onStateChange: (updater) => {
      setState(updater);
      options.onStateChange == null || options.onStateChange(updater);
    }
  }));
  return tableRef.current;
}
var reactDomExports = requireReactDom();
function memo(getDeps, fn, opts) {
  let deps = opts.initialDeps ?? [];
  let result;
  function memoizedFunction() {
    var _a, _b, _c, _d;
    let depTime;
    if (opts.key && ((_a = opts.debug) == null ? void 0 : _a.call(opts))) depTime = Date.now();
    const newDeps = getDeps();
    const depsChanged = newDeps.length !== deps.length || newDeps.some((dep, index) => deps[index] !== dep);
    if (!depsChanged) {
      return result;
    }
    deps = newDeps;
    let resultTime;
    if (opts.key && ((_b = opts.debug) == null ? void 0 : _b.call(opts))) resultTime = Date.now();
    result = fn(...newDeps);
    if (opts.key && ((_c = opts.debug) == null ? void 0 : _c.call(opts))) {
      const depEndTime = Math.round((Date.now() - depTime) * 100) / 100;
      const resultEndTime = Math.round((Date.now() - resultTime) * 100) / 100;
      const resultFpsPercentage = resultEndTime / 16;
      const pad = (str, num) => {
        str = String(str);
        while (str.length < num) {
          str = " " + str;
        }
        return str;
      };
      console.info(
        `%c⏱ ${pad(resultEndTime, 5)} /${pad(depEndTime, 5)} ms`,
        `
            font-size: .6rem;
            font-weight: bold;
            color: hsl(${Math.max(
          0,
          Math.min(120 - 120 * resultFpsPercentage, 120)
        )}deg 100% 31%);`,
        opts == null ? void 0 : opts.key
      );
    }
    (_d = opts == null ? void 0 : opts.onChange) == null ? void 0 : _d.call(opts, result);
    return result;
  }
  memoizedFunction.updateDeps = (newDeps) => {
    deps = newDeps;
  };
  return memoizedFunction;
}
function notUndefined(value, msg) {
  if (value === void 0) {
    throw new Error(`Unexpected undefined${""}`);
  } else {
    return value;
  }
}
const approxEqual = (a, b) => Math.abs(a - b) < 1.01;
const debounce = (targetWindow, fn, ms) => {
  let timeoutId;
  return function(...args) {
    targetWindow.clearTimeout(timeoutId);
    timeoutId = targetWindow.setTimeout(() => fn.apply(this, args), ms);
  };
};
const getRect = (element) => {
  const { offsetWidth, offsetHeight } = element;
  return { width: offsetWidth, height: offsetHeight };
};
const defaultKeyExtractor = (index) => index;
const defaultRangeExtractor = (range) => {
  const start = Math.max(range.startIndex - range.overscan, 0);
  const end = Math.min(range.endIndex + range.overscan, range.count - 1);
  const arr = [];
  for (let i = start; i <= end; i++) {
    arr.push(i);
  }
  return arr;
};
const observeElementRect = (instance, cb) => {
  const element = instance.scrollElement;
  if (!element) {
    return;
  }
  const targetWindow = instance.targetWindow;
  if (!targetWindow) {
    return;
  }
  const handler = (rect) => {
    const { width, height } = rect;
    cb({ width: Math.round(width), height: Math.round(height) });
  };
  handler(getRect(element));
  if (!targetWindow.ResizeObserver) {
    return () => {
    };
  }
  const observer = new targetWindow.ResizeObserver((entries) => {
    const run = () => {
      const entry = entries[0];
      if (entry == null ? void 0 : entry.borderBoxSize) {
        const box = entry.borderBoxSize[0];
        if (box) {
          handler({ width: box.inlineSize, height: box.blockSize });
          return;
        }
      }
      handler(getRect(element));
    };
    instance.options.useAnimationFrameWithResizeObserver ? requestAnimationFrame(run) : run();
  });
  observer.observe(element, { box: "border-box" });
  return () => {
    observer.unobserve(element);
  };
};
const addEventListenerOptions = {
  passive: true
};
const supportsScrollend = typeof window == "undefined" ? true : "onscrollend" in window;
const observeElementOffset = (instance, cb) => {
  const element = instance.scrollElement;
  if (!element) {
    return;
  }
  const targetWindow = instance.targetWindow;
  if (!targetWindow) {
    return;
  }
  let offset = 0;
  const fallback = instance.options.useScrollendEvent && supportsScrollend ? () => void 0 : debounce(
    targetWindow,
    () => {
      cb(offset, false);
    },
    instance.options.isScrollingResetDelay
  );
  const createHandler = (isScrolling) => () => {
    const { horizontal, isRtl } = instance.options;
    offset = horizontal ? element["scrollLeft"] * (isRtl && -1 || 1) : element["scrollTop"];
    fallback();
    cb(offset, isScrolling);
  };
  const handler = createHandler(true);
  const endHandler = createHandler(false);
  endHandler();
  element.addEventListener("scroll", handler, addEventListenerOptions);
  const registerScrollendEvent = instance.options.useScrollendEvent && supportsScrollend;
  if (registerScrollendEvent) {
    element.addEventListener("scrollend", endHandler, addEventListenerOptions);
  }
  return () => {
    element.removeEventListener("scroll", handler);
    if (registerScrollendEvent) {
      element.removeEventListener("scrollend", endHandler);
    }
  };
};
const measureElement = (element, entry, instance) => {
  if (entry == null ? void 0 : entry.borderBoxSize) {
    const box = entry.borderBoxSize[0];
    if (box) {
      const size = Math.round(
        box[instance.options.horizontal ? "inlineSize" : "blockSize"]
      );
      return size;
    }
  }
  return element[instance.options.horizontal ? "offsetWidth" : "offsetHeight"];
};
const elementScroll = (offset, {
  adjustments = 0,
  behavior
}, instance) => {
  var _a, _b;
  const toOffset = offset + adjustments;
  (_b = (_a = instance.scrollElement) == null ? void 0 : _a.scrollTo) == null ? void 0 : _b.call(_a, {
    [instance.options.horizontal ? "left" : "top"]: toOffset,
    behavior
  });
};
class Virtualizer {
  constructor(opts) {
    this.unsubs = [];
    this.scrollElement = null;
    this.targetWindow = null;
    this.isScrolling = false;
    this.measurementsCache = [];
    this.itemSizeCache = /* @__PURE__ */ new Map();
    this.pendingMeasuredCacheIndexes = [];
    this.scrollRect = null;
    this.scrollOffset = null;
    this.scrollDirection = null;
    this.scrollAdjustments = 0;
    this.elementsCache = /* @__PURE__ */ new Map();
    this.observer = /* @__PURE__ */ (() => {
      let _ro = null;
      const get = () => {
        if (_ro) {
          return _ro;
        }
        if (!this.targetWindow || !this.targetWindow.ResizeObserver) {
          return null;
        }
        return _ro = new this.targetWindow.ResizeObserver((entries) => {
          entries.forEach((entry) => {
            const run = () => {
              this._measureElement(entry.target, entry);
            };
            this.options.useAnimationFrameWithResizeObserver ? requestAnimationFrame(run) : run();
          });
        });
      };
      return {
        disconnect: () => {
          var _a;
          (_a = get()) == null ? void 0 : _a.disconnect();
          _ro = null;
        },
        observe: (target) => {
          var _a;
          return (_a = get()) == null ? void 0 : _a.observe(target, { box: "border-box" });
        },
        unobserve: (target) => {
          var _a;
          return (_a = get()) == null ? void 0 : _a.unobserve(target);
        }
      };
    })();
    this.range = null;
    this.setOptions = (opts2) => {
      Object.entries(opts2).forEach(([key, value]) => {
        if (typeof value === "undefined") delete opts2[key];
      });
      this.options = {
        debug: false,
        initialOffset: 0,
        overscan: 1,
        paddingStart: 0,
        paddingEnd: 0,
        scrollPaddingStart: 0,
        scrollPaddingEnd: 0,
        horizontal: false,
        getItemKey: defaultKeyExtractor,
        rangeExtractor: defaultRangeExtractor,
        onChange: () => {
        },
        measureElement,
        initialRect: { width: 0, height: 0 },
        scrollMargin: 0,
        gap: 0,
        indexAttribute: "data-index",
        initialMeasurementsCache: [],
        lanes: 1,
        isScrollingResetDelay: 150,
        enabled: true,
        isRtl: false,
        useScrollendEvent: false,
        useAnimationFrameWithResizeObserver: false,
        ...opts2
      };
    };
    this.notify = (sync) => {
      var _a, _b;
      (_b = (_a = this.options).onChange) == null ? void 0 : _b.call(_a, this, sync);
    };
    this.maybeNotify = memo(
      () => {
        this.calculateRange();
        return [
          this.isScrolling,
          this.range ? this.range.startIndex : null,
          this.range ? this.range.endIndex : null
        ];
      },
      (isScrolling) => {
        this.notify(isScrolling);
      },
      {
        key: false,
        debug: () => this.options.debug,
        initialDeps: [
          this.isScrolling,
          this.range ? this.range.startIndex : null,
          this.range ? this.range.endIndex : null
        ]
      }
    );
    this.cleanup = () => {
      this.unsubs.filter(Boolean).forEach((d) => d());
      this.unsubs = [];
      this.observer.disconnect();
      this.scrollElement = null;
      this.targetWindow = null;
    };
    this._didMount = () => {
      return () => {
        this.cleanup();
      };
    };
    this._willUpdate = () => {
      var _a;
      const scrollElement = this.options.enabled ? this.options.getScrollElement() : null;
      if (this.scrollElement !== scrollElement) {
        this.cleanup();
        if (!scrollElement) {
          this.maybeNotify();
          return;
        }
        this.scrollElement = scrollElement;
        if (this.scrollElement && "ownerDocument" in this.scrollElement) {
          this.targetWindow = this.scrollElement.ownerDocument.defaultView;
        } else {
          this.targetWindow = ((_a = this.scrollElement) == null ? void 0 : _a.window) ?? null;
        }
        this.elementsCache.forEach((cached) => {
          this.observer.observe(cached);
        });
        this._scrollToOffset(this.getScrollOffset(), {
          adjustments: void 0,
          behavior: void 0
        });
        this.unsubs.push(
          this.options.observeElementRect(this, (rect) => {
            this.scrollRect = rect;
            this.maybeNotify();
          })
        );
        this.unsubs.push(
          this.options.observeElementOffset(this, (offset, isScrolling) => {
            this.scrollAdjustments = 0;
            this.scrollDirection = isScrolling ? this.getScrollOffset() < offset ? "forward" : "backward" : null;
            this.scrollOffset = offset;
            this.isScrolling = isScrolling;
            this.maybeNotify();
          })
        );
      }
    };
    this.getSize = () => {
      if (!this.options.enabled) {
        this.scrollRect = null;
        return 0;
      }
      this.scrollRect = this.scrollRect ?? this.options.initialRect;
      return this.scrollRect[this.options.horizontal ? "width" : "height"];
    };
    this.getScrollOffset = () => {
      if (!this.options.enabled) {
        this.scrollOffset = null;
        return 0;
      }
      this.scrollOffset = this.scrollOffset ?? (typeof this.options.initialOffset === "function" ? this.options.initialOffset() : this.options.initialOffset);
      return this.scrollOffset;
    };
    this.getFurthestMeasurement = (measurements, index) => {
      const furthestMeasurementsFound = /* @__PURE__ */ new Map();
      const furthestMeasurements = /* @__PURE__ */ new Map();
      for (let m = index - 1; m >= 0; m--) {
        const measurement = measurements[m];
        if (furthestMeasurementsFound.has(measurement.lane)) {
          continue;
        }
        const previousFurthestMeasurement = furthestMeasurements.get(
          measurement.lane
        );
        if (previousFurthestMeasurement == null || measurement.end > previousFurthestMeasurement.end) {
          furthestMeasurements.set(measurement.lane, measurement);
        } else if (measurement.end < previousFurthestMeasurement.end) {
          furthestMeasurementsFound.set(measurement.lane, true);
        }
        if (furthestMeasurementsFound.size === this.options.lanes) {
          break;
        }
      }
      return furthestMeasurements.size === this.options.lanes ? Array.from(furthestMeasurements.values()).sort((a, b) => {
        if (a.end === b.end) {
          return a.index - b.index;
        }
        return a.end - b.end;
      })[0] : void 0;
    };
    this.getMeasurementOptions = memo(
      () => [
        this.options.count,
        this.options.paddingStart,
        this.options.scrollMargin,
        this.options.getItemKey,
        this.options.enabled
      ],
      (count2, paddingStart, scrollMargin, getItemKey, enabled) => {
        this.pendingMeasuredCacheIndexes = [];
        return {
          count: count2,
          paddingStart,
          scrollMargin,
          getItemKey,
          enabled
        };
      },
      {
        key: false
      }
    );
    this.getMeasurements = memo(
      () => [this.getMeasurementOptions(), this.itemSizeCache],
      ({ count: count2, paddingStart, scrollMargin, getItemKey, enabled }, itemSizeCache) => {
        if (!enabled) {
          this.measurementsCache = [];
          this.itemSizeCache.clear();
          return [];
        }
        if (this.measurementsCache.length === 0) {
          this.measurementsCache = this.options.initialMeasurementsCache;
          this.measurementsCache.forEach((item) => {
            this.itemSizeCache.set(item.key, item.size);
          });
        }
        const min2 = this.pendingMeasuredCacheIndexes.length > 0 ? Math.min(...this.pendingMeasuredCacheIndexes) : 0;
        this.pendingMeasuredCacheIndexes = [];
        const measurements = this.measurementsCache.slice(0, min2);
        for (let i = min2; i < count2; i++) {
          const key = getItemKey(i);
          const furthestMeasurement = this.options.lanes === 1 ? measurements[i - 1] : this.getFurthestMeasurement(measurements, i);
          const start = furthestMeasurement ? furthestMeasurement.end + this.options.gap : paddingStart + scrollMargin;
          const measuredSize = itemSizeCache.get(key);
          const size = typeof measuredSize === "number" ? measuredSize : this.options.estimateSize(i);
          const end = start + size;
          const lane = furthestMeasurement ? furthestMeasurement.lane : i % this.options.lanes;
          measurements[i] = {
            index: i,
            start,
            size,
            end,
            key,
            lane
          };
        }
        this.measurementsCache = measurements;
        return measurements;
      },
      {
        key: false,
        debug: () => this.options.debug
      }
    );
    this.calculateRange = memo(
      () => [
        this.getMeasurements(),
        this.getSize(),
        this.getScrollOffset(),
        this.options.lanes
      ],
      (measurements, outerSize, scrollOffset, lanes) => {
        return this.range = measurements.length > 0 && outerSize > 0 ? calculateRange({
          measurements,
          outerSize,
          scrollOffset,
          lanes
        }) : null;
      },
      {
        key: false,
        debug: () => this.options.debug
      }
    );
    this.getVirtualIndexes = memo(
      () => {
        let startIndex = null;
        let endIndex = null;
        const range = this.calculateRange();
        if (range) {
          startIndex = range.startIndex;
          endIndex = range.endIndex;
        }
        this.maybeNotify.updateDeps([this.isScrolling, startIndex, endIndex]);
        return [
          this.options.rangeExtractor,
          this.options.overscan,
          this.options.count,
          startIndex,
          endIndex
        ];
      },
      (rangeExtractor, overscan, count2, startIndex, endIndex) => {
        return startIndex === null || endIndex === null ? [] : rangeExtractor({
          startIndex,
          endIndex,
          overscan,
          count: count2
        });
      },
      {
        key: false,
        debug: () => this.options.debug
      }
    );
    this.indexFromElement = (node) => {
      const attributeName = this.options.indexAttribute;
      const indexStr = node.getAttribute(attributeName);
      if (!indexStr) {
        console.warn(
          `Missing attribute name '${attributeName}={index}' on measured element.`
        );
        return -1;
      }
      return parseInt(indexStr, 10);
    };
    this._measureElement = (node, entry) => {
      const index = this.indexFromElement(node);
      const item = this.measurementsCache[index];
      if (!item) {
        return;
      }
      const key = item.key;
      const prevNode = this.elementsCache.get(key);
      if (prevNode !== node) {
        if (prevNode) {
          this.observer.unobserve(prevNode);
        }
        this.observer.observe(node);
        this.elementsCache.set(key, node);
      }
      if (node.isConnected) {
        this.resizeItem(index, this.options.measureElement(node, entry, this));
      }
    };
    this.resizeItem = (index, size) => {
      const item = this.measurementsCache[index];
      if (!item) {
        return;
      }
      const itemSize = this.itemSizeCache.get(item.key) ?? item.size;
      const delta = size - itemSize;
      if (delta !== 0) {
        if (this.shouldAdjustScrollPositionOnItemSizeChange !== void 0 ? this.shouldAdjustScrollPositionOnItemSizeChange(item, delta, this) : item.start < this.getScrollOffset() + this.scrollAdjustments) {
          this._scrollToOffset(this.getScrollOffset(), {
            adjustments: this.scrollAdjustments += delta,
            behavior: void 0
          });
        }
        this.pendingMeasuredCacheIndexes.push(item.index);
        this.itemSizeCache = new Map(this.itemSizeCache.set(item.key, size));
        this.notify(false);
      }
    };
    this.measureElement = (node) => {
      if (!node) {
        this.elementsCache.forEach((cached, key) => {
          if (!cached.isConnected) {
            this.observer.unobserve(cached);
            this.elementsCache.delete(key);
          }
        });
        return;
      }
      this._measureElement(node, void 0);
    };
    this.getVirtualItems = memo(
      () => [this.getVirtualIndexes(), this.getMeasurements()],
      (indexes, measurements) => {
        const virtualItems = [];
        for (let k = 0, len = indexes.length; k < len; k++) {
          const i = indexes[k];
          const measurement = measurements[i];
          virtualItems.push(measurement);
        }
        return virtualItems;
      },
      {
        key: false,
        debug: () => this.options.debug
      }
    );
    this.getVirtualItemForOffset = (offset) => {
      const measurements = this.getMeasurements();
      if (measurements.length === 0) {
        return void 0;
      }
      return notUndefined(
        measurements[findNearestBinarySearch(
          0,
          measurements.length - 1,
          (index) => notUndefined(measurements[index]).start,
          offset
        )]
      );
    };
    this.getOffsetForAlignment = (toOffset, align, itemSize = 0) => {
      const size = this.getSize();
      const scrollOffset = this.getScrollOffset();
      if (align === "auto") {
        align = toOffset >= scrollOffset + size ? "end" : "start";
      }
      if (align === "center") {
        toOffset += (itemSize - size) / 2;
      } else if (align === "end") {
        toOffset -= size;
      }
      const maxOffset = this.getTotalSize() + this.options.scrollMargin - size;
      return Math.max(Math.min(maxOffset, toOffset), 0);
    };
    this.getOffsetForIndex = (index, align = "auto") => {
      index = Math.max(0, Math.min(index, this.options.count - 1));
      const item = this.measurementsCache[index];
      if (!item) {
        return void 0;
      }
      const size = this.getSize();
      const scrollOffset = this.getScrollOffset();
      if (align === "auto") {
        if (item.end >= scrollOffset + size - this.options.scrollPaddingEnd) {
          align = "end";
        } else if (item.start <= scrollOffset + this.options.scrollPaddingStart) {
          align = "start";
        } else {
          return [scrollOffset, align];
        }
      }
      const toOffset = align === "end" ? item.end + this.options.scrollPaddingEnd : item.start - this.options.scrollPaddingStart;
      return [
        this.getOffsetForAlignment(toOffset, align, item.size),
        align
      ];
    };
    this.isDynamicMode = () => this.elementsCache.size > 0;
    this.scrollToOffset = (toOffset, { align = "start", behavior } = {}) => {
      if (behavior === "smooth" && this.isDynamicMode()) {
        console.warn(
          "The `smooth` scroll behavior is not fully supported with dynamic size."
        );
      }
      this._scrollToOffset(this.getOffsetForAlignment(toOffset, align), {
        adjustments: void 0,
        behavior
      });
    };
    this.scrollToIndex = (index, { align: initialAlign = "auto", behavior } = {}) => {
      if (behavior === "smooth" && this.isDynamicMode()) {
        console.warn(
          "The `smooth` scroll behavior is not fully supported with dynamic size."
        );
      }
      index = Math.max(0, Math.min(index, this.options.count - 1));
      let attempts = 0;
      const maxAttempts = 10;
      const tryScroll = (currentAlign) => {
        if (!this.targetWindow) return;
        const offsetInfo = this.getOffsetForIndex(index, currentAlign);
        if (!offsetInfo) {
          console.warn("Failed to get offset for index:", index);
          return;
        }
        const [offset, align] = offsetInfo;
        this._scrollToOffset(offset, { adjustments: void 0, behavior });
        this.targetWindow.requestAnimationFrame(() => {
          const currentOffset = this.getScrollOffset();
          const afterInfo = this.getOffsetForIndex(index, align);
          if (!afterInfo) {
            console.warn("Failed to get offset for index:", index);
            return;
          }
          if (!approxEqual(afterInfo[0], currentOffset)) {
            scheduleRetry(align);
          }
        });
      };
      const scheduleRetry = (align) => {
        if (!this.targetWindow) return;
        attempts++;
        if (attempts < maxAttempts) {
          this.targetWindow.requestAnimationFrame(() => tryScroll(align));
        } else {
          console.warn(
            `Failed to scroll to index ${index} after ${maxAttempts} attempts.`
          );
        }
      };
      tryScroll(initialAlign);
    };
    this.scrollBy = (delta, { behavior } = {}) => {
      if (behavior === "smooth" && this.isDynamicMode()) {
        console.warn(
          "The `smooth` scroll behavior is not fully supported with dynamic size."
        );
      }
      this._scrollToOffset(this.getScrollOffset() + delta, {
        adjustments: void 0,
        behavior
      });
    };
    this.getTotalSize = () => {
      var _a;
      const measurements = this.getMeasurements();
      let end;
      if (measurements.length === 0) {
        end = this.options.paddingStart;
      } else if (this.options.lanes === 1) {
        end = ((_a = measurements[measurements.length - 1]) == null ? void 0 : _a.end) ?? 0;
      } else {
        const endByLane = Array(this.options.lanes).fill(null);
        let endIndex = measurements.length - 1;
        while (endIndex >= 0 && endByLane.some((val) => val === null)) {
          const item = measurements[endIndex];
          if (endByLane[item.lane] === null) {
            endByLane[item.lane] = item.end;
          }
          endIndex--;
        }
        end = Math.max(...endByLane.filter((val) => val !== null));
      }
      return Math.max(
        end - this.options.scrollMargin + this.options.paddingEnd,
        0
      );
    };
    this._scrollToOffset = (offset, {
      adjustments,
      behavior
    }) => {
      this.options.scrollToFn(offset, { behavior, adjustments }, this);
    };
    this.measure = () => {
      this.itemSizeCache = /* @__PURE__ */ new Map();
      this.notify(false);
    };
    this.setOptions(opts);
  }
}
const findNearestBinarySearch = (low, high, getCurrentValue, value) => {
  while (low <= high) {
    const middle = (low + high) / 2 | 0;
    const currentValue = getCurrentValue(middle);
    if (currentValue < value) {
      low = middle + 1;
    } else if (currentValue > value) {
      high = middle - 1;
    } else {
      return middle;
    }
  }
  if (low > 0) {
    return low - 1;
  } else {
    return 0;
  }
};
function calculateRange({
  measurements,
  outerSize,
  scrollOffset,
  lanes
}) {
  const lastIndex = measurements.length - 1;
  const getOffset = (index) => measurements[index].start;
  if (measurements.length <= lanes) {
    return {
      startIndex: 0,
      endIndex: lastIndex
    };
  }
  let startIndex = findNearestBinarySearch(
    0,
    lastIndex,
    getOffset,
    scrollOffset
  );
  let endIndex = startIndex;
  if (lanes === 1) {
    while (endIndex < lastIndex && measurements[endIndex].end < scrollOffset + outerSize) {
      endIndex++;
    }
  } else if (lanes > 1) {
    const endPerLane = Array(lanes).fill(0);
    while (endIndex < lastIndex && endPerLane.some((pos) => pos < scrollOffset + outerSize)) {
      const item = measurements[endIndex];
      endPerLane[item.lane] = item.end;
      endIndex++;
    }
    const startPerLane = Array(lanes).fill(scrollOffset + outerSize);
    while (startIndex >= 0 && startPerLane.some((pos) => pos >= scrollOffset)) {
      const item = measurements[startIndex];
      startPerLane[item.lane] = item.start;
      startIndex--;
    }
    startIndex = Math.max(0, startIndex - startIndex % lanes);
    endIndex = Math.min(lastIndex, endIndex + (lanes - 1 - endIndex % lanes));
  }
  return { startIndex, endIndex };
}
const useIsomorphicLayoutEffect = typeof document !== "undefined" ? reactExports.useLayoutEffect : reactExports.useEffect;
function useVirtualizerBase(options) {
  const rerender = reactExports.useReducer(() => ({}), {})[1];
  const resolvedOptions = {
    ...options,
    onChange: (instance2, sync) => {
      var _a;
      if (sync) {
        reactDomExports.flushSync(rerender);
      } else {
        rerender();
      }
      (_a = options.onChange) == null ? void 0 : _a.call(options, instance2, sync);
    }
  };
  const [instance] = reactExports.useState(
    () => new Virtualizer(resolvedOptions)
  );
  instance.setOptions(resolvedOptions);
  useIsomorphicLayoutEffect(() => {
    return instance._didMount();
  }, []);
  useIsomorphicLayoutEffect(() => {
    return instance._willUpdate();
  });
  return instance;
}
function useVirtualizer(options) {
  return useVirtualizerBase({
    observeElementRect,
    observeElementOffset,
    scrollToFn: elementScroll,
    ...options
  });
}
var main$1 = { exports: {} };
var main = main$1.exports;
var hasRequiredMain;
function requireMain() {
  if (hasRequiredMain) return main$1.exports;
  hasRequiredMain = 1;
  (function(module, exports) {
    !(function(e, t) {
      module.exports = t(requireReact());
    })(main, ((e) => (() => {
      var t = { 9735: (e2, t2) => {
        t2.__esModule = true, t2.default = { scheme: "apathy", author: "jannik siebert (https://github.com/janniks)", base00: "#031A16", base01: "#0B342D", base02: "#184E45", base03: "#2B685E", base04: "#5F9C92", base05: "#81B5AC", base06: "#A7CEC8", base07: "#D2E7E4", base08: "#3E9688", base09: "#3E7996", base0A: "#3E4C96", base0B: "#883E96", base0C: "#963E4C", base0D: "#96883E", base0E: "#4C963E", base0F: "#3E965B" }, e2.exports = t2.default;
      }, 294: (e2, t2) => {
        t2.__esModule = true, t2.default = { scheme: "ashes", author: "jannik siebert (https://github.com/janniks)", base00: "#1C2023", base01: "#393F45", base02: "#565E65", base03: "#747C84", base04: "#ADB3BA", base05: "#C7CCD1", base06: "#DFE2E5", base07: "#F3F4F5", base08: "#C7AE95", base09: "#C7C795", base0A: "#AEC795", base0B: "#95C7AE", base0C: "#95AEC7", base0D: "#AE95C7", base0E: "#C795AE", base0F: "#C79595" }, e2.exports = t2.default;
      }, 1733: (e2, t2) => {
        t2.__esModule = true, t2.default = { scheme: "atelier dune", author: "bram de haan (http://atelierbram.github.io/syntax-highlighting/atelier-schemes/dune)", base00: "#20201d", base01: "#292824", base02: "#6e6b5e", base03: "#7d7a68", base04: "#999580", base05: "#a6a28c", base06: "#e8e4cf", base07: "#fefbec", base08: "#d73737", base09: "#b65611", base0A: "#cfb017", base0B: "#60ac39", base0C: "#1fad83", base0D: "#6684e1", base0E: "#b854d4", base0F: "#d43552" }, e2.exports = t2.default;
      }, 8974: (e2, t2) => {
        t2.__esModule = true, t2.default = { scheme: "atelier forest", author: "bram de haan (http://atelierbram.github.io/syntax-highlighting/atelier-schemes/forest)", base00: "#1b1918", base01: "#2c2421", base02: "#68615e", base03: "#766e6b", base04: "#9c9491", base05: "#a8a19f", base06: "#e6e2e0", base07: "#f1efee", base08: "#f22c40", base09: "#df5320", base0A: "#d5911a", base0B: "#5ab738", base0C: "#00ad9c", base0D: "#407ee7", base0E: "#6666ea", base0F: "#c33ff3" }, e2.exports = t2.default;
      }, 6933: (e2, t2) => {
        t2.__esModule = true, t2.default = { scheme: "atelier heath", author: "bram de haan (http://atelierbram.github.io/syntax-highlighting/atelier-schemes/heath)", base00: "#1b181b", base01: "#292329", base02: "#695d69", base03: "#776977", base04: "#9e8f9e", base05: "#ab9bab", base06: "#d8cad8", base07: "#f7f3f7", base08: "#ca402b", base09: "#a65926", base0A: "#bb8a35", base0B: "#379a37", base0C: "#159393", base0D: "#516aec", base0E: "#7b59c0", base0F: "#cc33cc" }, e2.exports = t2.default;
      }, 523: (e2, t2) => {
        t2.__esModule = true, t2.default = { scheme: "atelier lakeside", author: "bram de haan (http://atelierbram.github.io/syntax-highlighting/atelier-schemes/lakeside/)", base00: "#161b1d", base01: "#1f292e", base02: "#516d7b", base03: "#5a7b8c", base04: "#7195a8", base05: "#7ea2b4", base06: "#c1e4f6", base07: "#ebf8ff", base08: "#d22d72", base09: "#935c25", base0A: "#8a8a0f", base0B: "#568c3b", base0C: "#2d8f6f", base0D: "#257fad", base0E: "#5d5db1", base0F: "#b72dd2" }, e2.exports = t2.default;
      }, 1223: (e2, t2) => {
        t2.__esModule = true, t2.default = { scheme: "atelier seaside", author: "bram de haan (http://atelierbram.github.io/syntax-highlighting/atelier-schemes/seaside/)", base00: "#131513", base01: "#242924", base02: "#5e6e5e", base03: "#687d68", base04: "#809980", base05: "#8ca68c", base06: "#cfe8cf", base07: "#f0fff0", base08: "#e6193c", base09: "#87711d", base0A: "#c3c322", base0B: "#29a329", base0C: "#1999b3", base0D: "#3d62f5", base0E: "#ad2bee", base0F: "#e619c3" }, e2.exports = t2.default;
      }, 1233: (e2, t2) => {
        t2.__esModule = true, t2.default = { scheme: "bespin", author: "jan t. sott", base00: "#28211c", base01: "#36312e", base02: "#5e5d5c", base03: "#666666", base04: "#797977", base05: "#8a8986", base06: "#9d9b97", base07: "#baae9e", base08: "#cf6a4c", base09: "#cf7d34", base0A: "#f9ee98", base0B: "#54be0d", base0C: "#afc4db", base0D: "#5ea6ea", base0E: "#9b859d", base0F: "#937121" }, e2.exports = t2.default;
      }, 2847: (e2, t2) => {
        t2.__esModule = true, t2.default = { scheme: "brewer", author: "timothée poisot (http://github.com/tpoisot)", base00: "#0c0d0e", base01: "#2e2f30", base02: "#515253", base03: "#737475", base04: "#959697", base05: "#b7b8b9", base06: "#dadbdc", base07: "#fcfdfe", base08: "#e31a1c", base09: "#e6550d", base0A: "#dca060", base0B: "#31a354", base0C: "#80b1d3", base0D: "#3182bd", base0E: "#756bb1", base0F: "#b15928" }, e2.exports = t2.default;
      }, 8120: (e2, t2) => {
        t2.__esModule = true, t2.default = { scheme: "bright", author: "chris kempson (http://chriskempson.com)", base00: "#000000", base01: "#303030", base02: "#505050", base03: "#b0b0b0", base04: "#d0d0d0", base05: "#e0e0e0", base06: "#f5f5f5", base07: "#ffffff", base08: "#fb0120", base09: "#fc6d24", base0A: "#fda331", base0B: "#a1c659", base0C: "#76c7b7", base0D: "#6fb3d2", base0E: "#d381c3", base0F: "#be643c" }, e2.exports = t2.default;
      }, 6305: (e2, t2) => {
        t2.__esModule = true, t2.default = { scheme: "chalk", author: "chris kempson (http://chriskempson.com)", base00: "#151515", base01: "#202020", base02: "#303030", base03: "#505050", base04: "#b0b0b0", base05: "#d0d0d0", base06: "#e0e0e0", base07: "#f5f5f5", base08: "#fb9fb1", base09: "#eda987", base0A: "#ddb26f", base0B: "#acc267", base0C: "#12cfc0", base0D: "#6fc2ef", base0E: "#e1a3ee", base0F: "#deaf8f" }, e2.exports = t2.default;
      }, 525: (e2, t2) => {
        t2.__esModule = true, t2.default = { scheme: "codeschool", author: "brettof86", base00: "#232c31", base01: "#1c3657", base02: "#2a343a", base03: "#3f4944", base04: "#84898c", base05: "#9ea7a6", base06: "#a7cfa3", base07: "#b5d8f6", base08: "#2a5491", base09: "#43820d", base0A: "#a03b1e", base0B: "#237986", base0C: "#b02f30", base0D: "#484d79", base0E: "#c59820", base0F: "#c98344" }, e2.exports = t2.default;
      }, 4124: (e2, t2) => {
        t2.__esModule = true, t2.default = { scheme: "colors", author: "mrmrs (http://clrs.cc)", base00: "#111111", base01: "#333333", base02: "#555555", base03: "#777777", base04: "#999999", base05: "#bbbbbb", base06: "#dddddd", base07: "#ffffff", base08: "#ff4136", base09: "#ff851b", base0A: "#ffdc00", base0B: "#2ecc40", base0C: "#7fdbff", base0D: "#0074d9", base0E: "#b10dc9", base0F: "#85144b" }, e2.exports = t2.default;
      }, 7167: (e2, t2) => {
        t2.__esModule = true, t2.default = { scheme: "default", author: "chris kempson (http://chriskempson.com)", base00: "#181818", base01: "#282828", base02: "#383838", base03: "#585858", base04: "#b8b8b8", base05: "#d8d8d8", base06: "#e8e8e8", base07: "#f8f8f8", base08: "#ab4642", base09: "#dc9656", base0A: "#f7ca88", base0B: "#a1b56c", base0C: "#86c1b9", base0D: "#7cafc2", base0E: "#ba8baf", base0F: "#a16946" }, e2.exports = t2.default;
      }, 4582: (e2, t2) => {
        t2.__esModule = true, t2.default = { scheme: "eighties", author: "chris kempson (http://chriskempson.com)", base00: "#2d2d2d", base01: "#393939", base02: "#515151", base03: "#747369", base04: "#a09f93", base05: "#d3d0c8", base06: "#e8e6df", base07: "#f2f0ec", base08: "#f2777a", base09: "#f99157", base0A: "#ffcc66", base0B: "#99cc99", base0C: "#66cccc", base0D: "#6699cc", base0E: "#cc99cc", base0F: "#d27b53" }, e2.exports = t2.default;
      }, 7096: (e2, t2) => {
        t2.__esModule = true, t2.default = { scheme: "embers", author: "jannik siebert (https://github.com/janniks)", base00: "#16130F", base01: "#2C2620", base02: "#433B32", base03: "#5A5047", base04: "#8A8075", base05: "#A39A90", base06: "#BEB6AE", base07: "#DBD6D1", base08: "#826D57", base09: "#828257", base0A: "#6D8257", base0B: "#57826D", base0C: "#576D82", base0D: "#6D5782", base0E: "#82576D", base0F: "#825757" }, e2.exports = t2.default;
      }, 9887: (e2, t2) => {
        t2.__esModule = true, t2.default = { scheme: "flat", author: "chris kempson (http://chriskempson.com)", base00: "#2C3E50", base01: "#34495E", base02: "#7F8C8D", base03: "#95A5A6", base04: "#BDC3C7", base05: "#e0e0e0", base06: "#f5f5f5", base07: "#ECF0F1", base08: "#E74C3C", base09: "#E67E22", base0A: "#F1C40F", base0B: "#2ECC71", base0C: "#1ABC9C", base0D: "#3498DB", base0E: "#9B59B6", base0F: "#be643c" }, e2.exports = t2.default;
      }, 7199: (e2, t2) => {
        t2.__esModule = true, t2.default = { scheme: "google", author: "seth wright (http://sethawright.com)", base00: "#1d1f21", base01: "#282a2e", base02: "#373b41", base03: "#969896", base04: "#b4b7b4", base05: "#c5c8c6", base06: "#e0e0e0", base07: "#ffffff", base08: "#CC342B", base09: "#F96A38", base0A: "#FBA922", base0B: "#198844", base0C: "#3971ED", base0D: "#3971ED", base0E: "#A36AC7", base0F: "#3971ED" }, e2.exports = t2.default;
      }, 1985: (e2, t2) => {
        t2.__esModule = true, t2.default = { scheme: "grayscale", author: "alexandre gavioli (https://github.com/alexx2/)", base00: "#101010", base01: "#252525", base02: "#464646", base03: "#525252", base04: "#ababab", base05: "#b9b9b9", base06: "#e3e3e3", base07: "#f7f7f7", base08: "#7c7c7c", base09: "#999999", base0A: "#a0a0a0", base0B: "#8e8e8e", base0C: "#868686", base0D: "#686868", base0E: "#747474", base0F: "#5e5e5e" }, e2.exports = t2.default;
      }, 8093: (e2, t2) => {
        t2.__esModule = true, t2.default = { scheme: "green screen", author: "chris kempson (http://chriskempson.com)", base00: "#001100", base01: "#003300", base02: "#005500", base03: "#007700", base04: "#009900", base05: "#00bb00", base06: "#00dd00", base07: "#00ff00", base08: "#007700", base09: "#009900", base0A: "#007700", base0B: "#00bb00", base0C: "#005500", base0D: "#009900", base0E: "#00bb00", base0F: "#005500" }, e2.exports = t2.default;
      }, 1615: (e2, t2) => {
        t2.__esModule = true, t2.default = { scheme: "harmonic16", author: "jannik siebert (https://github.com/janniks)", base00: "#0b1c2c", base01: "#223b54", base02: "#405c79", base03: "#627e99", base04: "#aabcce", base05: "#cbd6e2", base06: "#e5ebf1", base07: "#f7f9fb", base08: "#bf8b56", base09: "#bfbf56", base0A: "#8bbf56", base0B: "#56bf8b", base0C: "#568bbf", base0D: "#8b56bf", base0E: "#bf568b", base0F: "#bf5656" }, e2.exports = t2.default;
      }, 9063: (e2, t2) => {
        t2.__esModule = true, t2.default = { scheme: "hopscotch", author: "jan t. sott", base00: "#322931", base01: "#433b42", base02: "#5c545b", base03: "#797379", base04: "#989498", base05: "#b9b5b8", base06: "#d5d3d5", base07: "#ffffff", base08: "#dd464c", base09: "#fd8b19", base0A: "#fdcc59", base0B: "#8fc13e", base0C: "#149b93", base0D: "#1290bf", base0E: "#c85e7c", base0F: "#b33508" }, e2.exports = t2.default;
      }, 9446: (e2, t2, a2) => {
        function r2(e3) {
          return e3 && e3.__esModule ? e3.default : e3;
        }
        t2.__esModule = true;
        var n2 = a2(1308);
        t2.threezerotwofour = r2(n2);
        var o = a2(9735);
        t2.apathy = r2(o);
        var s = a2(294);
        t2.ashes = r2(s);
        var i = a2(1733);
        t2.atelierDune = r2(i);
        var l = a2(8974);
        t2.atelierForest = r2(l);
        var c = a2(6933);
        t2.atelierHeath = r2(c);
        var u = a2(523);
        t2.atelierLakeside = r2(u);
        var d = a2(1223);
        t2.atelierSeaside = r2(d);
        var b = a2(1233);
        t2.bespin = r2(b);
        var p = a2(2847);
        t2.brewer = r2(p);
        var f = a2(8120);
        t2.bright = r2(f);
        var h = a2(6305);
        t2.chalk = r2(h);
        var m = a2(525);
        t2.codeschool = r2(m);
        var v = a2(4124);
        t2.colors = r2(v);
        var g = a2(7167);
        t2.default = r2(g);
        var y = a2(4582);
        t2.eighties = r2(y);
        var k = a2(7096);
        t2.embers = r2(k);
        var E = a2(9887);
        t2.flat = r2(E);
        var w = a2(7199);
        t2.google = r2(w);
        var j = a2(1985);
        t2.grayscale = r2(j);
        var x = a2(8093);
        t2.greenscreen = r2(x);
        var C = a2(1615);
        t2.harmonic = r2(C);
        var O = a2(9063);
        t2.hopscotch = r2(O);
        var M = a2(9033);
        t2.isotope = r2(M);
        var S = a2(4112);
        t2.marrakesh = r2(S);
        var _ = a2(9600);
        t2.mocha = r2(_);
        var A = a2(1240);
        t2.monokai = r2(A);
        var F = a2(9768);
        t2.ocean = r2(F);
        var P = a2(8293);
        t2.paraiso = r2(P);
        var R = a2(3093);
        t2.pop = r2(R);
        var D = a2(1951);
        t2.railscasts = r2(D);
        var I = a2(6368);
        t2.shapeshifter = r2(I);
        var z = a2(2317);
        t2.solarized = r2(z);
        var B = a2(1091);
        t2.summerfruit = r2(B);
        var N = a2(6943);
        t2.tomorrow = r2(N);
        var L = a2(5670);
        t2.tube = r2(L);
        var q = a2(2536);
        t2.twilight = r2(q);
      }, 9033: (e2, t2) => {
        t2.__esModule = true, t2.default = { scheme: "isotope", author: "jan t. sott", base00: "#000000", base01: "#404040", base02: "#606060", base03: "#808080", base04: "#c0c0c0", base05: "#d0d0d0", base06: "#e0e0e0", base07: "#ffffff", base08: "#ff0000", base09: "#ff9900", base0A: "#ff0099", base0B: "#33ff00", base0C: "#00ffff", base0D: "#0066ff", base0E: "#cc00ff", base0F: "#3300ff" }, e2.exports = t2.default;
      }, 4112: (e2, t2) => {
        t2.__esModule = true, t2.default = { scheme: "marrakesh", author: "alexandre gavioli (http://github.com/alexx2/)", base00: "#201602", base01: "#302e00", base02: "#5f5b17", base03: "#6c6823", base04: "#86813b", base05: "#948e48", base06: "#ccc37a", base07: "#faf0a5", base08: "#c35359", base09: "#b36144", base0A: "#a88339", base0B: "#18974e", base0C: "#75a738", base0D: "#477ca1", base0E: "#8868b3", base0F: "#b3588e" }, e2.exports = t2.default;
      }, 9600: (e2, t2) => {
        t2.__esModule = true, t2.default = { scheme: "mocha", author: "chris kempson (http://chriskempson.com)", base00: "#3B3228", base01: "#534636", base02: "#645240", base03: "#7e705a", base04: "#b8afad", base05: "#d0c8c6", base06: "#e9e1dd", base07: "#f5eeeb", base08: "#cb6077", base09: "#d28b71", base0A: "#f4bc87", base0B: "#beb55b", base0C: "#7bbda4", base0D: "#8ab3b5", base0E: "#a89bb9", base0F: "#bb9584" }, e2.exports = t2.default;
      }, 1240: (e2, t2) => {
        t2.__esModule = true, t2.default = { scheme: "monokai", author: "wimer hazenberg (http://www.monokai.nl)", base00: "#272822", base01: "#383830", base02: "#49483e", base03: "#75715e", base04: "#a59f85", base05: "#f8f8f2", base06: "#f5f4f1", base07: "#f9f8f5", base08: "#f92672", base09: "#fd971f", base0A: "#f4bf75", base0B: "#a6e22e", base0C: "#a1efe4", base0D: "#66d9ef", base0E: "#ae81ff", base0F: "#cc6633" }, e2.exports = t2.default;
      }, 9768: (e2, t2) => {
        t2.__esModule = true, t2.default = { scheme: "ocean", author: "chris kempson (http://chriskempson.com)", base00: "#2b303b", base01: "#343d46", base02: "#4f5b66", base03: "#65737e", base04: "#a7adba", base05: "#c0c5ce", base06: "#dfe1e8", base07: "#eff1f5", base08: "#bf616a", base09: "#d08770", base0A: "#ebcb8b", base0B: "#a3be8c", base0C: "#96b5b4", base0D: "#8fa1b3", base0E: "#b48ead", base0F: "#ab7967" }, e2.exports = t2.default;
      }, 8293: (e2, t2) => {
        t2.__esModule = true, t2.default = { scheme: "paraiso", author: "jan t. sott", base00: "#2f1e2e", base01: "#41323f", base02: "#4f424c", base03: "#776e71", base04: "#8d8687", base05: "#a39e9b", base06: "#b9b6b0", base07: "#e7e9db", base08: "#ef6155", base09: "#f99b15", base0A: "#fec418", base0B: "#48b685", base0C: "#5bc4bf", base0D: "#06b6ef", base0E: "#815ba4", base0F: "#e96ba8" }, e2.exports = t2.default;
      }, 3093: (e2, t2) => {
        t2.__esModule = true, t2.default = { scheme: "pop", author: "chris kempson (http://chriskempson.com)", base00: "#000000", base01: "#202020", base02: "#303030", base03: "#505050", base04: "#b0b0b0", base05: "#d0d0d0", base06: "#e0e0e0", base07: "#ffffff", base08: "#eb008a", base09: "#f29333", base0A: "#f8ca12", base0B: "#37b349", base0C: "#00aabb", base0D: "#0e5a94", base0E: "#b31e8d", base0F: "#7a2d00" }, e2.exports = t2.default;
      }, 1951: (e2, t2) => {
        t2.__esModule = true, t2.default = { scheme: "railscasts", author: "ryan bates (http://railscasts.com)", base00: "#2b2b2b", base01: "#272935", base02: "#3a4055", base03: "#5a647e", base04: "#d4cfc9", base05: "#e6e1dc", base06: "#f4f1ed", base07: "#f9f7f3", base08: "#da4939", base09: "#cc7833", base0A: "#ffc66d", base0B: "#a5c261", base0C: "#519f50", base0D: "#6d9cbe", base0E: "#b6b3eb", base0F: "#bc9458" }, e2.exports = t2.default;
      }, 6368: (e2, t2) => {
        t2.__esModule = true, t2.default = { scheme: "shapeshifter", author: "tyler benziger (http://tybenz.com)", base00: "#000000", base01: "#040404", base02: "#102015", base03: "#343434", base04: "#555555", base05: "#ababab", base06: "#e0e0e0", base07: "#f9f9f9", base08: "#e92f2f", base09: "#e09448", base0A: "#dddd13", base0B: "#0ed839", base0C: "#23edda", base0D: "#3b48e3", base0E: "#f996e2", base0F: "#69542d" }, e2.exports = t2.default;
      }, 2317: (e2, t2) => {
        t2.__esModule = true, t2.default = { scheme: "solarized", author: "ethan schoonover (http://ethanschoonover.com/solarized)", base00: "#002b36", base01: "#073642", base02: "#586e75", base03: "#657b83", base04: "#839496", base05: "#93a1a1", base06: "#eee8d5", base07: "#fdf6e3", base08: "#dc322f", base09: "#cb4b16", base0A: "#b58900", base0B: "#859900", base0C: "#2aa198", base0D: "#268bd2", base0E: "#6c71c4", base0F: "#d33682" }, e2.exports = t2.default;
      }, 1091: (e2, t2) => {
        t2.__esModule = true, t2.default = { scheme: "summerfruit", author: "christopher corley (http://cscorley.github.io/)", base00: "#151515", base01: "#202020", base02: "#303030", base03: "#505050", base04: "#B0B0B0", base05: "#D0D0D0", base06: "#E0E0E0", base07: "#FFFFFF", base08: "#FF0086", base09: "#FD8900", base0A: "#ABA800", base0B: "#00C918", base0C: "#1faaaa", base0D: "#3777E6", base0E: "#AD00A1", base0F: "#cc6633" }, e2.exports = t2.default;
      }, 1308: (e2, t2) => {
        t2.__esModule = true, t2.default = { scheme: "threezerotwofour", author: "jan t. sott (http://github.com/idleberg)", base00: "#090300", base01: "#3a3432", base02: "#4a4543", base03: "#5c5855", base04: "#807d7c", base05: "#a5a2a2", base06: "#d6d5d4", base07: "#f7f7f7", base08: "#db2d20", base09: "#e8bbd0", base0A: "#fded02", base0B: "#01a252", base0C: "#b5e4f4", base0D: "#01a0e4", base0E: "#a16a94", base0F: "#cdab53" }, e2.exports = t2.default;
      }, 6943: (e2, t2) => {
        t2.__esModule = true, t2.default = { scheme: "tomorrow", author: "chris kempson (http://chriskempson.com)", base00: "#1d1f21", base01: "#282a2e", base02: "#373b41", base03: "#969896", base04: "#b4b7b4", base05: "#c5c8c6", base06: "#e0e0e0", base07: "#ffffff", base08: "#cc6666", base09: "#de935f", base0A: "#f0c674", base0B: "#b5bd68", base0C: "#8abeb7", base0D: "#81a2be", base0E: "#b294bb", base0F: "#a3685a" }, e2.exports = t2.default;
      }, 5670: (e2, t2) => {
        t2.__esModule = true, t2.default = { scheme: "london tube", author: "jan t. sott", base00: "#231f20", base01: "#1c3f95", base02: "#5a5758", base03: "#737171", base04: "#959ca1", base05: "#d9d8d8", base06: "#e7e7e8", base07: "#ffffff", base08: "#ee2e24", base09: "#f386a1", base0A: "#ffd204", base0B: "#00853e", base0C: "#85cebc", base0D: "#009ddc", base0E: "#98005d", base0F: "#b06110" }, e2.exports = t2.default;
      }, 2536: (e2, t2) => {
        t2.__esModule = true, t2.default = { scheme: "twilight", author: "david hart (http://hart-dev.com)", base00: "#1e1e1e", base01: "#323537", base02: "#464b50", base03: "#5f5a60", base04: "#838184", base05: "#a7a7a7", base06: "#c3c3c3", base07: "#ffffff", base08: "#cf6a4c", base09: "#cda869", base0A: "#f9ee98", base0B: "#8f9d6a", base0C: "#afc4db", base0D: "#7587a6", base0E: "#9b859d", base0F: "#9b703f" }, e2.exports = t2.default;
      }, 6481: (e2, t2, a2) => {
        var r2 = a2(4176), n2 = {};
        for (var o in r2) r2.hasOwnProperty(o) && (n2[r2[o]] = o);
        var s = e2.exports = { rgb: { channels: 3, labels: "rgb" }, hsl: { channels: 3, labels: "hsl" }, hsv: { channels: 3, labels: "hsv" }, hwb: { channels: 3, labels: "hwb" }, cmyk: { channels: 4, labels: "cmyk" }, xyz: { channels: 3, labels: "xyz" }, lab: { channels: 3, labels: "lab" }, lch: { channels: 3, labels: "lch" }, hex: { channels: 1, labels: ["hex"] }, keyword: { channels: 1, labels: ["keyword"] }, ansi16: { channels: 1, labels: ["ansi16"] }, ansi256: { channels: 1, labels: ["ansi256"] }, hcg: { channels: 3, labels: ["h", "c", "g"] }, apple: { channels: 3, labels: ["r16", "g16", "b16"] }, gray: { channels: 1, labels: ["gray"] } };
        for (var i in s) if (s.hasOwnProperty(i)) {
          if (!("channels" in s[i])) throw new Error("missing channels property: " + i);
          if (!("labels" in s[i])) throw new Error("missing channel labels property: " + i);
          if (s[i].labels.length !== s[i].channels) throw new Error("channel and label counts mismatch: " + i);
          var l = s[i].channels, c = s[i].labels;
          delete s[i].channels, delete s[i].labels, Object.defineProperty(s[i], "channels", { value: l }), Object.defineProperty(s[i], "labels", { value: c });
        }
        s.rgb.hsl = function(e3) {
          var t3, a3, r3 = e3[0] / 255, n3 = e3[1] / 255, o2 = e3[2] / 255, s2 = Math.min(r3, n3, o2), i2 = Math.max(r3, n3, o2), l2 = i2 - s2;
          return i2 === s2 ? t3 = 0 : r3 === i2 ? t3 = (n3 - o2) / l2 : n3 === i2 ? t3 = 2 + (o2 - r3) / l2 : o2 === i2 && (t3 = 4 + (r3 - n3) / l2), (t3 = Math.min(60 * t3, 360)) < 0 && (t3 += 360), a3 = (s2 + i2) / 2, [t3, 100 * (i2 === s2 ? 0 : a3 <= 0.5 ? l2 / (i2 + s2) : l2 / (2 - i2 - s2)), 100 * a3];
        }, s.rgb.hsv = function(e3) {
          var t3, a3, r3, n3, o2, s2 = e3[0] / 255, i2 = e3[1] / 255, l2 = e3[2] / 255, c2 = Math.max(s2, i2, l2), u = c2 - Math.min(s2, i2, l2), d = function(e4) {
            return (c2 - e4) / 6 / u + 0.5;
          };
          return 0 === u ? n3 = o2 = 0 : (o2 = u / c2, t3 = d(s2), a3 = d(i2), r3 = d(l2), s2 === c2 ? n3 = r3 - a3 : i2 === c2 ? n3 = 1 / 3 + t3 - r3 : l2 === c2 && (n3 = 2 / 3 + a3 - t3), n3 < 0 ? n3 += 1 : n3 > 1 && (n3 -= 1)), [360 * n3, 100 * o2, 100 * c2];
        }, s.rgb.hwb = function(e3) {
          var t3 = e3[0], a3 = e3[1], r3 = e3[2];
          return [s.rgb.hsl(e3)[0], 100 * (1 / 255 * Math.min(t3, Math.min(a3, r3))), 100 * (r3 = 1 - 1 / 255 * Math.max(t3, Math.max(a3, r3)))];
        }, s.rgb.cmyk = function(e3) {
          var t3, a3 = e3[0] / 255, r3 = e3[1] / 255, n3 = e3[2] / 255;
          return [100 * ((1 - a3 - (t3 = Math.min(1 - a3, 1 - r3, 1 - n3))) / (1 - t3) || 0), 100 * ((1 - r3 - t3) / (1 - t3) || 0), 100 * ((1 - n3 - t3) / (1 - t3) || 0), 100 * t3];
        }, s.rgb.keyword = function(e3) {
          var t3 = n2[e3];
          if (t3) return t3;
          var a3, o2, s2, i2 = 1 / 0;
          for (var l2 in r2) if (r2.hasOwnProperty(l2)) {
            var c2 = r2[l2], u = (o2 = e3, s2 = c2, Math.pow(o2[0] - s2[0], 2) + Math.pow(o2[1] - s2[1], 2) + Math.pow(o2[2] - s2[2], 2));
            u < i2 && (i2 = u, a3 = l2);
          }
          return a3;
        }, s.keyword.rgb = function(e3) {
          return r2[e3];
        }, s.rgb.xyz = function(e3) {
          var t3 = e3[0] / 255, a3 = e3[1] / 255, r3 = e3[2] / 255;
          return [100 * (0.4124 * (t3 = t3 > 0.04045 ? Math.pow((t3 + 0.055) / 1.055, 2.4) : t3 / 12.92) + 0.3576 * (a3 = a3 > 0.04045 ? Math.pow((a3 + 0.055) / 1.055, 2.4) : a3 / 12.92) + 0.1805 * (r3 = r3 > 0.04045 ? Math.pow((r3 + 0.055) / 1.055, 2.4) : r3 / 12.92)), 100 * (0.2126 * t3 + 0.7152 * a3 + 0.0722 * r3), 100 * (0.0193 * t3 + 0.1192 * a3 + 0.9505 * r3)];
        }, s.rgb.lab = function(e3) {
          var t3 = s.rgb.xyz(e3), a3 = t3[0], r3 = t3[1], n3 = t3[2];
          return r3 /= 100, n3 /= 108.883, a3 = (a3 /= 95.047) > 8856e-6 ? Math.pow(a3, 1 / 3) : 7.787 * a3 + 16 / 116, [116 * (r3 = r3 > 8856e-6 ? Math.pow(r3, 1 / 3) : 7.787 * r3 + 16 / 116) - 16, 500 * (a3 - r3), 200 * (r3 - (n3 = n3 > 8856e-6 ? Math.pow(n3, 1 / 3) : 7.787 * n3 + 16 / 116))];
        }, s.hsl.rgb = function(e3) {
          var t3, a3, r3, n3, o2, s2 = e3[0] / 360, i2 = e3[1] / 100, l2 = e3[2] / 100;
          if (0 === i2) return [o2 = 255 * l2, o2, o2];
          t3 = 2 * l2 - (a3 = l2 < 0.5 ? l2 * (1 + i2) : l2 + i2 - l2 * i2), n3 = [0, 0, 0];
          for (var c2 = 0; c2 < 3; c2++) (r3 = s2 + 1 / 3 * -(c2 - 1)) < 0 && r3++, r3 > 1 && r3--, o2 = 6 * r3 < 1 ? t3 + 6 * (a3 - t3) * r3 : 2 * r3 < 1 ? a3 : 3 * r3 < 2 ? t3 + (a3 - t3) * (2 / 3 - r3) * 6 : t3, n3[c2] = 255 * o2;
          return n3;
        }, s.hsl.hsv = function(e3) {
          var t3 = e3[0], a3 = e3[1] / 100, r3 = e3[2] / 100, n3 = a3, o2 = Math.max(r3, 0.01);
          return a3 *= (r3 *= 2) <= 1 ? r3 : 2 - r3, n3 *= o2 <= 1 ? o2 : 2 - o2, [t3, 100 * (0 === r3 ? 2 * n3 / (o2 + n3) : 2 * a3 / (r3 + a3)), 100 * ((r3 + a3) / 2)];
        }, s.hsv.rgb = function(e3) {
          var t3 = e3[0] / 60, a3 = e3[1] / 100, r3 = e3[2] / 100, n3 = Math.floor(t3) % 6, o2 = t3 - Math.floor(t3), s2 = 255 * r3 * (1 - a3), i2 = 255 * r3 * (1 - a3 * o2), l2 = 255 * r3 * (1 - a3 * (1 - o2));
          switch (r3 *= 255, n3) {
            case 0:
              return [r3, l2, s2];
            case 1:
              return [i2, r3, s2];
            case 2:
              return [s2, r3, l2];
            case 3:
              return [s2, i2, r3];
            case 4:
              return [l2, s2, r3];
            case 5:
              return [r3, s2, i2];
          }
        }, s.hsv.hsl = function(e3) {
          var t3, a3, r3, n3 = e3[0], o2 = e3[1] / 100, s2 = e3[2] / 100, i2 = Math.max(s2, 0.01);
          return r3 = (2 - o2) * s2, a3 = o2 * i2, [n3, 100 * (a3 = (a3 /= (t3 = (2 - o2) * i2) <= 1 ? t3 : 2 - t3) || 0), 100 * (r3 /= 2)];
        }, s.hwb.rgb = function(e3) {
          var t3, a3, r3, n3, o2, s2, i2, l2 = e3[0] / 360, c2 = e3[1] / 100, u = e3[2] / 100, d = c2 + u;
          switch (d > 1 && (c2 /= d, u /= d), r3 = 6 * l2 - (t3 = Math.floor(6 * l2)), 1 & t3 && (r3 = 1 - r3), n3 = c2 + r3 * ((a3 = 1 - u) - c2), t3) {
            default:
            case 6:
            case 0:
              o2 = a3, s2 = n3, i2 = c2;
              break;
            case 1:
              o2 = n3, s2 = a3, i2 = c2;
              break;
            case 2:
              o2 = c2, s2 = a3, i2 = n3;
              break;
            case 3:
              o2 = c2, s2 = n3, i2 = a3;
              break;
            case 4:
              o2 = n3, s2 = c2, i2 = a3;
              break;
            case 5:
              o2 = a3, s2 = c2, i2 = n3;
          }
          return [255 * o2, 255 * s2, 255 * i2];
        }, s.cmyk.rgb = function(e3) {
          var t3 = e3[0] / 100, a3 = e3[1] / 100, r3 = e3[2] / 100, n3 = e3[3] / 100;
          return [255 * (1 - Math.min(1, t3 * (1 - n3) + n3)), 255 * (1 - Math.min(1, a3 * (1 - n3) + n3)), 255 * (1 - Math.min(1, r3 * (1 - n3) + n3))];
        }, s.xyz.rgb = function(e3) {
          var t3, a3, r3, n3 = e3[0] / 100, o2 = e3[1] / 100, s2 = e3[2] / 100;
          return a3 = -0.9689 * n3 + 1.8758 * o2 + 0.0415 * s2, r3 = 0.0557 * n3 + -0.204 * o2 + 1.057 * s2, t3 = (t3 = 3.2406 * n3 + -1.5372 * o2 + -0.4986 * s2) > 31308e-7 ? 1.055 * Math.pow(t3, 1 / 2.4) - 0.055 : 12.92 * t3, a3 = a3 > 31308e-7 ? 1.055 * Math.pow(a3, 1 / 2.4) - 0.055 : 12.92 * a3, r3 = r3 > 31308e-7 ? 1.055 * Math.pow(r3, 1 / 2.4) - 0.055 : 12.92 * r3, [255 * (t3 = Math.min(Math.max(0, t3), 1)), 255 * (a3 = Math.min(Math.max(0, a3), 1)), 255 * (r3 = Math.min(Math.max(0, r3), 1))];
        }, s.xyz.lab = function(e3) {
          var t3 = e3[0], a3 = e3[1], r3 = e3[2];
          return a3 /= 100, r3 /= 108.883, t3 = (t3 /= 95.047) > 8856e-6 ? Math.pow(t3, 1 / 3) : 7.787 * t3 + 16 / 116, [116 * (a3 = a3 > 8856e-6 ? Math.pow(a3, 1 / 3) : 7.787 * a3 + 16 / 116) - 16, 500 * (t3 - a3), 200 * (a3 - (r3 = r3 > 8856e-6 ? Math.pow(r3, 1 / 3) : 7.787 * r3 + 16 / 116))];
        }, s.lab.xyz = function(e3) {
          var t3, a3, r3, n3 = e3[0];
          t3 = e3[1] / 500 + (a3 = (n3 + 16) / 116), r3 = a3 - e3[2] / 200;
          var o2 = Math.pow(a3, 3), s2 = Math.pow(t3, 3), i2 = Math.pow(r3, 3);
          return a3 = o2 > 8856e-6 ? o2 : (a3 - 16 / 116) / 7.787, t3 = s2 > 8856e-6 ? s2 : (t3 - 16 / 116) / 7.787, r3 = i2 > 8856e-6 ? i2 : (r3 - 16 / 116) / 7.787, [t3 *= 95.047, a3 *= 100, r3 *= 108.883];
        }, s.lab.lch = function(e3) {
          var t3, a3 = e3[0], r3 = e3[1], n3 = e3[2];
          return (t3 = 360 * Math.atan2(n3, r3) / 2 / Math.PI) < 0 && (t3 += 360), [a3, Math.sqrt(r3 * r3 + n3 * n3), t3];
        }, s.lch.lab = function(e3) {
          var t3, a3 = e3[0], r3 = e3[1];
          return t3 = e3[2] / 360 * 2 * Math.PI, [a3, r3 * Math.cos(t3), r3 * Math.sin(t3)];
        }, s.rgb.ansi16 = function(e3) {
          var t3 = e3[0], a3 = e3[1], r3 = e3[2], n3 = 1 in arguments ? arguments[1] : s.rgb.hsv(e3)[2];
          if (0 === (n3 = Math.round(n3 / 50))) return 30;
          var o2 = 30 + (Math.round(r3 / 255) << 2 | Math.round(a3 / 255) << 1 | Math.round(t3 / 255));
          return 2 === n3 && (o2 += 60), o2;
        }, s.hsv.ansi16 = function(e3) {
          return s.rgb.ansi16(s.hsv.rgb(e3), e3[2]);
        }, s.rgb.ansi256 = function(e3) {
          var t3 = e3[0], a3 = e3[1], r3 = e3[2];
          return t3 === a3 && a3 === r3 ? t3 < 8 ? 16 : t3 > 248 ? 231 : Math.round((t3 - 8) / 247 * 24) + 232 : 16 + 36 * Math.round(t3 / 255 * 5) + 6 * Math.round(a3 / 255 * 5) + Math.round(r3 / 255 * 5);
        }, s.ansi16.rgb = function(e3) {
          var t3 = e3 % 10;
          if (0 === t3 || 7 === t3) return e3 > 50 && (t3 += 3.5), [t3 = t3 / 10.5 * 255, t3, t3];
          var a3 = 0.5 * (1 + ~~(e3 > 50));
          return [(1 & t3) * a3 * 255, (t3 >> 1 & 1) * a3 * 255, (t3 >> 2 & 1) * a3 * 255];
        }, s.ansi256.rgb = function(e3) {
          if (e3 >= 232) {
            var t3 = 10 * (e3 - 232) + 8;
            return [t3, t3, t3];
          }
          var a3;
          return e3 -= 16, [Math.floor(e3 / 36) / 5 * 255, Math.floor((a3 = e3 % 36) / 6) / 5 * 255, a3 % 6 / 5 * 255];
        }, s.rgb.hex = function(e3) {
          var t3 = (((255 & Math.round(e3[0])) << 16) + ((255 & Math.round(e3[1])) << 8) + (255 & Math.round(e3[2]))).toString(16).toUpperCase();
          return "000000".substring(t3.length) + t3;
        }, s.hex.rgb = function(e3) {
          var t3 = e3.toString(16).match(/[a-f0-9]{6}|[a-f0-9]{3}/i);
          if (!t3) return [0, 0, 0];
          var a3 = t3[0];
          3 === t3[0].length && (a3 = a3.split("").map((function(e4) {
            return e4 + e4;
          })).join(""));
          var r3 = parseInt(a3, 16);
          return [r3 >> 16 & 255, r3 >> 8 & 255, 255 & r3];
        }, s.rgb.hcg = function(e3) {
          var t3, a3 = e3[0] / 255, r3 = e3[1] / 255, n3 = e3[2] / 255, o2 = Math.max(Math.max(a3, r3), n3), s2 = Math.min(Math.min(a3, r3), n3), i2 = o2 - s2;
          return t3 = i2 <= 0 ? 0 : o2 === a3 ? (r3 - n3) / i2 % 6 : o2 === r3 ? 2 + (n3 - a3) / i2 : 4 + (a3 - r3) / i2 + 4, t3 /= 6, [360 * (t3 %= 1), 100 * i2, 100 * (i2 < 1 ? s2 / (1 - i2) : 0)];
        }, s.hsl.hcg = function(e3) {
          var t3 = e3[1] / 100, a3 = e3[2] / 100, r3 = 1, n3 = 0;
          return (r3 = a3 < 0.5 ? 2 * t3 * a3 : 2 * t3 * (1 - a3)) < 1 && (n3 = (a3 - 0.5 * r3) / (1 - r3)), [e3[0], 100 * r3, 100 * n3];
        }, s.hsv.hcg = function(e3) {
          var t3 = e3[1] / 100, a3 = e3[2] / 100, r3 = t3 * a3, n3 = 0;
          return r3 < 1 && (n3 = (a3 - r3) / (1 - r3)), [e3[0], 100 * r3, 100 * n3];
        }, s.hcg.rgb = function(e3) {
          var t3 = e3[0] / 360, a3 = e3[1] / 100, r3 = e3[2] / 100;
          if (0 === a3) return [255 * r3, 255 * r3, 255 * r3];
          var n3, o2 = [0, 0, 0], s2 = t3 % 1 * 6, i2 = s2 % 1, l2 = 1 - i2;
          switch (Math.floor(s2)) {
            case 0:
              o2[0] = 1, o2[1] = i2, o2[2] = 0;
              break;
            case 1:
              o2[0] = l2, o2[1] = 1, o2[2] = 0;
              break;
            case 2:
              o2[0] = 0, o2[1] = 1, o2[2] = i2;
              break;
            case 3:
              o2[0] = 0, o2[1] = l2, o2[2] = 1;
              break;
            case 4:
              o2[0] = i2, o2[1] = 0, o2[2] = 1;
              break;
            default:
              o2[0] = 1, o2[1] = 0, o2[2] = l2;
          }
          return n3 = (1 - a3) * r3, [255 * (a3 * o2[0] + n3), 255 * (a3 * o2[1] + n3), 255 * (a3 * o2[2] + n3)];
        }, s.hcg.hsv = function(e3) {
          var t3 = e3[1] / 100, a3 = t3 + e3[2] / 100 * (1 - t3), r3 = 0;
          return a3 > 0 && (r3 = t3 / a3), [e3[0], 100 * r3, 100 * a3];
        }, s.hcg.hsl = function(e3) {
          var t3 = e3[1] / 100, a3 = e3[2] / 100 * (1 - t3) + 0.5 * t3, r3 = 0;
          return a3 > 0 && a3 < 0.5 ? r3 = t3 / (2 * a3) : a3 >= 0.5 && a3 < 1 && (r3 = t3 / (2 * (1 - a3))), [e3[0], 100 * r3, 100 * a3];
        }, s.hcg.hwb = function(e3) {
          var t3 = e3[1] / 100, a3 = t3 + e3[2] / 100 * (1 - t3);
          return [e3[0], 100 * (a3 - t3), 100 * (1 - a3)];
        }, s.hwb.hcg = function(e3) {
          var t3 = e3[1] / 100, a3 = 1 - e3[2] / 100, r3 = a3 - t3, n3 = 0;
          return r3 < 1 && (n3 = (a3 - r3) / (1 - r3)), [e3[0], 100 * r3, 100 * n3];
        }, s.apple.rgb = function(e3) {
          return [e3[0] / 65535 * 255, e3[1] / 65535 * 255, e3[2] / 65535 * 255];
        }, s.rgb.apple = function(e3) {
          return [e3[0] / 255 * 65535, e3[1] / 255 * 65535, e3[2] / 255 * 65535];
        }, s.gray.rgb = function(e3) {
          return [e3[0] / 100 * 255, e3[0] / 100 * 255, e3[0] / 100 * 255];
        }, s.gray.hsl = s.gray.hsv = function(e3) {
          return [0, 0, e3[0]];
        }, s.gray.hwb = function(e3) {
          return [0, 100, e3[0]];
        }, s.gray.cmyk = function(e3) {
          return [0, 0, 0, e3[0]];
        }, s.gray.lab = function(e3) {
          return [e3[0], 0, 0];
        }, s.gray.hex = function(e3) {
          var t3 = 255 & Math.round(e3[0] / 100 * 255), a3 = ((t3 << 16) + (t3 << 8) + t3).toString(16).toUpperCase();
          return "000000".substring(a3.length) + a3;
        }, s.rgb.gray = function(e3) {
          return [(e3[0] + e3[1] + e3[2]) / 3 / 255 * 100];
        };
      }, 4732: (e2, t2, a2) => {
        var r2 = a2(6481), n2 = a2(1157), o = {};
        Object.keys(r2).forEach((function(e3) {
          o[e3] = {}, Object.defineProperty(o[e3], "channels", { value: r2[e3].channels }), Object.defineProperty(o[e3], "labels", { value: r2[e3].labels });
          var t3 = n2(e3);
          Object.keys(t3).forEach((function(a3) {
            var r3 = t3[a3];
            o[e3][a3] = (function(e4) {
              var t4 = function(t5) {
                if (null == t5) return t5;
                arguments.length > 1 && (t5 = Array.prototype.slice.call(arguments));
                var a4 = e4(t5);
                if ("object" == typeof a4) for (var r4 = a4.length, n3 = 0; n3 < r4; n3++) a4[n3] = Math.round(a4[n3]);
                return a4;
              };
              return "conversion" in e4 && (t4.conversion = e4.conversion), t4;
            })(r3), o[e3][a3].raw = (function(e4) {
              var t4 = function(t5) {
                return null == t5 ? t5 : (arguments.length > 1 && (t5 = Array.prototype.slice.call(arguments)), e4(t5));
              };
              return "conversion" in e4 && (t4.conversion = e4.conversion), t4;
            })(r3);
          }));
        })), e2.exports = o;
      }, 1157: (e2, t2, a2) => {
        var r2 = a2(6481);
        function n2(e3) {
          var t3 = (function() {
            for (var e4 = {}, t4 = Object.keys(r2), a4 = t4.length, n4 = 0; n4 < a4; n4++) e4[t4[n4]] = { distance: -1, parent: null };
            return e4;
          })(), a3 = [e3];
          for (t3[e3].distance = 0; a3.length; ) for (var n3 = a3.pop(), o2 = Object.keys(r2[n3]), s2 = o2.length, i = 0; i < s2; i++) {
            var l = o2[i], c = t3[l];
            -1 === c.distance && (c.distance = t3[n3].distance + 1, c.parent = n3, a3.unshift(l));
          }
          return t3;
        }
        function o(e3, t3) {
          return function(a3) {
            return t3(e3(a3));
          };
        }
        function s(e3, t3) {
          for (var a3 = [t3[e3].parent, e3], n3 = r2[t3[e3].parent][e3], s2 = t3[e3].parent; t3[s2].parent; ) a3.unshift(t3[s2].parent), n3 = o(r2[t3[s2].parent][s2], n3), s2 = t3[s2].parent;
          return n3.conversion = a3, n3;
        }
        e2.exports = function(e3) {
          for (var t3 = n2(e3), a3 = {}, r3 = Object.keys(t3), o2 = r3.length, i = 0; i < o2; i++) {
            var l = r3[i];
            null !== t3[l].parent && (a3[l] = s(l, t3));
          }
          return a3;
        };
      }, 4176: (e2) => {
        e2.exports = { aliceblue: [240, 248, 255], antiquewhite: [250, 235, 215], aqua: [0, 255, 255], aquamarine: [127, 255, 212], azure: [240, 255, 255], beige: [245, 245, 220], bisque: [255, 228, 196], black: [0, 0, 0], blanchedalmond: [255, 235, 205], blue: [0, 0, 255], blueviolet: [138, 43, 226], brown: [165, 42, 42], burlywood: [222, 184, 135], cadetblue: [95, 158, 160], chartreuse: [127, 255, 0], chocolate: [210, 105, 30], coral: [255, 127, 80], cornflowerblue: [100, 149, 237], cornsilk: [255, 248, 220], crimson: [220, 20, 60], cyan: [0, 255, 255], darkblue: [0, 0, 139], darkcyan: [0, 139, 139], darkgoldenrod: [184, 134, 11], darkgray: [169, 169, 169], darkgreen: [0, 100, 0], darkgrey: [169, 169, 169], darkkhaki: [189, 183, 107], darkmagenta: [139, 0, 139], darkolivegreen: [85, 107, 47], darkorange: [255, 140, 0], darkorchid: [153, 50, 204], darkred: [139, 0, 0], darksalmon: [233, 150, 122], darkseagreen: [143, 188, 143], darkslateblue: [72, 61, 139], darkslategray: [47, 79, 79], darkslategrey: [47, 79, 79], darkturquoise: [0, 206, 209], darkviolet: [148, 0, 211], deeppink: [255, 20, 147], deepskyblue: [0, 191, 255], dimgray: [105, 105, 105], dimgrey: [105, 105, 105], dodgerblue: [30, 144, 255], firebrick: [178, 34, 34], floralwhite: [255, 250, 240], forestgreen: [34, 139, 34], fuchsia: [255, 0, 255], gainsboro: [220, 220, 220], ghostwhite: [248, 248, 255], gold: [255, 215, 0], goldenrod: [218, 165, 32], gray: [128, 128, 128], green: [0, 128, 0], greenyellow: [173, 255, 47], grey: [128, 128, 128], honeydew: [240, 255, 240], hotpink: [255, 105, 180], indianred: [205, 92, 92], indigo: [75, 0, 130], ivory: [255, 255, 240], khaki: [240, 230, 140], lavender: [230, 230, 250], lavenderblush: [255, 240, 245], lawngreen: [124, 252, 0], lemonchiffon: [255, 250, 205], lightblue: [173, 216, 230], lightcoral: [240, 128, 128], lightcyan: [224, 255, 255], lightgoldenrodyellow: [250, 250, 210], lightgray: [211, 211, 211], lightgreen: [144, 238, 144], lightgrey: [211, 211, 211], lightpink: [255, 182, 193], lightsalmon: [255, 160, 122], lightseagreen: [32, 178, 170], lightskyblue: [135, 206, 250], lightslategray: [119, 136, 153], lightslategrey: [119, 136, 153], lightsteelblue: [176, 196, 222], lightyellow: [255, 255, 224], lime: [0, 255, 0], limegreen: [50, 205, 50], linen: [250, 240, 230], magenta: [255, 0, 255], maroon: [128, 0, 0], mediumaquamarine: [102, 205, 170], mediumblue: [0, 0, 205], mediumorchid: [186, 85, 211], mediumpurple: [147, 112, 219], mediumseagreen: [60, 179, 113], mediumslateblue: [123, 104, 238], mediumspringgreen: [0, 250, 154], mediumturquoise: [72, 209, 204], mediumvioletred: [199, 21, 133], midnightblue: [25, 25, 112], mintcream: [245, 255, 250], mistyrose: [255, 228, 225], moccasin: [255, 228, 181], navajowhite: [255, 222, 173], navy: [0, 0, 128], oldlace: [253, 245, 230], olive: [128, 128, 0], olivedrab: [107, 142, 35], orange: [255, 165, 0], orangered: [255, 69, 0], orchid: [218, 112, 214], palegoldenrod: [238, 232, 170], palegreen: [152, 251, 152], paleturquoise: [175, 238, 238], palevioletred: [219, 112, 147], papayawhip: [255, 239, 213], peachpuff: [255, 218, 185], peru: [205, 133, 63], pink: [255, 192, 203], plum: [221, 160, 221], powderblue: [176, 224, 230], purple: [128, 0, 128], rebeccapurple: [102, 51, 153], red: [255, 0, 0], rosybrown: [188, 143, 143], royalblue: [65, 105, 225], saddlebrown: [139, 69, 19], salmon: [250, 128, 114], sandybrown: [244, 164, 96], seagreen: [46, 139, 87], seashell: [255, 245, 238], sienna: [160, 82, 45], silver: [192, 192, 192], skyblue: [135, 206, 235], slateblue: [106, 90, 205], slategray: [112, 128, 144], slategrey: [112, 128, 144], snow: [255, 250, 250], springgreen: [0, 255, 127], steelblue: [70, 130, 180], tan: [210, 180, 140], teal: [0, 128, 128], thistle: [216, 191, 216], tomato: [255, 99, 71], turquoise: [64, 224, 208], violet: [238, 130, 238], wheat: [245, 222, 179], white: [255, 255, 255], whitesmoke: [245, 245, 245], yellow: [255, 255, 0], yellowgreen: [154, 205, 50] };
      }, 4877: (e2) => {
        e2.exports = { aliceblue: [240, 248, 255], antiquewhite: [250, 235, 215], aqua: [0, 255, 255], aquamarine: [127, 255, 212], azure: [240, 255, 255], beige: [245, 245, 220], bisque: [255, 228, 196], black: [0, 0, 0], blanchedalmond: [255, 235, 205], blue: [0, 0, 255], blueviolet: [138, 43, 226], brown: [165, 42, 42], burlywood: [222, 184, 135], cadetblue: [95, 158, 160], chartreuse: [127, 255, 0], chocolate: [210, 105, 30], coral: [255, 127, 80], cornflowerblue: [100, 149, 237], cornsilk: [255, 248, 220], crimson: [220, 20, 60], cyan: [0, 255, 255], darkblue: [0, 0, 139], darkcyan: [0, 139, 139], darkgoldenrod: [184, 134, 11], darkgray: [169, 169, 169], darkgreen: [0, 100, 0], darkgrey: [169, 169, 169], darkkhaki: [189, 183, 107], darkmagenta: [139, 0, 139], darkolivegreen: [85, 107, 47], darkorange: [255, 140, 0], darkorchid: [153, 50, 204], darkred: [139, 0, 0], darksalmon: [233, 150, 122], darkseagreen: [143, 188, 143], darkslateblue: [72, 61, 139], darkslategray: [47, 79, 79], darkslategrey: [47, 79, 79], darkturquoise: [0, 206, 209], darkviolet: [148, 0, 211], deeppink: [255, 20, 147], deepskyblue: [0, 191, 255], dimgray: [105, 105, 105], dimgrey: [105, 105, 105], dodgerblue: [30, 144, 255], firebrick: [178, 34, 34], floralwhite: [255, 250, 240], forestgreen: [34, 139, 34], fuchsia: [255, 0, 255], gainsboro: [220, 220, 220], ghostwhite: [248, 248, 255], gold: [255, 215, 0], goldenrod: [218, 165, 32], gray: [128, 128, 128], green: [0, 128, 0], greenyellow: [173, 255, 47], grey: [128, 128, 128], honeydew: [240, 255, 240], hotpink: [255, 105, 180], indianred: [205, 92, 92], indigo: [75, 0, 130], ivory: [255, 255, 240], khaki: [240, 230, 140], lavender: [230, 230, 250], lavenderblush: [255, 240, 245], lawngreen: [124, 252, 0], lemonchiffon: [255, 250, 205], lightblue: [173, 216, 230], lightcoral: [240, 128, 128], lightcyan: [224, 255, 255], lightgoldenrodyellow: [250, 250, 210], lightgray: [211, 211, 211], lightgreen: [144, 238, 144], lightgrey: [211, 211, 211], lightpink: [255, 182, 193], lightsalmon: [255, 160, 122], lightseagreen: [32, 178, 170], lightskyblue: [135, 206, 250], lightslategray: [119, 136, 153], lightslategrey: [119, 136, 153], lightsteelblue: [176, 196, 222], lightyellow: [255, 255, 224], lime: [0, 255, 0], limegreen: [50, 205, 50], linen: [250, 240, 230], magenta: [255, 0, 255], maroon: [128, 0, 0], mediumaquamarine: [102, 205, 170], mediumblue: [0, 0, 205], mediumorchid: [186, 85, 211], mediumpurple: [147, 112, 219], mediumseagreen: [60, 179, 113], mediumslateblue: [123, 104, 238], mediumspringgreen: [0, 250, 154], mediumturquoise: [72, 209, 204], mediumvioletred: [199, 21, 133], midnightblue: [25, 25, 112], mintcream: [245, 255, 250], mistyrose: [255, 228, 225], moccasin: [255, 228, 181], navajowhite: [255, 222, 173], navy: [0, 0, 128], oldlace: [253, 245, 230], olive: [128, 128, 0], olivedrab: [107, 142, 35], orange: [255, 165, 0], orangered: [255, 69, 0], orchid: [218, 112, 214], palegoldenrod: [238, 232, 170], palegreen: [152, 251, 152], paleturquoise: [175, 238, 238], palevioletred: [219, 112, 147], papayawhip: [255, 239, 213], peachpuff: [255, 218, 185], peru: [205, 133, 63], pink: [255, 192, 203], plum: [221, 160, 221], powderblue: [176, 224, 230], purple: [128, 0, 128], rebeccapurple: [102, 51, 153], red: [255, 0, 0], rosybrown: [188, 143, 143], royalblue: [65, 105, 225], saddlebrown: [139, 69, 19], salmon: [250, 128, 114], sandybrown: [244, 164, 96], seagreen: [46, 139, 87], seashell: [255, 245, 238], sienna: [160, 82, 45], silver: [192, 192, 192], skyblue: [135, 206, 235], slateblue: [106, 90, 205], slategray: [112, 128, 144], slategrey: [112, 128, 144], snow: [255, 250, 250], springgreen: [0, 255, 127], steelblue: [70, 130, 180], tan: [210, 180, 140], teal: [0, 128, 128], thistle: [216, 191, 216], tomato: [255, 99, 71], turquoise: [64, 224, 208], violet: [238, 130, 238], wheat: [245, 222, 179], white: [255, 255, 255], whitesmoke: [245, 245, 245], yellow: [255, 255, 0], yellowgreen: [154, 205, 50] };
      }, 6138: (e2, t2, a2) => {
        var r2 = a2(4877), n2 = a2(301), o = Object.hasOwnProperty, s = /* @__PURE__ */ Object.create(null);
        for (var i in r2) o.call(r2, i) && (s[r2[i]] = i);
        var l = e2.exports = { to: {}, get: {} };
        function c(e3, t3, a3) {
          return Math.min(Math.max(t3, e3), a3);
        }
        function u(e3) {
          var t3 = Math.round(e3).toString(16).toUpperCase();
          return t3.length < 2 ? "0" + t3 : t3;
        }
        l.get = function(e3) {
          var t3, a3;
          switch (e3.substring(0, 3).toLowerCase()) {
            case "hsl":
              t3 = l.get.hsl(e3), a3 = "hsl";
              break;
            case "hwb":
              t3 = l.get.hwb(e3), a3 = "hwb";
              break;
            default:
              t3 = l.get.rgb(e3), a3 = "rgb";
          }
          return t3 ? { model: a3, value: t3 } : null;
        }, l.get.rgb = function(e3) {
          if (!e3) return null;
          var t3, a3, n3, s2 = [0, 0, 0, 1];
          if (t3 = e3.match(/^#([a-f0-9]{6})([a-f0-9]{2})?$/i)) {
            for (n3 = t3[2], t3 = t3[1], a3 = 0; a3 < 3; a3++) {
              var i2 = 2 * a3;
              s2[a3] = parseInt(t3.slice(i2, i2 + 2), 16);
            }
            n3 && (s2[3] = parseInt(n3, 16) / 255);
          } else if (t3 = e3.match(/^#([a-f0-9]{3,4})$/i)) {
            for (n3 = (t3 = t3[1])[3], a3 = 0; a3 < 3; a3++) s2[a3] = parseInt(t3[a3] + t3[a3], 16);
            n3 && (s2[3] = parseInt(n3 + n3, 16) / 255);
          } else if (t3 = e3.match(/^rgba?\(\s*([+-]?\d+)(?=[\s,])\s*(?:,\s*)?([+-]?\d+)(?=[\s,])\s*(?:,\s*)?([+-]?\d+)\s*(?:[,|\/]\s*([+-]?[\d\.]+)(%?)\s*)?\)$/)) {
            for (a3 = 0; a3 < 3; a3++) s2[a3] = parseInt(t3[a3 + 1], 0);
            t3[4] && (t3[5] ? s2[3] = 0.01 * parseFloat(t3[4]) : s2[3] = parseFloat(t3[4]));
          } else {
            if (!(t3 = e3.match(/^rgba?\(\s*([+-]?[\d\.]+)\%\s*,?\s*([+-]?[\d\.]+)\%\s*,?\s*([+-]?[\d\.]+)\%\s*(?:[,|\/]\s*([+-]?[\d\.]+)(%?)\s*)?\)$/))) return (t3 = e3.match(/^(\w+)$/)) ? "transparent" === t3[1] ? [0, 0, 0, 0] : o.call(r2, t3[1]) ? ((s2 = r2[t3[1]])[3] = 1, s2) : null : null;
            for (a3 = 0; a3 < 3; a3++) s2[a3] = Math.round(2.55 * parseFloat(t3[a3 + 1]));
            t3[4] && (t3[5] ? s2[3] = 0.01 * parseFloat(t3[4]) : s2[3] = parseFloat(t3[4]));
          }
          for (a3 = 0; a3 < 3; a3++) s2[a3] = c(s2[a3], 0, 255);
          return s2[3] = c(s2[3], 0, 1), s2;
        }, l.get.hsl = function(e3) {
          if (!e3) return null;
          var t3 = e3.match(/^hsla?\(\s*([+-]?(?:\d{0,3}\.)?\d+)(?:deg)?\s*,?\s*([+-]?[\d\.]+)%\s*,?\s*([+-]?[\d\.]+)%\s*(?:[,|\/]\s*([+-]?(?=\.\d|\d)(?:0|[1-9]\d*)?(?:\.\d*)?(?:[eE][+-]?\d+)?)\s*)?\)$/);
          if (t3) {
            var a3 = parseFloat(t3[4]);
            return [(parseFloat(t3[1]) % 360 + 360) % 360, c(parseFloat(t3[2]), 0, 100), c(parseFloat(t3[3]), 0, 100), c(isNaN(a3) ? 1 : a3, 0, 1)];
          }
          return null;
        }, l.get.hwb = function(e3) {
          if (!e3) return null;
          var t3 = e3.match(/^hwb\(\s*([+-]?\d{0,3}(?:\.\d+)?)(?:deg)?\s*,\s*([+-]?[\d\.]+)%\s*,\s*([+-]?[\d\.]+)%\s*(?:,\s*([+-]?(?=\.\d|\d)(?:0|[1-9]\d*)?(?:\.\d*)?(?:[eE][+-]?\d+)?)\s*)?\)$/);
          if (t3) {
            var a3 = parseFloat(t3[4]);
            return [(parseFloat(t3[1]) % 360 + 360) % 360, c(parseFloat(t3[2]), 0, 100), c(parseFloat(t3[3]), 0, 100), c(isNaN(a3) ? 1 : a3, 0, 1)];
          }
          return null;
        }, l.to.hex = function() {
          var e3 = n2(arguments);
          return "#" + u(e3[0]) + u(e3[1]) + u(e3[2]) + (e3[3] < 1 ? u(Math.round(255 * e3[3])) : "");
        }, l.to.rgb = function() {
          var e3 = n2(arguments);
          return e3.length < 4 || 1 === e3[3] ? "rgb(" + Math.round(e3[0]) + ", " + Math.round(e3[1]) + ", " + Math.round(e3[2]) + ")" : "rgba(" + Math.round(e3[0]) + ", " + Math.round(e3[1]) + ", " + Math.round(e3[2]) + ", " + e3[3] + ")";
        }, l.to.rgb.percent = function() {
          var e3 = n2(arguments), t3 = Math.round(e3[0] / 255 * 100), a3 = Math.round(e3[1] / 255 * 100), r3 = Math.round(e3[2] / 255 * 100);
          return e3.length < 4 || 1 === e3[3] ? "rgb(" + t3 + "%, " + a3 + "%, " + r3 + "%)" : "rgba(" + t3 + "%, " + a3 + "%, " + r3 + "%, " + e3[3] + ")";
        }, l.to.hsl = function() {
          var e3 = n2(arguments);
          return e3.length < 4 || 1 === e3[3] ? "hsl(" + e3[0] + ", " + e3[1] + "%, " + e3[2] + "%)" : "hsla(" + e3[0] + ", " + e3[1] + "%, " + e3[2] + "%, " + e3[3] + ")";
        }, l.to.hwb = function() {
          var e3 = n2(arguments), t3 = "";
          return e3.length >= 4 && 1 !== e3[3] && (t3 = ", " + e3[3]), "hwb(" + e3[0] + ", " + e3[1] + "%, " + e3[2] + "%" + t3 + ")";
        }, l.to.keyword = function(e3) {
          return s[e3.slice(0, 3)];
        };
      }, 3639: (e2, t2, a2) => {
        var r2 = a2(6138), n2 = a2(4732), o = [].slice, s = ["keyword", "gray", "hex"], i = {};
        Object.keys(n2).forEach((function(e3) {
          i[o.call(n2[e3].labels).sort().join("")] = e3;
        }));
        var l = {};
        function c(e3, t3) {
          if (!(this instanceof c)) return new c(e3, t3);
          if (t3 && t3 in s && (t3 = null), t3 && !(t3 in n2)) throw new Error("Unknown model: " + t3);
          var a3, u2;
          if (null == e3) this.model = "rgb", this.color = [0, 0, 0], this.valpha = 1;
          else if (e3 instanceof c) this.model = e3.model, this.color = e3.color.slice(), this.valpha = e3.valpha;
          else if ("string" == typeof e3) {
            var d2 = r2.get(e3);
            if (null === d2) throw new Error("Unable to parse color from string: " + e3);
            this.model = d2.model, u2 = n2[this.model].channels, this.color = d2.value.slice(0, u2), this.valpha = "number" == typeof d2.value[u2] ? d2.value[u2] : 1;
          } else if (e3.length) {
            this.model = t3 || "rgb", u2 = n2[this.model].channels;
            var p = o.call(e3, 0, u2);
            this.color = b(p, u2), this.valpha = "number" == typeof e3[u2] ? e3[u2] : 1;
          } else if ("number" == typeof e3) e3 &= 16777215, this.model = "rgb", this.color = [e3 >> 16 & 255, e3 >> 8 & 255, 255 & e3], this.valpha = 1;
          else {
            this.valpha = 1;
            var f = Object.keys(e3);
            "alpha" in e3 && (f.splice(f.indexOf("alpha"), 1), this.valpha = "number" == typeof e3.alpha ? e3.alpha : 0);
            var h = f.sort().join("");
            if (!(h in i)) throw new Error("Unable to parse color from object: " + JSON.stringify(e3));
            this.model = i[h];
            var m = n2[this.model].labels, v = [];
            for (a3 = 0; a3 < m.length; a3++) v.push(e3[m[a3]]);
            this.color = b(v);
          }
          if (l[this.model]) for (u2 = n2[this.model].channels, a3 = 0; a3 < u2; a3++) {
            var g = l[this.model][a3];
            g && (this.color[a3] = g(this.color[a3]));
          }
          this.valpha = Math.max(0, Math.min(1, this.valpha)), Object.freeze && Object.freeze(this);
        }
        function u(e3, t3, a3) {
          return (e3 = Array.isArray(e3) ? e3 : [e3]).forEach((function(e4) {
            (l[e4] || (l[e4] = []))[t3] = a3;
          })), e3 = e3[0], function(r3) {
            var n3;
            return arguments.length ? (a3 && (r3 = a3(r3)), (n3 = this[e3]()).color[t3] = r3, n3) : (n3 = this[e3]().color[t3], a3 && (n3 = a3(n3)), n3);
          };
        }
        function d(e3) {
          return function(t3) {
            return Math.max(0, Math.min(e3, t3));
          };
        }
        function b(e3, t3) {
          for (var a3 = 0; a3 < t3; a3++) "number" != typeof e3[a3] && (e3[a3] = 0);
          return e3;
        }
        c.prototype = { toString: function() {
          return this.string();
        }, toJSON: function() {
          return this[this.model]();
        }, string: function(e3) {
          var t3 = this.model in r2.to ? this : this.rgb(), a3 = 1 === (t3 = t3.round("number" == typeof e3 ? e3 : 1)).valpha ? t3.color : t3.color.concat(this.valpha);
          return r2.to[t3.model](a3);
        }, percentString: function(e3) {
          var t3 = this.rgb().round("number" == typeof e3 ? e3 : 1), a3 = 1 === t3.valpha ? t3.color : t3.color.concat(this.valpha);
          return r2.to.rgb.percent(a3);
        }, array: function() {
          return 1 === this.valpha ? this.color.slice() : this.color.concat(this.valpha);
        }, object: function() {
          for (var e3 = {}, t3 = n2[this.model].channels, a3 = n2[this.model].labels, r3 = 0; r3 < t3; r3++) e3[a3[r3]] = this.color[r3];
          return 1 !== this.valpha && (e3.alpha = this.valpha), e3;
        }, unitArray: function() {
          var e3 = this.rgb().color;
          return e3[0] /= 255, e3[1] /= 255, e3[2] /= 255, 1 !== this.valpha && e3.push(this.valpha), e3;
        }, unitObject: function() {
          var e3 = this.rgb().object();
          return e3.r /= 255, e3.g /= 255, e3.b /= 255, 1 !== this.valpha && (e3.alpha = this.valpha), e3;
        }, round: function(e3) {
          return e3 = Math.max(e3 || 0, 0), new c(this.color.map(/* @__PURE__ */ (function(e4) {
            return function(t3) {
              return (function(e5, t4) {
                return Number(e5.toFixed(t4));
              })(t3, e4);
            };
          })(e3)).concat(this.valpha), this.model);
        }, alpha: function(e3) {
          return arguments.length ? new c(this.color.concat(Math.max(0, Math.min(1, e3))), this.model) : this.valpha;
        }, red: u("rgb", 0, d(255)), green: u("rgb", 1, d(255)), blue: u("rgb", 2, d(255)), hue: u(["hsl", "hsv", "hsl", "hwb", "hcg"], 0, (function(e3) {
          return (e3 % 360 + 360) % 360;
        })), saturationl: u("hsl", 1, d(100)), lightness: u("hsl", 2, d(100)), saturationv: u("hsv", 1, d(100)), value: u("hsv", 2, d(100)), chroma: u("hcg", 1, d(100)), gray: u("hcg", 2, d(100)), white: u("hwb", 1, d(100)), wblack: u("hwb", 2, d(100)), cyan: u("cmyk", 0, d(100)), magenta: u("cmyk", 1, d(100)), yellow: u("cmyk", 2, d(100)), black: u("cmyk", 3, d(100)), x: u("xyz", 0, d(100)), y: u("xyz", 1, d(100)), z: u("xyz", 2, d(100)), l: u("lab", 0, d(100)), a: u("lab", 1), b: u("lab", 2), keyword: function(e3) {
          return arguments.length ? new c(e3) : n2[this.model].keyword(this.color);
        }, hex: function(e3) {
          return arguments.length ? new c(e3) : r2.to.hex(this.rgb().round().color);
        }, rgbNumber: function() {
          var e3 = this.rgb().color;
          return (255 & e3[0]) << 16 | (255 & e3[1]) << 8 | 255 & e3[2];
        }, luminosity: function() {
          for (var e3 = this.rgb().color, t3 = [], a3 = 0; a3 < e3.length; a3++) {
            var r3 = e3[a3] / 255;
            t3[a3] = r3 <= 0.03928 ? r3 / 12.92 : Math.pow((r3 + 0.055) / 1.055, 2.4);
          }
          return 0.2126 * t3[0] + 0.7152 * t3[1] + 0.0722 * t3[2];
        }, contrast: function(e3) {
          var t3 = this.luminosity(), a3 = e3.luminosity();
          return t3 > a3 ? (t3 + 0.05) / (a3 + 0.05) : (a3 + 0.05) / (t3 + 0.05);
        }, level: function(e3) {
          var t3 = this.contrast(e3);
          return t3 >= 7.1 ? "AAA" : t3 >= 4.5 ? "AA" : "";
        }, isDark: function() {
          var e3 = this.rgb().color;
          return (299 * e3[0] + 587 * e3[1] + 114 * e3[2]) / 1e3 < 128;
        }, isLight: function() {
          return !this.isDark();
        }, negate: function() {
          for (var e3 = this.rgb(), t3 = 0; t3 < 3; t3++) e3.color[t3] = 255 - e3.color[t3];
          return e3;
        }, lighten: function(e3) {
          var t3 = this.hsl();
          return t3.color[2] += t3.color[2] * e3, t3;
        }, darken: function(e3) {
          var t3 = this.hsl();
          return t3.color[2] -= t3.color[2] * e3, t3;
        }, saturate: function(e3) {
          var t3 = this.hsl();
          return t3.color[1] += t3.color[1] * e3, t3;
        }, desaturate: function(e3) {
          var t3 = this.hsl();
          return t3.color[1] -= t3.color[1] * e3, t3;
        }, whiten: function(e3) {
          var t3 = this.hwb();
          return t3.color[1] += t3.color[1] * e3, t3;
        }, blacken: function(e3) {
          var t3 = this.hwb();
          return t3.color[2] += t3.color[2] * e3, t3;
        }, grayscale: function() {
          var e3 = this.rgb().color, t3 = 0.3 * e3[0] + 0.59 * e3[1] + 0.11 * e3[2];
          return c.rgb(t3, t3, t3);
        }, fade: function(e3) {
          return this.alpha(this.valpha - this.valpha * e3);
        }, opaquer: function(e3) {
          return this.alpha(this.valpha + this.valpha * e3);
        }, rotate: function(e3) {
          var t3 = this.hsl(), a3 = t3.color[0];
          return a3 = (a3 = (a3 + e3) % 360) < 0 ? 360 + a3 : a3, t3.color[0] = a3, t3;
        }, mix: function(e3, t3) {
          if (!e3 || !e3.rgb) throw new Error('Argument to "mix" was not a Color instance, but rather an instance of ' + typeof e3);
          var a3 = e3.rgb(), r3 = this.rgb(), n3 = void 0 === t3 ? 0.5 : t3, o2 = 2 * n3 - 1, s2 = a3.alpha() - r3.alpha(), i2 = ((o2 * s2 == -1 ? o2 : (o2 + s2) / (1 + o2 * s2)) + 1) / 2, l2 = 1 - i2;
          return c.rgb(i2 * a3.red() + l2 * r3.red(), i2 * a3.green() + l2 * r3.green(), i2 * a3.blue() + l2 * r3.blue(), a3.alpha() * n3 + r3.alpha() * (1 - n3));
        } }, Object.keys(n2).forEach((function(e3) {
          if (-1 === s.indexOf(e3)) {
            var t3 = n2[e3].channels;
            c.prototype[e3] = function() {
              if (this.model === e3) return new c(this);
              if (arguments.length) return new c(arguments, e3);
              var a3, r3 = "number" == typeof arguments[t3] ? t3 : this.valpha;
              return new c((a3 = n2[this.model][e3].raw(this.color), Array.isArray(a3) ? a3 : [a3]).concat(r3), e3);
            }, c[e3] = function(a3) {
              return "number" == typeof a3 && (a3 = b(o.call(arguments), t3)), new c(a3, e3);
            };
          }
        })), e2.exports = c;
      }, 9784: (e2) => {
        var t2, a2 = "object" == typeof Reflect ? Reflect : null, r2 = a2 && "function" == typeof a2.apply ? a2.apply : function(e3, t3, a3) {
          return Function.prototype.apply.call(e3, t3, a3);
        };
        t2 = a2 && "function" == typeof a2.ownKeys ? a2.ownKeys : Object.getOwnPropertySymbols ? function(e3) {
          return Object.getOwnPropertyNames(e3).concat(Object.getOwnPropertySymbols(e3));
        } : function(e3) {
          return Object.getOwnPropertyNames(e3);
        };
        var n2 = Number.isNaN || function(e3) {
          return e3 != e3;
        };
        function o() {
          o.init.call(this);
        }
        e2.exports = o, e2.exports.once = function(e3, t3) {
          return new Promise((function(a3, r3) {
            function n3(a4) {
              e3.removeListener(t3, o2), r3(a4);
            }
            function o2() {
              "function" == typeof e3.removeListener && e3.removeListener("error", n3), a3([].slice.call(arguments));
            }
            h(e3, t3, o2, { once: true }), "error" !== t3 && (function(e4, t4, a4) {
              "function" == typeof e4.on && h(e4, "error", t4, a4);
            })(e3, n3, { once: true });
          }));
        }, o.EventEmitter = o, o.prototype._events = void 0, o.prototype._eventsCount = 0, o.prototype._maxListeners = void 0;
        var s = 10;
        function i(e3) {
          if ("function" != typeof e3) throw new TypeError('The "listener" argument must be of type Function. Received type ' + typeof e3);
        }
        function l(e3) {
          return void 0 === e3._maxListeners ? o.defaultMaxListeners : e3._maxListeners;
        }
        function c(e3, t3, a3, r3) {
          var n3, o2, s2, c2;
          if (i(a3), void 0 === (o2 = e3._events) ? (o2 = e3._events = /* @__PURE__ */ Object.create(null), e3._eventsCount = 0) : (void 0 !== o2.newListener && (e3.emit("newListener", t3, a3.listener ? a3.listener : a3), o2 = e3._events), s2 = o2[t3]), void 0 === s2) s2 = o2[t3] = a3, ++e3._eventsCount;
          else if ("function" == typeof s2 ? s2 = o2[t3] = r3 ? [a3, s2] : [s2, a3] : r3 ? s2.unshift(a3) : s2.push(a3), (n3 = l(e3)) > 0 && s2.length > n3 && !s2.warned) {
            s2.warned = true;
            var u2 = new Error("Possible EventEmitter memory leak detected. " + s2.length + " " + String(t3) + " listeners added. Use emitter.setMaxListeners() to increase limit");
            u2.name = "MaxListenersExceededWarning", u2.emitter = e3, u2.type = t3, u2.count = s2.length, c2 = u2, console && console.warn && console.warn(c2);
          }
          return e3;
        }
        function u() {
          if (!this.fired) return this.target.removeListener(this.type, this.wrapFn), this.fired = true, 0 === arguments.length ? this.listener.call(this.target) : this.listener.apply(this.target, arguments);
        }
        function d(e3, t3, a3) {
          var r3 = { fired: false, wrapFn: void 0, target: e3, type: t3, listener: a3 }, n3 = u.bind(r3);
          return n3.listener = a3, r3.wrapFn = n3, n3;
        }
        function b(e3, t3, a3) {
          var r3 = e3._events;
          if (void 0 === r3) return [];
          var n3 = r3[t3];
          return void 0 === n3 ? [] : "function" == typeof n3 ? a3 ? [n3.listener || n3] : [n3] : a3 ? (function(e4) {
            for (var t4 = new Array(e4.length), a4 = 0; a4 < t4.length; ++a4) t4[a4] = e4[a4].listener || e4[a4];
            return t4;
          })(n3) : f(n3, n3.length);
        }
        function p(e3) {
          var t3 = this._events;
          if (void 0 !== t3) {
            var a3 = t3[e3];
            if ("function" == typeof a3) return 1;
            if (void 0 !== a3) return a3.length;
          }
          return 0;
        }
        function f(e3, t3) {
          for (var a3 = new Array(t3), r3 = 0; r3 < t3; ++r3) a3[r3] = e3[r3];
          return a3;
        }
        function h(e3, t3, a3, r3) {
          if ("function" == typeof e3.on) r3.once ? e3.once(t3, a3) : e3.on(t3, a3);
          else {
            if ("function" != typeof e3.addEventListener) throw new TypeError('The "emitter" argument must be of type EventEmitter. Received type ' + typeof e3);
            e3.addEventListener(t3, (function n3(o2) {
              r3.once && e3.removeEventListener(t3, n3), a3(o2);
            }));
          }
        }
        Object.defineProperty(o, "defaultMaxListeners", { enumerable: true, get: function() {
          return s;
        }, set: function(e3) {
          if ("number" != typeof e3 || e3 < 0 || n2(e3)) throw new RangeError('The value of "defaultMaxListeners" is out of range. It must be a non-negative number. Received ' + e3 + ".");
          s = e3;
        } }), o.init = function() {
          void 0 !== this._events && this._events !== Object.getPrototypeOf(this)._events || (this._events = /* @__PURE__ */ Object.create(null), this._eventsCount = 0), this._maxListeners = this._maxListeners || void 0;
        }, o.prototype.setMaxListeners = function(e3) {
          if ("number" != typeof e3 || e3 < 0 || n2(e3)) throw new RangeError('The value of "n" is out of range. It must be a non-negative number. Received ' + e3 + ".");
          return this._maxListeners = e3, this;
        }, o.prototype.getMaxListeners = function() {
          return l(this);
        }, o.prototype.emit = function(e3) {
          for (var t3 = [], a3 = 1; a3 < arguments.length; a3++) t3.push(arguments[a3]);
          var n3 = "error" === e3, o2 = this._events;
          if (void 0 !== o2) n3 = n3 && void 0 === o2.error;
          else if (!n3) return false;
          if (n3) {
            var s2;
            if (t3.length > 0 && (s2 = t3[0]), s2 instanceof Error) throw s2;
            var i2 = new Error("Unhandled error." + (s2 ? " (" + s2.message + ")" : ""));
            throw i2.context = s2, i2;
          }
          var l2 = o2[e3];
          if (void 0 === l2) return false;
          if ("function" == typeof l2) r2(l2, this, t3);
          else {
            var c2 = l2.length, u2 = f(l2, c2);
            for (a3 = 0; a3 < c2; ++a3) r2(u2[a3], this, t3);
          }
          return true;
        }, o.prototype.addListener = function(e3, t3) {
          return c(this, e3, t3, false);
        }, o.prototype.on = o.prototype.addListener, o.prototype.prependListener = function(e3, t3) {
          return c(this, e3, t3, true);
        }, o.prototype.once = function(e3, t3) {
          return i(t3), this.on(e3, d(this, e3, t3)), this;
        }, o.prototype.prependOnceListener = function(e3, t3) {
          return i(t3), this.prependListener(e3, d(this, e3, t3)), this;
        }, o.prototype.removeListener = function(e3, t3) {
          var a3, r3, n3, o2, s2;
          if (i(t3), void 0 === (r3 = this._events)) return this;
          if (void 0 === (a3 = r3[e3])) return this;
          if (a3 === t3 || a3.listener === t3) 0 == --this._eventsCount ? this._events = /* @__PURE__ */ Object.create(null) : (delete r3[e3], r3.removeListener && this.emit("removeListener", e3, a3.listener || t3));
          else if ("function" != typeof a3) {
            for (n3 = -1, o2 = a3.length - 1; o2 >= 0; o2--) if (a3[o2] === t3 || a3[o2].listener === t3) {
              s2 = a3[o2].listener, n3 = o2;
              break;
            }
            if (n3 < 0) return this;
            0 === n3 ? a3.shift() : (function(e4, t4) {
              for (; t4 + 1 < e4.length; t4++) e4[t4] = e4[t4 + 1];
              e4.pop();
            })(a3, n3), 1 === a3.length && (r3[e3] = a3[0]), void 0 !== r3.removeListener && this.emit("removeListener", e3, s2 || t3);
          }
          return this;
        }, o.prototype.off = o.prototype.removeListener, o.prototype.removeAllListeners = function(e3) {
          var t3, a3, r3;
          if (void 0 === (a3 = this._events)) return this;
          if (void 0 === a3.removeListener) return 0 === arguments.length ? (this._events = /* @__PURE__ */ Object.create(null), this._eventsCount = 0) : void 0 !== a3[e3] && (0 == --this._eventsCount ? this._events = /* @__PURE__ */ Object.create(null) : delete a3[e3]), this;
          if (0 === arguments.length) {
            var n3, o2 = Object.keys(a3);
            for (r3 = 0; r3 < o2.length; ++r3) "removeListener" !== (n3 = o2[r3]) && this.removeAllListeners(n3);
            return this.removeAllListeners("removeListener"), this._events = /* @__PURE__ */ Object.create(null), this._eventsCount = 0, this;
          }
          if ("function" == typeof (t3 = a3[e3])) this.removeListener(e3, t3);
          else if (void 0 !== t3) for (r3 = t3.length - 1; r3 >= 0; r3--) this.removeListener(e3, t3[r3]);
          return this;
        }, o.prototype.listeners = function(e3) {
          return b(this, e3, true);
        }, o.prototype.rawListeners = function(e3) {
          return b(this, e3, false);
        }, o.listenerCount = function(e3, t3) {
          return "function" == typeof e3.listenerCount ? e3.listenerCount(t3) : p.call(e3, t3);
        }, o.prototype.listenerCount = p, o.prototype.eventNames = function() {
          return this._eventsCount > 0 ? t2(this._events) : [];
        };
      }, 8336: (e2) => {
        e2.exports = function(e3) {
          return !(!e3 || "string" == typeof e3) && (e3 instanceof Array || Array.isArray(e3) || e3.length >= 0 && (e3.splice instanceof Function || Object.getOwnPropertyDescriptor(e3, e3.length - 1) && "String" !== e3.constructor.name));
        };
      }, 3989: (e2) => {
        var t2 = "__lodash_placeholder__", a2 = 32, r2 = 1 / 0, n2 = NaN, o = [["ary", 128], ["bind", 1], ["bindKey", 2], ["curry", 8], ["curryRight", 16], ["flip", 512], ["partial", a2], ["partialRight", 64], ["rearg", 256]], s = "[object Function]", i = "[object GeneratorFunction]", l = /^\s+|\s+$/g, c = /\{(?:\n\/\* \[wrapped with .+\] \*\/)?\n?/, u = /\{\n\/\* \[wrapped with (.+)\] \*/, d = /,? & /, b = /^[-+]0x[0-9a-f]+$/i, p = /^0b[01]+$/i, f = /^\[object .+?Constructor\]$/, h = /^0o[0-7]+$/i, m = /^(?:0|[1-9]\d*)$/, v = parseInt, g = "object" == typeof commonjsGlobal && commonjsGlobal && commonjsGlobal.Object === Object && commonjsGlobal, y = "object" == typeof self && self && self.Object === Object && self, k = g || y || Function("return this")();
        function E(e3, t3, a3) {
          switch (a3.length) {
            case 0:
              return e3.call(t3);
            case 1:
              return e3.call(t3, a3[0]);
            case 2:
              return e3.call(t3, a3[0], a3[1]);
            case 3:
              return e3.call(t3, a3[0], a3[1], a3[2]);
          }
          return e3.apply(t3, a3);
        }
        function w(e3, t3) {
          return !!(e3 ? e3.length : 0) && (function(e4, t4, a3) {
            if (t4 != t4) return (function(e5, t5, a4, r4) {
              var n4 = e5.length, o2 = a4 + -1;
              for (; ++o2 < n4; ) if (t5(e5[o2], o2, e5)) return o2;
              return -1;
            })(e4, j, a3);
            var r3 = a3 - 1, n3 = e4.length;
            for (; ++r3 < n3; ) if (e4[r3] === t4) return r3;
            return -1;
          })(e3, t3, 0) > -1;
        }
        function j(e3) {
          return e3 != e3;
        }
        function x(e3, a3) {
          for (var r3 = -1, n3 = e3.length, o2 = 0, s2 = []; ++r3 < n3; ) {
            var i2 = e3[r3];
            i2 !== a3 && i2 !== t2 || (e3[r3] = t2, s2[o2++] = r3);
          }
          return s2;
        }
        var C, O, M, S = Function.prototype, _ = Object.prototype, A = k["__core-js_shared__"], F = (C = /[^.]+$/.exec(A && A.keys && A.keys.IE_PROTO || "")) ? "Symbol(src)_1." + C : "", P = S.toString, R = _.hasOwnProperty, D = _.toString, I = RegExp("^" + P.call(R).replace(/[\\^$.*+?()[\]{}|]/g, "\\$&").replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, "$1.*?") + "$"), z = Object.create, B = Math.max, N = Math.min, L = (O = H(Object, "defineProperty"), (M = H.name) && M.length > 2 ? O : void 0);
        function q(e3) {
          if (!X2(e3) || (function(e4) {
            return !!F && F in e4;
          })(e3)) return false;
          var t3 = (function(e4) {
            var t4 = X2(e4) ? D.call(e4) : "";
            return t4 == s || t4 == i;
          })(e3) || (function(e4) {
            var t4 = false;
            if (null != e4 && "function" != typeof e4.toString) try {
              t4 = !!(e4 + "");
            } catch (e5) {
            }
            return t4;
          })(e3) ? I : f;
          return t3.test((function(e4) {
            if (null != e4) {
              try {
                return P.call(e4);
              } catch (e5) {
              }
              try {
                return e4 + "";
              } catch (e5) {
              }
            }
            return "";
          })(e3));
        }
        function V(e3) {
          return function() {
            var t3 = arguments;
            switch (t3.length) {
              case 0:
                return new e3();
              case 1:
                return new e3(t3[0]);
              case 2:
                return new e3(t3[0], t3[1]);
              case 3:
                return new e3(t3[0], t3[1], t3[2]);
              case 4:
                return new e3(t3[0], t3[1], t3[2], t3[3]);
              case 5:
                return new e3(t3[0], t3[1], t3[2], t3[3], t3[4]);
              case 6:
                return new e3(t3[0], t3[1], t3[2], t3[3], t3[4], t3[5]);
              case 7:
                return new e3(t3[0], t3[1], t3[2], t3[3], t3[4], t3[5], t3[6]);
            }
            var a3, r3 = X2(a3 = e3.prototype) ? z(a3) : {}, n3 = e3.apply(r3, t3);
            return X2(n3) ? n3 : r3;
          };
        }
        function T(e3, t3, a3, r3, n3, o2, s2, i2, l2, c2) {
          var u2 = 128 & t3, d2 = 1 & t3, b2 = 2 & t3, p2 = 24 & t3, f2 = 512 & t3, h2 = b2 ? void 0 : V(e3);
          return function m2() {
            for (var v2 = arguments.length, g2 = Array(v2), y2 = v2; y2--; ) g2[y2] = arguments[y2];
            if (p2) var E2 = U(m2), w2 = (function(e4, t4) {
              for (var a4 = e4.length, r4 = 0; a4--; ) e4[a4] === t4 && r4++;
              return r4;
            })(g2, E2);
            if (r3 && (g2 = (function(e4, t4, a4, r4) {
              for (var n4 = -1, o3 = e4.length, s3 = a4.length, i3 = -1, l3 = t4.length, c3 = B(o3 - s3, 0), u3 = Array(l3 + c3), d3 = !r4; ++i3 < l3; ) u3[i3] = t4[i3];
              for (; ++n4 < s3; ) (d3 || n4 < o3) && (u3[a4[n4]] = e4[n4]);
              for (; c3--; ) u3[i3++] = e4[n4++];
              return u3;
            })(g2, r3, n3, p2)), o2 && (g2 = (function(e4, t4, a4, r4) {
              for (var n4 = -1, o3 = e4.length, s3 = -1, i3 = a4.length, l3 = -1, c3 = t4.length, u3 = B(o3 - i3, 0), d3 = Array(u3 + c3), b3 = !r4; ++n4 < u3; ) d3[n4] = e4[n4];
              for (var p3 = n4; ++l3 < c3; ) d3[p3 + l3] = t4[l3];
              for (; ++s3 < i3; ) (b3 || n4 < o3) && (d3[p3 + a4[s3]] = e4[n4++]);
              return d3;
            })(g2, o2, s2, p2)), v2 -= w2, p2 && v2 < c2) {
              var j2 = x(g2, E2);
              return K(e3, t3, T, m2.placeholder, a3, g2, j2, i2, l2, c2 - v2);
            }
            var C2 = d2 ? a3 : this, O2 = b2 ? C2[e3] : e3;
            return v2 = g2.length, i2 ? g2 = (function(e4, t4) {
              var a4 = e4.length, r4 = N(t4.length, a4), n4 = (function(e5, t5) {
                var a5 = -1, r5 = e5.length;
                for (t5 || (t5 = Array(r5)); ++a5 < r5; ) t5[a5] = e5[a5];
                return t5;
              })(e4);
              for (; r4--; ) {
                var o3 = t4[r4];
                e4[r4] = J(o3, a4) ? n4[o3] : void 0;
              }
              return e4;
            })(g2, i2) : f2 && v2 > 1 && g2.reverse(), u2 && l2 < v2 && (g2.length = l2), this && this !== k && this instanceof m2 && (O2 = h2 || V(O2)), O2.apply(C2, g2);
          };
        }
        function K(e3, t3, r3, n3, o2, s2, i2, l2, c2, u2) {
          var d2 = 8 & t3;
          t3 |= d2 ? a2 : 64, 4 & (t3 &= ~(d2 ? 64 : a2)) || (t3 &= -4);
          var b2 = r3(e3, t3, o2, d2 ? s2 : void 0, d2 ? i2 : void 0, d2 ? void 0 : s2, d2 ? void 0 : i2, l2, c2, u2);
          return b2.placeholder = n3, G(b2, e3, t3);
        }
        function W(e3, t3, r3, n3, o2, s2, i2, l2) {
          var c2 = 2 & t3;
          if (!c2 && "function" != typeof e3) throw new TypeError("Expected a function");
          var u2 = n3 ? n3.length : 0;
          if (u2 || (t3 &= -97, n3 = o2 = void 0), i2 = void 0 === i2 ? i2 : B(te(i2), 0), l2 = void 0 === l2 ? l2 : te(l2), u2 -= o2 ? o2.length : 0, 64 & t3) {
            var d2 = n3, b2 = o2;
            n3 = o2 = void 0;
          }
          var p2 = [e3, t3, r3, n3, o2, d2, b2, s2, i2, l2];
          if (e3 = p2[0], t3 = p2[1], r3 = p2[2], n3 = p2[3], o2 = p2[4], !(l2 = p2[9] = null == p2[9] ? c2 ? 0 : e3.length : B(p2[9] - u2, 0)) && 24 & t3 && (t3 &= -25), t3 && 1 != t3) f2 = 8 == t3 || 16 == t3 ? (function(e4, t4, a3) {
            var r4 = V(e4);
            return function n4() {
              for (var o3 = arguments.length, s3 = Array(o3), i3 = o3, l3 = U(n4); i3--; ) s3[i3] = arguments[i3];
              var c3 = o3 < 3 && s3[0] !== l3 && s3[o3 - 1] !== l3 ? [] : x(s3, l3);
              return (o3 -= c3.length) < a3 ? K(e4, t4, T, n4.placeholder, void 0, s3, c3, void 0, void 0, a3 - o3) : E(this && this !== k && this instanceof n4 ? r4 : e4, this, s3);
            };
          })(e3, t3, l2) : t3 != a2 && 33 != t3 || o2.length ? T.apply(void 0, p2) : (function(e4, t4, a3, r4) {
            var n4 = 1 & t4, o3 = V(e4);
            return function t5() {
              for (var s3 = -1, i3 = arguments.length, l3 = -1, c3 = r4.length, u3 = Array(c3 + i3), d3 = this && this !== k && this instanceof t5 ? o3 : e4; ++l3 < c3; ) u3[l3] = r4[l3];
              for (; i3--; ) u3[l3++] = arguments[++s3];
              return E(d3, n4 ? a3 : this, u3);
            };
          })(e3, t3, r3, n3);
          else var f2 = (function(e4, t4, a3) {
            var r4 = 1 & t4, n4 = V(e4);
            return function t5() {
              return (this && this !== k && this instanceof t5 ? n4 : e4).apply(r4 ? a3 : this, arguments);
            };
          })(e3, t3, r3);
          return G(f2, e3, t3);
        }
        function U(e3) {
          return e3.placeholder;
        }
        function H(e3, t3) {
          var a3 = (function(e4, t4) {
            return null == e4 ? void 0 : e4[t4];
          })(e3, t3);
          return q(a3) ? a3 : void 0;
        }
        function $(e3) {
          var t3 = e3.match(u);
          return t3 ? t3[1].split(d) : [];
        }
        function Y(e3, t3) {
          var a3 = t3.length, r3 = a3 - 1;
          return t3[r3] = (a3 > 1 ? "& " : "") + t3[r3], t3 = t3.join(a3 > 2 ? ", " : " "), e3.replace(c, "{\n/* [wrapped with " + t3 + "] */\n");
        }
        function J(e3, t3) {
          return !!(t3 = null == t3 ? 9007199254740991 : t3) && ("number" == typeof e3 || m.test(e3)) && e3 > -1 && e3 % 1 == 0 && e3 < t3;
        }
        var G = L ? function(e3, t3, a3) {
          var r3, n3 = t3 + "";
          return L(e3, "toString", { configurable: true, enumerable: false, value: (r3 = Y(n3, Q($(n3), a3)), function() {
            return r3;
          }) });
        } : function(e3) {
          return e3;
        };
        function Q(e3, t3) {
          return (function(e4, t4) {
            for (var a3 = -1, r3 = e4 ? e4.length : 0; ++a3 < r3 && false !== t4(e4[a3], a3, e4); ) ;
          })(o, (function(a3) {
            var r3 = "_." + a3[0];
            t3 & a3[1] && !w(e3, r3) && e3.push(r3);
          })), e3.sort();
        }
        function Z(e3, t3, a3) {
          var r3 = W(e3, 8, void 0, void 0, void 0, void 0, void 0, t3 = a3 ? void 0 : t3);
          return r3.placeholder = Z.placeholder, r3;
        }
        function X2(e3) {
          var t3 = typeof e3;
          return !!e3 && ("object" == t3 || "function" == t3);
        }
        function ee(e3) {
          return e3 ? (e3 = (function(e4) {
            if ("number" == typeof e4) return e4;
            if ((function(e5) {
              return "symbol" == typeof e5 || /* @__PURE__ */ (function(e6) {
                return !!e6 && "object" == typeof e6;
              })(e5) && "[object Symbol]" == D.call(e5);
            })(e4)) return n2;
            if (X2(e4)) {
              var t3 = "function" == typeof e4.valueOf ? e4.valueOf() : e4;
              e4 = X2(t3) ? t3 + "" : t3;
            }
            if ("string" != typeof e4) return 0 === e4 ? e4 : +e4;
            e4 = e4.replace(l, "");
            var a3 = p.test(e4);
            return a3 || h.test(e4) ? v(e4.slice(2), a3 ? 2 : 8) : b.test(e4) ? n2 : +e4;
          })(e3)) === r2 || e3 === -1 / 0 ? 17976931348623157e292 * (e3 < 0 ? -1 : 1) : e3 == e3 ? e3 : 0 : 0 === e3 ? e3 : 0;
        }
        function te(e3) {
          var t3 = ee(e3), a3 = t3 % 1;
          return t3 == t3 ? a3 ? t3 - a3 : t3 : 0;
        }
        Z.placeholder = {}, e2.exports = Z;
      }, 301: (e2, t2, a2) => {
        var r2 = a2(8336), n2 = Array.prototype.concat, o = Array.prototype.slice, s = e2.exports = function(e3) {
          for (var t3 = [], a3 = 0, s2 = e3.length; a3 < s2; a3++) {
            var i = e3[a3];
            r2(i) ? t3 = n2.call(t3, o.call(i)) : t3.push(i);
          }
          return t3;
        };
        s.wrap = function(e3) {
          return function() {
            return e3(s(arguments));
          };
        };
      }, 4119: (t2) => {
        t2.exports = e;
      } }, a = {};
      function r(e2) {
        var n2 = a[e2];
        if (void 0 !== n2) return n2.exports;
        var o = a[e2] = { exports: {} };
        return t[e2](o, o.exports, r), o.exports;
      }
      r.n = (e2) => {
        var t2 = e2 && e2.__esModule ? () => e2.default : () => e2;
        return r.d(t2, { a: t2 }), t2;
      }, r.d = (e2, t2) => {
        for (var a2 in t2) r.o(t2, a2) && !r.o(e2, a2) && Object.defineProperty(e2, a2, { enumerable: true, get: t2[a2] });
      }, r.o = (e2, t2) => Object.prototype.hasOwnProperty.call(e2, t2), r.r = (e2) => {
        "undefined" != typeof Symbol && Symbol.toStringTag && Object.defineProperty(e2, Symbol.toStringTag, { value: "Module" }), Object.defineProperty(e2, "__esModule", { value: true });
      };
      var n = {};
      return (() => {
        function e2(t3) {
          return e2 = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function(e3) {
            return typeof e3;
          } : function(e3) {
            return e3 && "function" == typeof Symbol && e3.constructor === Symbol && e3 !== Symbol.prototype ? "symbol" : typeof e3;
          }, e2(t3);
        }
        function t2(t3) {
          var a3 = (function(t4, a4) {
            if ("object" != e2(t4) || !t4) return t4;
            var r2 = t4[Symbol.toPrimitive];
            if (void 0 !== r2) {
              var n2 = r2.call(t4, a4);
              if ("object" != e2(n2)) return n2;
              throw new TypeError("@@toPrimitive must return a primitive value.");
            }
            return ("string" === a4 ? String : Number)(t4);
          })(t3, "string");
          return "symbol" == e2(a3) ? a3 : a3 + "";
        }
        function a2(e3, a3, r2) {
          return (a3 = t2(a3)) in e3 ? Object.defineProperty(e3, a3, { value: r2, enumerable: true, configurable: true, writable: true }) : e3[a3] = r2, e3;
        }
        function o(e3, t3) {
          var a3 = Object.keys(e3);
          if (Object.getOwnPropertySymbols) {
            var r2 = Object.getOwnPropertySymbols(e3);
            t3 && (r2 = r2.filter((function(t4) {
              return Object.getOwnPropertyDescriptor(e3, t4).enumerable;
            }))), a3.push.apply(a3, r2);
          }
          return a3;
        }
        function s(e3) {
          for (var t3 = 1; t3 < arguments.length; t3++) {
            var r2 = null != arguments[t3] ? arguments[t3] : {};
            t3 % 2 ? o(Object(r2), true).forEach((function(t4) {
              a2(e3, t4, r2[t4]);
            })) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e3, Object.getOwnPropertyDescriptors(r2)) : o(Object(r2)).forEach((function(t4) {
              Object.defineProperty(e3, t4, Object.getOwnPropertyDescriptor(r2, t4));
            }));
          }
          return e3;
        }
        function i(e3, t3) {
          if (!(e3 instanceof t3)) throw new TypeError("Cannot call a class as a function");
        }
        function l(e3, a3) {
          for (var r2 = 0; r2 < a3.length; r2++) {
            var n2 = a3[r2];
            n2.enumerable = n2.enumerable || false, n2.configurable = true, "value" in n2 && (n2.writable = true), Object.defineProperty(e3, t2(n2.key), n2);
          }
        }
        function c(e3, t3, a3) {
          return t3 && l(e3.prototype, t3), a3 && l(e3, a3), Object.defineProperty(e3, "prototype", { writable: false }), e3;
        }
        function u(e3) {
          return u = Object.setPrototypeOf ? Object.getPrototypeOf.bind() : function(e4) {
            return e4.__proto__ || Object.getPrototypeOf(e4);
          }, u(e3);
        }
        function d() {
          try {
            var e3 = !Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], (function() {
            })));
          } catch (e4) {
          }
          return (d = function() {
            return !!e3;
          })();
        }
        function b(t3, a3) {
          if (a3 && ("object" == e2(a3) || "function" == typeof a3)) return a3;
          if (void 0 !== a3) throw new TypeError("Derived constructors may only return object or undefined");
          return (function(e3) {
            if (void 0 === e3) throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
            return e3;
          })(t3);
        }
        function p(e3, t3, a3) {
          return t3 = u(t3), b(e3, d() ? Reflect.construct(t3, a3 || [], u(e3).constructor) : t3.apply(e3, a3));
        }
        function f(e3, t3) {
          return f = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function(e4, t4) {
            return e4.__proto__ = t4, e4;
          }, f(e3, t3);
        }
        function h(e3, t3) {
          if ("function" != typeof t3 && null !== t3) throw new TypeError("Super expression must either be null or a function");
          e3.prototype = Object.create(t3 && t3.prototype, { constructor: { value: e3, writable: true, configurable: true } }), Object.defineProperty(e3, "prototype", { writable: false }), t3 && f(e3, t3);
        }
        r.r(n), r.d(n, { default: () => Et });
        var m = r(4119), v = r.n(m);
        function g() {
          var e3 = this.constructor.getDerivedStateFromProps(this.props, this.state);
          null != e3 && this.setState(e3);
        }
        function y(e3) {
          this.setState((function(t3) {
            var a3 = this.constructor.getDerivedStateFromProps(e3, t3);
            return null != a3 ? a3 : null;
          }).bind(this));
        }
        function k(e3, t3) {
          try {
            var a3 = this.props, r2 = this.state;
            this.props = e3, this.state = t3, this.__reactInternalSnapshotFlag = true, this.__reactInternalSnapshot = this.getSnapshotBeforeUpdate(a3, r2);
          } finally {
            this.props = a3, this.state = r2;
          }
        }
        function E(e3) {
          var t3 = e3.prototype;
          if (!t3 || !t3.isReactComponent) throw new Error("Can only polyfill class components");
          if ("function" != typeof e3.getDerivedStateFromProps && "function" != typeof t3.getSnapshotBeforeUpdate) return e3;
          var a3 = null, r2 = null, n2 = null;
          if ("function" == typeof t3.componentWillMount ? a3 = "componentWillMount" : "function" == typeof t3.UNSAFE_componentWillMount && (a3 = "UNSAFE_componentWillMount"), "function" == typeof t3.componentWillReceiveProps ? r2 = "componentWillReceiveProps" : "function" == typeof t3.UNSAFE_componentWillReceiveProps && (r2 = "UNSAFE_componentWillReceiveProps"), "function" == typeof t3.componentWillUpdate ? n2 = "componentWillUpdate" : "function" == typeof t3.UNSAFE_componentWillUpdate && (n2 = "UNSAFE_componentWillUpdate"), null !== a3 || null !== r2 || null !== n2) {
            var o2 = e3.displayName || e3.name, s2 = "function" == typeof e3.getDerivedStateFromProps ? "getDerivedStateFromProps()" : "getSnapshotBeforeUpdate()";
            throw Error("Unsafe legacy lifecycles will not be called for components using new component APIs.\n\n" + o2 + " uses " + s2 + " but also contains the following legacy lifecycles:" + (null !== a3 ? "\n  " + a3 : "") + (null !== r2 ? "\n  " + r2 : "") + (null !== n2 ? "\n  " + n2 : "") + "\n\nThe above lifecycles should be removed. Learn more about this warning here:\nhttps://fb.me/react-async-component-lifecycle-hooks");
          }
          if ("function" == typeof e3.getDerivedStateFromProps && (t3.componentWillMount = g, t3.componentWillReceiveProps = y), "function" == typeof t3.getSnapshotBeforeUpdate) {
            if ("function" != typeof t3.componentDidUpdate) throw new Error("Cannot polyfill getSnapshotBeforeUpdate() for components that do not define componentDidUpdate() on the prototype");
            t3.componentWillUpdate = k;
            var i2 = t3.componentDidUpdate;
            t3.componentDidUpdate = function(e4, t4, a4) {
              var r3 = this.__reactInternalSnapshotFlag ? this.__reactInternalSnapshot : a4;
              i2.call(this, e4, t4, r3);
            };
          }
          return e3;
        }
        function w(e3, t3) {
          if (null == e3) return {};
          var a3 = {};
          for (var r2 in e3) if ({}.hasOwnProperty.call(e3, r2)) {
            if (t3.includes(r2)) continue;
            a3[r2] = e3[r2];
          }
          return a3;
        }
        function j(e3, t3) {
          if (null == e3) return {};
          var a3, r2, n2 = w(e3, t3);
          if (Object.getOwnPropertySymbols) {
            var o2 = Object.getOwnPropertySymbols(e3);
            for (r2 = 0; r2 < o2.length; r2++) a3 = o2[r2], t3.includes(a3) || {}.propertyIsEnumerable.call(e3, a3) && (n2[a3] = e3[a3]);
          }
          return n2;
        }
        function x(e3, t3) {
          if (t3 && (null == e3 ? void 0 : e3.constructor) === t3) return "bigNumber";
          var a3 = (function(e4) {
            return {}.toString.call(e4).match(/\s([a-zA-Z]+)/)[1].toLowerCase();
          })(e3);
          return "number" === a3 && (a3 = isNaN(e3) ? "nan" : (0 | e3) != e3 ? "float" : "integer"), a3;
        }
        function C(e3) {
          return e3.replace(/\\/g, "\\\\").replace(/\n/g, "\\n").replace(/\t/g, "\\t").replace(/\r/g, "\\r").replace(/\f/g, "\\f");
        }
        g.__suppressDeprecationWarning = true, y.__suppressDeprecationWarning = true, k.__suppressDeprecationWarning = true;
        var O = { scheme: "rjv-default", author: "mac gainor", base00: "rgba(0, 0, 0, 0)", base01: "rgb(245, 245, 245)", base02: "rgb(235, 235, 235)", base03: "#93a1a1", base04: "rgba(0, 0, 0, 0.3)", base05: "#586e75", base06: "#073642", base07: "#002b36", base08: "#d33682", base09: "#cb4b16", base0A: "#dc322f", base0B: "#859900", base0C: "#6c71c4", base0D: "#586e75", base0E: "#2aa198", base0F: "#268bd2" }, M = { scheme: "rjv-grey", author: "mac gainor", base00: "rgba(1, 1, 1, 0)", base01: "rgba(1, 1, 1, 0.1)", base02: "rgba(0, 0, 0, 0.2)", base03: "rgba(1, 1, 1, 0.3)", base04: "rgba(0, 0, 0, 0.4)", base05: "rgba(1, 1, 1, 0.5)", base06: "rgba(1, 1, 1, 0.6)", base07: "rgba(1, 1, 1, 0.7)", base08: "rgba(1, 1, 1, 0.8)", base09: "rgba(1, 1, 1, 0.8)", base0A: "rgba(1, 1, 1, 0.8)", base0B: "rgba(1, 1, 1, 0.8)", base0C: "rgba(1, 1, 1, 0.8)", base0D: "rgba(1, 1, 1, 0.8)", base0E: "rgba(1, 1, 1, 0.8)", base0F: "rgba(1, 1, 1, 0.8)" };
        const S = { globalFontFamily: "monospace", globalCursor: "default", braceFontWeight: "bold", braceCursor: "pointer", ellipsisFontSize: "18px", ellipsisLineHeight: "10px", ellipsisCursor: "pointer", keyMargin: "0px 5px", keyLetterSpacing: "0.5px", keyFontStyle: "none", keyVerticalAlign: "top", keyOpacity: "0.85", keyOpacityHover: "1", keyValPaddingTop: "3px", keyValPaddingBottom: "3px", keyValPaddingRight: "5px", keyValBorderLeft: "1px solid", keyValBorderHover: "2px solid", pushedContentMarginLeft: "6px", variableValuePaddingRight: "6px", nullFontSize: "11px", nullFontWeight: "bold", nullPadding: "1px 2px", nullBorderRadius: "3px", nanFontSize: "11px", nanFontWeight: "bold", nanPadding: "1px 2px", nanBorderRadius: "3px", undefinedFontSize: "11px", undefinedPadding: "1px 2px", undefinedBorderRadius: "3px", dataTypeFontSize: "11px", dataTypeMarginRight: "4px", datatypeOpacity: "0.8", objectSizeBorderRadius: "3px", objectSizeFontStyle: "italic", objectSizeMargin: "0px 6px 0px 0px", clipboardCursor: "pointer", clipboardCheckMarginLeft: "-12px", metaDataPadding: "0px 0px 0px 10px", arrayGroupMetaPadding: "0px 0px 0px 4px", iconContainerWidth: "17px", tooltipPadding: "4px", editInputMinWidth: "130px", editInputBorderRadius: "2px", editInputPadding: "5px", editInputMarginRight: "4px", editInputFontFamily: "monospace", iconCursor: "pointer", iconFontSize: "15px", iconPaddingRight: "1px", dateValueMarginLeft: "2px", iconMarginRight: "3px", detectedRowPaddingTop: "3px", addKeyCoverBackground: "rgba(255, 255, 255, 0.3)", addKeyCoverPosition: "absolute", addKeyCoverPositionPx: "0px", addKeyModalWidth: "200px", addKeyModalMargin: "auto", addKeyModalPadding: "10px", addKeyModalRadius: "3px", commaColor: "#666", commaFontSize: "12px", commaMarginRight: "4px" };
        function _(e3, t3) {
          (null == t3 || t3 > e3.length) && (t3 = e3.length);
          for (var a3 = 0, r2 = Array(t3); a3 < t3; a3++) r2[a3] = e3[a3];
          return r2;
        }
        function A(e3, t3) {
          if (e3) {
            if ("string" == typeof e3) return _(e3, t3);
            var a3 = {}.toString.call(e3).slice(8, -1);
            return "Object" === a3 && e3.constructor && (a3 = e3.constructor.name), "Map" === a3 || "Set" === a3 ? Array.from(e3) : "Arguments" === a3 || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(a3) ? _(e3, t3) : void 0;
          }
        }
        function F(e3, t3) {
          return (function(e4) {
            if (Array.isArray(e4)) return e4;
          })(e3) || (function(e4, t4) {
            var a3 = null == e4 ? null : "undefined" != typeof Symbol && e4[Symbol.iterator] || e4["@@iterator"];
            if (null != a3) {
              var r2, n2, o2, s2, i2 = [], l2 = true, c2 = false;
              try {
                if (o2 = (a3 = a3.call(e4)).next, 0 === t4) {
                  if (Object(a3) !== a3) return;
                  l2 = false;
                } else for (; !(l2 = (r2 = o2.call(a3)).done) && (i2.push(r2.value), i2.length !== t4); l2 = true) ;
              } catch (e5) {
                c2 = true, n2 = e5;
              } finally {
                try {
                  if (!l2 && null != a3.return && (s2 = a3.return(), Object(s2) !== s2)) return;
                } finally {
                  if (c2) throw n2;
                }
              }
              return i2;
            }
          })(e3, t3) || A(e3, t3) || (function() {
            throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
          })();
        }
        var P = r(9446), R = r(3639), D = r.n(R), I = r(3989), z = r.n(I);
        function B(e3, t3) {
          var a3 = Object.keys(e3);
          if (Object.getOwnPropertySymbols) {
            var r2 = Object.getOwnPropertySymbols(e3);
            t3 && (r2 = r2.filter((function(t4) {
              return Object.getOwnPropertyDescriptor(e3, t4).enumerable;
            }))), a3.push.apply(a3, r2);
          }
          return a3;
        }
        function N(e3) {
          for (var t3 = 1; t3 < arguments.length; t3++) {
            var r2 = null != arguments[t3] ? arguments[t3] : {};
            t3 % 2 ? B(Object(r2), true).forEach((function(t4) {
              a2(e3, t4, r2[t4]);
            })) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e3, Object.getOwnPropertyDescriptors(r2)) : B(Object(r2)).forEach((function(t4) {
              Object.defineProperty(e3, t4, Object.getOwnPropertyDescriptor(r2, t4));
            }));
          }
          return e3;
        }
        var L = P.default, q = Object.keys(L), V = function(e3) {
          var t3, a3 = (function(e4) {
            var t4 = e4[0] / 255, a4 = e4[1] / 255, r3 = e4[2] / 255;
            return [0.299 * t4 + 0.587 * a4 + 0.114 * r3, -0.14713 * t4 + -0.28886 * a4 + 0.436 * r3, 0.615 * t4 + -0.51499 * a4 + -0.10001 * r3];
          })(D()(e3).array()), r2 = F(a3, 3), n2 = r2[0], o2 = r2[1], s2 = r2[2], i2 = (function(e4) {
            var t4, a4, r3, n3 = e4[0], o3 = e4[1], s3 = e4[2];
            return t4 = 1 * n3 + 0 * o3 + 1.13983 * s3, a4 = 1 * n3 + -0.39465 * o3 + -0.5806 * s3, r3 = 1 * n3 + 2.02311 * o3 + 0 * s3, [255 * (t4 = Math.min(Math.max(0, t4), 1)), 255 * (a4 = Math.min(Math.max(0, a4), 1)), 255 * (r3 = Math.min(Math.max(0, r3), 1))];
          })([(t3 = n2, t3 < 0.25 ? 1 : t3 < 0.5 ? 0.9 - t3 : 1.1 - t3), o2, s2]);
          return D().rgb(i2).hex();
        }, T = function(e3) {
          return function(t3) {
            return { className: [t3.className, e3.className].filter(Boolean).join(" "), style: N(N({}, t3.style || {}), e3.style || {}) };
          };
        }, K = function(t3, a3) {
          var r2 = Object.keys(a3);
          for (var n2 in t3) -1 === r2.indexOf(n2) && r2.push(n2);
          return r2.reduce((function(r3, n3) {
            return r3[n3] = (function(t4, a4) {
              if (void 0 === t4) return a4;
              if (void 0 === a4) return t4;
              var r4 = e2(t4), n4 = e2(a4);
              switch (r4) {
                case "string":
                  switch (n4) {
                    case "string":
                      return [a4, t4].filter(Boolean).join(" ");
                    case "object":
                      return T({ className: t4, style: a4 });
                    case "function":
                      return function(e3) {
                        for (var r5 = arguments.length, n5 = new Array(r5 > 1 ? r5 - 1 : 0), o2 = 1; o2 < r5; o2++) n5[o2 - 1] = arguments[o2];
                        return T({ className: t4 })(a4.apply(void 0, [e3].concat(n5)));
                      };
                  }
                  break;
                case "object":
                  switch (n4) {
                    case "string":
                      return T({ className: a4, style: t4 });
                    case "object":
                      return N(N({}, a4), t4);
                    case "function":
                      return function(e3) {
                        for (var r5 = arguments.length, n5 = new Array(r5 > 1 ? r5 - 1 : 0), o2 = 1; o2 < r5; o2++) n5[o2 - 1] = arguments[o2];
                        return T({ style: t4 })(a4.apply(void 0, [e3].concat(n5)));
                      };
                  }
                  break;
                case "function":
                  switch (n4) {
                    case "string":
                      return function(e3) {
                        for (var r5 = arguments.length, n5 = new Array(r5 > 1 ? r5 - 1 : 0), o2 = 1; o2 < r5; o2++) n5[o2 - 1] = arguments[o2];
                        return t4.apply(void 0, [T(e3)({ className: a4 })].concat(n5));
                      };
                    case "object":
                      return function(e3) {
                        for (var r5 = arguments.length, n5 = new Array(r5 > 1 ? r5 - 1 : 0), o2 = 1; o2 < r5; o2++) n5[o2 - 1] = arguments[o2];
                        return t4.apply(void 0, [T(e3)({ style: a4 })].concat(n5));
                      };
                    case "function":
                      return function(e3) {
                        for (var r5 = arguments.length, n5 = new Array(r5 > 1 ? r5 - 1 : 0), o2 = 1; o2 < r5; o2++) n5[o2 - 1] = arguments[o2];
                        return t4.apply(void 0, [a4.apply(void 0, [e3].concat(n5))].concat(n5));
                      };
                  }
              }
            })(t3[n3], a3[n3]), r3;
          }), {});
        }, W = function(t3, a3) {
          for (var r2 = arguments.length, n2 = new Array(r2 > 2 ? r2 - 2 : 0), o2 = 2; o2 < r2; o2++) n2[o2 - 2] = arguments[o2];
          if (null === a3) return t3;
          Array.isArray(a3) || (a3 = [a3]);
          var s2 = a3.map((function(e3) {
            return t3[e3];
          })).filter(Boolean).reduce((function(t4, a4) {
            return "string" == typeof a4 ? t4.className = [t4.className, a4].filter(Boolean).join(" ") : "object" === e2(a4) ? t4.style = N(N({}, t4.style), a4) : "function" == typeof a4 && (t4 = N(N({}, t4), a4.apply(void 0, [t4].concat(n2)))), t4;
          }), { className: "", style: {} });
          return s2.className || delete s2.className, 0 === Object.keys(s2.style).length && delete s2.style, s2;
        }, U = function(e3) {
          return Object.keys(e3).reduce((function(t3, a3) {
            return t3[a3] = /^base/.test(a3) ? V(e3[a3]) : "scheme" === a3 ? e3[a3] + ":inverted" : e3[a3], t3;
          }), {});
        }, H = z()((function(e3) {
          var t3 = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : {}, a3 = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : {}, r2 = t3.defaultBase16, n2 = void 0 === r2 ? L : r2, o2 = t3.base16Themes, s2 = Y(a3, void 0 === o2 ? null : o2);
          s2 && (a3 = N(N({}, s2), a3));
          for (var i2 = q.reduce((function(e4, t4) {
            return e4[t4] = a3[t4] || n2[t4], e4;
          }), {}), l2 = Object.keys(a3).reduce((function(e4, t4) {
            return -1 === q.indexOf(t4) ? (e4[t4] = a3[t4], e4) : e4;
          }), {}), c2 = e3(i2), u2 = K(l2, c2), d2 = arguments.length, b2 = new Array(d2 > 3 ? d2 - 3 : 0), p2 = 3; p2 < d2; p2++) b2[p2 - 3] = arguments[p2];
          return z()(W, 2).apply(void 0, [u2].concat(b2));
        }), 3), $ = function(e3) {
          return !!e3.extend;
        }, Y = function(e3, t3) {
          if (e3 && $(e3) && e3.extend && (e3 = e3.extend), "string" == typeof e3) {
            var a3 = F(e3.split(":"), 2), r2 = a3[0], n2 = a3[1];
            e3 = t3 ? t3[r2] : P[r2], "inverted" === n2 && (e3 = U(e3));
          }
          return e3 && Object.prototype.hasOwnProperty.call(e3, "base00") ? e3 : void 0;
        }, J = function(e3) {
          var t3 = (function(e4) {
            return { backgroundColor: e4.base00, ellipsisColor: e4.base09, braceColor: e4.base07, expandedIcon: e4.base0D, collapsedIcon: e4.base0E, keyColor: e4.base07, arrayKeyColor: e4.base0C, objectSize: e4.base04, copyToClipboard: e4.base0F, copyToClipboardCheck: e4.base0D, objectBorder: e4.base02, dataTypes: { boolean: e4.base0E, date: e4.base0D, float: e4.base0B, function: e4.base0D, integer: e4.base0F, string: e4.base09, nan: e4.base08, null: e4.base0A, undefined: e4.base05, regexp: e4.base0A, background: e4.base02, bigNumber: e4.base09 }, editVariable: { editIcon: e4.base0E, cancelIcon: e4.base09, removeIcon: e4.base09, addIcon: e4.base0E, checkIcon: e4.base0E, background: e4.base01, color: e4.base0A, border: e4.base07 }, addKeyModal: { background: e4.base05, border: e4.base04, color: e4.base0A, labelColor: e4.base01 }, validationFailure: { background: e4.base09, iconColor: e4.base01, fontColor: e4.base01 } };
          })(e3);
          return { "app-container": { fontFamily: S.globalFontFamily, cursor: S.globalCursor, backgroundColor: t3.backgroundColor, position: "relative" }, ellipsis: { display: "inline-block", color: t3.ellipsisColor, fontSize: S.ellipsisFontSize, lineHeight: S.ellipsisLineHeight, cursor: S.ellipsisCursor }, "brace-row": { display: "inline-block", cursor: "pointer" }, brace: { display: "inline-block", cursor: S.braceCursor, fontWeight: S.braceFontWeight, color: t3.braceColor }, "expanded-icon": { color: t3.expandedIcon }, "collapsed-icon": { color: t3.collapsedIcon }, colon: { display: "inline-block", margin: S.keyMargin, color: t3.keyColor, verticalAlign: "top" }, objectKeyVal: function(e4, a3) {
            return { style: s({ paddingTop: S.keyValPaddingTop, paddingRight: S.keyValPaddingRight, paddingBottom: S.keyValPaddingBottom, borderLeft: S.keyValBorderLeft + " " + t3.objectBorder, ":hover": { paddingLeft: a3.paddingLeft - 1 + "px", borderLeft: S.keyValBorderHover + " " + t3.objectBorder } }, a3) };
          }, "object-key-val-no-border": { padding: S.keyValPadding }, "pushed-content": { marginLeft: S.pushedContentMarginLeft }, variableValue: function(e4, t4) {
            return { style: s({ display: "inline-block", paddingRight: S.variableValuePaddingRight, position: "relative" }, t4) };
          }, "object-name": { display: "inline-block", color: t3.keyColor, letterSpacing: S.keyLetterSpacing, fontStyle: S.keyFontStyle, verticalAlign: S.keyVerticalAlign, opacity: S.keyOpacity, ":hover": { opacity: S.keyOpacityHover } }, "array-key": { display: "inline-block", color: t3.arrayKeyColor, letterSpacing: S.keyLetterSpacing, fontStyle: S.keyFontStyle, verticalAlign: S.keyVerticalAlign, opacity: S.keyOpacity, ":hover": { opacity: S.keyOpacityHover } }, "object-size": { color: t3.objectSize, borderRadius: S.objectSizeBorderRadius, fontStyle: S.objectSizeFontStyle, margin: S.objectSizeMargin, cursor: "default" }, "data-type-label": { fontSize: S.dataTypeFontSize, marginRight: S.dataTypeMarginRight, opacity: S.datatypeOpacity }, boolean: { display: "inline-block", color: t3.dataTypes.boolean }, date: { display: "inline-block", color: t3.dataTypes.date }, "date-value": { marginLeft: S.dateValueMarginLeft }, float: { display: "inline-block", color: t3.dataTypes.float }, function: { display: "inline-block", color: t3.dataTypes.function, cursor: "pointer", whiteSpace: "pre-line" }, "function-value": { fontStyle: "italic" }, integer: { display: "inline-block", color: t3.dataTypes.integer }, bigNumber: { display: "inline-block", color: t3.dataTypes.bigNumber }, string: { display: "inline-block", color: t3.dataTypes.string }, nan: { display: "inline-block", color: t3.dataTypes.nan, fontSize: S.nanFontSize, fontWeight: S.nanFontWeight, backgroundColor: t3.dataTypes.background, padding: S.nanPadding, borderRadius: S.nanBorderRadius }, null: { display: "inline-block", color: t3.dataTypes.null, fontSize: S.nullFontSize, fontWeight: S.nullFontWeight, backgroundColor: t3.dataTypes.background, padding: S.nullPadding, borderRadius: S.nullBorderRadius }, undefined: { display: "inline-block", color: t3.dataTypes.undefined, fontSize: S.undefinedFontSize, padding: S.undefinedPadding, borderRadius: S.undefinedBorderRadius, backgroundColor: t3.dataTypes.background }, regexp: { display: "inline-block", color: t3.dataTypes.regexp }, "copy-to-clipboard": { cursor: S.clipboardCursor }, "copy-icon": { color: t3.copyToClipboard, fontSize: S.iconFontSize, marginRight: S.iconMarginRight, verticalAlign: "top" }, "copy-icon-copied": { color: t3.copyToClipboardCheck, marginLeft: S.clipboardCheckMarginLeft }, "array-group-meta-data": { display: "inline-block", padding: S.arrayGroupMetaPadding }, "object-meta-data": { display: "inline-block", padding: S.metaDataPadding }, "icon-container": { display: "inline-block", width: S.iconContainerWidth }, tooltip: { padding: S.tooltipPadding }, removeVarIcon: { verticalAlign: "top", display: "inline-block", color: t3.editVariable.removeIcon, cursor: S.iconCursor, fontSize: S.iconFontSize, marginRight: S.iconMarginRight }, addVarIcon: { verticalAlign: "top", display: "inline-block", color: t3.editVariable.addIcon, cursor: S.iconCursor, fontSize: S.iconFontSize, marginRight: S.iconMarginRight }, editVarIcon: { verticalAlign: "top", display: "inline-block", color: t3.editVariable.editIcon, cursor: S.iconCursor, fontSize: S.iconFontSize, marginRight: S.iconMarginRight }, "edit-icon-container": { display: "inline-block", verticalAlign: "top" }, "check-icon": { display: "inline-block", cursor: S.iconCursor, color: t3.editVariable.checkIcon, fontSize: S.iconFontSize, paddingRight: S.iconPaddingRight }, "cancel-icon": { display: "inline-block", cursor: S.iconCursor, color: t3.editVariable.cancelIcon, fontSize: S.iconFontSize, paddingRight: S.iconPaddingRight }, "edit-input": { display: "inline-block", minWidth: S.editInputMinWidth, borderRadius: S.editInputBorderRadius, backgroundColor: t3.editVariable.background, color: t3.editVariable.color, padding: S.editInputPadding, marginRight: S.editInputMarginRight, fontFamily: S.editInputFontFamily }, "detected-row": { paddingTop: S.detectedRowPaddingTop }, "key-modal-request": { position: S.addKeyCoverPosition, top: S.addKeyCoverPositionPx, left: S.addKeyCoverPositionPx, right: S.addKeyCoverPositionPx, bottom: S.addKeyCoverPositionPx, backgroundColor: S.addKeyCoverBackground }, "key-modal": { width: S.addKeyModalWidth, backgroundColor: t3.addKeyModal.background, marginLeft: S.addKeyModalMargin, marginRight: S.addKeyModalMargin, padding: S.addKeyModalPadding, borderRadius: S.addKeyModalRadius, marginTop: "15px", position: "relative" }, "key-modal-label": { color: t3.addKeyModal.labelColor, marginLeft: "2px", marginBottom: "5px", fontSize: "11px" }, "key-modal-input-container": { overflow: "hidden" }, "key-modal-input": { width: "100%", padding: "3px 6px", fontFamily: "monospace", color: t3.addKeyModal.color, border: "none", boxSizing: "border-box", borderRadius: "2px" }, "key-modal-cancel": { backgroundColor: t3.editVariable.removeIcon, position: "absolute", top: "0px", right: "0px", borderRadius: "0px 3px 0px 3px", cursor: "pointer" }, "key-modal-cancel-icon": { color: t3.addKeyModal.labelColor, fontSize: S.iconFontSize, transform: "rotate(45deg)" }, "key-modal-submit": { color: t3.editVariable.addIcon, fontSize: S.iconFontSize, position: "absolute", right: "2px", top: "3px", cursor: "pointer" }, "function-ellipsis": { display: "inline-block", color: t3.ellipsisColor, fontSize: S.ellipsisFontSize, lineHeight: S.ellipsisLineHeight, cursor: S.ellipsisCursor }, "validation-failure": { float: "right", padding: "3px 6px", borderRadius: "2px", cursor: "pointer", color: t3.validationFailure.fontColor, backgroundColor: t3.validationFailure.background }, "validation-failure-label": { marginRight: "6px" }, "validation-failure-clear": { position: "relative", verticalAlign: "top", cursor: "pointer", color: t3.validationFailure.iconColor, fontSize: S.iconFontSize, transform: "rotate(45deg)" }, comma: { display: "inline-block", color: S.commaColor, fontSize: S.commaFontSize, marginRight: S.commaMarginRight, cursor: "default" } };
        };
        function G(e3, t3, a3) {
          return e3 || console.error("theme has not been set"), (function(e4) {
            var t4 = O;
            return false !== e4 && "none" !== e4 || (t4 = M), H(J, { defaultBase16: t4 })(e4);
          })(e3)(t3, a3);
        }
        var Q = (function(e3) {
          function t3() {
            return i(this, t3), p(this, t3, arguments);
          }
          return h(t3, e3), c(t3, [{ key: "render", value: function() {
            var e4 = this.props, t4 = (e4.rjvId, e4.type_name), a3 = e4.displayDataTypes, r2 = e4.theme;
            return a3 ? v().createElement("span", Object.assign({ className: "data-type-label" }, G(r2, "data-type-label")), t4) : null;
          } }]);
        })(v().PureComponent), Z = (function(e3) {
          function t3() {
            return i(this, t3), p(this, t3, arguments);
          }
          return h(t3, e3), c(t3, [{ key: "render", value: function() {
            var e4 = this.props;
            return v().createElement("div", G(e4.theme, "boolean"), v().createElement(Q, Object.assign({ type_name: "bool" }, e4)), e4.value ? "true" : "false");
          } }]);
        })(v().PureComponent), X2 = (function(e3) {
          function t3() {
            return i(this, t3), p(this, t3, arguments);
          }
          return h(t3, e3), c(t3, [{ key: "render", value: function() {
            var e4 = this.props;
            return v().createElement("div", G(e4.theme, "date"), v().createElement(Q, Object.assign({ type_name: "date" }, e4)), v().createElement("span", Object.assign({ className: "date-value" }, G(e4.theme, "date-value")), e4.value.toLocaleTimeString("en-us", { weekday: "short", year: "numeric", month: "short", day: "numeric", hour: "2-digit", minute: "2-digit" })));
          } }]);
        })(v().PureComponent), ee = (function(e3) {
          function t3() {
            return i(this, t3), p(this, t3, arguments);
          }
          return h(t3, e3), c(t3, [{ key: "render", value: function() {
            var e4 = this.props;
            return v().createElement("div", G(e4.theme, "float"), v().createElement(Q, Object.assign({ type_name: "float" }, e4)), this.props.value);
          } }]);
        })(v().PureComponent);
        function te(e3) {
          return (function(e4) {
            if (Array.isArray(e4)) return _(e4);
          })(e3) || (function(e4) {
            if ("undefined" != typeof Symbol && null != e4[Symbol.iterator] || null != e4["@@iterator"]) return Array.from(e4);
          })(e3) || A(e3) || (function() {
            throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
          })();
        }
        var ae = r(9784), re = (function() {
          return c((function e3() {
            i(this, e3), this.handler = function() {
            };
          }), [{ key: "register", value: function(e3) {
            this.handler = e3;
          } }, { key: "dispatch", value: function(e3) {
            var t3;
            null === (t3 = this.handler) || void 0 === t3 || t3.call(this, e3);
          } }]);
        })();
        globalThis.__globalDispatcherInstance || (globalThis.__globalDispatcherInstance = new re());
        const ne = globalThis.__globalDispatcherInstance;
        var oe = new ((function(e3) {
          function t3() {
            var e4;
            i(this, t3);
            for (var a3 = arguments.length, r2 = new Array(a3), n2 = 0; n2 < a3; n2++) r2[n2] = arguments[n2];
            return (e4 = p(this, t3, [].concat(r2))).objects = {}, e4.set = function(t4, a4, r3, n3) {
              void 0 === e4.objects[t4] && (e4.objects[t4] = {}), void 0 === e4.objects[t4][a4] && (e4.objects[t4][a4] = {}), e4.objects[t4][a4][r3] = n3;
            }, e4.get = function(t4, a4, r3, n3) {
              return void 0 === e4.objects[t4] || void 0 === e4.objects[t4][a4] || null == e4.objects[t4][a4][r3] ? n3 : e4.objects[t4][a4][r3];
            }, e4.handleAction = function(t4) {
              var a4 = t4.rjvId, r3 = t4.data;
              switch (t4.name) {
                case "RESET":
                  e4.emit("reset-" + a4);
                  break;
                case "VARIABLE_UPDATED":
                  t4.data.updated_src = e4.updateSrc(a4, r3), e4.set(a4, "action", "variable-update", s(s({}, r3), {}, { type: "variable-edited" })), e4.emit("variable-update-" + a4);
                  break;
                case "VARIABLE_REMOVED":
                  t4.data.updated_src = e4.updateSrc(a4, r3), e4.set(a4, "action", "variable-update", s(s({}, r3), {}, { type: "variable-removed" })), e4.emit("variable-update-" + a4);
                  break;
                case "VARIABLE_ADDED":
                  t4.data.updated_src = e4.updateSrc(a4, r3), e4.set(a4, "action", "variable-update", s(s({}, r3), {}, { type: "variable-added" })), e4.emit("variable-update-" + a4);
                  break;
                case "ADD_VARIABLE_KEY_REQUEST":
                  e4.set(a4, "action", "new-key-request", r3), e4.emit("add-key-request-" + a4);
              }
            }, e4.updateSrc = function(t4, a4) {
              var r3 = a4.name, n3 = a4.namespace, o2 = a4.new_value, s2 = (a4.existing_value, a4.variable_removed);
              n3.shift();
              var i2, l2 = e4.get(t4, "global", "src"), c2 = e4.deepCopy(l2, te(n3)), u2 = c2, d2 = (function(e5, t5) {
                var a5 = "undefined" != typeof Symbol && e5[Symbol.iterator] || e5["@@iterator"];
                if (!a5) {
                  if (Array.isArray(e5) || (a5 = A(e5)) || t5) {
                    a5 && (e5 = a5);
                    var r4 = 0, n4 = function() {
                    };
                    return { s: n4, n: function() {
                      return r4 >= e5.length ? { done: true } : { done: false, value: e5[r4++] };
                    }, e: function(e6) {
                      throw e6;
                    }, f: n4 };
                  }
                  throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
                }
                var o3, s3 = true, i3 = false;
                return { s: function() {
                  a5 = a5.call(e5);
                }, n: function() {
                  var e6 = a5.next();
                  return s3 = e6.done, e6;
                }, e: function(e6) {
                  i3 = true, o3 = e6;
                }, f: function() {
                  try {
                    s3 || null == a5.return || a5.return();
                  } finally {
                    if (i3) throw o3;
                  }
                } };
              })(n3);
              try {
                for (d2.s(); !(i2 = d2.n()).done; ) {
                  u2 = u2[i2.value];
                }
              } catch (e5) {
                d2.e(e5);
              } finally {
                d2.f();
              }
              return s2 ? "array" == x(u2) ? u2.splice(r3, 1) : delete u2[r3] : null !== r3 ? u2[r3] = o2 : c2 = o2, e4.set(t4, "global", "src", c2), c2;
            }, e4.deepCopy = function(t4, a4) {
              var r3, n3 = x(t4), o2 = a4.shift();
              return "array" == n3 ? r3 = te(t4) : "object" == n3 && (r3 = s({}, t4)), void 0 !== o2 && (r3[o2] = e4.deepCopy(t4[o2], a4)), r3;
            }, e4;
          }
          return h(t3, e3), c(t3);
        })(ae.EventEmitter))();
        ne.register(oe.handleAction.bind(oe));
        const se = oe;
        var ie = (function(e3) {
          function t3(e4) {
            var a3;
            return i(this, t3), (a3 = p(this, t3, [e4])).toggleCollapsed = function() {
              a3.setState({ collapsed: !a3.state.collapsed }, (function() {
                se.set(a3.props.rjvId, a3.props.namespace, "collapsed", a3.state.collapsed);
              }));
            }, a3.getFunctionDisplay = function(e5) {
              var t4 = a3.props;
              return e5 ? v().createElement("span", null, a3.props.value.toString().slice(9, -1).replace(/\{[\s\S]+/, ""), v().createElement("span", { className: "function-collapsed", style: { fontWeight: "bold" } }, v().createElement("span", null, "{"), v().createElement("span", G(t4.theme, "ellipsis"), "..."), v().createElement("span", null, "}"))) : a3.props.value.toString().slice(9, -1);
            }, a3.state = { collapsed: se.get(e4.rjvId, e4.namespace, "collapsed", true) }, a3;
          }
          return h(t3, e3), c(t3, [{ key: "render", value: function() {
            var e4 = this.props, t4 = this.state.collapsed;
            return v().createElement("div", G(e4.theme, "function"), v().createElement(Q, Object.assign({ type_name: "function" }, e4)), v().createElement("span", Object.assign({}, G(e4.theme, "function-value"), { className: "rjv-function-container", onClick: this.toggleCollapsed }), this.getFunctionDisplay(t4)));
          } }]);
        })(v().PureComponent), le = (function(e3) {
          function t3() {
            return i(this, t3), p(this, t3, arguments);
          }
          return h(t3, e3), c(t3, [{ key: "render", value: function() {
            return v().createElement("div", G(this.props.theme, "nan"), "NaN");
          } }]);
        })(v().PureComponent), ce = (function(e3) {
          function t3() {
            return i(this, t3), p(this, t3, arguments);
          }
          return h(t3, e3), c(t3, [{ key: "render", value: function() {
            return v().createElement("div", G(this.props.theme, "null"), "NULL");
          } }]);
        })(v().PureComponent), ue = (function(e3) {
          function t3() {
            return i(this, t3), p(this, t3, arguments);
          }
          return h(t3, e3), c(t3, [{ key: "render", value: function() {
            var e4 = this.props;
            return v().createElement("div", G(e4.theme, "integer"), v().createElement(Q, Object.assign({ type_name: "int" }, e4)), this.props.value);
          } }]);
        })(v().PureComponent), de = (function(e3) {
          function t3() {
            return i(this, t3), p(this, t3, arguments);
          }
          return h(t3, e3), c(t3, [{ key: "render", value: function() {
            var e4 = this.props;
            return v().createElement("div", G(e4.theme, "regexp"), v().createElement(Q, Object.assign({ type_name: "regexp" }, e4)), this.props.value.toString());
          } }]);
        })(v().PureComponent), be = (function(e3) {
          function t3(e4) {
            var a3;
            return i(this, t3), (a3 = p(this, t3, [e4])).toggleCollapsed = function() {
              a3.setState({ collapsed: !a3.state.collapsed }, (function() {
                se.set(a3.props.rjvId, a3.props.namespace, "collapsed", a3.state.collapsed);
              }));
            }, a3.state = { collapsed: se.get(e4.rjvId, e4.namespace, "collapsed", true) }, a3;
          }
          return h(t3, e3), c(t3, [{ key: "render", value: function() {
            var e4 = this.state.collapsed, t4 = this.props, a3 = t4.collapseStringsAfterLength, r2 = t4.theme, n2 = t4.escapeStrings, o2 = t4.value, s2 = "integer" === x(a3), i2 = { style: { cursor: "default", wordBreak: "break-all" } };
            return n2 && (o2 = C(o2)), s2 && o2.length > a3 && (i2.style.cursor = "pointer", e4 && (o2 = v().createElement("span", null, o2.substring(0, a3), v().createElement("span", G(r2, "ellipsis"), " ...")))), v().createElement("div", G(r2, "string"), v().createElement(Q, Object.assign({ type_name: "string" }, t4)), v().createElement("span", Object.assign({ className: "string-value" }, i2, { onClick: this.toggleCollapsed }), '"', o2, '"'));
          } }]);
        })(v().PureComponent), pe = (function(e3) {
          function t3() {
            return i(this, t3), p(this, t3, arguments);
          }
          return h(t3, e3), c(t3, [{ key: "render", value: function() {
            return v().createElement("div", G(this.props.theme, "undefined"), "undefined");
          } }]);
        })(v().PureComponent), fe = (function(e3) {
          function t3() {
            return i(this, t3), p(this, t3, arguments);
          }
          return h(t3, e3), c(t3, [{ key: "render", value: function() {
            var e4 = this.props;
            return v().createElement("div", G(e4.theme, "bigNumber"), v().createElement(Q, Object.assign({ type_name: "bigNumber" }, e4)), this.props.value.toString());
          } }]);
        })(v().PureComponent);
        function he() {
          return he = Object.assign ? Object.assign.bind() : function(e3) {
            for (var t3 = 1; t3 < arguments.length; t3++) {
              var a3 = arguments[t3];
              for (var r2 in a3) ({}).hasOwnProperty.call(a3, r2) && (e3[r2] = a3[r2]);
            }
            return e3;
          }, he.apply(null, arguments);
        }
        const me = m.useLayoutEffect;
        var ve = function(e3, t3) {
          "function" != typeof e3 ? e3.current = t3 : e3(t3);
        };
        const ge = function(e3, t3) {
          var a3 = (0, m.useRef)();
          return (0, m.useCallback)((function(r2) {
            e3.current = r2, a3.current && ve(a3.current, null), a3.current = t3, t3 && ve(t3, r2);
          }), [t3]);
        };
        var ye = { "min-height": "0", "max-height": "none", height: "0", visibility: "hidden", overflow: "hidden", position: "absolute", "z-index": "-1000", top: "0", right: "0", display: "block" }, ke = function(e3) {
          Object.keys(ye).forEach((function(t3) {
            e3.style.setProperty(t3, ye[t3], "important");
          }));
        }, Ee = null, we = function(e3, t3) {
          var a3 = e3.scrollHeight;
          return "border-box" === t3.sizingStyle.boxSizing ? a3 + t3.borderSize : a3 - t3.paddingSize;
        };
        var je = function() {
        }, xe = ["borderBottomWidth", "borderLeftWidth", "borderRightWidth", "borderTopWidth", "boxSizing", "fontFamily", "fontSize", "fontStyle", "fontWeight", "letterSpacing", "lineHeight", "paddingBottom", "paddingLeft", "paddingRight", "paddingTop", "tabSize", "textIndent", "textRendering", "textTransform", "width", "wordBreak", "wordSpacing", "scrollbarGutter"], Ce = !!document.documentElement.currentStyle, Oe = function(e3) {
          var t3 = window.getComputedStyle(e3);
          if (null === t3) return null;
          var a3, r2 = (a3 = t3, xe.reduce((function(e4, t4) {
            return e4[t4] = a3[t4], e4;
          }), {})), n2 = r2.boxSizing;
          return "" === n2 ? null : (Ce && "border-box" === n2 && (r2.width = parseFloat(r2.width) + parseFloat(r2.borderRightWidth) + parseFloat(r2.borderLeftWidth) + parseFloat(r2.paddingRight) + parseFloat(r2.paddingLeft) + "px"), { sizingStyle: r2, paddingSize: parseFloat(r2.paddingBottom) + parseFloat(r2.paddingTop), borderSize: parseFloat(r2.borderBottomWidth) + parseFloat(r2.borderTopWidth) });
        };
        function Me(e3, t3, a3) {
          var r2, n2, o2 = (r2 = a3, n2 = m.useRef(r2), me((function() {
            n2.current = r2;
          })), n2);
          m.useLayoutEffect((function() {
            var a4 = function(e4) {
              return o2.current(e4);
            };
            if (e3) return e3.addEventListener(t3, a4), function() {
              return e3.removeEventListener(t3, a4);
            };
          }), []);
        }
        var Se = ["cacheMeasurements", "maxRows", "minRows", "onChange", "onHeightChange"], _e = function(e3, t3) {
          var a3 = e3.cacheMeasurements, r2 = e3.maxRows, n2 = e3.minRows, o2 = e3.onChange, s2 = void 0 === o2 ? je : o2, i2 = e3.onHeightChange, l2 = void 0 === i2 ? je : i2, c2 = w(e3, Se), u2 = void 0 !== c2.value, d2 = m.useRef(null), b2 = ge(d2, t3), p2 = m.useRef(0), f2 = m.useRef(), h2 = function() {
            var e4 = d2.current, t4 = a3 && f2.current ? f2.current : Oe(e4);
            if (t4) {
              f2.current = t4;
              var o3 = (function(e5, t5, a4, r3) {
                void 0 === a4 && (a4 = 1), void 0 === r3 && (r3 = 1 / 0), Ee || ((Ee = document.createElement("textarea")).setAttribute("tabindex", "-1"), Ee.setAttribute("aria-hidden", "true"), ke(Ee)), null === Ee.parentNode && document.body.appendChild(Ee);
                var n3 = e5.paddingSize, o4 = e5.borderSize, s4 = e5.sizingStyle, i4 = s4.boxSizing;
                Object.keys(s4).forEach((function(e6) {
                  var t6 = e6;
                  Ee.style[t6] = s4[t6];
                })), ke(Ee), Ee.value = t5;
                var l3 = we(Ee, e5);
                Ee.value = t5, l3 = we(Ee, e5), Ee.value = "x";
                var c3 = Ee.scrollHeight - n3, u3 = c3 * a4;
                "border-box" === i4 && (u3 = u3 + n3 + o4), l3 = Math.max(u3, l3);
                var d3 = c3 * r3;
                return "border-box" === i4 && (d3 = d3 + n3 + o4), [l3 = Math.min(d3, l3), c3];
              })(t4, e4.value || e4.placeholder || "x", n2, r2), s3 = o3[0], i3 = o3[1];
              p2.current !== s3 && (p2.current = s3, e4.style.setProperty("height", s3 + "px", "important"), l2(s3, { rowHeight: i3 }));
            }
          };
          return m.useLayoutEffect(h2), (function(e4, t4) {
            Me(document.body, "reset", (function(a4) {
              e4.current.form === a4.target && t4(a4);
            }));
          })(d2, (function() {
            if (!u2) {
              var e4 = d2.current.value;
              requestAnimationFrame((function() {
                var t4 = d2.current;
                t4 && e4 !== t4.value && h2();
              }));
            }
          })), Me(window, "resize", h2), (function(e4) {
            Me(document.fonts, "loadingdone", e4);
          })(h2), m.createElement("textarea", he({}, c2, { onChange: function(e4) {
            u2 || h2(), s2(e4);
          }, ref: b2 }));
        }, Ae = m.forwardRef(_e);
        function Fe(e3, t3) {
          e3 = e3.trim();
          try {
            if ("[" === (e3 = structuredClone(e3))[0]) return Pe("array", JSON.parse(e3));
            if ("{" === e3[0]) return Pe("object", JSON.parse(e3));
            if (e3.match(/\-?\d+\.\d+/) && e3.match(/\-?\d+\.\d+/)[0] === e3) return t3 && parseFloat(e3).toString() !== e3 ? Pe("bigNumber", e3) : Pe("float", parseFloat(e3));
            if (e3.match(/\-?\d+e-\d+/) && e3.match(/\-?\d+e-\d+/)[0] === e3) return Pe("float", Number(e3));
            if (e3.match(/\-?\d+/) && e3.match(/\-?\d+/)[0] === e3) return t3 && parseInt(e3).toString() !== e3 ? Pe("bigNumber", e3) : Pe("integer", parseInt(e3));
            if (e3.match(/\-?\d+e\+\d+/) && e3.match(/\-?\d+e\+\d+/)[0] === e3) return Pe("integer", Number(e3));
          } catch (e4) {
          }
          switch (e3 = e3.toLowerCase()) {
            case "undefined":
              return Pe("undefined", void 0);
            case "nan":
              return Pe("nan", NaN);
            case "null":
              return Pe("null", null);
            case "true":
              return Pe("boolean", true);
            case "false":
              return Pe("boolean", false);
            default:
              if (e3 = Date.parse(e3)) return Pe("date", new Date(e3));
          }
          return Pe(false, null);
        }
        function Pe(e3, t3) {
          return { type: e3, value: t3 };
        }
        var Re = ["style"], De = ["style"], Ie = ["style"], ze = ["style"], Be = ["style"], Ne = ["style"], Le = ["style"], qe = ["style"], Ve = ["style"], Te = ["style"], Ke = ["style"], We = ["style"], Ue = (function(e3) {
          function t3() {
            return i(this, t3), p(this, t3, arguments);
          }
          return h(t3, e3), c(t3, [{ key: "render", value: function() {
            var e4 = this.props, t4 = e4.style, a3 = j(e4, Re);
            return v().createElement("span", a3, v().createElement("svg", Object.assign({}, rt(t4), { viewBox: "0 0 24 24", fill: "currentColor", preserveAspectRatio: "xMidYMid meet" }), v().createElement("path", { d: "M12,20C7.59,20 4,16.41 4,12C4,7.59 7.59,4 12,4C16.41,4 20,7.59 20,12C20,16.41 16.41,20 12,20M12,2A10,10 0 0,0 2,12A10,10 0 0,0 12,22A10,10 0 0,0 22,12A10,10 0 0,0 12,2M7,13H17V11H7" })));
          } }]);
        })(v().PureComponent), He = (function(e3) {
          function t3() {
            return i(this, t3), p(this, t3, arguments);
          }
          return h(t3, e3), c(t3, [{ key: "render", value: function() {
            var e4 = this.props, t4 = e4.style, a3 = j(e4, De);
            return v().createElement("span", a3, v().createElement("svg", Object.assign({}, rt(t4), { viewBox: "0 0 24 24", fill: "currentColor", preserveAspectRatio: "xMidYMid meet" }), v().createElement("path", { d: "M12,20C7.59,20 4,16.41 4,12C4,7.59 7.59,4 12,4C16.41,4 20,7.59 20,12C20,16.41 16.41,20 12,20M12,2A10,10 0 0,0 2,12A10,10 0 0,0 12,22A10,10 0 0,0 22,12A10,10 0 0,0 12,2M13,7H11V11H7V13H11V17H13V13H17V11H13V7Z" })));
          } }]);
        })(v().PureComponent), $e = (function(e3) {
          function t3() {
            return i(this, t3), p(this, t3, arguments);
          }
          return h(t3, e3), c(t3, [{ key: "render", value: function() {
            var e4 = this.props, t4 = e4.style, a3 = j(e4, Ie), r2 = rt(t4).style;
            return v().createElement("span", a3, v().createElement("svg", { fill: r2.color, width: r2.height, height: r2.width, style: r2, viewBox: "0 0 1792 1792" }, v().createElement("path", { d: "M1344 800v64q0 14-9 23t-23 9h-832q-14 0-23-9t-9-23v-64q0-14 9-23t23-9h832q14 0 23 9t9 23zm128 448v-832q0-66-47-113t-113-47h-832q-66 0-113 47t-47 113v832q0 66 47 113t113 47h832q66 0 113-47t47-113zm128-832v832q0 119-84.5 203.5t-203.5 84.5h-832q-119 0-203.5-84.5t-84.5-203.5v-832q0-119 84.5-203.5t203.5-84.5h832q119 0 203.5 84.5t84.5 203.5z" })));
          } }]);
        })(v().PureComponent), Ye = (function(e3) {
          function t3() {
            return i(this, t3), p(this, t3, arguments);
          }
          return h(t3, e3), c(t3, [{ key: "render", value: function() {
            var e4 = this.props, t4 = e4.style, a3 = j(e4, ze), r2 = rt(t4).style;
            return v().createElement("span", a3, v().createElement("svg", { fill: r2.color, width: r2.height, height: r2.width, style: r2, viewBox: "0 0 1792 1792" }, v().createElement("path", { d: "M1344 800v64q0 14-9 23t-23 9h-352v352q0 14-9 23t-23 9h-64q-14 0-23-9t-9-23v-352h-352q-14 0-23-9t-9-23v-64q0-14 9-23t23-9h352v-352q0-14 9-23t23-9h64q14 0 23 9t9 23v352h352q14 0 23 9t9 23zm128 448v-832q0-66-47-113t-113-47h-832q-66 0-113 47t-47 113v832q0 66 47 113t113 47h832q66 0 113-47t47-113zm128-832v832q0 119-84.5 203.5t-203.5 84.5h-832q-119 0-203.5-84.5t-84.5-203.5v-832q0-119 84.5-203.5t203.5-84.5h832q119 0 203.5 84.5t84.5 203.5z" })));
          } }]);
        })(v().PureComponent), Je = (function(e3) {
          function t3() {
            return i(this, t3), p(this, t3, arguments);
          }
          return h(t3, e3), c(t3, [{ key: "render", value: function() {
            var e4 = this.props, t4 = e4.style, a3 = j(e4, Be);
            return v().createElement("span", a3, v().createElement("svg", { style: s(s({}, rt(t4).style), {}, { paddingLeft: "2px", verticalAlign: "top" }), viewBox: "0 0 15 15", fill: "currentColor" }, v().createElement("path", { d: "M0 14l6-6-6-6z" })));
          } }]);
        })(v().PureComponent), Ge = (function(e3) {
          function t3() {
            return i(this, t3), p(this, t3, arguments);
          }
          return h(t3, e3), c(t3, [{ key: "render", value: function() {
            var e4 = this.props, t4 = e4.style, a3 = j(e4, Ne);
            return v().createElement("span", a3, v().createElement("svg", { style: s(s({}, rt(t4).style), {}, { paddingLeft: "2px", verticalAlign: "top" }), viewBox: "0 0 15 15", fill: "currentColor" }, v().createElement("path", { d: "M0 5l6 6 6-6z" })));
          } }]);
        })(v().PureComponent), Qe = (function(e3) {
          function t3() {
            return i(this, t3), p(this, t3, arguments);
          }
          return h(t3, e3), c(t3, [{ key: "render", value: function() {
            var e4 = this.props, t4 = e4.style, a3 = j(e4, Le);
            return v().createElement("span", a3, v().createElement("svg", Object.assign({}, rt(t4), { viewBox: "0 0 40 40", fill: "currentColor", preserveAspectRatio: "xMidYMid meet" }), v().createElement("g", null, v().createElement("path", { d: "m30 35h-25v-22.5h25v7.5h2.5v-12.5c0-1.4-1.1-2.5-2.5-2.5h-7.5c0-2.8-2.2-5-5-5s-5 2.2-5 5h-7.5c-1.4 0-2.5 1.1-2.5 2.5v27.5c0 1.4 1.1 2.5 2.5 2.5h25c1.4 0 2.5-1.1 2.5-2.5v-5h-2.5v5z m-20-27.5h2.5s2.5-1.1 2.5-2.5 1.1-2.5 2.5-2.5 2.5 1.1 2.5 2.5 1.3 2.5 2.5 2.5h2.5s2.5 1.1 2.5 2.5h-20c0-1.5 1.1-2.5 2.5-2.5z m-2.5 20h5v-2.5h-5v2.5z m17.5-5v-5l-10 7.5 10 7.5v-5h12.5v-5h-12.5z m-17.5 10h7.5v-2.5h-7.5v2.5z m12.5-17.5h-12.5v2.5h12.5v-2.5z m-7.5 5h-5v2.5h5v-2.5z" }))));
          } }]);
        })(v().PureComponent), Ze = (function(e3) {
          function t3() {
            return i(this, t3), p(this, t3, arguments);
          }
          return h(t3, e3), c(t3, [{ key: "render", value: function() {
            var e4 = this.props, t4 = e4.style, a3 = j(e4, qe);
            return v().createElement("span", a3, v().createElement("svg", Object.assign({}, rt(t4), { viewBox: "0 0 40 40", fill: "currentColor", preserveAspectRatio: "xMidYMid meet" }), v().createElement("g", null, v().createElement("path", { d: "m28.6 25q0-0.5-0.4-1l-4-4 4-4q0.4-0.5 0.4-1 0-0.6-0.4-1.1l-2-2q-0.4-0.4-1-0.4-0.6 0-1 0.4l-4.1 4.1-4-4.1q-0.4-0.4-1-0.4-0.6 0-1 0.4l-2 2q-0.5 0.5-0.5 1.1 0 0.5 0.5 1l4 4-4 4q-0.5 0.5-0.5 1 0 0.7 0.5 1.1l2 2q0.4 0.4 1 0.4 0.6 0 1-0.4l4-4.1 4.1 4.1q0.4 0.4 1 0.4 0.6 0 1-0.4l2-2q0.4-0.4 0.4-1z m8.7-5q0 4.7-2.3 8.6t-6.3 6.2-8.6 2.3-8.6-2.3-6.2-6.2-2.3-8.6 2.3-8.6 6.2-6.2 8.6-2.3 8.6 2.3 6.3 6.2 2.3 8.6z" }))));
          } }]);
        })(v().PureComponent), Xe = (function(e3) {
          function t3() {
            return i(this, t3), p(this, t3, arguments);
          }
          return h(t3, e3), c(t3, [{ key: "render", value: function() {
            var e4 = this.props, t4 = e4.style, a3 = j(e4, Ve);
            return v().createElement("span", a3, v().createElement("svg", Object.assign({}, rt(t4), { viewBox: "0 0 40 40", fill: "currentColor", preserveAspectRatio: "xMidYMid meet" }), v().createElement("g", null, v().createElement("path", { d: "m30.1 21.4v-2.8q0-0.6-0.4-1t-1-0.5h-5.7v-5.7q0-0.6-0.4-1t-1-0.4h-2.9q-0.6 0-1 0.4t-0.4 1v5.7h-5.7q-0.6 0-1 0.5t-0.5 1v2.8q0 0.6 0.5 1t1 0.5h5.7v5.7q0 0.5 0.4 1t1 0.4h2.9q0.6 0 1-0.4t0.4-1v-5.7h5.7q0.6 0 1-0.5t0.4-1z m7.2-1.4q0 4.7-2.3 8.6t-6.3 6.2-8.6 2.3-8.6-2.3-6.2-6.2-2.3-8.6 2.3-8.6 6.2-6.2 8.6-2.3 8.6 2.3 6.3 6.2 2.3 8.6z" }))));
          } }]);
        })(v().PureComponent), et = (function(e3) {
          function t3() {
            return i(this, t3), p(this, t3, arguments);
          }
          return h(t3, e3), c(t3, [{ key: "render", value: function() {
            var e4 = this.props, t4 = e4.style, a3 = j(e4, Te);
            return v().createElement("span", a3, v().createElement("svg", Object.assign({}, rt(t4), { viewBox: "0 0 40 40", fill: "currentColor", preserveAspectRatio: "xMidYMid meet" }), v().createElement("g", null, v().createElement("path", { d: "m31.6 21.6h-10v10h-3.2v-10h-10v-3.2h10v-10h3.2v10h10v3.2z" }))));
          } }]);
        })(v().PureComponent), tt = (function(e3) {
          function t3() {
            return i(this, t3), p(this, t3, arguments);
          }
          return h(t3, e3), c(t3, [{ key: "render", value: function() {
            var e4 = this.props, t4 = e4.style, a3 = j(e4, Ke);
            return v().createElement("span", a3, v().createElement("svg", Object.assign({}, rt(t4), { viewBox: "0 0 40 40", fill: "currentColor", preserveAspectRatio: "xMidYMid meet" }), v().createElement("g", null, v().createElement("path", { d: "m19.8 26.4l2.6-2.6-3.4-3.4-2.6 2.6v1.3h2.2v2.1h1.2z m9.8-16q-0.3-0.4-0.7 0l-7.8 7.8q-0.4 0.4 0 0.7t0.7 0l7.8-7.8q0.4-0.4 0-0.7z m1.8 13.2v4.3q0 2.6-1.9 4.5t-4.5 1.9h-18.6q-2.6 0-4.5-1.9t-1.9-4.5v-18.6q0-2.7 1.9-4.6t4.5-1.8h18.6q1.4 0 2.6 0.5 0.3 0.2 0.4 0.5 0.1 0.4-0.2 0.7l-1.1 1.1q-0.3 0.3-0.7 0.1-0.5-0.1-1-0.1h-18.6q-1.4 0-2.5 1.1t-1 2.5v18.6q0 1.4 1 2.5t2.5 1h18.6q1.5 0 2.5-1t1.1-2.5v-2.9q0-0.2 0.2-0.4l1.4-1.5q0.3-0.3 0.8-0.1t0.4 0.6z m-2.1-16.5l6.4 6.5-15 15h-6.4v-6.5z m9.9 3l-2.1 2-6.4-6.4 2.1-2q0.6-0.7 1.5-0.7t1.5 0.7l3.4 3.4q0.6 0.6 0.6 1.5t-0.6 1.5z" }))));
          } }]);
        })(v().PureComponent), at = (function(e3) {
          function t3() {
            return i(this, t3), p(this, t3, arguments);
          }
          return h(t3, e3), c(t3, [{ key: "render", value: function() {
            var e4 = this.props, t4 = e4.style, a3 = j(e4, We);
            return v().createElement("span", a3, v().createElement("svg", Object.assign({}, rt(t4), { viewBox: "0 0 40 40", fill: "currentColor", preserveAspectRatio: "xMidYMid meet" }), v().createElement("g", null, v().createElement("path", { d: "m31.7 16.4q0-0.6-0.4-1l-2.1-2.1q-0.4-0.4-1-0.4t-1 0.4l-9.1 9.1-5-5q-0.5-0.4-1-0.4t-1 0.4l-2.1 2q-0.4 0.4-0.4 1 0 0.6 0.4 1l8.1 8.1q0.4 0.4 1 0.4 0.6 0 1-0.4l12.2-12.1q0.4-0.4 0.4-1z m5.6 3.6q0 4.7-2.3 8.6t-6.3 6.2-8.6 2.3-8.6-2.3-6.2-6.2-2.3-8.6 2.3-8.6 6.2-6.2 8.6-2.3 8.6 2.3 6.3 6.2 2.3 8.6z" }))));
          } }]);
        })(v().PureComponent);
        function rt(e3) {
          return e3 || (e3 = {}), { style: s(s({ verticalAlign: "middle" }, e3), {}, { color: e3.color ? e3.color : "#000000", height: "1em", width: "1em" }) };
        }
        var nt = (function(e3) {
          function t3(e4) {
            var a3;
            return i(this, t3), (a3 = p(this, t3, [e4])).copiedTimer = null, a3.copyToClipboardFallback = function(e5) {
              var t4 = document.createElement("textarea");
              t4.value = e5, document.body.appendChild(t4), t4.select(), document.execCommand("copy"), document.body.removeChild(t4);
            }, a3.handleCopy = function() {
              var e5 = a3.props, t4 = e5.clickCallback, r2 = e5.src, n2 = e5.namespace, o2 = JSON.stringify(a3.clipboardValue(r2), null, "  ");
              navigator.clipboard ? navigator.clipboard.writeText(o2).catch((function() {
                a3.copyToClipboardFallback(o2);
              })) : a3.copyToClipboardFallback(o2), a3.copiedTimer = setTimeout((function() {
                a3.setState({ copied: false });
              }), 5500), a3.setState({ copied: true }, (function() {
                "function" == typeof t4 && t4({ src: r2, namespace: n2, name: n2[n2.length - 1] });
              }));
            }, a3.getClippyIcon = function() {
              var e5 = a3.props.theme;
              return a3.state.copied ? v().createElement("span", null, v().createElement(Qe, Object.assign({ className: "copy-icon" }, G(e5, "copy-icon"))), v().createElement("span", G(e5, "copy-icon-copied"), "✔")) : v().createElement(Qe, Object.assign({ className: "copy-icon" }, G(e5, "copy-icon")));
            }, a3.clipboardValue = function(e5) {
              switch (x(e5)) {
                case "function":
                case "regexp":
                  return e5.toString();
                default:
                  return e5;
              }
            }, a3.state = { copied: false }, a3;
          }
          return h(t3, e3), c(t3, [{ key: "componentWillUnmount", value: function() {
            this.copiedTimer && (clearTimeout(this.copiedTimer), this.copiedTimer = null);
          } }, { key: "render", value: function() {
            var e4 = this.props, t4 = (e4.src, e4.theme), a3 = e4.hidden, r2 = e4.rowHovered, n2 = G(t4, "copy-to-clipboard").style, o2 = "inline";
            return a3 && (o2 = "none"), v().createElement("span", { className: "copy-to-clipboard-container", title: "Copy to clipboard", style: { verticalAlign: "top", display: r2 ? "inline-block" : "none" } }, v().createElement("span", { style: s(s({}, n2), {}, { display: o2 }), onClick: this.handleCopy }, this.getClippyIcon()));
          } }]);
        })(v().PureComponent);
        const ot = (function(e3) {
          function t3(e4) {
            var a3;
            return i(this, t3), (a3 = p(this, t3, [e4])).getEditIcon = function() {
              var e5 = a3.props, t4 = e5.variable, r2 = e5.theme;
              return v().createElement("div", { className: "click-to-edit", style: { verticalAlign: "top", display: a3.state.hovered ? "inline-block" : "none" } }, v().createElement(tt, Object.assign({ className: "click-to-edit-icon" }, G(r2, "editVarIcon"), { onClick: function() {
                a3.prepopInput(t4);
              } })));
            }, a3.prepopInput = function(e5) {
              if (false !== a3.props.onEdit) {
                var t4 = (function(e6, t5) {
                  var a4;
                  switch (x(e6, t5)) {
                    case "undefined":
                      a4 = "undefined";
                      break;
                    case "nan":
                      a4 = "NaN";
                      break;
                    case "string":
                      a4 = e6;
                      break;
                    case "bigNumber":
                    case "date":
                    case "function":
                    case "regexp":
                      a4 = e6.toString();
                      break;
                    default:
                      try {
                        a4 = JSON.stringify(e6, null, "  ");
                      } catch (e7) {
                        a4 = "";
                      }
                  }
                  return a4;
                })(e5.value, a3.props.bigNumber), r2 = Fe(t4, a3.props.bigNumber);
                a3.setState({ editMode: true, editValue: t4, parsedInput: { type: r2.type, value: r2.value } });
              }
            }, a3.getRemoveIcon = function() {
              var e5 = a3.props, t4 = e5.variable, r2 = e5.namespace, n2 = e5.theme, o2 = e5.rjvId;
              return v().createElement("div", { className: "click-to-remove", style: { verticalAlign: "top", display: a3.state.hovered ? "inline-block" : "none" } }, v().createElement(Ze, Object.assign({ className: "click-to-remove-icon" }, G(n2, "removeVarIcon"), { onClick: function() {
                ne.dispatch({ name: "VARIABLE_REMOVED", rjvId: o2, data: { name: t4.name, namespace: r2, existing_value: t4.value, variable_removed: true } });
              } })));
            }, a3.getValue = function(e5, t4) {
              var r2 = !t4 && e5.type, n2 = a3.props;
              switch (r2) {
                case false:
                  return a3.getEditInput();
                case "string":
                  return v().createElement(be, Object.assign({ value: e5.value }, n2));
                case "integer":
                  return v().createElement(ue, Object.assign({ value: e5.value }, n2));
                case "float":
                  return v().createElement(ee, Object.assign({ value: e5.value }, n2));
                case "boolean":
                  return v().createElement(Z, Object.assign({ value: e5.value }, n2));
                case "function":
                  return v().createElement(ie, Object.assign({ value: e5.value }, n2));
                case "null":
                  return v().createElement(ce, n2);
                case "nan":
                  return v().createElement(le, n2);
                case "undefined":
                  return v().createElement(pe, n2);
                case "date":
                  return v().createElement(X2, Object.assign({ value: e5.value }, n2));
                case "regexp":
                  return v().createElement(de, Object.assign({ value: e5.value }, n2));
                case "bigNumber":
                  return v().createElement(fe, Object.assign({ value: e5.value }, n2));
                default:
                  return v().createElement("div", { className: "object-value" }, JSON.stringify(e5.value));
              }
            }, a3.getEditInput = function() {
              var e5 = a3.props, t4 = e5.keyModifier, r2 = e5.selectOnFocus, n2 = e5.theme, o2 = a3.state.editValue;
              return v().createElement("div", null, v().createElement(Ae, Object.assign({ type: "text", ref: function(e6) {
                e6 && e6[r2 ? "select" : "focus"]();
              }, value: o2, className: "variable-editor", onChange: function(e6) {
                var t5 = e6.target.value, r3 = Fe(t5, a3.props.bigNumber);
                a3.setState({ editValue: t5, parsedInput: { type: r3.type, value: r3.value } });
              }, onKeyDown: function(e6) {
                switch (e6.key) {
                  case "Escape":
                    a3.setState({ editMode: false, editValue: "" });
                    break;
                  case "Enter":
                    t4(e6, "submit") && a3.submitEdit(true);
                }
                e6.stopPropagation();
              }, placeholder: "update this value", minRows: 2 }, G(n2, "edit-input"))), v().createElement("div", G(n2, "edit-icon-container"), v().createElement(Ze, Object.assign({ className: "edit-cancel" }, G(n2, "cancel-icon"), { onClick: function(e6) {
                e6 && e6.stopPropagation(), a3.setState({ editMode: false, editValue: "" });
              } })), v().createElement(at, Object.assign({ className: "edit-check string-value" }, G(n2, "check-icon"), { onClick: function(e6) {
                e6 && e6.stopPropagation(), a3.submitEdit();
              } })), v().createElement("div", null, a3.showDetected())));
            }, a3.submitEdit = function(e5) {
              var t4 = a3.props, r2 = t4.variable, n2 = t4.namespace, o2 = t4.rjvId, s2 = t4.bigNumber, i2 = a3.state, l2 = i2.editValue, c2 = i2.parsedInput, u2 = l2;
              e5 && c2.type && (u2 = c2.value, s2 && "bigNumber" === c2.type && (u2 = new s2(u2))), a3.setState({ editMode: false }), ne.dispatch({ name: "VARIABLE_UPDATED", rjvId: o2, data: { name: r2.name, namespace: n2, existing_value: r2.value, new_value: u2, variable_removed: false } });
            }, a3.showDetected = function() {
              var e5 = a3.props, t4 = e5.theme, r2 = (e5.variable, e5.namespace, e5.rjvId, a3.state.parsedInput), n2 = (r2.type, r2.value, a3.getDetectedInput());
              if (n2) return v().createElement("div", null, v().createElement("div", G(t4, "detected-row"), n2, v().createElement(at, { className: "edit-check detected", style: s({ verticalAlign: "top", paddingLeft: "3px" }, G(t4, "check-icon").style), onClick: function(e6) {
                e6 && e6.stopPropagation(), a3.submitEdit(true);
              } })));
            }, a3.getDetectedInput = function() {
              var e5 = a3.state.parsedInput, t4 = e5.type, r2 = e5.value, n2 = a3.props, o2 = n2.theme;
              if (false !== t4) switch (t4.toLowerCase()) {
                case "object":
                  return v().createElement("span", null, v().createElement("span", { style: s(s({}, G(o2, "brace").style), {}, { cursor: "default" }) }, "{"), v().createElement("span", { style: s(s({}, G(o2, "ellipsis").style), {}, { cursor: "default" }) }, "..."), v().createElement("span", { style: s(s({}, G(o2, "brace").style), {}, { cursor: "default" }) }, "}"));
                case "array":
                  return v().createElement("span", null, v().createElement("span", { style: s(s({}, G(o2, "brace").style), {}, { cursor: "default" }) }, "["), v().createElement("span", { style: s(s({}, G(o2, "ellipsis").style), {}, { cursor: "default" }) }, "..."), v().createElement("span", { style: s(s({}, G(o2, "brace").style), {}, { cursor: "default" }) }, "]"));
                case "string":
                  return v().createElement(be, Object.assign({ value: r2 }, n2));
                case "integer":
                  return v().createElement(ue, Object.assign({ value: r2 }, n2));
                case "float":
                  return v().createElement(ee, Object.assign({ value: r2 }, n2));
                case "boolean":
                  return v().createElement(Z, Object.assign({ value: r2 }, n2));
                case "function":
                  return v().createElement(ie, Object.assign({ value: r2 }, n2));
                case "null":
                  return v().createElement(ce, n2);
                case "nan":
                  return v().createElement(le, n2);
                case "undefined":
                  return v().createElement(pe, n2);
                case "date":
                  return v().createElement(X2, Object.assign({ value: new Date(r2) }, n2));
                case "bignumber":
                  return v().createElement(fe, Object.assign({ value: r2 }, n2));
              }
            }, a3.state = { editMode: false, editValue: "", hovered: false, renameKey: false, parsedInput: { type: false, value: null } }, a3;
          }
          return h(t3, e3), c(t3, [{ key: "render", value: function() {
            var e4 = this, t4 = this.props, a3 = t4.variable, r2 = t4.singleIndent, n2 = t4.type, o2 = t4.theme, i2 = t4.namespace, l2 = t4.indentWidth, c2 = t4.enableClipboard, u2 = t4.onEdit, d2 = t4.onDelete, b2 = t4.onSelect, p2 = t4.displayArrayKey, f2 = t4.quotesOnKeys, h2 = t4.keyModifier, m2 = t4.showComma, g2 = t4.isLast, y2 = this.state.editMode;
            return v().createElement("div", Object.assign({}, G(o2, "objectKeyVal", { paddingLeft: l2 * r2 }), { onMouseEnter: function() {
              return e4.setState(s(s({}, e4.state), {}, { hovered: true }));
            }, onMouseLeave: function() {
              return e4.setState(s(s({}, e4.state), {}, { hovered: false }));
            }, className: "variable-row", key: a3.name }), "array" == n2 ? p2 ? v().createElement("span", Object.assign({}, G(o2, "array-key"), { key: a3.name + "_" + i2 }), a3.name, v().createElement("div", G(o2, "colon"), ":")) : null : v().createElement("span", null, v().createElement("span", Object.assign({}, G(o2, "object-name"), { className: "object-key", key: a3.name + "_" + i2 }), !!f2 && v().createElement("span", { style: { verticalAlign: "top" } }, '"'), v().createElement("span", { style: { display: "inline-block" } }, C(a3.name)), !!f2 && v().createElement("span", { style: { verticalAlign: "top" } }, '"')), v().createElement("span", G(o2, "colon"), ":")), v().createElement("div", Object.assign({ className: "variable-value", onClick: false === b2 && false === u2 ? null : function(t5) {
              var r3 = te(i2);
              h2(t5, "edit") && false !== u2 ? e4.prepopInput(a3) : false !== b2 && (r3.shift(), b2(s(s({}, a3), {}, { namespace: r3 })));
            } }, G(o2, "variableValue", { cursor: false === b2 ? "default" : "pointer" })), this.getValue(a3, y2)), m2 && !g2 && v().createElement("span", G(o2, "comma"), ","), c2 ? v().createElement(nt, { rowHovered: this.state.hovered, hidden: y2, src: a3.value, clickCallback: c2, theme: o2, namespace: [].concat(te(i2), [a3.name]) }) : null, false !== u2 && 0 == y2 ? this.getEditIcon() : null, false !== d2 && 0 == y2 ? this.getRemoveIcon() : null);
          } }]);
        })(v().PureComponent);
        var st = (function(e3) {
          function t3() {
            var e4;
            i(this, t3);
            for (var a3 = arguments.length, r2 = new Array(a3), n2 = 0; n2 < a3; n2++) r2[n2] = arguments[n2];
            return (e4 = p(this, t3, [].concat(r2))).getObjectSize = function() {
              var t4 = e4.props, a4 = t4.size, r3 = t4.theme;
              if (t4.displayObjectSize) return v().createElement("span", Object.assign({ className: "object-size" }, G(r3, "object-size")), a4, " item", 1 === a4 ? "" : "s");
            }, e4.getAddAttribute = function(t4) {
              var a4 = e4.props, r3 = a4.theme, n3 = a4.namespace, o2 = a4.name, i2 = a4.src, l2 = a4.rjvId, c2 = a4.depth;
              return v().createElement("span", { className: "click-to-add", style: { verticalAlign: "top", display: t4 ? "inline-block" : "none" } }, v().createElement(Xe, Object.assign({ className: "click-to-add-icon" }, G(r3, "addVarIcon"), { onClick: function() {
                var e5 = { name: c2 > 0 ? o2 : null, namespace: n3.splice(0, n3.length - 1), existing_value: i2, variable_removed: false, key_name: null };
                "object" === x(i2) ? ne.dispatch({ name: "ADD_VARIABLE_KEY_REQUEST", rjvId: l2, data: e5 }) : ne.dispatch({ name: "VARIABLE_ADDED", rjvId: l2, data: s(s({}, e5), {}, { new_value: [].concat(te(i2), [null]) }) });
              } })));
            }, e4.getRemoveObject = function(t4) {
              var a4 = e4.props, r3 = a4.theme, n3 = (a4.hover, a4.namespace), o2 = a4.name, s2 = a4.src, i2 = a4.rjvId;
              if (1 !== n3.length) return v().createElement("span", { className: "click-to-remove", style: { display: t4 ? "inline-block" : "none" } }, v().createElement(Ze, Object.assign({ className: "click-to-remove-icon" }, G(r3, "removeVarIcon"), { onClick: function() {
                ne.dispatch({ name: "VARIABLE_REMOVED", rjvId: i2, data: { name: o2, namespace: n3.splice(0, n3.length - 1), existing_value: s2, variable_removed: true } });
              } })));
            }, e4.render = function() {
              var t4 = e4.props, a4 = t4.theme, r3 = t4.onDelete, n3 = t4.onAdd, o2 = t4.enableClipboard, s2 = t4.src, i2 = t4.namespace, l2 = t4.rowHovered;
              return v().createElement("div", Object.assign({}, G(a4, "object-meta-data"), { className: "object-meta-data", onClick: function(e5) {
                e5.stopPropagation();
              } }), e4.getObjectSize(), o2 ? v().createElement(nt, { rowHovered: l2, clickCallback: o2, src: s2, theme: a4, namespace: i2 }) : null, false !== n3 ? e4.getAddAttribute(l2) : null, false !== r3 ? e4.getRemoveObject(l2) : null);
            }, e4;
          }
          return h(t3, e3), c(t3);
        })(v().PureComponent);
        function it(e3) {
          var t3 = e3.parent_type, a3 = e3.namespace, r2 = e3.quotesOnKeys, n2 = e3.theme, o2 = e3.jsvRoot, s2 = e3.name, i2 = e3.displayArrayKey, l2 = e3.name ? e3.name : "";
          return !o2 || false !== s2 && null !== s2 ? "array" == t3 ? i2 ? v().createElement("span", Object.assign({}, G(n2, "array-key"), { key: a3 }), v().createElement("span", { className: "array-key" }, l2), v().createElement("span", G(n2, "colon"), ":")) : v().createElement("span", null) : v().createElement("span", Object.assign({}, G(n2, "object-name"), { key: a3 }), v().createElement("span", { className: "object-key" }, r2 && v().createElement("span", { style: { verticalAlign: "top" } }, '"'), v().createElement("span", null, l2), r2 && v().createElement("span", { style: { verticalAlign: "top" } }, '"')), v().createElement("span", G(n2, "colon"), ":")) : v().createElement("span", null);
        }
        function lt(e3) {
          var t3 = e3.theme;
          switch (e3.iconStyle) {
            case "triangle":
              return v().createElement(Ge, Object.assign({}, G(t3, "expanded-icon"), { className: "expanded-icon" }));
            case "square":
              return v().createElement($e, Object.assign({}, G(t3, "expanded-icon"), { className: "expanded-icon" }));
            default:
              return v().createElement(Ue, Object.assign({}, G(t3, "expanded-icon"), { className: "expanded-icon" }));
          }
        }
        function ct(e3) {
          var t3 = e3.theme;
          switch (e3.iconStyle) {
            case "triangle":
              return v().createElement(Je, Object.assign({}, G(t3, "collapsed-icon"), { className: "collapsed-icon" }));
            case "square":
              return v().createElement(Ye, Object.assign({}, G(t3, "collapsed-icon"), { className: "collapsed-icon" }));
            default:
              return v().createElement(He, Object.assign({}, G(t3, "collapsed-icon"), { className: "collapsed-icon" }));
          }
        }
        var ut = ["src", "groupArraysAfterLength", "depth", "name", "theme", "jsvRoot", "namespace", "parent_type"], dt = (function(e3) {
          function t3(e4) {
            var a3;
            return i(this, t3), (a3 = p(this, t3, [e4])).toggleCollapsed = function(e5) {
              var t4 = [];
              for (var r2 in a3.state.expanded) t4.push(a3.state.expanded[r2]);
              t4[e5] = !t4[e5], a3.setState({ expanded: t4 });
            }, a3.state = { expanded: [] }, a3;
          }
          return h(t3, e3), c(t3, [{ key: "getExpandedIcon", value: function(e4) {
            var t4 = this.props, a3 = t4.theme, r2 = t4.iconStyle;
            return this.state.expanded[e4] ? v().createElement(lt, { theme: a3, iconStyle: r2 }) : v().createElement(ct, { theme: a3, iconStyle: r2 });
          } }, { key: "render", value: function() {
            var e4 = this, t4 = this.props, a3 = t4.src, r2 = t4.groupArraysAfterLength, n2 = (t4.depth, t4.name), o2 = t4.theme, s2 = t4.jsvRoot, i2 = t4.namespace, l2 = (t4.parent_type, j(t4, ut)), c2 = 0, u2 = 5 * this.props.indentWidth;
            s2 || (c2 = 5 * this.props.indentWidth);
            var d2 = r2, b2 = Math.ceil(a3.length / d2);
            return v().createElement("div", Object.assign({ className: "object-key-val" }, G(o2, s2 ? "jsv-root" : "objectKeyVal", { paddingLeft: c2 })), v().createElement(it, this.props), v().createElement("span", null, v().createElement(st, Object.assign({ size: a3.length }, this.props))), te(Array(b2)).map((function(t5, r3) {
              return v().createElement("div", Object.assign({ key: r3, className: "object-key-val array-group" }, G(o2, "objectKeyVal", { marginLeft: 6, paddingLeft: u2 })), v().createElement("span", G(o2, "brace-row"), v().createElement("div", Object.assign({ className: "icon-container" }, G(o2, "icon-container"), { onClick: function(t6) {
                e4.toggleCollapsed(r3);
              } }), e4.getExpandedIcon(r3)), e4.state.expanded[r3] ? v().createElement(ht, Object.assign({ key: n2 + r3, depth: 0, name: false, collapsed: false, groupArraysAfterLength: d2, index_offset: r3 * d2, src: a3.slice(r3 * d2, r3 * d2 + d2), namespace: i2, type: "array", parent_type: "array_group", theme: o2, showComma: e4.props.showComma, isLast: r3 === b2 - 1 }, l2)) : v().createElement("span", Object.assign({}, G(o2, "brace"), { onClick: function(t6) {
                e4.toggleCollapsed(r3);
              }, className: "array-group-brace" }), "[", v().createElement("div", Object.assign({}, G(o2, "array-group-meta-data"), { className: "array-group-meta-data" }), v().createElement("span", Object.assign({ className: "object-size" }, G(o2, "object-size")), r3 * d2, " - ", r3 * d2 + d2 > a3.length ? a3.length : r3 * d2 + d2)), "]")));
            })));
          } }]);
        })(v().PureComponent), bt = ["depth", "src", "namespace", "name", "type", "parent_type", "theme", "jsvRoot", "iconStyle", "showComma", "isLast"], pt = (function(e3) {
          function t3(e4) {
            var a3;
            i(this, t3), (a3 = p(this, t3, [e4])).toggleCollapsed = function() {
              a3.setState({ expanded: !a3.state.expanded }, (function() {
                se.set(a3.props.rjvId, a3.props.namespace, "expanded", a3.state.expanded);
              }));
            }, a3.getObjectContent = function(e5, t4, r3) {
              return v().createElement("div", { className: "pushed-content object-container" }, v().createElement("div", Object.assign({ className: "object-content" }, G(a3.props.theme, "pushed-content")), a3.renderObjectContents(t4, r3)));
            }, a3.getEllipsis = function() {
              return 0 === a3.state.size ? null : v().createElement("div", Object.assign({}, G(a3.props.theme, "ellipsis"), { className: "node-ellipsis", onClick: a3.toggleCollapsed }), "...");
            }, a3.getObjectMetaData = function(e5) {
              var t4 = a3.props, r3 = (t4.rjvId, t4.theme, a3.state), n2 = r3.size, o2 = r3.hovered;
              return v().createElement(st, Object.assign({ rowHovered: o2, size: n2 }, a3.props));
            }, a3.renderObjectContents = function(e5, t4) {
              var r3, n2 = a3.props, o2 = n2.depth, s2 = n2.parent_type, i2 = n2.index_offset, l2 = n2.groupArraysAfterLength, c2 = n2.namespace, u2 = n2.showComma, d2 = a3.state.object_type, b2 = [], p2 = Object.keys(e5 || {});
              return a3.props.sortKeys && "array" !== d2 && (p2 = p2.sort()), p2.forEach((function(n3, f2) {
                r3 = new ft(n3, e5[n3], t4.bigNumber);
                var h2 = f2 === p2.length - 1;
                if ("array_group" === s2 && i2 && (r3.name = parseInt(r3.name) + i2), Object.prototype.hasOwnProperty.call(e5, n3)) if ("object" === r3.type) b2.push(v().createElement(ht, Object.assign({ key: r3.name, depth: o2 + 1, name: r3.name, src: r3.value, namespace: c2.concat(r3.name), parent_type: d2, isLast: h2, showComma: u2 }, t4)));
                else if ("array" === r3.type) {
                  var m2 = ht;
                  l2 && r3.value.length > l2 && (m2 = dt), b2.push(v().createElement(m2, Object.assign({ key: r3.name, depth: o2 + 1, name: r3.name, src: r3.value, namespace: c2.concat(r3.name), type: "array", parent_type: d2, isLast: h2, showComma: u2 }, t4)));
                } else b2.push(v().createElement(ot, Object.assign({ key: r3.name + "_" + c2, variable: r3, singleIndent: 5, namespace: c2, type: a3.props.type, isLast: h2, showComma: u2 }, t4)));
              })), b2;
            };
            var r2 = t3.getState(e4);
            return a3.state = s(s({}, r2), {}, { prevProps: {} }), a3;
          }
          return h(t3, e3), c(t3, [{ key: "getBraceStart", value: function(e4, t4) {
            var a3 = this, r2 = this.props, n2 = (r2.src, r2.theme), o2 = r2.iconStyle;
            if ("array_group" === r2.parent_type) return v().createElement("span", null, v().createElement("span", G(n2, "brace"), "array" === e4 ? "[" : "{"));
            var s2 = t4 ? lt : ct;
            return v().createElement("span", null, v().createElement("span", Object.assign({ onClick: function(e5) {
              a3.toggleCollapsed();
            } }, G(n2, "brace-row")), v().createElement("div", Object.assign({ className: "icon-container" }, G(n2, "icon-container")), v().createElement(s2, { theme: n2, iconStyle: o2 })), v().createElement(it, this.props), v().createElement("span", G(n2, "brace"), "array" === e4 ? "[" : "{")));
          } }, { key: "render", value: function() {
            var e4 = this, t4 = this.props, a3 = t4.depth, r2 = t4.src, n2 = (t4.namespace, t4.name, t4.type, t4.parent_type), o2 = t4.theme, i2 = t4.jsvRoot, l2 = t4.iconStyle, c2 = t4.showComma, u2 = t4.isLast, d2 = j(t4, bt), b2 = this.state, p2 = b2.object_type, f2 = b2.expanded, h2 = {};
            return i2 || "array_group" === n2 ? "array_group" === n2 && (h2.borderLeft = 0, h2.display = "inline") : h2.paddingLeft = 5 * this.props.indentWidth, v().createElement("div", Object.assign({ className: "object-key-val", onMouseEnter: function() {
              return e4.setState(s(s({}, e4.state), {}, { hovered: true }));
            }, onMouseLeave: function() {
              return e4.setState(s(s({}, e4.state), {}, { hovered: false }));
            } }, G(o2, i2 ? "jsv-root" : "objectKeyVal", h2)), this.getBraceStart(p2, f2), f2 ? this.getObjectContent(a3, r2, s({ theme: o2, iconStyle: l2 }, d2)) : this.getEllipsis(), v().createElement("span", { className: "brace-row" }, v().createElement("span", { style: s(s({}, G(o2, "brace").style), {}, { paddingLeft: f2 ? "3px" : "0px" }) }, "array" === p2 ? "]" : "}")), c2 && !u2 && !i2 && v().createElement("span", G(o2, "comma"), ","), this.getObjectMetaData(r2));
          } }], [{ key: "getDerivedStateFromProps", value: function(e4, a3) {
            var r2 = a3.prevProps;
            return e4.src !== r2.src || e4.collapsed !== r2.collapsed || e4.name !== r2.name || e4.namespace !== r2.namespace || e4.rjvId !== r2.rjvId ? s(s({}, t3.getState(e4)), {}, { prevProps: e4 }) : null;
          } }]);
        })(v().PureComponent);
        pt.getState = function(e3) {
          var t3 = Object.keys(e3.src).length, a3 = (false === e3.collapsed || true !== e3.collapsed && e3.collapsed > e3.depth) && (!e3.shouldCollapse || false === e3.shouldCollapse({ name: e3.name, src: e3.src, type: x(e3.src), namespace: e3.namespace })) && 0 !== t3;
          return { expanded: se.get(e3.rjvId, e3.namespace, "expanded", a3), object_type: "array" === e3.type ? "array" : "object", parent_type: "array" === e3.type ? "array" : "object", size: t3, hovered: false };
        };
        var ft = c((function e3(t3, a3, r2) {
          i(this, e3), this.name = t3, this.value = a3, this.type = x(a3, r2);
        }));
        E(pt);
        const ht = pt;
        var mt = (function(e3) {
          function t3() {
            var e4;
            i(this, t3);
            for (var a3 = arguments.length, r2 = new Array(a3), n2 = 0; n2 < a3; n2++) r2[n2] = arguments[n2];
            return (e4 = p(this, t3, [].concat(r2))).render = function() {
              var t4, a4, r3, n3, o2 = e4.props, s2 = [o2.name], i2 = ht;
              "object" != typeof o2.name || Array.isArray(o2.name) || (s2 = [(null === (t4 = o2.name) || void 0 === t4 ? void 0 : t4.displayName) || (null === (a4 = o2.name) || void 0 === a4 ? void 0 : a4.name) || (null === (r3 = o2.name) || void 0 === r3 || null === (n3 = r3.type) || void 0 === n3 ? void 0 : n3.name) || "Anonymous"]);
              return Array.isArray(o2.src) && o2.groupArraysAfterLength && o2.src.length > o2.groupArraysAfterLength && (i2 = dt), v().createElement("div", { className: "pretty-json-container object-container" }, v().createElement("div", { className: "object-content" }, v().createElement(i2, Object.assign({ namespace: s2, depth: 0, jsvRoot: true }, o2))));
            }, e4;
          }
          return h(t3, e3), c(t3);
        })(v().PureComponent), vt = (function(e3) {
          function t3(e4) {
            var a3;
            return i(this, t3), (a3 = p(this, t3, [e4])).closeModal = function() {
              ne.dispatch({ rjvId: a3.props.rjvId, name: "RESET" });
            }, a3.submit = function() {
              a3.props.submit(a3.state.input);
            }, a3.state = { input: e4.input ? e4.input : "" }, a3;
          }
          return h(t3, e3), c(t3, [{ key: "render", value: function() {
            var e4 = this, t4 = this.props, a3 = t4.theme, r2 = t4.rjvId, n2 = t4.isValid, o2 = this.state.input, s2 = n2(o2);
            return v().createElement("div", Object.assign({ className: "key-modal-request" }, G(a3, "key-modal-request"), { onClick: this.closeModal }), v().createElement("div", Object.assign({}, G(a3, "key-modal"), { onClick: function(e5) {
              e5.stopPropagation();
            } }), v().createElement("div", G(a3, "key-modal-label"), "Key Name:"), v().createElement("div", { style: { position: "relative" } }, v().createElement("input", Object.assign({}, G(a3, "key-modal-input"), { className: "key-modal-input", ref: function(e5) {
              return e5 && e5.focus();
            }, spellCheck: false, value: o2, placeholder: "...", onChange: function(t5) {
              e4.setState({ input: t5.target.value });
            }, onKeyPress: function(t5) {
              s2 && "Enter" === t5.key ? e4.submit() : "Escape" === t5.key && e4.closeModal();
            } })), s2 ? v().createElement(at, Object.assign({}, G(a3, "key-modal-submit"), { className: "key-modal-submit", onClick: function(t5) {
              return e4.submit();
            } })) : null), v().createElement("span", G(a3, "key-modal-cancel"), v().createElement(et, Object.assign({}, G(a3, "key-modal-cancel-icon"), { className: "key-modal-cancel", onClick: function() {
              ne.dispatch({ rjvId: r2, name: "RESET" });
            } })))));
          } }]);
        })(v().PureComponent), gt = (function(e3) {
          function t3() {
            var e4;
            i(this, t3);
            for (var a3 = arguments.length, r2 = new Array(a3), n2 = 0; n2 < a3; n2++) r2[n2] = arguments[n2];
            return (e4 = p(this, t3, [].concat(r2))).isValid = function(t4) {
              var a4 = e4.props.rjvId, r3 = se.get(a4, "action", "new-key-request");
              return "" != t4 && -1 === Object.keys(r3.existing_value).indexOf(t4);
            }, e4.submit = function(t4) {
              var a4 = e4.props.rjvId, r3 = se.get(a4, "action", "new-key-request");
              r3.new_value = s({}, r3.existing_value), r3.new_value[t4] = e4.props.defaultValue, ne.dispatch({ name: "VARIABLE_ADDED", rjvId: a4, data: r3 });
            }, e4;
          }
          return h(t3, e3), c(t3, [{ key: "render", value: function() {
            var e4 = this.props, t4 = e4.active, a3 = e4.theme, r2 = e4.rjvId;
            return t4 ? v().createElement(vt, { rjvId: r2, theme: a3, isValid: this.isValid, submit: this.submit }) : null;
          } }]);
        })(v().PureComponent), yt = (function(e3) {
          function t3() {
            return i(this, t3), p(this, t3, arguments);
          }
          return h(t3, e3), c(t3, [{ key: "render", value: function() {
            var e4 = this.props, t4 = e4.message, a3 = e4.active, r2 = e4.theme, n2 = e4.rjvId;
            return a3 ? v().createElement("div", Object.assign({ className: "validation-failure" }, G(r2, "validation-failure"), { onClick: function() {
              ne.dispatch({ rjvId: n2, name: "RESET" });
            } }), v().createElement("span", G(r2, "validation-failure-label"), t4), v().createElement(et, G(r2, "validation-failure-clear"))) : null;
          } }]);
        })(v().PureComponent), kt = (function(e3) {
          function t3(e4) {
            var a3;
            return i(this, t3), (a3 = p(this, t3, [e4])).rjvId = Date.now().toString() + Math.random().toString(36).slice(2), a3.getListeners = function() {
              return { reset: a3.resetState, "variable-update": a3.updateSrc, "add-key-request": a3.addKeyRequest };
            }, a3.updateSrc = function() {
              var e5, t4 = se.get(a3.rjvId, "action", "variable-update"), r2 = t4.name, n2 = t4.namespace, o2 = t4.new_value, s2 = t4.existing_value, i2 = t4.updated_src, l2 = t4.type, c2 = a3.props, u2 = c2.onEdit, d2 = c2.onDelete, b2 = c2.onAdd, p2 = { existing_src: a3.state.src, new_value: o2, updated_src: i2, name: r2, namespace: n2, existing_value: s2 };
              switch (l2) {
                case "variable-added":
                  e5 = b2(p2);
                  break;
                case "variable-edited":
                  e5 = u2(p2);
                  break;
                case "variable-removed":
                  e5 = d2(p2);
              }
              false !== e5 ? (se.set(a3.rjvId, "global", "src", i2), a3.setState({ src: i2 })) : a3.setState({ validationFailure: true });
            }, a3.addKeyRequest = function() {
              a3.setState({ addKeyRequest: true });
            }, a3.resetState = function() {
              a3.setState({ validationFailure: false, addKeyRequest: false });
            }, a3.state = { addKeyRequest: false, editKeyRequest: false, validationFailure: false, src: t3.defaultProps.src, name: t3.defaultProps.name, theme: t3.defaultProps.theme, validationMessage: t3.defaultProps.validationMessage, prevSrc: t3.defaultProps.src, prevName: t3.defaultProps.name, prevTheme: t3.defaultProps.theme }, a3;
          }
          return h(t3, e3), c(t3, [{ key: "componentDidMount", value: function() {
            se.set(this.rjvId, "global", "src", this.state.src);
            var e4 = this.getListeners();
            for (var t4 in e4) se.on(t4 + "-" + this.rjvId, e4[t4]);
            this.setState({ addKeyRequest: false, editKeyRequest: false });
          } }, { key: "componentDidUpdate", value: function(e4, t4) {
            false !== t4.addKeyRequest && this.setState({ addKeyRequest: false }), false !== t4.editKeyRequest && this.setState({ editKeyRequest: false }), e4.src !== this.state.src && se.set(this.rjvId, "global", "src", this.state.src);
          } }, { key: "componentWillUnmount", value: function() {
            var e4 = this.getListeners();
            for (var t4 in e4) se.removeListener(t4 + "-" + this.rjvId, e4[t4]);
          } }, { key: "render", value: function() {
            var e4 = this.state, t4 = e4.validationFailure, a3 = e4.validationMessage, r2 = e4.addKeyRequest, n2 = e4.theme, o2 = e4.src, i2 = e4.name, l2 = this.props, c2 = l2.style, u2 = l2.defaultValue;
            return v().createElement("div", { className: "react-json-view", style: s(s({}, G(n2, "app-container").style), c2) }, v().createElement(yt, { message: a3, active: t4, theme: n2, rjvId: this.rjvId }), v().createElement(mt, Object.assign({}, this.props, { src: o2, name: i2, theme: n2, type: x(o2), rjvId: this.rjvId })), v().createElement(gt, { active: r2, theme: n2, rjvId: this.rjvId, defaultValue: u2 }));
          } }], [{ key: "getDerivedStateFromProps", value: function(e4, a3) {
            if (e4.src !== a3.prevSrc || e4.name !== a3.prevName || e4.theme !== a3.prevTheme) {
              var r2 = { src: e4.src, name: e4.name, theme: e4.theme, validationMessage: e4.validationMessage, prevSrc: e4.src, prevName: e4.name, prevTheme: e4.theme };
              return t3.validateState(r2);
            }
            return null;
          } }]);
        })(v().PureComponent);
        kt.defaultProps = { src: {}, name: "root", theme: "rjv-default", collapsed: false, collapseStringsAfterLength: false, shouldCollapse: false, sortKeys: false, quotesOnKeys: true, groupArraysAfterLength: 100, indentWidth: 4, enableClipboard: true, escapeStrings: true, displayObjectSize: true, displayDataTypes: true, onEdit: false, onDelete: false, onAdd: false, onSelect: false, iconStyle: "triangle", style: {}, validationMessage: "Validation Error", defaultValue: null, displayArrayKey: true, selectOnFocus: false, keyModifier: function(e3) {
          return e3.metaKey || e3.ctrlKey;
        }, bigNumber: null, showComma: true }, kt.validateState = function(e3) {
          var t3 = {};
          return "object" !== x(e3.theme) || (function(e4) {
            var t4 = ["base00", "base01", "base02", "base03", "base04", "base05", "base06", "base07", "base08", "base09", "base0A", "base0B", "base0C", "base0D", "base0E", "base0F"];
            if ("object" === x(e4)) {
              for (var a3 = 0; a3 < t4.length; a3++) if (!(t4[a3] in e4)) return false;
              return true;
            }
            return false;
          })(e3.theme) || (console.error("react-json-view error:", "theme prop must be a theme name or valid base-16 theme object.", 'defaulting to "rjv-default" theme'), t3.theme = "rjv-default"), "object" !== x(e3.src) && "array" !== x(e3.src) && (console.error("react-json-view error:", "src property must be a valid json object"), t3.name = "ERROR", t3.src = { message: "src property must be a valid json object" }), s(s({}, e3), t3);
        }, E(kt);
        const Et = kt;
      })(), n;
    })()));
  })(main$1);
  return main$1.exports;
}
var mainExports = requireMain();
const ReactJson = /* @__PURE__ */ getDefaultExportFromCjs(mainExports);
const LogViewer = ({ logs, height = "500px", onClearFilter }) => {
  const [sorting, setSorting] = reactExports.useState([{ id: "timestamp", desc: true }]);
  const [columnFilters, setColumnFilters] = reactExports.useState([]);
  const [globalFilter, setGlobalFilter] = reactExports.useState("");
  const [expandedRows, setExpandedRows] = reactExports.useState(/* @__PURE__ */ new Set());
  const [newestFirst, setNewestFirst] = reactExports.useState(true);
  const tableContainerRef = reactExports.useRef(null);
  const toggleRow = (rowId) => {
    setExpandedRows((prev) => {
      const next = new Set(prev);
      if (next.has(rowId)) {
        next.delete(rowId);
      } else {
        next.add(rowId);
      }
      return next;
    });
  };
  const toggleSortOrder = () => {
    setNewestFirst((prev) => {
      const newValue = !prev;
      setSorting([{ id: "timestamp", desc: newValue }]);
      return newValue;
    });
  };
  const columns = reactExports.useMemo(
    () => [
      {
        accessorKey: "timestamp",
        header: "Time",
        cell: (info) => {
          const date = new Date(info.getValue());
          const timeStr = date.toLocaleTimeString("en-US", {
            hour12: false,
            hour: "2-digit",
            minute: "2-digit",
            second: "2-digit"
          });
          const ms = date.getMilliseconds().toString().padStart(3, "0");
          return `${timeStr}.${ms}`;
        },
        size: 120
      },
      {
        accessorKey: "level",
        header: "Level",
        cell: (info) => {
          const level = info.getValue();
          const colors = {
            log: "#a1a1aa",
            info: "#3b82f6",
            warn: "#f59e0b",
            error: "#ef4444",
            debug: "#8b5cf6"
          };
          return /* @__PURE__ */ jsxRuntimeExports.jsx(
            "span",
            {
              style: {
                color: colors[level] || "#a1a1aa",
                fontWeight: 500,
                textTransform: "uppercase",
                fontSize: "11px"
              },
              children: level
            }
          );
        },
        size: 70,
        filterFn: "equals"
      },
      {
        accessorKey: "context",
        header: "Context",
        cell: (info) => /* @__PURE__ */ jsxRuntimeExports.jsx(
          "span",
          {
            style: {
              fontFamily: "monospace",
              fontSize: "12px",
              color: "#a1a1aa"
            },
            children: info.getValue()
          }
        ),
        size: 120
      },
      {
        accessorKey: "message",
        header: "Message",
        cell: (info) => {
          const row = info.row.original;
          const hasData = row.data !== void 0 && row.data !== null;
          const isExpanded = expandedRows.has(info.row.id);
          return /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
            /* @__PURE__ */ jsxRuntimeExports.jsxs(
              "div",
              {
                style: {
                  fontSize: "13px",
                  color: "#e5e5e5",
                  wordBreak: "break-word",
                  display: "flex",
                  alignItems: "flex-start",
                  gap: "8px",
                  cursor: hasData ? "pointer" : "default"
                },
                onClick: () => hasData && toggleRow(info.row.id),
                children: [
                  /* @__PURE__ */ jsxRuntimeExports.jsx("div", { style: { width: "16px", flexShrink: 0 }, children: hasData && /* @__PURE__ */ jsxRuntimeExports.jsx(
                    "div",
                    {
                      style: {
                        display: "flex",
                        alignItems: "center",
                        color: "#a1a1aa",
                        transition: "transform 0.2s",
                        transform: isExpanded ? "rotate(90deg)" : "rotate(0deg)"
                      },
                      children: /* @__PURE__ */ jsxRuntimeExports.jsx(ChevronRight, { size: 16 })
                    }
                  ) }),
                  /* @__PURE__ */ jsxRuntimeExports.jsx("span", { style: { flex: 1 }, children: info.getValue() })
                ]
              }
            ),
            hasData && isExpanded && /* @__PURE__ */ jsxRuntimeExports.jsx(
              "div",
              {
                style: {
                  marginTop: "8px",
                  marginLeft: "24px"
                },
                children: /* @__PURE__ */ jsxRuntimeExports.jsx(
                  ReactJson,
                  {
                    src: row.data,
                    theme: "monokai",
                    collapsed: false,
                    displayDataTypes: false,
                    displayObjectSize: false,
                    enableClipboard: false,
                    name: false,
                    iconStyle: "triangle",
                    collapseStringsAfterLength: 100,
                    style: {
                      background: "#171717",
                      padding: "8px",
                      borderRadius: "4px",
                      fontSize: "12px"
                    }
                  }
                )
              }
            )
          ] });
        },
        size: 600
      }
    ],
    [expandedRows]
  );
  const table = useReactTable({
    data: logs,
    columns,
    state: {
      sorting,
      columnFilters,
      globalFilter
    },
    onSortingChange: setSorting,
    onColumnFiltersChange: setColumnFilters,
    onGlobalFilterChange: setGlobalFilter,
    getCoreRowModel: getCoreRowModel(),
    getSortedRowModel: getSortedRowModel(),
    getFilteredRowModel: getFilteredRowModel(),
    globalFilterFn: "includesString"
  });
  const { rows } = table.getRowModel();
  const rowVirtualizer = useVirtualizer({
    count: rows.length,
    getScrollElement: () => tableContainerRef.current,
    estimateSize: () => 40,
    overscan: 10
  });
  const virtualRows = rowVirtualizer.getVirtualItems();
  const totalSize = rowVirtualizer.getTotalSize();
  const paddingTop = virtualRows.length > 0 ? virtualRows[0].start : 0;
  const paddingBottom = virtualRows.length > 0 ? totalSize - virtualRows[virtualRows.length - 1].end : 0;
  return /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { style: { width: "100%" }, children: [
    /* @__PURE__ */ jsxRuntimeExports.jsxs(
      "div",
      {
        style: {
          marginBottom: "16px",
          display: "flex",
          gap: "12px",
          alignItems: "center",
          flexWrap: "wrap"
        },
        children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { style: { position: "relative", flex: "1 1 300px" }, children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(
              Search,
              {
                size: 16,
                style: {
                  position: "absolute",
                  left: "12px",
                  top: "50%",
                  transform: "translateY(-50%)",
                  color: "#71717a"
                }
              }
            ),
            /* @__PURE__ */ jsxRuntimeExports.jsx(
              "input",
              {
                type: "text",
                value: globalFilter ?? "",
                onChange: (e) => setGlobalFilter(e.target.value),
                placeholder: "Search all logs...",
                style: {
                  width: "100%",
                  padding: "8px 36px 8px 36px",
                  background: "#171717",
                  border: "1px solid #1a1a1a",
                  borderRadius: "6px",
                  color: "#e5e5e5",
                  fontSize: "13px"
                }
              }
            ),
            globalFilter && /* @__PURE__ */ jsxRuntimeExports.jsx(
              "button",
              {
                onClick: () => setGlobalFilter(""),
                style: {
                  position: "absolute",
                  right: "8px",
                  top: "50%",
                  transform: "translateY(-50%)",
                  background: "none",
                  border: "none",
                  cursor: "pointer",
                  color: "#71717a",
                  padding: "4px",
                  display: "flex",
                  alignItems: "center"
                },
                children: /* @__PURE__ */ jsxRuntimeExports.jsx(X, { size: 16 })
              }
            )
          ] }),
          /* @__PURE__ */ jsxRuntimeExports.jsxs(
            "select",
            {
              value: table.getColumn("level")?.getFilterValue() ?? "all",
              onChange: (e) => {
                const value = e.target.value;
                table.getColumn("level")?.setFilterValue(value === "all" ? void 0 : value);
              },
              style: {
                padding: "8px 12px",
                background: "#171717",
                border: "1px solid #1a1a1a",
                borderRadius: "6px",
                color: "#e5e5e5",
                fontSize: "13px",
                cursor: "pointer"
              },
              children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx("option", { value: "all", children: "All Levels" }),
                /* @__PURE__ */ jsxRuntimeExports.jsx("option", { value: "log", children: "Log" }),
                /* @__PURE__ */ jsxRuntimeExports.jsx("option", { value: "info", children: "Info" }),
                /* @__PURE__ */ jsxRuntimeExports.jsx("option", { value: "warn", children: "Warn" }),
                /* @__PURE__ */ jsxRuntimeExports.jsx("option", { value: "error", children: "Error" }),
                /* @__PURE__ */ jsxRuntimeExports.jsx("option", { value: "debug", children: "Debug" })
              ]
            }
          ),
          /* @__PURE__ */ jsxRuntimeExports.jsxs(
            "button",
            {
              onClick: toggleSortOrder,
              style: {
                padding: "8px 12px",
                background: "#171717",
                border: "1px solid #1a1a1a",
                borderRadius: "6px",
                color: "#e5e5e5",
                fontSize: "13px",
                cursor: "pointer",
                display: "flex",
                alignItems: "center",
                gap: "6px"
              },
              title: newestFirst ? "Newest first" : "Oldest first",
              children: [
                newestFirst ? /* @__PURE__ */ jsxRuntimeExports.jsx(ArrowDown, { size: 14 }) : /* @__PURE__ */ jsxRuntimeExports.jsx(ArrowUp, { size: 14 }),
                newestFirst ? "Newest" : "Oldest"
              ]
            }
          ),
          /* @__PURE__ */ jsxRuntimeExports.jsxs("span", { style: { color: "#71717a", fontSize: "13px", whiteSpace: "nowrap" }, children: [
            rows.length,
            " ",
            rows.length === 1 ? "log" : "logs",
            rows.length !== logs.length && ` (filtered from ${logs.length})`
          ] }),
          (globalFilter || columnFilters.length > 0) && /* @__PURE__ */ jsxRuntimeExports.jsxs(
            "button",
            {
              onClick: () => {
                setGlobalFilter("");
                setColumnFilters([]);
                onClearFilter?.();
              },
              style: {
                padding: "8px 12px",
                background: "#171717",
                border: "1px solid #1a1a1a",
                borderRadius: "6px",
                color: "#ef4444",
                fontSize: "13px",
                cursor: "pointer",
                display: "flex",
                alignItems: "center",
                gap: "6px"
              },
              children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx(X, { size: 14 }),
                "Clear Filters"
              ]
            }
          )
        ]
      }
    ),
    /* @__PURE__ */ jsxRuntimeExports.jsxs(
      "div",
      {
        ref: tableContainerRef,
        style: {
          height,
          overflow: "auto",
          border: "1px solid #1a1a1a",
          borderRadius: "6px",
          background: "#0a0a0a"
        },
        children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs(
            "table",
            {
              style: {
                width: "100%",
                borderCollapse: "collapse",
                fontSize: "13px"
              },
              children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx(
                  "thead",
                  {
                    style: {
                      position: "sticky",
                      top: 0,
                      background: "#171717",
                      zIndex: 1,
                      borderBottom: "1px solid #1a1a1a"
                    },
                    children: table.getHeaderGroups().map((headerGroup) => /* @__PURE__ */ jsxRuntimeExports.jsx("tr", { children: headerGroup.headers.map((header) => /* @__PURE__ */ jsxRuntimeExports.jsx(
                      "th",
                      {
                        style: {
                          padding: "12px",
                          textAlign: "left",
                          color: "#a1a1aa",
                          fontWeight: 600,
                          fontSize: "12px",
                          textTransform: "uppercase",
                          letterSpacing: "0.5px",
                          cursor: header.column.getCanSort() ? "pointer" : "default",
                          userSelect: "none",
                          width: header.getSize()
                        },
                        onClick: header.column.getToggleSortingHandler(),
                        children: /* @__PURE__ */ jsxRuntimeExports.jsxs(
                          "div",
                          {
                            style: {
                              display: "flex",
                              alignItems: "center",
                              gap: "6px"
                            },
                            children: [
                              flexRender(header.column.columnDef.header, header.getContext()),
                              header.column.getIsSorted() && /* @__PURE__ */ jsxRuntimeExports.jsx("span", { style: { color: "#3b82f6" }, children: header.column.getIsSorted() === "asc" ? /* @__PURE__ */ jsxRuntimeExports.jsx(ChevronUp, { size: 14 }) : /* @__PURE__ */ jsxRuntimeExports.jsx(ChevronDown, { size: 14 }) })
                            ]
                          }
                        )
                      },
                      header.id
                    )) }, headerGroup.id))
                  }
                ),
                /* @__PURE__ */ jsxRuntimeExports.jsxs("tbody", { children: [
                  paddingTop > 0 && /* @__PURE__ */ jsxRuntimeExports.jsx("tr", { children: /* @__PURE__ */ jsxRuntimeExports.jsx("td", { style: { height: `${paddingTop}px` } }) }),
                  virtualRows.map((virtualRow) => {
                    const row = rows[virtualRow.index];
                    return /* @__PURE__ */ jsxRuntimeExports.jsx(
                      "tr",
                      {
                        style: {
                          borderBottom: "1px solid #1a1a1a",
                          transition: "background 0.1s"
                        },
                        onMouseEnter: (e) => {
                          e.currentTarget.style.background = "#171717";
                        },
                        onMouseLeave: (e) => {
                          e.currentTarget.style.background = "transparent";
                        },
                        children: row.getVisibleCells().map((cell) => /* @__PURE__ */ jsxRuntimeExports.jsx(
                          "td",
                          {
                            style: {
                              padding: "10px 12px",
                              verticalAlign: "top"
                            },
                            children: flexRender(cell.column.columnDef.cell, cell.getContext())
                          },
                          cell.id
                        ))
                      },
                      row.id
                    );
                  }),
                  paddingBottom > 0 && /* @__PURE__ */ jsxRuntimeExports.jsx("tr", { children: /* @__PURE__ */ jsxRuntimeExports.jsx("td", { style: { height: `${paddingBottom}px` } }) })
                ] })
              ]
            }
          ),
          rows.length === 0 && /* @__PURE__ */ jsxRuntimeExports.jsxs(
            "div",
            {
              style: {
                padding: "48px 24px",
                textAlign: "center",
                color: "#71717a"
              },
              children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx("p", { style: { fontSize: "14px", marginBottom: "8px" }, children: "No logs found" }),
                /* @__PURE__ */ jsxRuntimeExports.jsx("p", { style: { fontSize: "12px" }, children: logs.length === 0 ? "Logs will appear here as the extension runs" : "Try adjusting your filters" })
              ]
            }
          )
        ]
      }
    )
  ] });
};
const LoggingTab = () => {
  const [settings, setSettings] = reactExports.useState({
    remoteLogging: true,
    storeLogs: true,
    maxStoredLogs: DEFAULT_MAX_STORED_LOGS
  });
  const [logStats, setLogStats] = reactExports.useState({ count: 0 });
  const [logs, setLogs] = reactExports.useState([]);
  reactExports.useEffect(() => {
    chrome.storage.local.get(["automationConfig"], (result) => {
      if (result.automationConfig) {
        setSettings({
          remoteLogging: result.automationConfig.remoteLogging !== false,
          storeLogs: result.automationConfig.storeLogs !== false,
          maxStoredLogs: result.automationConfig.maxStoredLogs || DEFAULT_MAX_STORED_LOGS
        });
      }
    });
    loadLogStats();
    loadLogs();
  }, []);
  const loadLogStats = async () => {
    try {
      const stats = await getLogStats();
      setLogStats(stats);
    } catch (error) {
      console.error("Failed to load log stats:", error);
    }
  };
  const loadLogs = () => {
    chrome.storage.local.get(["debugLogs"], (result) => {
      setLogs(result.debugLogs || []);
    });
  };
  reactExports.useEffect(() => {
    chrome.storage.local.get(["automationConfig"], (result) => {
      const fullConfig = {
        ...result.automationConfig,
        remoteLogging: settings.remoteLogging,
        storeLogs: settings.storeLogs,
        maxStoredLogs: settings.maxStoredLogs
      };
      chrome.storage.local.set({ automationConfig: fullConfig });
    });
  }, [settings]);
  const handleExportLogs = async () => {
    try {
      const jsonData = await exportLogs();
      const blob = new Blob([jsonData], { type: "application/json" });
      const url = URL.createObjectURL(blob);
      const a = document.createElement("a");
      a.href = url;
      a.download = `lazyfrog-logs-v${VERSION}-${Date.now()}.json`;
      document.body.appendChild(a);
      a.click();
      document.body.removeChild(a);
      URL.revokeObjectURL(url);
    } catch (error) {
      alert(`Failed to export logs: ${error}`);
    }
  };
  const handleClearLogs = async () => {
    if (window.confirm("Are you sure you want to clear all stored logs? This cannot be undone.")) {
      try {
        await clearLogs();
        await loadLogStats();
        loadLogs();
        alert("All logs cleared successfully!");
      } catch (error) {
        alert(`Failed to clear logs: ${error}`);
      }
    }
  };
  const handleRefreshLogs = () => {
    loadLogs();
    loadLogStats();
  };
  return /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
    /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "card", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs("h2", { children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(
          Terminal,
          {
            size: 20,
            style: {
              display: "inline-block",
              marginRight: "8px",
              verticalAlign: "middle"
            }
          }
        ),
        "Remote Logging"
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "form-group", children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs(
          "label",
          {
            style: {
              display: "flex",
              alignItems: "center",
              gap: "8px",
              cursor: "pointer"
            },
            children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(
                "input",
                {
                  type: "checkbox",
                  checked: settings.remoteLogging,
                  onChange: (e) => setSettings((prev) => ({
                    ...prev,
                    remoteLogging: e.target.checked
                  })),
                  style: { cursor: "pointer" }
                }
              ),
              /* @__PURE__ */ jsxRuntimeExports.jsx("span", { children: "Enable Remote Logging" })
            ]
          }
        ),
        /* @__PURE__ */ jsxRuntimeExports.jsx(
          "p",
          {
            style: {
              color: "#a1a1aa",
              fontSize: "13px",
              marginTop: "8px",
              marginLeft: "28px"
            },
            children: "Sends logs to http://localhost:7856/log for debugging and AI integration. This allows you to monitor extension behavior in real-time from an external log viewer."
          }
        )
      ] })
    ] }),
    /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "card", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs("h2", { children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(
          Database,
          {
            size: 20,
            style: {
              display: "inline-block",
              marginRight: "8px",
              verticalAlign: "middle"
            }
          }
        ),
        "Log Storage"
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "form-group", style: { marginBottom: "20px" }, children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs(
          "label",
          {
            style: {
              display: "flex",
              alignItems: "center",
              gap: "8px",
              cursor: "pointer"
            },
            children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(
                "input",
                {
                  type: "checkbox",
                  checked: settings.storeLogs,
                  onChange: (e) => setSettings((prev) => ({
                    ...prev,
                    storeLogs: e.target.checked
                  })),
                  style: { cursor: "pointer" }
                }
              ),
              /* @__PURE__ */ jsxRuntimeExports.jsx("span", { children: "Store Logs in Browser" })
            ]
          }
        ),
        /* @__PURE__ */ jsxRuntimeExports.jsx(
          "p",
          {
            style: {
              color: "#a1a1aa",
              fontSize: "13px",
              marginTop: "8px",
              marginLeft: "28px"
            },
            children: "Stores logs in browser storage for later export. Useful for debugging issues and sharing logs with support."
          }
        ),
        settings.storeLogs && /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { style: { marginTop: "12px", marginLeft: "28px" }, children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx(
            "label",
            {
              style: {
                display: "block",
                fontSize: "13px",
                color: "#e5e5e5",
                marginBottom: "8px"
              },
              children: "Maximum logs to keep:"
            }
          ),
          /* @__PURE__ */ jsxRuntimeExports.jsx(
            "input",
            {
              type: "number",
              min: "1000",
              max: "20000",
              step: "1000",
              value: settings.maxStoredLogs,
              onChange: (e) => setSettings((prev) => ({
                ...prev,
                maxStoredLogs: parseInt(e.target.value) || DEFAULT_MAX_STORED_LOGS
              })),
              style: {
                padding: "6px 12px",
                background: "#171717",
                border: "1px solid #1a1a1a",
                borderRadius: "6px",
                color: "#e5e5e5",
                fontSize: "13px",
                width: "120px"
              }
            }
          ),
          /* @__PURE__ */ jsxRuntimeExports.jsxs(
            "p",
            {
              style: {
                color: "#a1a1aa",
                fontSize: "12px",
                marginTop: "6px"
              },
              children: [
                "Oldest logs will be removed when limit is reached. Current: ",
                logStats.count,
                " logs stored."
              ]
            }
          )
        ] })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { style: { marginTop: "16px" }, children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("p", { style: { color: "#a1a1aa", fontSize: "14px", marginBottom: "12px" }, children: "Export stored logs for debugging or clear them to free up storage space." }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { style: { display: "flex", gap: "12px", flexWrap: "wrap" }, children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs(
            "button",
            {
              className: "button",
              onClick: handleExportLogs,
              style: { display: "flex", alignItems: "center", gap: "8px" },
              disabled: logStats.count === 0,
              children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx(Download, { size: 16 }),
                "Export Debug Logs (",
                logStats.count,
                ")"
              ]
            }
          ),
          /* @__PURE__ */ jsxRuntimeExports.jsxs(
            "button",
            {
              className: "button danger",
              onClick: handleClearLogs,
              style: { display: "flex", alignItems: "center", gap: "8px" },
              disabled: logStats.count === 0,
              children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx(Trash2, { size: 16 }),
                "Clear Logs"
              ]
            }
          )
        ] })
      ] })
    ] }),
    /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "card", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs(
        "div",
        {
          style: {
            display: "flex",
            alignItems: "center",
            justifyContent: "space-between",
            marginBottom: "16px"
          },
          children: [
            /* @__PURE__ */ jsxRuntimeExports.jsxs("h2", { children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(
                Eye,
                {
                  size: 20,
                  style: {
                    display: "inline-block",
                    marginRight: "8px",
                    verticalAlign: "middle"
                  }
                }
              ),
              "Log Viewer"
            ] }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(
              "button",
              {
                className: "button",
                onClick: handleRefreshLogs,
                style: {
                  display: "flex",
                  alignItems: "center",
                  gap: "8px",
                  fontSize: "13px",
                  padding: "6px 12px"
                },
                children: "Refresh"
              }
            )
          ]
        }
      ),
      /* @__PURE__ */ jsxRuntimeExports.jsx("p", { style: { color: "#a1a1aa", fontSize: "14px", marginBottom: "16px" }, children: "View and search through stored logs in real-time. Logs are automatically loaded from storage." }),
      /* @__PURE__ */ jsxRuntimeExports.jsx(LogViewer, { logs, height: "600px" })
    ] })
  ] });
};
function exportMissionsForDB(missions) {
  const completeMissions = missions.filter(
    (m) => m.encounters && m.encounters.length > 0 && m.difficulty && m.environment && m.foodName
  );
  if (completeMissions.length === 0) {
    alert("No missions with complete data found. Browse missions to capture their data via RenderPostContent API.");
    return 0;
  }
  const dbExport = {};
  completeMissions.forEach((mission) => {
    const { cleared, clearedAt, disabled, totalLoot, ...cleanMission } = mission;
    dbExport[mission.postId] = cleanMission;
  });
  const json = JSON.stringify(dbExport, null, 2);
  const blob = new Blob([json], { type: "application/json" });
  const url = URL.createObjectURL(blob);
  const a = document.createElement("a");
  a.href = url;
  a.download = `missions-db-export-${Date.now()}.json`;
  a.click();
  URL.revokeObjectURL(url);
  return completeMissions.length;
}
function normalizePostId(id) {
  if (!id || typeof id !== "string") {
    return null;
  }
  if (id.startsWith("t3_")) {
    const postIdPart = id.slice(3);
    if (postIdPart && /^[a-z0-9]+$/i.test(postIdPart)) {
      return id;
    }
    return null;
  }
  if (/^[a-z0-9]+$/i.test(id)) {
    return `t3_${id}`;
  }
  return null;
}
function normalizeRedditPermalink(input) {
  const base = "https://www.reddit.com";
  const stripT3 = (id) => id?.startsWith("t3_") ? id.slice(3) : id;
  let postId = "";
  try {
    if (input?.startsWith("http")) {
      const url = new URL(input);
      const match = url.pathname.match(/\/comments\/([^/]+)/);
      if (match && match[1]) {
        postId = stripT3(match[1]);
      }
    } else if (input) {
      postId = stripT3(input);
    }
  } catch {
    postId = stripT3(input);
  }
  if (!postId) {
    return `${base}/r/SwordAndSupperGame/`;
  }
  return `${base}/r/SwordAndSupperGame/comments/${postId}/`;
}
function extractPostId(url) {
  try {
    const trimmed = url.trim();
    if (!trimmed) return null;
    if (trimmed.startsWith("http")) {
      const urlObj = new URL(trimmed);
      if (!urlObj.hostname.includes("reddit.com")) {
        return null;
      }
      const match = urlObj.pathname.match(/\/comments\/([a-z0-9]+)/i);
      if (match && match[1]) {
        return normalizePostId(match[1]);
      }
    }
    return null;
  } catch {
    return null;
  }
}
async function importFromUrls(options) {
  const result = {
    imported: 0,
    skipped: 0,
    failed: 0,
    errors: []
  };
  const uniqueUrls = Array.from(new Set(options.urls.map((u) => u.trim()).filter(Boolean)));
  const missionsToSave = [];
  for (const url of uniqueUrls) {
    try {
      const postId = extractPostId(url);
      if (!postId) {
        result.failed++;
        result.errors.push(`Invalid URL: ${url}`);
        continue;
      }
      const existing = await getMission(postId);
      if (existing) {
        result.skipped++;
        continue;
      }
      const mission = {
        // Core identification
        postId,
        timestamp: Date.now(),
        permalink: normalizeRedditPermalink(postId.slice(3)),
        // Mission metadata
        missionTitle: `Mission ${postId.slice(3)}`,
        missionAuthorName: "Unknown",
        // Mission data (placeholders for now)
        environment: "haunted_forest",
        // Default placeholder
        encounters: [],
        // Will be filled when data is captured
        minLevel: options.minLevel,
        maxLevel: options.maxLevel,
        difficulty: 0,
        // Unknown until captured
        foodImage: "",
        foodName: "",
        authorWeaponId: "",
        chef: "",
        cart: "",
        rarity: "common",
        type: void 0
      };
      missionsToSave.push(mission);
      result.imported++;
    } catch (error) {
      result.failed++;
      result.errors.push(`Failed to import ${url}: ${error instanceof Error ? error.message : String(error)}`);
    }
  }
  if (missionsToSave.length > 0) {
    try {
      await saveMissionsBatch(missionsToSave);
    } catch (error) {
      result.errors.push(`Batch save failed: ${error instanceof Error ? error.message : String(error)}`);
    }
  }
  return result;
}
async function fetchLevelFromRedditAPI(postId) {
  try {
    const cleanPostId = postId.replace("t3_", "");
    const cache = await new Promise((resolve) => {
      chrome.storage.local.get([STORAGE_KEYS.REDDIT_API_CACHE], (result) => {
        resolve(result[STORAGE_KEYS.REDDIT_API_CACHE] || {});
      });
    });
    const cached = cache[cleanPostId];
    if (cached) {
      redditLogger.log(`[fetchLevelFromRedditAPI] Using cached data for ${cleanPostId}`, cached);
      return {
        minLevel: cached.minLevel,
        maxLevel: cached.maxLevel,
        title: cached.title,
        author: cached.author
      };
    }
    const url = `https://www.reddit.com/r/SwordAndSupperGame/comments/${cleanPostId}/.json`;
    redditLogger.log(`[fetchLevelFromRedditAPI] Fetching ${url}`);
    const response = await fetch(url);
    if (!response.ok) {
      redditLogger.error(`[fetchLevelFromRedditAPI] HTTP error: ${response.status}`);
      return null;
    }
    const data = await response.json();
    const post = data[0]?.data?.children?.[0]?.data;
    if (!post) {
      redditLogger.error("[fetchLevelFromRedditAPI] No post data found in response");
      return null;
    }
    const linkFlairText = post.link_flair_text;
    const title = post.title;
    const author = post.author;
    if (!linkFlairText) {
      redditLogger.log("[fetchLevelFromRedditAPI] No link_flair_text found");
      return null;
    }
    const levelMatch = linkFlairText.match(/Levels?\s+(\d+)-(\d+)/i);
    if (levelMatch) {
      const minLevel = parseInt(levelMatch[1], 10);
      const maxLevel = parseInt(levelMatch[2], 10);
      redditLogger.log(`[fetchLevelFromRedditAPI] Parsed levels from flair`, {
        postId,
        linkFlairText,
        minLevel,
        maxLevel,
        title,
        author
      });
      const cacheEntry = {
        postId: cleanPostId,
        minLevel,
        maxLevel,
        title,
        author,
        timestamp: Date.now()
      };
      const updatedCache = { ...cache, [cleanPostId]: cacheEntry };
      await new Promise((resolve) => {
        chrome.storage.local.set({ [STORAGE_KEYS.REDDIT_API_CACHE]: updatedCache }, () => {
          resolve();
        });
      });
      redditLogger.log(`[fetchLevelFromRedditAPI] Cached data for ${cleanPostId}`);
      return { minLevel, maxLevel, title, author };
    }
    redditLogger.log("[fetchLevelFromRedditAPI] Could not parse levels from flair", { linkFlairText });
    return null;
  } catch (error) {
    redditLogger.error("[fetchLevelFromRedditAPI] Error fetching Reddit API", {
      error: error instanceof Error ? error.message : String(error),
      postId
    });
    return null;
  }
}
const ImportFromUrlsModal = ({ isOpen, onClose, onImportComplete }) => {
  const [urls, setUrls] = reactExports.useState("");
  const [minLevel, setMinLevel] = reactExports.useState(1);
  const [maxLevel, setMaxLevel] = reactExports.useState(999);
  const [isImporting, setIsImporting] = reactExports.useState(false);
  const [importResult, setImportResult] = reactExports.useState(null);
  const [levelWarning, setLevelWarning] = reactExports.useState(null);
  const [isDetectingLevels, setIsDetectingLevels] = reactExports.useState(false);
  const fileInputRef = reactExports.useRef(null);
  const extractPostId2 = (url) => {
    try {
      const trimmed = url.trim();
      if (!trimmed) return null;
      if (trimmed.startsWith("http")) {
        const urlObj = new URL(trimmed);
        const match = urlObj.pathname.match(/\/comments\/([a-z0-9]+)/i);
        return match?.[1] || null;
      }
      return null;
    } catch {
      return null;
    }
  };
  reactExports.useEffect(() => {
    const detectLevels = async () => {
      if (!urls.trim()) {
        setLevelWarning(null);
        return;
      }
      const urlList = urls.split("\n").filter((u) => u.trim());
      if (urlList.length === 0) {
        setLevelWarning(null);
        return;
      }
      const samplesToCheck = urlList.slice(0, 3);
      setIsDetectingLevels(true);
      setLevelWarning(null);
      try {
        const levelResults = [];
        for (const url of samplesToCheck) {
          const postId = extractPostId2(url);
          if (!postId) continue;
          const levelData = await fetchLevelFromRedditAPI(postId);
          if (levelData && levelData.minLevel !== void 0 && levelData.maxLevel !== void 0) {
            levelResults.push(levelData);
          }
        }
        if (levelResults.length > 0) {
          const firstMin = levelResults[0].minLevel;
          const firstMax = levelResults[0].maxLevel;
          const allSame = levelResults.every(
            (r) => r.minLevel === firstMin && r.maxLevel === firstMax
          );
          if (allSame && firstMin !== void 0 && firstMax !== void 0) {
            setMinLevel(firstMin);
            setMaxLevel(firstMax);
            setLevelWarning(null);
          } else {
            setLevelWarning(
              `Mixed level ranges detected in sample URLs. Please verify min/max levels manually.`
            );
          }
        }
      } catch (error) {
      } finally {
        setIsDetectingLevels(false);
      }
    };
    const timer = setTimeout(() => {
      detectLevels();
    }, 1e3);
    return () => clearTimeout(timer);
  }, [urls]);
  const handleFileSelect = async (event) => {
    const file = event.target.files?.[0];
    if (!file) return;
    try {
      const text2 = await file.text();
      setUrls(text2);
      if (fileInputRef.current) {
        fileInputRef.current.value = "";
      }
    } catch (err) {
      alert(`Failed to read file: ${err}`);
    }
  };
  const handleImport = async () => {
    if (!urls.trim()) {
      setImportResult({
        imported: 0,
        skipped: 0,
        failed: 1,
        errors: ["Please enter at least one URL"]
      });
      return;
    }
    if (minLevel < 1 || maxLevel < 1) {
      setImportResult({
        imported: 0,
        skipped: 0,
        failed: 1,
        errors: ["Levels must be at least 1"]
      });
      return;
    }
    if (minLevel > maxLevel) {
      setImportResult({
        imported: 0,
        skipped: 0,
        failed: 1,
        errors: ["Min level cannot be greater than max level"]
      });
      return;
    }
    setIsImporting(true);
    setImportResult(null);
    try {
      const urlList = urls.split("\n").filter((u) => u.trim());
      const result = await importFromUrls({
        urls: urlList,
        minLevel,
        maxLevel
      });
      setImportResult(result);
      onImportComplete();
    } catch (err) {
      setImportResult({
        imported: 0,
        skipped: 0,
        failed: 1,
        errors: [`Import failed: ${err}`]
      });
    } finally {
      setIsImporting(false);
    }
  };
  const handleClose = () => {
    setUrls("");
    setMinLevel(1);
    setMaxLevel(999);
    setImportResult(null);
    setLevelWarning(null);
    onClose();
  };
  if (!isOpen) return null;
  return /* @__PURE__ */ jsxRuntimeExports.jsx(
    "div",
    {
      style: {
        position: "fixed",
        top: 0,
        left: 0,
        right: 0,
        bottom: 0,
        background: "rgba(0, 0, 0, 0.8)",
        display: "flex",
        alignItems: "center",
        justifyContent: "center",
        zIndex: 1e3
      },
      onClick: onClose,
      children: /* @__PURE__ */ jsxRuntimeExports.jsxs(
        "div",
        {
          className: "card",
          style: {
            maxWidth: "600px",
            width: "90%",
            maxHeight: "80vh",
            overflow: "auto",
            position: "relative"
          },
          onClick: (e) => e.stopPropagation(),
          children: [
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { style: { display: "flex", alignItems: "center", justifyContent: "space-between", marginBottom: "20px" }, children: [
              /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { style: { display: "flex", alignItems: "center", gap: "12px" }, children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx(Link, { size: 24, style: { color: "#3b82f6" } }),
                /* @__PURE__ */ jsxRuntimeExports.jsx("h2", { style: { margin: 0, fontSize: "20px", fontWeight: "600" }, children: "Import from URLs" })
              ] }),
              /* @__PURE__ */ jsxRuntimeExports.jsx(
                "button",
                {
                  onClick: handleClose,
                  style: {
                    background: "transparent",
                    border: "none",
                    color: "#71717a",
                    cursor: "pointer",
                    padding: "4px",
                    display: "flex",
                    alignItems: "center"
                  },
                  children: /* @__PURE__ */ jsxRuntimeExports.jsx(X, { size: 20 })
                }
              )
            ] }),
            importResult ? /* @__PURE__ */ jsxRuntimeExports.jsxs(jsxRuntimeExports.Fragment, { children: [
              /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { style: { marginBottom: "24px" }, children: [
                /* @__PURE__ */ jsxRuntimeExports.jsxs(
                  "div",
                  {
                    style: {
                      background: "#0a0a0a",
                      border: "1px solid #1a1a1a",
                      borderRadius: "8px",
                      padding: "20px",
                      marginBottom: "16px"
                    },
                    children: [
                      /* @__PURE__ */ jsxRuntimeExports.jsx("h3", { style: { margin: "0 0 16px 0", fontSize: "16px", fontWeight: "600" }, children: "Import Summary" }),
                      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { style: { display: "flex", flexDirection: "column", gap: "12px" }, children: [
                        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { style: { display: "flex", alignItems: "center", gap: "12px" }, children: [
                          /* @__PURE__ */ jsxRuntimeExports.jsx(CircleCheckBig, { size: 32, style: { color: "#22c55e" } }),
                          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
                            /* @__PURE__ */ jsxRuntimeExports.jsx("div", { style: { fontSize: "20px", fontWeight: "600", color: "#22c55e" }, children: importResult.imported }),
                            /* @__PURE__ */ jsxRuntimeExports.jsx("div", { style: { fontSize: "13px", color: "#a1a1aa" }, children: "Imported" })
                          ] })
                        ] }),
                        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { style: { display: "flex", alignItems: "center", gap: "12px" }, children: [
                          /* @__PURE__ */ jsxRuntimeExports.jsx(CircleAlert, { size: 32, style: { color: "#3b82f6" } }),
                          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
                            /* @__PURE__ */ jsxRuntimeExports.jsx("div", { style: { fontSize: "20px", fontWeight: "600", color: "#3b82f6" }, children: importResult.skipped }),
                            /* @__PURE__ */ jsxRuntimeExports.jsx("div", { style: { fontSize: "13px", color: "#a1a1aa" }, children: "Skipped (already exist)" })
                          ] })
                        ] }),
                        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { style: { display: "flex", alignItems: "center", gap: "12px" }, children: [
                          /* @__PURE__ */ jsxRuntimeExports.jsx(CircleX, { size: 32, style: { color: "#ef4444" } }),
                          /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
                            /* @__PURE__ */ jsxRuntimeExports.jsx("div", { style: { fontSize: "20px", fontWeight: "600", color: "#ef4444" }, children: importResult.failed }),
                            /* @__PURE__ */ jsxRuntimeExports.jsx("div", { style: { fontSize: "13px", color: "#a1a1aa" }, children: "Failed" })
                          ] })
                        ] })
                      ] })
                    ]
                  }
                ),
                importResult.errors.length > 0 && /* @__PURE__ */ jsxRuntimeExports.jsxs(
                  "div",
                  {
                    style: {
                      background: "#1a0a0a",
                      border: "1px solid #3a1a1a",
                      borderRadius: "8px",
                      padding: "12px",
                      maxHeight: "200px",
                      overflowY: "auto"
                    },
                    children: [
                      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { style: { fontSize: "13px", fontWeight: "600", color: "#ef4444", marginBottom: "8px" }, children: [
                        "Errors (",
                        importResult.errors.length,
                        ")"
                      ] }),
                      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { style: { fontSize: "12px", color: "#fca5a5", fontFamily: "monospace" }, children: [
                        importResult.errors.slice(0, 10).map((error, i) => /* @__PURE__ */ jsxRuntimeExports.jsx("div", { style: { marginBottom: "4px" }, children: error }, i)),
                        importResult.errors.length > 10 && /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { style: { marginTop: "8px", color: "#a1a1aa" }, children: [
                          "... and ",
                          importResult.errors.length - 10,
                          " more"
                        ] })
                      ] })
                    ]
                  }
                )
              ] }),
              /* @__PURE__ */ jsxRuntimeExports.jsx("div", { style: { display: "flex", justifyContent: "flex-end" }, children: /* @__PURE__ */ jsxRuntimeExports.jsx(
                "button",
                {
                  onClick: handleClose,
                  className: "button",
                  style: {
                    background: "#3b82f6",
                    color: "#fff",
                    fontWeight: "500"
                  },
                  children: "Close"
                }
              ) })
            ] }) : /* @__PURE__ */ jsxRuntimeExports.jsxs(jsxRuntimeExports.Fragment, { children: [
              /* @__PURE__ */ jsxRuntimeExports.jsxs(
                "div",
                {
                  style: {
                    background: "#0a0a0a",
                    border: "1px solid #1a1a1a",
                    borderRadius: "8px",
                    padding: "12px",
                    marginBottom: "16px",
                    fontSize: "13px",
                    color: "#a1a1aa"
                  },
                  children: [
                    /* @__PURE__ */ jsxRuntimeExports.jsx("p", { style: { margin: "0 0 8px 0" }, children: "Paste Reddit mission URLs (one per line) or upload a text file. Existing missions will be skipped." }),
                    /* @__PURE__ */ jsxRuntimeExports.jsx("p", { style: { margin: 0, fontSize: "12px", color: "#71717a" }, children: "Example: https://www.reddit.com/r/SwordAndSupperGame/comments/1og6ocy/..." })
                  ]
                }
              ),
              /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { style: { marginBottom: "16px" }, children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx("label", { style: { display: "block", marginBottom: "8px", fontSize: "14px", fontWeight: "500" }, children: "URLs" }),
                /* @__PURE__ */ jsxRuntimeExports.jsx(
                  "textarea",
                  {
                    value: urls,
                    onChange: (e) => setUrls(e.target.value),
                    placeholder: "https://www.reddit.com/r/SwordAndSupperGame/comments/1og6ocy/\nhttps://www.reddit.com/r/SwordAndSupperGame/comments/1og6oh2/\n...",
                    style: {
                      width: "100%",
                      minHeight: "150px",
                      padding: "12px",
                      background: "#0a0a0a",
                      border: "1px solid #1a1a1a",
                      borderRadius: "8px",
                      color: "#e5e5e5",
                      fontSize: "13px",
                      fontFamily: "monospace",
                      resize: "vertical"
                    }
                  }
                ),
                /* @__PURE__ */ jsxRuntimeExports.jsxs(
                  "button",
                  {
                    onClick: () => fileInputRef.current?.click(),
                    className: "button",
                    style: {
                      marginTop: "8px",
                      display: "flex",
                      alignItems: "center",
                      gap: "8px",
                      fontSize: "13px"
                    },
                    children: [
                      /* @__PURE__ */ jsxRuntimeExports.jsx(Upload, { size: 14 }),
                      "Choose File (.txt)"
                    ]
                  }
                ),
                /* @__PURE__ */ jsxRuntimeExports.jsx(
                  "input",
                  {
                    ref: fileInputRef,
                    type: "file",
                    accept: ".txt,text/plain",
                    onChange: handleFileSelect,
                    style: { display: "none" }
                  }
                )
              ] }),
              isDetectingLevels && /* @__PURE__ */ jsxRuntimeExports.jsxs(
                "div",
                {
                  style: {
                    background: "#0a0a0a",
                    border: "1px solid #1a1a1a",
                    borderRadius: "8px",
                    padding: "12px",
                    marginBottom: "16px",
                    fontSize: "13px",
                    color: "#a1a1aa",
                    display: "flex",
                    alignItems: "center",
                    gap: "8px"
                  },
                  children: [
                    /* @__PURE__ */ jsxRuntimeExports.jsx(CircleAlert, { size: 16, style: { color: "#3b82f6" } }),
                    "Detecting levels from sample URLs..."
                  ]
                }
              ),
              levelWarning && !isDetectingLevels && /* @__PURE__ */ jsxRuntimeExports.jsxs(
                "div",
                {
                  style: {
                    background: "#1a0a0a",
                    border: "1px solid #eab308",
                    borderRadius: "8px",
                    padding: "12px",
                    marginBottom: "16px",
                    fontSize: "13px",
                    color: "#fbbf24",
                    display: "flex",
                    alignItems: "center",
                    gap: "8px"
                  },
                  children: [
                    /* @__PURE__ */ jsxRuntimeExports.jsx(TriangleAlert, { size: 16 }),
                    levelWarning
                  ]
                }
              ),
              /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { style: { display: "flex", gap: "16px", marginBottom: "24px" }, children: [
                /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { style: { flex: 1 }, children: [
                  /* @__PURE__ */ jsxRuntimeExports.jsx("label", { style: { display: "block", marginBottom: "8px", fontSize: "14px", fontWeight: "500" }, children: "Min Level" }),
                  /* @__PURE__ */ jsxRuntimeExports.jsx(
                    "input",
                    {
                      type: "number",
                      min: "1",
                      value: minLevel,
                      onChange: (e) => setMinLevel(parseInt(e.target.value) || 1),
                      style: {
                        width: "100%",
                        padding: "10px 12px",
                        background: "#0a0a0a",
                        border: "1px solid #1a1a1a",
                        borderRadius: "8px",
                        color: "#e5e5e5",
                        fontSize: "14px"
                      }
                    }
                  )
                ] }),
                /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { style: { flex: 1 }, children: [
                  /* @__PURE__ */ jsxRuntimeExports.jsx("label", { style: { display: "block", marginBottom: "8px", fontSize: "14px", fontWeight: "500" }, children: "Max Level" }),
                  /* @__PURE__ */ jsxRuntimeExports.jsx(
                    "input",
                    {
                      type: "number",
                      min: "1",
                      value: maxLevel,
                      onChange: (e) => setMaxLevel(parseInt(e.target.value) || 999),
                      style: {
                        width: "100%",
                        padding: "10px 12px",
                        background: "#0a0a0a",
                        border: "1px solid #1a1a1a",
                        borderRadius: "8px",
                        color: "#e5e5e5",
                        fontSize: "14px"
                      }
                    }
                  )
                ] })
              ] }),
              /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { style: { display: "flex", gap: "12px", justifyContent: "flex-end" }, children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx("button", { onClick: handleClose, className: "button", disabled: isImporting, children: "Cancel" }),
                /* @__PURE__ */ jsxRuntimeExports.jsx(
                  "button",
                  {
                    onClick: handleImport,
                    className: "button",
                    disabled: isImporting,
                    style: {
                      background: "#3b82f6",
                      color: "#fff",
                      fontWeight: "500"
                    },
                    children: isImporting ? "Importing..." : "Import"
                  }
                )
              ] })
            ] })
          ]
        }
      )
    }
  );
};
const GITHUB_RAW_URL = "https://raw.githubusercontent.com/Saturate/LazyFrog/refs/heads/main/db/missions.json";
const ImportDatabaseModal = ({
  isOpen,
  onClose,
  onImportComplete
}) => {
  const [progress, setProgress] = reactExports.useState({
    phase: "fetching",
    message: "Connecting to FrogDB..."
  });
  const [results, setResults] = reactExports.useState(null);
  const [error, setError] = reactExports.useState(null);
  reactExports.useEffect(() => {
    if (isOpen) {
      startImport();
    }
  }, [isOpen]);
  const startImport = async () => {
    try {
      setProgress({ phase: "fetching", message: "Fetching missions from FrogDB..." });
      setResults(null);
      setError(null);
      const response = await fetch(GITHUB_RAW_URL);
      if (!response.ok) {
        throw new Error(`Failed to fetch: ${response.status} ${response.statusText}`);
      }
      const data = await response.json();
      const missionsArray = Object.values(data);
      setProgress({
        phase: "processing",
        message: "Processing missions...",
        totalCount: missionsArray.length,
        processedCount: 0
      });
      const existingMissions = await getAllMissions();
      const existingPostIds = new Set(Object.keys(existingMissions));
      let newCount = 0;
      let updatedCount = 0;
      let skippedCount = 0;
      const batchSize = 50;
      for (let i = 0; i < missionsArray.length; i += batchSize) {
        const batch = missionsArray.slice(i, i + batchSize);
        for (const mission of batch) {
          if (existingPostIds.has(mission.postId)) {
            updatedCount++;
          } else {
            newCount++;
          }
        }
        await importMissions(batch);
        setProgress({
          phase: "processing",
          message: "Processing missions...",
          totalCount: missionsArray.length,
          processedCount: Math.min(i + batchSize, missionsArray.length)
        });
        await new Promise((resolve) => setTimeout(resolve, 10));
      }
      skippedCount = missionsArray.length - newCount - updatedCount;
      const finalResults = {
        newMissions: newCount,
        updatedMissions: updatedCount,
        skippedMissions: skippedCount,
        totalInDatabase: missionsArray.length
      };
      setResults(finalResults);
      setProgress({
        phase: "complete",
        message: "Import complete!"
      });
      onImportComplete();
    } catch (err) {
      console.error("Import error:", err);
      const errorMessage = err instanceof Error ? err.message : "Unknown error occurred";
      setError(errorMessage);
      setProgress({
        phase: "error",
        message: "Import failed"
      });
    }
  };
  const handleClose = () => {
    if (progress.phase !== "fetching" && progress.phase !== "processing") {
      onClose();
    }
  };
  const handleRetry = () => {
    startImport();
  };
  if (!isOpen) return null;
  return /* @__PURE__ */ jsxRuntimeExports.jsxs(
    "div",
    {
      style: {
        position: "fixed",
        top: 0,
        left: 0,
        right: 0,
        bottom: 0,
        backgroundColor: "rgba(0, 0, 0, 0.7)",
        display: "flex",
        alignItems: "center",
        justifyContent: "center",
        zIndex: 9999
      },
      onClick: handleClose,
      children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs(
          "div",
          {
            style: {
              backgroundColor: "#18181b",
              borderRadius: "12px",
              padding: "24px",
              maxWidth: "500px",
              width: "90%",
              border: "1px solid #27272a",
              boxShadow: "0 20px 25px -5px rgba(0, 0, 0, 0.5)"
            },
            onClick: (e) => e.stopPropagation(),
            children: [
              /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { style: { display: "flex", justifyContent: "space-between", alignItems: "center", marginBottom: "20px" }, children: [
                /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { style: { display: "flex", alignItems: "center", gap: "12px" }, children: [
                  /* @__PURE__ */ jsxRuntimeExports.jsx(Download, { size: 24, style: { color: "#22c55e" } }),
                  /* @__PURE__ */ jsxRuntimeExports.jsx("h2", { style: { fontSize: "20px", fontWeight: "600", color: "#e5e5e5", margin: 0 }, children: "Import from FrogDB" })
                ] }),
                progress.phase !== "fetching" && progress.phase !== "processing" && /* @__PURE__ */ jsxRuntimeExports.jsx(
                  "button",
                  {
                    onClick: handleClose,
                    style: {
                      background: "transparent",
                      border: "none",
                      color: "#71717a",
                      cursor: "pointer",
                      padding: "4px",
                      display: "flex",
                      alignItems: "center"
                    },
                    children: /* @__PURE__ */ jsxRuntimeExports.jsx(X, { size: 20 })
                  }
                )
              ] }),
              /* @__PURE__ */ jsxRuntimeExports.jsx("div", { style: { marginBottom: "20px" }, children: progress.phase === "error" ? /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
                /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { style: { display: "flex", alignItems: "center", gap: "12px", marginBottom: "12px" }, children: [
                  /* @__PURE__ */ jsxRuntimeExports.jsx(CircleAlert, { size: 24, style: { color: "#ef4444" } }),
                  /* @__PURE__ */ jsxRuntimeExports.jsx("span", { style: { fontSize: "16px", color: "#e5e5e5" }, children: progress.message })
                ] }),
                error && /* @__PURE__ */ jsxRuntimeExports.jsx(
                  "div",
                  {
                    style: {
                      padding: "12px",
                      background: "#7f1d1d",
                      borderRadius: "6px",
                      marginBottom: "12px"
                    },
                    children: /* @__PURE__ */ jsxRuntimeExports.jsx("p", { style: { fontSize: "14px", color: "#fca5a5", margin: 0 }, children: error })
                  }
                ),
                /* @__PURE__ */ jsxRuntimeExports.jsx(
                  "button",
                  {
                    onClick: handleRetry,
                    style: {
                      padding: "8px 16px",
                      background: "#22c55e",
                      border: "none",
                      borderRadius: "6px",
                      color: "white",
                      cursor: "pointer",
                      fontSize: "14px",
                      fontWeight: "500"
                    },
                    children: "Retry"
                  }
                )
              ] }) : progress.phase === "complete" ? /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
                /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { style: { display: "flex", alignItems: "center", gap: "12px", marginBottom: "16px" }, children: [
                  /* @__PURE__ */ jsxRuntimeExports.jsx(CircleCheckBig, { size: 24, style: { color: "#22c55e" } }),
                  /* @__PURE__ */ jsxRuntimeExports.jsx("span", { style: { fontSize: "16px", color: "#e5e5e5" }, children: progress.message })
                ] }),
                results && /* @__PURE__ */ jsxRuntimeExports.jsxs(
                  "div",
                  {
                    style: {
                      padding: "16px",
                      background: "#171717",
                      borderRadius: "8px",
                      border: "1px solid #27272a"
                    },
                    children: [
                      /* @__PURE__ */ jsxRuntimeExports.jsx("h3", { style: { fontSize: "14px", fontWeight: "600", color: "#a1a1aa", marginBottom: "12px" }, children: "Import Results" }),
                      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { style: { display: "flex", flexDirection: "column", gap: "8px" }, children: [
                        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { style: { display: "flex", justifyContent: "space-between" }, children: [
                          /* @__PURE__ */ jsxRuntimeExports.jsx("span", { style: { fontSize: "14px", color: "#e5e5e5" }, children: "New missions:" }),
                          /* @__PURE__ */ jsxRuntimeExports.jsx(
                            "span",
                            {
                              style: {
                                fontSize: "14px",
                                fontWeight: "600",
                                color: results.newMissions > 0 ? "#22c55e" : "#71717a"
                              },
                              children: results.newMissions
                            }
                          )
                        ] }),
                        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { style: { display: "flex", justifyContent: "space-between" }, children: [
                          /* @__PURE__ */ jsxRuntimeExports.jsx("span", { style: { fontSize: "14px", color: "#e5e5e5" }, children: "Updated missions:" }),
                          /* @__PURE__ */ jsxRuntimeExports.jsx(
                            "span",
                            {
                              style: {
                                fontSize: "14px",
                                fontWeight: "600",
                                color: results.updatedMissions > 0 ? "#3b82f6" : "#71717a"
                              },
                              children: results.updatedMissions
                            }
                          )
                        ] }),
                        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { style: { display: "flex", justifyContent: "space-between" }, children: [
                          /* @__PURE__ */ jsxRuntimeExports.jsx("span", { style: { fontSize: "14px", color: "#e5e5e5" }, children: "Total in database:" }),
                          /* @__PURE__ */ jsxRuntimeExports.jsx("span", { style: { fontSize: "14px", fontWeight: "600", color: "#e5e5e5" }, children: results.totalInDatabase })
                        ] })
                      ] })
                    ]
                  }
                ),
                /* @__PURE__ */ jsxRuntimeExports.jsx(
                  "button",
                  {
                    onClick: handleClose,
                    style: {
                      marginTop: "16px",
                      padding: "8px 16px",
                      background: "#22c55e",
                      border: "none",
                      borderRadius: "6px",
                      color: "white",
                      cursor: "pointer",
                      fontSize: "14px",
                      fontWeight: "500",
                      width: "100%"
                    },
                    children: "Done"
                  }
                )
              ] }) : /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
                /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { style: { display: "flex", alignItems: "center", gap: "12px", marginBottom: "16px" }, children: [
                  /* @__PURE__ */ jsxRuntimeExports.jsx(Loader, { size: 24, style: { color: "#22c55e", animation: "spin 1s linear infinite" } }),
                  /* @__PURE__ */ jsxRuntimeExports.jsx("span", { style: { fontSize: "16px", color: "#e5e5e5" }, children: progress.message })
                ] }),
                progress.totalCount && progress.processedCount !== void 0 && /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
                  /* @__PURE__ */ jsxRuntimeExports.jsx(
                    "div",
                    {
                      style: {
                        width: "100%",
                        height: "8px",
                        background: "#27272a",
                        borderRadius: "4px",
                        overflow: "hidden",
                        marginBottom: "8px"
                      },
                      children: /* @__PURE__ */ jsxRuntimeExports.jsx(
                        "div",
                        {
                          style: {
                            width: `${progress.processedCount / progress.totalCount * 100}%`,
                            height: "100%",
                            background: "linear-gradient(to right, #22c55e, #16a34a)",
                            transition: "width 0.3s ease"
                          }
                        }
                      )
                    }
                  ),
                  /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { style: { textAlign: "center", fontSize: "14px", color: "#a1a1aa" }, children: [
                    progress.processedCount,
                    " / ",
                    progress.totalCount
                  ] })
                ] })
              ] }) }),
              progress.phase === "fetching" && /* @__PURE__ */ jsxRuntimeExports.jsx(
                "div",
                {
                  style: {
                    padding: "12px",
                    background: "#171717",
                    borderRadius: "6px",
                    border: "1px solid #27272a"
                  },
                  children: /* @__PURE__ */ jsxRuntimeExports.jsx("p", { style: { fontSize: "13px", color: "#a1a1aa", margin: 0 }, children: "Importing community-contributed missions from the FrogDB database..." })
                }
              )
            ]
          }
        ),
        /* @__PURE__ */ jsxRuntimeExports.jsx("style", { children: `
          @keyframes spin {
            from { transform: rotate(0deg); }
            to { transform: rotate(360deg); }
          }
        ` })
      ]
    }
  );
};
const MissionsTab = () => {
  const [missions, setMissions] = reactExports.useState([]);
  const [filteredMissions, setFilteredMissions] = reactExports.useState([]);
  const [clearedPostIds, setClearedPostIds] = reactExports.useState([]);
  const [disabledPostIds, setDisabledPostIds] = reactExports.useState([]);
  const fileInputRef = reactExports.useRef(null);
  const [isImportFromUrlsModalOpen, setIsImportFromUrlsModalOpen] = reactExports.useState(false);
  const [isImportDatabaseModalOpen, setIsImportDatabaseModalOpen] = reactExports.useState(false);
  const [searchQuery, setSearchQuery] = reactExports.useState(() => {
    return localStorage.getItem("missionsTab.searchQuery") || "";
  });
  const [showCompleted, setShowCompleted] = reactExports.useState(() => {
    const saved = localStorage.getItem("missionsTab.showCompleted");
    return saved !== null ? JSON.parse(saved) : true;
  });
  const [showUncompleted, setShowUncompleted] = reactExports.useState(() => {
    const saved = localStorage.getItem("missionsTab.showUncompleted");
    return saved !== null ? JSON.parse(saved) : true;
  });
  const [difficultyFilter, setDifficultyFilter] = reactExports.useState(() => {
    const saved = localStorage.getItem("missionsTab.difficultyFilter");
    return saved ? JSON.parse(saved) : [1, 2, 3, 4, 5];
  });
  const [showMiniboss, setShowMiniboss] = reactExports.useState(() => {
    const saved = localStorage.getItem("missionsTab.showMiniboss");
    return saved !== null ? JSON.parse(saved) : null;
  });
  const [minLevelFilter, setMinLevelFilter] = reactExports.useState(() => {
    const saved = localStorage.getItem("missionsTab.minLevelFilter");
    return saved !== null ? parseInt(saved) : 1;
  });
  const [maxLevelFilter, setMaxLevelFilter] = reactExports.useState(() => {
    const saved = localStorage.getItem("missionsTab.maxLevelFilter");
    return saved !== null ? parseInt(saved) : 999;
  });
  const [sortConfig, setSortConfig] = reactExports.useState(() => {
    const saved = localStorage.getItem("missionsTab.sortConfig");
    return saved ? JSON.parse(saved) : { field: "timestamp", direction: "desc" };
  });
  const [stats, setStats] = reactExports.useState({
    total: 0,
    cleared: 0,
    uncleared: 0,
    byDifficulty: {}
  });
  reactExports.useEffect(() => {
    loadMissions();
  }, []);
  reactExports.useEffect(() => {
    localStorage.setItem("missionsTab.searchQuery", searchQuery);
  }, [searchQuery]);
  reactExports.useEffect(() => {
    localStorage.setItem("missionsTab.showCompleted", JSON.stringify(showCompleted));
  }, [showCompleted]);
  reactExports.useEffect(() => {
    localStorage.setItem("missionsTab.showUncompleted", JSON.stringify(showUncompleted));
  }, [showUncompleted]);
  reactExports.useEffect(() => {
    localStorage.setItem("missionsTab.difficultyFilter", JSON.stringify(difficultyFilter));
  }, [difficultyFilter]);
  reactExports.useEffect(() => {
    localStorage.setItem("missionsTab.showMiniboss", JSON.stringify(showMiniboss));
  }, [showMiniboss]);
  reactExports.useEffect(() => {
    localStorage.setItem("missionsTab.minLevelFilter", minLevelFilter.toString());
  }, [minLevelFilter]);
  reactExports.useEffect(() => {
    localStorage.setItem("missionsTab.maxLevelFilter", maxLevelFilter.toString());
  }, [maxLevelFilter]);
  reactExports.useEffect(() => {
    localStorage.setItem("missionsTab.sortConfig", JSON.stringify(sortConfig));
  }, [sortConfig]);
  reactExports.useEffect(() => {
    let filtered = missions;
    if (!showCompleted) {
      filtered = filtered.filter((m) => !clearedPostIds.includes(m.postId));
    }
    if (!showUncompleted) {
      filtered = filtered.filter((m) => clearedPostIds.includes(m.postId));
    }
    const allDifficultiesSelected = difficultyFilter.length === 5 && [1, 2, 3, 4, 5].every((d) => difficultyFilter.includes(d));
    filtered = filtered.filter((m) => {
      const diff = m.difficulty;
      if (allDifficultiesSelected) {
        return true;
      }
      return diff !== void 0 && diff !== null && difficultyFilter.includes(diff);
    });
    if (showMiniboss !== null) {
      filtered = filtered.filter((m) => {
        const hasMiniboss = m.environment?.toLowerCase().includes("miniboss");
        return hasMiniboss === showMiniboss;
      });
    }
    filtered = filtered.filter((m) => {
      if (m.minLevel !== void 0 && m.minLevel < minLevelFilter) {
        return false;
      }
      if (m.maxLevel !== void 0 && m.maxLevel > maxLevelFilter) {
        return false;
      }
      return true;
    });
    if (searchQuery) {
      const query = searchQuery.toLowerCase();
      filtered = filtered.filter((m) => {
        return m.foodName?.toLowerCase().includes(query) || m.missionTitle?.toLowerCase().includes(query) || m.environment?.toLowerCase().includes(query) || m.postId?.toLowerCase().includes(query) || m.missionAuthorName?.toLowerCase().includes(query);
      });
    }
    filtered.sort((a, b) => {
      let aVal;
      let bVal;
      switch (sortConfig.field) {
        case "timestamp":
          aVal = a.timestamp || 0;
          bVal = b.timestamp || 0;
          break;
        case "difficulty":
          aVal = a.difficulty || 0;
          bVal = b.difficulty || 0;
          break;
        case "minLevel":
          aVal = a.minLevel || 0;
          bVal = b.minLevel || 0;
          break;
        case "foodName":
          aVal = a.foodName || "";
          bVal = b.foodName || "";
          break;
        case "author":
          aVal = a.missionAuthorName || "";
          bVal = b.missionAuthorName || "";
          break;
        default:
          aVal = a.timestamp || 0;
          bVal = b.timestamp || 0;
      }
      if (aVal < bVal) return sortConfig.direction === "asc" ? -1 : 1;
      if (aVal > bVal) return sortConfig.direction === "asc" ? 1 : -1;
      return 0;
    });
    setFilteredMissions(filtered);
  }, [
    missions,
    clearedPostIds,
    showCompleted,
    showUncompleted,
    difficultyFilter,
    showMiniboss,
    minLevelFilter,
    maxLevelFilter,
    searchQuery,
    sortConfig
  ]);
  reactExports.useEffect(() => {
    const cleared = clearedPostIds.length;
    const byDifficulty = {};
    missions.forEach((m) => {
      const diff = m.difficulty || 0;
      byDifficulty[diff] = (byDifficulty[diff] || 0) + 1;
    });
    setStats({
      total: missions.length,
      cleared,
      uncleared: missions.length - cleared,
      byDifficulty
    });
  }, [missions, clearedPostIds]);
  const loadMissions = async () => {
    const [allMissions, progress] = await Promise.all([getAllMissions(), getAllUserProgress()]);
    const missionArray = Object.values(allMissions);
    setMissions(missionArray);
    setClearedPostIds(progress.cleared);
    setDisabledPostIds(progress.disabled);
  };
  const handleImport = () => {
    fileInputRef.current?.click();
  };
  const handleFileSelect = async (event) => {
    const file = event.target.files?.[0];
    if (!file) return;
    try {
      const text2 = await file.text();
      const stats2 = await importMissions(text2, "merge");
      let message = `Import completed!

Imported: ${stats2.imported}
Skipped (duplicates): ${stats2.skipped}`;
      if (stats2.errors.length > 0) {
        message += `

Errors:
${stats2.errors.slice(0, 5).join("\n")}`;
        if (stats2.errors.length > 5) {
          message += `
... and ${stats2.errors.length - 5} more`;
        }
      }
      alert(message);
      await loadMissions();
      if (fileInputRef.current) {
        fileInputRef.current.value = "";
      }
    } catch (err) {
      alert(`Failed to import missions: ${err}`);
    }
  };
  const handleExport = () => {
    const missionsExport = {};
    missions.forEach((mission) => {
      missionsExport[mission.postId] = mission;
    });
    const json = JSON.stringify(missionsExport, null, 2);
    const blob = new Blob([json], { type: "application/json" });
    const url = URL.createObjectURL(blob);
    const a = document.createElement("a");
    a.href = url;
    a.download = `missions-${Date.now()}.json`;
    a.click();
    URL.revokeObjectURL(url);
  };
  const handleExportForDB = () => {
    const count2 = exportMissionsForDB(missions);
    if (count2 > 0) {
      alert(`Exported ${count2} missions with metadata for database.`);
    }
  };
  const handleSort = (field) => {
    setSortConfig((prev) => ({
      field,
      direction: prev.field === field && prev.direction === "asc" ? "desc" : "asc"
    }));
  };
  const toggleDifficulty = (diff) => {
    setDifficultyFilter((prev) => {
      if (prev.includes(diff)) {
        return prev.filter((d) => d !== diff);
      } else {
        return [...prev, diff].sort();
      }
    });
  };
  return /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
    /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "grid-3", style: { marginBottom: "24px" }, children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs(
        "div",
        {
          className: "card",
          style: { display: "flex", alignItems: "center", gap: "16px", padding: "20px" },
          children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(ChartColumn, { size: 32, style: { color: "#3b82f6" } }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx("div", { style: { fontSize: "28px", fontWeight: "700", color: "#e5e5e5", lineHeight: "1" }, children: stats.total }),
              /* @__PURE__ */ jsxRuntimeExports.jsx("div", { style: { fontSize: "13px", color: "#a1a1aa", marginTop: "4px" }, children: "Total Missions" })
            ] })
          ]
        }
      ),
      /* @__PURE__ */ jsxRuntimeExports.jsxs(
        "div",
        {
          className: "card",
          style: { display: "flex", alignItems: "center", gap: "16px", padding: "20px" },
          children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(Check, { size: 32, style: { color: "#22c55e" } }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx("div", { style: { fontSize: "28px", fontWeight: "700", color: "#e5e5e5", lineHeight: "1" }, children: stats.cleared }),
              /* @__PURE__ */ jsxRuntimeExports.jsx("div", { style: { fontSize: "13px", color: "#a1a1aa", marginTop: "4px" }, children: "Cleared" })
            ] })
          ]
        }
      ),
      /* @__PURE__ */ jsxRuntimeExports.jsxs(
        "div",
        {
          className: "card",
          style: { display: "flex", alignItems: "center", gap: "16px", padding: "20px" },
          children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(Star, { size: 32, style: { color: "#eab308" } }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx("div", { style: { fontSize: "28px", fontWeight: "700", color: "#e5e5e5", lineHeight: "1" }, children: stats.uncleared }),
              /* @__PURE__ */ jsxRuntimeExports.jsx("div", { style: { fontSize: "13px", color: "#a1a1aa", marginTop: "4px" }, children: "Uncleared" })
            ] })
          ]
        }
      )
    ] }),
    /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "card", style: { marginBottom: "24px" }, children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { style: { display: "flex", gap: "12px", flexWrap: "wrap" }, children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs(
          "button",
          {
            onClick: loadMissions,
            className: "button",
            style: { display: "flex", alignItems: "center", gap: "8px" },
            children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(RefreshCw, { size: 16 }),
              "Refresh"
            ]
          }
        ),
        /* @__PURE__ */ jsxRuntimeExports.jsxs(
          "button",
          {
            onClick: handleImport,
            className: "button",
            style: { display: "flex", alignItems: "center", gap: "8px" },
            children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(Upload, { size: 16 }),
              "Import"
            ]
          }
        ),
        /* @__PURE__ */ jsxRuntimeExports.jsxs(
          "button",
          {
            onClick: () => setIsImportFromUrlsModalOpen(true),
            className: "button",
            style: { display: "flex", alignItems: "center", gap: "8px" },
            children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(Link, { size: 16 }),
              "Import from URLs"
            ]
          }
        ),
        /* @__PURE__ */ jsxRuntimeExports.jsxs(
          "button",
          {
            onClick: handleExport,
            className: "button",
            style: { display: "flex", alignItems: "center", gap: "8px" },
            children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(Download, { size: 16 }),
              "Export"
            ]
          }
        ),
        /* @__PURE__ */ jsxRuntimeExports.jsxs(
          "button",
          {
            onClick: handleExportForDB,
            className: "button",
            style: { display: "flex", alignItems: "center", gap: "8px" },
            children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(Download, { size: 16 }),
              "Export for DB"
            ]
          }
        ),
        /* @__PURE__ */ jsxRuntimeExports.jsxs(
          "button",
          {
            onClick: () => setIsImportDatabaseModalOpen(true),
            className: "button",
            style: { display: "flex", alignItems: "center", gap: "8px", background: "#22c55e", color: "white" },
            children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(Database, { size: 16 }),
              "Import from FrogDB"
            ]
          }
        )
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsx(
        "input",
        {
          ref: fileInputRef,
          type: "file",
          accept: ".json,application/json",
          onChange: handleFileSelect,
          style: { display: "none" }
        }
      )
    ] }),
    /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "card", style: { marginBottom: "24px" }, children: [
      /* @__PURE__ */ jsxRuntimeExports.jsx("div", { style: { display: "flex", gap: "12px", marginBottom: "16px", flexWrap: "wrap" }, children: /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { style: { flex: "1", minWidth: "250px", position: "relative" }, children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(
          Search,
          {
            size: 16,
            style: {
              position: "absolute",
              left: "12px",
              top: "50%",
              transform: "translateY(-50%)",
              color: "#71717a"
            }
          }
        ),
        /* @__PURE__ */ jsxRuntimeExports.jsx(
          "input",
          {
            type: "text",
            placeholder: "Search missions...",
            value: searchQuery,
            onChange: (e) => setSearchQuery(e.target.value),
            style: {
              width: "100%",
              padding: "10px 12px 10px 36px",
              background: "#0a0a0a",
              border: "1px solid #1a1a1a",
              borderRadius: "8px",
              color: "#e5e5e5",
              fontSize: "14px"
            }
          }
        ),
        searchQuery && /* @__PURE__ */ jsxRuntimeExports.jsx(
          "button",
          {
            onClick: () => setSearchQuery(""),
            style: {
              position: "absolute",
              right: "8px",
              top: "50%",
              transform: "translateY(-50%)",
              background: "transparent",
              border: "none",
              color: "#71717a",
              cursor: "pointer",
              padding: "4px",
              display: "flex",
              alignItems: "center"
            },
            children: /* @__PURE__ */ jsxRuntimeExports.jsx(X, { size: 16 })
          }
        )
      ] }) }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { style: { display: "flex", gap: "16px", flexWrap: "wrap", alignItems: "center" }, children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs(
          "label",
          {
            style: {
              display: "flex",
              alignItems: "center",
              gap: "8px",
              color: "#a1a1aa",
              fontSize: "14px",
              cursor: "pointer"
            },
            children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(
                "input",
                {
                  type: "checkbox",
                  checked: showCompleted,
                  onChange: (e) => setShowCompleted(e.target.checked),
                  style: { cursor: "pointer" }
                }
              ),
              "Completed"
            ]
          }
        ),
        /* @__PURE__ */ jsxRuntimeExports.jsxs(
          "label",
          {
            style: {
              display: "flex",
              alignItems: "center",
              gap: "8px",
              color: "#a1a1aa",
              fontSize: "14px",
              cursor: "pointer"
            },
            children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(
                "input",
                {
                  type: "checkbox",
                  checked: showUncompleted,
                  onChange: (e) => setShowUncompleted(e.target.checked),
                  style: { cursor: "pointer" }
                }
              ),
              "Uncompleted"
            ]
          }
        ),
        /* @__PURE__ */ jsxRuntimeExports.jsx("div", { style: { display: "flex", gap: "6px", marginLeft: "8px" }, children: [1, 2, 3, 4, 5].map((diff) => /* @__PURE__ */ jsxRuntimeExports.jsxs(
          "button",
          {
            onClick: () => toggleDifficulty(diff),
            style: {
              padding: "6px 12px",
              background: difficultyFilter.includes(diff) ? "#3b82f6" : "#0a0a0a",
              border: difficultyFilter.includes(diff) ? "1px solid #3b82f6" : "1px solid #1a1a1a",
              borderRadius: "6px",
              color: difficultyFilter.includes(diff) ? "#fff" : "#a1a1aa",
              fontSize: "13px",
              cursor: "pointer",
              display: "flex",
              alignItems: "center",
              gap: "4px",
              fontWeight: "500",
              transition: "all 0.2s"
            },
            children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(Star, { size: 14 }),
              diff
            ]
          },
          diff
        )) }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs(
          "select",
          {
            value: showMiniboss === null ? "all" : showMiniboss ? "yes" : "no",
            onChange: (e) => {
              const val = e.target.value;
              setShowMiniboss(val === "all" ? null : val === "yes");
            },
            style: {
              padding: "8px 12px",
              background: "#0a0a0a",
              border: "1px solid #1a1a1a",
              borderRadius: "6px",
              color: "#e5e5e5",
              fontSize: "14px",
              cursor: "pointer"
            },
            children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx("option", { value: "all", children: "All Environments" }),
              /* @__PURE__ */ jsxRuntimeExports.jsx("option", { value: "yes", children: "Miniboss Only" }),
              /* @__PURE__ */ jsxRuntimeExports.jsx("option", { value: "no", children: "No Miniboss" })
            ]
          }
        ),
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { style: { display: "flex", alignItems: "center", gap: "8px", marginLeft: "8px" }, children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("label", { style: { fontSize: "14px", color: "#a1a1aa" }, children: "Min Level:" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(
            "input",
            {
              type: "number",
              min: "1",
              value: minLevelFilter,
              onChange: (e) => setMinLevelFilter(parseInt(e.target.value) || 1),
              style: {
                width: "70px",
                padding: "6px 8px",
                background: "#0a0a0a",
                border: "1px solid #1a1a1a",
                borderRadius: "6px",
                color: "#e5e5e5",
                fontSize: "14px"
              }
            }
          )
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { style: { display: "flex", alignItems: "center", gap: "8px" }, children: [
          /* @__PURE__ */ jsxRuntimeExports.jsx("label", { style: { fontSize: "14px", color: "#a1a1aa" }, children: "Max Level:" }),
          /* @__PURE__ */ jsxRuntimeExports.jsx(
            "input",
            {
              type: "number",
              min: "1",
              value: maxLevelFilter,
              onChange: (e) => setMaxLevelFilter(parseInt(e.target.value) || 999),
              style: {
                width: "70px",
                padding: "6px 8px",
                background: "#0a0a0a",
                border: "1px solid #1a1a1a",
                borderRadius: "6px",
                color: "#e5e5e5",
                fontSize: "14px"
              }
            }
          )
        ] })
      ] })
    ] }),
    /* @__PURE__ */ jsxRuntimeExports.jsx("div", { className: "card", style: { padding: "0", overflow: "hidden" }, children: filteredMissions.length > 0 ? /* @__PURE__ */ jsxRuntimeExports.jsxs(jsxRuntimeExports.Fragment, { children: [
      /* @__PURE__ */ jsxRuntimeExports.jsx("div", { style: { overflowX: "auto" }, children: /* @__PURE__ */ jsxRuntimeExports.jsxs("table", { style: { width: "100%", borderCollapse: "collapse" }, children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx("thead", { children: /* @__PURE__ */ jsxRuntimeExports.jsxs("tr", { style: { borderBottom: "1px solid #1a1a1a" }, children: [
          /* @__PURE__ */ jsxRuntimeExports.jsxs(
            "th",
            {
              onClick: () => handleSort("timestamp"),
              style: {
                padding: "16px",
                textAlign: "left",
                fontSize: "13px",
                fontWeight: "600",
                color: "#a1a1aa",
                cursor: "pointer",
                userSelect: "none",
                background: sortConfig.field === "timestamp" ? "#171717" : "transparent"
              },
              children: [
                "Date",
                " ",
                sortConfig.field === "timestamp" && (sortConfig.direction === "asc" ? "↑" : "↓")
              ]
            }
          ),
          /* @__PURE__ */ jsxRuntimeExports.jsxs(
            "th",
            {
              onClick: () => handleSort("foodName"),
              style: {
                padding: "16px",
                textAlign: "left",
                fontSize: "13px",
                fontWeight: "600",
                color: "#a1a1aa",
                cursor: "pointer",
                userSelect: "none",
                background: sortConfig.field === "foodName" ? "#171717" : "transparent"
              },
              children: [
                "Mission",
                " ",
                sortConfig.field === "foodName" && (sortConfig.direction === "asc" ? "↑" : "↓")
              ]
            }
          ),
          /* @__PURE__ */ jsxRuntimeExports.jsxs(
            "th",
            {
              onClick: () => handleSort("author"),
              style: {
                padding: "16px",
                textAlign: "left",
                fontSize: "13px",
                fontWeight: "600",
                color: "#a1a1aa",
                cursor: "pointer",
                userSelect: "none",
                background: sortConfig.field === "author" ? "#171717" : "transparent"
              },
              children: [
                "Author",
                " ",
                sortConfig.field === "author" && (sortConfig.direction === "asc" ? "↑" : "↓")
              ]
            }
          ),
          /* @__PURE__ */ jsxRuntimeExports.jsxs(
            "th",
            {
              onClick: () => handleSort("difficulty"),
              style: {
                padding: "16px",
                textAlign: "left",
                fontSize: "13px",
                fontWeight: "600",
                color: "#a1a1aa",
                cursor: "pointer",
                userSelect: "none",
                background: sortConfig.field === "difficulty" ? "#171717" : "transparent"
              },
              children: [
                "Difficulty",
                " ",
                sortConfig.field === "difficulty" && (sortConfig.direction === "asc" ? "↑" : "↓")
              ]
            }
          ),
          /* @__PURE__ */ jsxRuntimeExports.jsxs(
            "th",
            {
              onClick: () => handleSort("minLevel"),
              style: {
                padding: "16px",
                textAlign: "left",
                fontSize: "13px",
                fontWeight: "600",
                color: "#a1a1aa",
                cursor: "pointer",
                userSelect: "none",
                background: sortConfig.field === "minLevel" ? "#171717" : "transparent"
              },
              children: [
                "Level",
                " ",
                sortConfig.field === "minLevel" && (sortConfig.direction === "asc" ? "↑" : "↓")
              ]
            }
          ),
          /* @__PURE__ */ jsxRuntimeExports.jsx(
            "th",
            {
              style: {
                padding: "16px",
                textAlign: "left",
                fontSize: "13px",
                fontWeight: "600",
                color: "#a1a1aa"
              },
              children: "Metadata"
            }
          ),
          /* @__PURE__ */ jsxRuntimeExports.jsx(
            "th",
            {
              style: {
                padding: "16px",
                textAlign: "left",
                fontSize: "13px",
                fontWeight: "600",
                color: "#a1a1aa"
              },
              children: "Rewards"
            }
          ),
          /* @__PURE__ */ jsxRuntimeExports.jsx(
            "th",
            {
              style: {
                padding: "16px",
                textAlign: "left",
                fontSize: "13px",
                fontWeight: "600",
                color: "#a1a1aa"
              },
              children: "Environment"
            }
          ),
          /* @__PURE__ */ jsxRuntimeExports.jsx(
            "th",
            {
              style: {
                padding: "16px",
                textAlign: "left",
                fontSize: "13px",
                fontWeight: "600",
                color: "#a1a1aa"
              },
              children: "Status"
            }
          ),
          /* @__PURE__ */ jsxRuntimeExports.jsx(
            "th",
            {
              style: {
                padding: "16px",
                textAlign: "right",
                fontSize: "13px",
                fontWeight: "600",
                color: "#a1a1aa"
              },
              children: "Actions"
            }
          )
        ] }) }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("tbody", { children: filteredMissions.map((mission) => /* @__PURE__ */ jsxRuntimeExports.jsxs(
          "tr",
          {
            style: {
              borderBottom: "1px solid #1a1a1a",
              opacity: clearedPostIds.includes(mission.postId) ? 0.6 : 1,
              transition: "background 0.2s"
            },
            onMouseEnter: (e) => e.currentTarget.style.background = "#171717",
            onMouseLeave: (e) => e.currentTarget.style.background = "transparent",
            children: [
              /* @__PURE__ */ jsxRuntimeExports.jsx(
                "td",
                {
                  style: {
                    padding: "14px 16px",
                    fontSize: "13px",
                    color: "#a1a1aa",
                    whiteSpace: "nowrap"
                  },
                  children: mission.timestamp ? new Date(mission.timestamp).toLocaleDateString() : "N/A"
                }
              ),
              /* @__PURE__ */ jsxRuntimeExports.jsx("td", { style: { padding: "14px 16px", fontSize: "14px" }, children: /* @__PURE__ */ jsxRuntimeExports.jsx(
                "a",
                {
                  href: mission.permalink,
                  target: "_blank",
                  rel: "noopener noreferrer",
                  style: { color: "#3b82f6", textDecoration: "none", fontWeight: "500" },
                  children: mission.foodName || "Unknown"
                }
              ) }),
              /* @__PURE__ */ jsxRuntimeExports.jsx("td", { style: { padding: "14px 16px", fontSize: "13px", color: "#a1a1aa" }, children: mission.missionAuthorName || "N/A" }),
              /* @__PURE__ */ jsxRuntimeExports.jsx("td", { style: { padding: "14px 16px", fontSize: "16px", color: "#eab308" }, children: mission.difficulty ? "★".repeat(mission.difficulty) : /* @__PURE__ */ jsxRuntimeExports.jsx("span", { style: { fontSize: "13px", color: "#71717a" }, children: "N/A" }) }),
              /* @__PURE__ */ jsxRuntimeExports.jsx(
                "td",
                {
                  style: {
                    padding: "14px 16px",
                    fontSize: "13px",
                    color: "#e5e5e5",
                    fontWeight: "500"
                  },
                  children: mission.minLevel && mission.maxLevel ? `${mission.minLevel}-${mission.maxLevel}` : /* @__PURE__ */ jsxRuntimeExports.jsx("span", { style: { color: "#71717a" }, children: "N/A" })
                }
              ),
              /* @__PURE__ */ jsxRuntimeExports.jsx("td", { style: { padding: "14px 16px", fontSize: "13px", color: "#a1a1aa" }, children: mission.environment || "N/A" }),
              /* @__PURE__ */ jsxRuntimeExports.jsx("td", { style: { padding: "14px 16px", textAlign: "center" }, children: mission.encounters && mission.encounters.length > 0 ? /* @__PURE__ */ jsxRuntimeExports.jsx(
                "span",
                {
                  title: `${mission.encounters.length} encounters`,
                  style: { cursor: "help" },
                  children: /* @__PURE__ */ jsxRuntimeExports.jsx(Check, { size: 16, color: "#22c55e" })
                }
              ) : /* @__PURE__ */ jsxRuntimeExports.jsx(
                "span",
                {
                  title: "No metadata - play mission to capture",
                  style: { cursor: "help", opacity: 0.4 },
                  children: /* @__PURE__ */ jsxRuntimeExports.jsx(ChartColumn, { size: 16, color: "#666" })
                }
              ) }),
              /* @__PURE__ */ jsxRuntimeExports.jsx("td", { style: { padding: "14px 16px", textAlign: "center" }, children: /* @__PURE__ */ jsxRuntimeExports.jsx("span", { title: "Loot data not displayed in list view", className: "no-rewards", children: "—" }) }),
              /* @__PURE__ */ jsxRuntimeExports.jsx("td", { style: { padding: "14px 16px" }, children: disabledPostIds.includes(mission.postId) ? /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "status-badge disabled", children: "Disabled" }) : clearedPostIds.includes(mission.postId) ? /* @__PURE__ */ jsxRuntimeExports.jsxs("span", { className: "status-badge completed", children: [
                /* @__PURE__ */ jsxRuntimeExports.jsx(Check, { size: 14 }),
                "Cleared"
              ] }) : /* @__PURE__ */ jsxRuntimeExports.jsx("span", { className: "status-badge uncompleted", children: "Pending" }) }),
              /* @__PURE__ */ jsxRuntimeExports.jsxs(
                "td",
                {
                  style: { padding: "14px 16px", textAlign: "right", whiteSpace: "nowrap" },
                  children: [
                    /* @__PURE__ */ jsxRuntimeExports.jsx(
                      "button",
                      {
                        className: "button btn-action",
                        onClick: async () => {
                          const { generateMissionMarkdown: generateMissionMarkdown2 } = await __vitePreload(async () => {
                            const { generateMissionMarkdown: generateMissionMarkdown22 } = await import("./missionMarkdown-zmN4yOrf.js");
                            return { generateMissionMarkdown: generateMissionMarkdown22 };
                          }, true ? [] : void 0);
                          const md = generateMissionMarkdown2(mission);
                          if (md) {
                            await navigator.clipboard.writeText(md);
                            alert("Mission markdown copied to clipboard");
                          } else {
                            alert(
                              "No metadata available for this mission. Play it once to capture metadata."
                            );
                          }
                        },
                        children: "Copy Markdown"
                      }
                    ),
                    /* @__PURE__ */ jsxRuntimeExports.jsx(
                      "button",
                      {
                        className: "button",
                        onClick: async () => {
                          const { setMissionDisabled } = await __vitePreload(async () => {
                            const { setMissionDisabled: setMissionDisabled2 } = await import("./missions-CTZOI1oz.js").then((n) => n.o);
                            return { setMissionDisabled: setMissionDisabled2 };
                          }, true ? [] : void 0);
                          const isDisabled = disabledPostIds.includes(mission.postId);
                          await setMissionDisabled(mission.postId, !isDisabled);
                          if (isDisabled) {
                            setDisabledPostIds((prev) => prev.filter((id) => id !== mission.postId));
                          } else {
                            setDisabledPostIds((prev) => [...prev, mission.postId]);
                          }
                        },
                        children: disabledPostIds.includes(mission.postId) ? "Enable" : "Disable"
                      }
                    )
                  ]
                }
              )
            ]
          },
          mission.postId
        )) })
      ] }) }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs(
        "div",
        {
          style: {
            padding: "16px",
            borderTop: "1px solid #1a1a1a",
            fontSize: "14px",
            color: "#71717a"
          },
          children: [
            "Showing ",
            filteredMissions.length,
            " of ",
            missions.length,
            " missions"
          ]
        }
      )
    ] }) : /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { style: { textAlign: "center", padding: "60px 20px", color: "#71717a" }, children: [
      /* @__PURE__ */ jsxRuntimeExports.jsx(ChartColumn, { size: 48, style: { margin: "0 auto 16px", opacity: 0.5 } }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("p", { style: { margin: 0, fontSize: "16px" }, children: "No missions found" })
    ] }) }),
    /* @__PURE__ */ jsxRuntimeExports.jsx(
      ImportFromUrlsModal,
      {
        isOpen: isImportFromUrlsModalOpen,
        onClose: () => setIsImportFromUrlsModalOpen(false),
        onImportComplete: loadMissions
      }
    ),
    /* @__PURE__ */ jsxRuntimeExports.jsx(
      ImportDatabaseModal,
      {
        isOpen: isImportDatabaseModalOpen,
        onClose: () => setIsImportDatabaseModalOpen(false),
        onImportComplete: loadMissions
      }
    )
  ] });
};
const AboutTab = () => {
  const buildDate = /* @__PURE__ */ new Date("2025-11-05T15:49:07.024Z");
  const now = /* @__PURE__ */ new Date();
  const hoursAgo = Math.floor((now.getTime() - buildDate.getTime()) / (1e3 * 60 * 60));
  return /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
    /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "card", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs("h2", { children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(
          Info,
          {
            size: 20,
            style: {
              display: "inline-block",
              marginRight: "8px",
              verticalAlign: "middle"
            }
          }
        ),
        "About LazyFrog"
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { style: { marginBottom: "24px" }, children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { style: { fontSize: "14px", color: "#a1a1aa", marginBottom: "8px" }, children: [
          "Version: ",
          /* @__PURE__ */ jsxRuntimeExports.jsx("span", { style: { color: "#e5e5e5", fontWeight: "500" }, children: "0.16.0" })
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { style: { fontSize: "14px", color: "#a1a1aa" }, children: [
          "Build:",
          " ",
          /* @__PURE__ */ jsxRuntimeExports.jsx("span", { style: { color: "#e5e5e5", fontWeight: "500" }, children: hoursAgo < 1 ? "Less than 1 hour ago" : `${hoursAgo} hour${hoursAgo > 1 ? "s" : ""} ago` })
        ] })
      ] })
    ] }),
    /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "card", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs("h2", { children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(
          Rocket,
          {
            size: 20,
            style: {
              display: "inline-block",
              marginRight: "8px",
              verticalAlign: "middle"
            }
          }
        ),
        "Quick Start"
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("ol", { style: { color: "#a1a1aa", lineHeight: "1.8", paddingLeft: "20px" }, children: [
        /* @__PURE__ */ jsxRuntimeExports.jsxs("li", { children: [
          "Configure mission filters in the",
          " ",
          /* @__PURE__ */ jsxRuntimeExports.jsx("strong", { style: { color: "#3b82f6" }, children: "Automation" }),
          " tab"
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs("li", { children: [
          "Adjust automation settings in the ",
          /* @__PURE__ */ jsxRuntimeExports.jsx("strong", { style: { color: "#3b82f6" }, children: "Settings" }),
          " ",
          "tab"
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("li", { children: "Visit a Sword & Supper post on Reddit" }),
        /* @__PURE__ */ jsxRuntimeExports.jsxs("li", { children: [
          "Click the ",
          /* @__PURE__ */ jsxRuntimeExports.jsx("strong", { style: { color: "#22c55e" }, children: "START" }),
          " button in the control panel"
        ] }),
        /* @__PURE__ */ jsxRuntimeExports.jsx("li", { children: "The bot will automatically find and complete missions" })
      ] })
    ] }),
    /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "card", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs("h2", { children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(
          Link,
          {
            size: 20,
            style: {
              display: "inline-block",
              marginRight: "8px",
              verticalAlign: "middle"
            }
          }
        ),
        "Links"
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { style: { display: "flex", flexDirection: "column", gap: "12px" }, children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(
          "a",
          {
            href: "#",
            target: "_blank",
            rel: "noopener noreferrer",
            style: {
              color: "#3b82f6",
              textDecoration: "none",
              fontSize: "14px",
              display: "flex",
              alignItems: "center",
              gap: "8px"
            },
            children: "Donate"
          }
        ),
        /* @__PURE__ */ jsxRuntimeExports.jsx(
          "a",
          {
            href: "https://www.reddit.com/r/SwordAndSupper/",
            target: "_blank",
            rel: "noopener noreferrer",
            style: {
              color: "#3b82f6",
              textDecoration: "none",
              fontSize: "14px",
              display: "flex",
              alignItems: "center",
              gap: "8px"
            },
            children: "Sword & Supper Community"
          }
        )
      ] })
    ] }),
    /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "card", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs("h2", { children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(
          TriangleAlert,
          {
            size: 20,
            style: {
              display: "inline-block",
              marginRight: "8px",
              verticalAlign: "middle"
            }
          }
        ),
        "Disclaimer"
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("p", { style: { color: "#a1a1aa", fontSize: "14px", lineHeight: "1.6" }, children: "This is an automation tool for educational purposes. Use responsibly and in accordance with Reddit's Terms of Service. The developers are not responsible for any consequences of using this tool." })
    ] }),
    /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "card", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs("h2", { children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(
          Info,
          {
            size: 20,
            style: {
              display: "inline-block",
              marginRight: "8px",
              verticalAlign: "middle"
            }
          }
        ),
        "Credits"
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("p", { style: { color: "#a1a1aa", fontSize: "14px", lineHeight: "1.6" }, children: [
        "Created by ",
        /* @__PURE__ */ jsxRuntimeExports.jsx("span", { style: { color: "#3b82f6" }, children: "Allan Kimmer Jensen" })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("p", { style: { color: "#a1a1aa", fontSize: "14px", lineHeight: "1.6" }, children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(Github, { size: 16, style: { opacity: 0.9 } }),
        " GitHub:",
        " ",
        /* @__PURE__ */ jsxRuntimeExports.jsx(
          "a",
          {
            href: "https://github.com/Saturate",
            target: "_blank",
            rel: "noopener noreferrer",
            style: {
              color: "#a855f7",
              textDecoration: "none",
              fontWeight: 500
            },
            children: "@Saturate"
          }
        )
      ] })
    ] })
  ] });
};
const DebugTab = () => {
  const [input, setInput] = reactExports.useState(
    "https://www.reddit.com/r/SwordAndSupperGame/comments/1okp2mg/in_search_of_playable_pies/"
  );
  const [isLoading, setIsLoading] = reactExports.useState(false);
  const [result, setResult] = reactExports.useState(null);
  const [error, setError] = reactExports.useState(null);
  const [copied, setCopied] = reactExports.useState(false);
  const extractPostId2 = (input2) => {
    const trimmed = input2.trim();
    if (/^t3_[a-z0-9]+$/.test(trimmed)) {
      return trimmed;
    }
    if (/^[a-z0-9]+$/.test(trimmed) && !trimmed.includes("/")) {
      return `t3_${trimmed}`;
    }
    const urlMatch = trimmed.match(/\/comments\/([a-z0-9]+)/);
    if (urlMatch) {
      return `t3_${urlMatch[1]}`;
    }
    return null;
  };
  const handleFetch = async () => {
    setError(null);
    setResult(null);
    setCopied(false);
    const postId = extractPostId2(input);
    if (!postId) {
      setError("Invalid input. Please provide a post ID (t3_xxxxx) or Reddit URL.");
      return;
    }
    setIsLoading(true);
    try {
      let tabs = await chrome.tabs.query({ url: "*://*.reddit.com/*" });
      if (tabs.length === 0) {
        setError("No Reddit tab found. Opening reddit.com...");
        const newTab = await chrome.tabs.create({
          url: "https://www.reddit.com/r/SwordAndSupperGame/",
          active: false
        });
        await new Promise((resolve) => {
          const listener = (tabId, changeInfo) => {
            if (tabId === newTab.id && changeInfo.status === "complete") {
              chrome.tabs.onUpdated.removeListener(listener);
              resolve();
            }
          };
          chrome.tabs.onUpdated.addListener(listener);
          setTimeout(() => {
            chrome.tabs.onUpdated.removeListener(listener);
            resolve();
          }, 1e4);
        });
        tabs = await chrome.tabs.query({ url: "*://*.reddit.com/*" });
        if (tabs.length === 0) {
          setError("Failed to open Reddit tab. Please try manually opening reddit.com first.");
          setIsLoading(false);
          return;
        }
        await new Promise((resolve) => setTimeout(resolve, 1e3));
        setError(null);
      }
      const redditTab = tabs[0];
      chrome.runtime.sendMessage(
        { type: "FETCH_MISSION_DATA", postId, tabId: redditTab.id },
        (response) => {
          if (chrome.runtime.lastError) {
            setError(
              `Failed to communicate with background worker: ${chrome.runtime.lastError.message}`
            );
            setIsLoading(false);
            return;
          }
          if (response?.success && response.data) {
            setResult(response.data);
          } else {
            setError(
              response?.error || "Failed to fetch mission data. Make sure you are logged into Reddit."
            );
          }
          setIsLoading(false);
        }
      );
    } catch (err) {
      setError(err instanceof Error ? err.message : String(err));
      setIsLoading(false);
    }
  };
  const handleCopy = async () => {
    if (result) {
      try {
        await navigator.clipboard.writeText(JSON.stringify(result, null, 2));
        setCopied(true);
        setTimeout(() => setCopied(false), 2e3);
      } catch (err) {
        console.error("Failed to copy:", err);
      }
    }
  };
  return /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
    /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "card", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs("h2", { style: { fontSize: "20px", fontWeight: "600", marginBottom: "8px" }, children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(
          Code,
          {
            size: 20,
            style: { display: "inline", verticalAlign: "text-bottom", marginRight: "8px" }
          }
        ),
        "Mission Data Fetcher"
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("p", { style: { color: "#a3a3a3", marginBottom: "24px", fontSize: "14px" }, children: "Fetch mission data directly from Reddit's API using a post ID or URL." }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { style: { marginBottom: "16px" }, children: [
        /* @__PURE__ */ jsxRuntimeExports.jsx(
          "label",
          {
            style: { display: "block", marginBottom: "8px", fontWeight: "500", fontSize: "14px" },
            children: "Post ID or URL"
          }
        ),
        /* @__PURE__ */ jsxRuntimeExports.jsx(
          "input",
          {
            type: "text",
            value: input,
            onChange: (e) => setInput(e.target.value),
            placeholder: "t3_1oh01dp or https://www.reddit.com/r/SwordAndSupperGame/comments/1oh01dp/...",
            style: {
              width: "100%",
              padding: "12px",
              borderRadius: "8px",
              border: "1px solid #404040",
              background: "#1a1a1a",
              color: "#e5e5e5",
              fontSize: "14px",
              fontFamily: "monospace"
            },
            onKeyDown: (e) => {
              if (e.key === "Enter" && !isLoading) {
                handleFetch();
              }
            }
          }
        ),
        /* @__PURE__ */ jsxRuntimeExports.jsx("p", { style: { marginTop: "8px", fontSize: "12px", color: "#737373" }, children: "Accepts: Post ID (t3_xxxxx), short ID (xxxxx), or full Reddit URL" })
      ] }),
      /* @__PURE__ */ jsxRuntimeExports.jsxs(
        "button",
        {
          onClick: handleFetch,
          disabled: isLoading || !input.trim(),
          className: "button",
          style: {
            display: "flex",
            alignItems: "center",
            gap: "8px",
            background: "#3b82f6",
            color: "white",
            opacity: isLoading || !input.trim() ? 0.5 : 1
          },
          children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(Play, { size: 16 }),
            isLoading ? "Fetching..." : "Fetch Mission Data"
          ]
        }
      ),
      error && /* @__PURE__ */ jsxRuntimeExports.jsxs(
        "div",
        {
          style: {
            marginTop: "16px",
            padding: "12px",
            background: "#7f1d1d",
            border: "1px solid #991b1b",
            borderRadius: "8px",
            color: "#fecaca",
            fontSize: "14px"
          },
          children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("strong", { children: "Error:" }),
            " ",
            error
          ]
        }
      ),
      /* @__PURE__ */ jsxRuntimeExports.jsxs(
        "div",
        {
          style: {
            marginTop: "24px",
            padding: "12px",
            background: "#14532d",
            border: "1px solid #166534",
            borderRadius: "8px",
            fontSize: "14px"
          },
          children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("strong", { style: { color: "#86efac" }, children: "Need to decode protobuf requests/responses?" }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs("p", { style: { marginTop: "4px", color: "#bbf7d0", fontSize: "13px" }, children: [
              "Visit the",
              " ",
              /* @__PURE__ */ jsxRuntimeExports.jsx(
                "a",
                {
                  href: "https://lazyfrog.xyz/protobuf",
                  target: "_blank",
                  rel: "noopener noreferrer",
                  style: { color: "#86efac", textDecoration: "underline" },
                  children: "Protobuf Decoder"
                }
              ),
              " ",
              "on the LazyFrog website to decode requests, responses, and HAR files."
            ] })
          ]
        }
      )
    ] }),
    result && /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "card", style: { marginTop: "24px" }, children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs(
        "div",
        {
          style: {
            display: "flex",
            justifyContent: "space-between",
            alignItems: "center",
            marginBottom: "16px"
          },
          children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("h3", { style: { fontSize: "18px", fontWeight: "600" }, children: "Result" }),
            /* @__PURE__ */ jsxRuntimeExports.jsx(
              "button",
              {
                onClick: handleCopy,
                className: "button",
                style: {
                  display: "flex",
                  alignItems: "center",
                  gap: "8px",
                  padding: "8px 12px"
                },
                children: copied ? /* @__PURE__ */ jsxRuntimeExports.jsxs(jsxRuntimeExports.Fragment, { children: [
                  /* @__PURE__ */ jsxRuntimeExports.jsx(Check, { size: 16 }),
                  "Copied!"
                ] }) : /* @__PURE__ */ jsxRuntimeExports.jsxs(jsxRuntimeExports.Fragment, { children: [
                  /* @__PURE__ */ jsxRuntimeExports.jsx(Copy, { size: 16 }),
                  "Copy JSON"
                ] })
              }
            )
          ]
        }
      ),
      /* @__PURE__ */ jsxRuntimeExports.jsx(
        "pre",
        {
          style: {
            background: "#0a0a0a",
            border: "1px solid #404040",
            borderRadius: "8px",
            padding: "16px",
            overflow: "auto",
            maxHeight: "600px",
            fontSize: "13px",
            lineHeight: "1.5",
            color: "#d4d4d4"
          },
          children: JSON.stringify(result, null, 2)
        }
      ),
      /* @__PURE__ */ jsxRuntimeExports.jsxs(
        "div",
        {
          style: {
            marginTop: "16px",
            padding: "12px",
            background: "#14532d",
            border: "1px solid #166534",
            borderRadius: "8px",
            fontSize: "14px"
          },
          children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx("strong", { style: { color: "#86efac" }, children: "Fetched successfully!" }),
            /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { style: { marginTop: "8px", color: "#bbf7d0", fontSize: "13px" }, children: [
              result.difficulty && /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
                "Difficulty: ",
                result.difficulty,
                " stars"
              ] }),
              result.minLevel && result.maxLevel && /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
                "Level Range: ",
                result.minLevel,
                " - ",
                result.maxLevel
              ] }),
              result.environment && /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
                "Environment: ",
                result.environment
              ] }),
              result.encounters && /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { children: [
                "Encounters: ",
                result.encounters.length
              ] })
            ] })
          ]
        }
      )
    ] })
  ] });
};
const OptionsPage = () => {
  const [activeTab, setActiveTab] = reactExports.useState("missions");
  const [debugMode, setDebugMode] = reactExports.useState(false);
  reactExports.useEffect(() => {
    chrome.storage.local.get(["userOptions"], (result) => {
      if (result.userOptions?.debugMode) {
        setDebugMode(true);
      }
    });
    const handleStorageChange = (changes) => {
      if (changes.userOptions?.newValue?.debugMode !== void 0) {
        setDebugMode(changes.userOptions.newValue.debugMode);
      }
    };
    chrome.storage.onChanged.addListener(handleStorageChange);
    return () => chrome.storage.onChanged.removeListener(handleStorageChange);
  }, []);
  reactExports.useEffect(() => {
    const hash = window.location.hash.slice(1);
    if (hash && ["missions", "automation", "logging", "settings", "about", "debug"].includes(hash)) {
      setActiveTab(hash);
    }
  }, []);
  const handleTabChange = (tab) => {
    setActiveTab(tab);
    window.location.hash = tab;
  };
  return /* @__PURE__ */ jsxRuntimeExports.jsxs("div", { className: "options-container", children: [
    /* @__PURE__ */ jsxRuntimeExports.jsxs("header", { className: "options-header", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsx("h1", { children: "LazyFrog Settings" }),
      /* @__PURE__ */ jsxRuntimeExports.jsx("p", { children: "Configure your Sword & Supper automation bot" })
    ] }),
    /* @__PURE__ */ jsxRuntimeExports.jsxs("nav", { className: "tab-navigation", children: [
      /* @__PURE__ */ jsxRuntimeExports.jsxs(
        "button",
        {
          className: `tab-button ${activeTab === "missions" ? "active" : ""}`,
          onClick: () => handleTabChange("missions"),
          children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(ChartColumn, { size: 16 }),
            "Missions"
          ]
        }
      ),
      /* @__PURE__ */ jsxRuntimeExports.jsxs(
        "button",
        {
          className: `tab-button ${activeTab === "automation" ? "active" : ""}`,
          onClick: () => handleTabChange("automation"),
          children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(Target, { size: 16 }),
            "Automation"
          ]
        }
      ),
      /* @__PURE__ */ jsxRuntimeExports.jsxs(
        "button",
        {
          className: `tab-button ${activeTab === "logging" ? "active" : ""}`,
          onClick: () => handleTabChange("logging"),
          children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(Terminal, { size: 16 }),
            "Logging"
          ]
        }
      ),
      /* @__PURE__ */ jsxRuntimeExports.jsxs(
        "button",
        {
          className: `tab-button ${activeTab === "settings" ? "active" : ""}`,
          onClick: () => handleTabChange("settings"),
          children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(Settings, { size: 16 }),
            "Settings"
          ]
        }
      ),
      debugMode && /* @__PURE__ */ jsxRuntimeExports.jsxs(
        "button",
        {
          className: `tab-button ${activeTab === "debug" ? "active" : ""}`,
          onClick: () => handleTabChange("debug"),
          children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(Bug, { size: 16 }),
            "Debug"
          ]
        }
      ),
      /* @__PURE__ */ jsxRuntimeExports.jsxs(
        "button",
        {
          className: `tab-button ${activeTab === "about" ? "active" : ""}`,
          onClick: () => handleTabChange("about"),
          children: [
            /* @__PURE__ */ jsxRuntimeExports.jsx(Info, { size: 16 }),
            "About"
          ]
        }
      )
    ] }),
    /* @__PURE__ */ jsxRuntimeExports.jsxs("main", { className: "tab-content", children: [
      activeTab === "missions" && /* @__PURE__ */ jsxRuntimeExports.jsx(MissionsTab, {}),
      activeTab === "automation" && /* @__PURE__ */ jsxRuntimeExports.jsx(AutomationTab, {}),
      activeTab === "logging" && /* @__PURE__ */ jsxRuntimeExports.jsx(LoggingTab, {}),
      activeTab === "settings" && /* @__PURE__ */ jsxRuntimeExports.jsx(SettingsTab, {}),
      activeTab === "debug" && debugMode && /* @__PURE__ */ jsxRuntimeExports.jsx(DebugTab, {}),
      activeTab === "about" && /* @__PURE__ */ jsxRuntimeExports.jsx(AboutTab, {})
    ] })
  ] });
};
const container = document.getElementById("root");
if (container) {
  const root = clientExports.createRoot(container);
  root.render(/* @__PURE__ */ jsxRuntimeExports.jsx(OptionsPage, {}));
}
