/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ 630:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   aB: () => (/* binding */ saveMission),
/* harmony export */   getMission: () => (/* binding */ getMission)
/* harmony export */ });
/* unused harmony exports saveMissionsBatch, getAllMissions, deleteMission, clearAllMissions, markAllMissionsIncomplete, markMissionCleared, accumulateMissionLoot, setMissionDisabled, importMissions */
/* harmony import */ var _storageTypes__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5551);
/* harmony import */ var _userProgress__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(6853);
/* harmony import */ var _utils_missionRecordMigration__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(1772);
/**
 * Mission CRUD operations
 */



/**
 * Save a mission to storage
 */
async function saveMission(mission) {
    return new Promise((resolve, reject) => {
        // Check if extension context is still valid
        if (!chrome.runtime?.id) {
            reject(new Error('Extension context invalidated'));
            return;
        }
        chrome.storage.local.get([_storageTypes__WEBPACK_IMPORTED_MODULE_0__/* .STORAGE_KEYS */ .d.MISSIONS], (result) => {
            // Check for errors on get
            if (chrome.runtime.lastError) {
                reject(chrome.runtime.lastError);
                return;
            }
            const missions = result[_storageTypes__WEBPACK_IMPORTED_MODULE_0__/* .STORAGE_KEYS */ .d.MISSIONS] || {};
            // Use postId as key to avoid duplicates
            missions[mission.postId] = mission;
            chrome.storage.local.set({ [_storageTypes__WEBPACK_IMPORTED_MODULE_0__/* .STORAGE_KEYS */ .d.MISSIONS]: missions }, () => {
                if (chrome.runtime.lastError) {
                    reject(chrome.runtime.lastError);
                }
                else {
                    // Notify background script that missions changed
                    chrome.runtime.sendMessage({
                        type: 'MISSIONS_UPDATED',
                    }).catch(() => {
                        // Ignore errors if no listeners
                    });
                    resolve();
                }
            });
        });
    });
}
/**
 * Save multiple missions to storage in a single batch operation
 */
async function saveMissionsBatch(missions) {
    return new Promise((resolve, reject) => {
        // Check if extension context is still valid
        if (!chrome.runtime?.id) {
            reject(new Error('Extension context invalidated'));
            return;
        }
        chrome.storage.local.get([STORAGE_KEYS.MISSIONS], (result) => {
            // Check for errors on get
            if (chrome.runtime.lastError) {
                reject(chrome.runtime.lastError);
                return;
            }
            const existingMissions = result[STORAGE_KEYS.MISSIONS] || {};
            // Add all new missions using postId as key
            missions.forEach((mission) => {
                existingMissions[mission.postId] = mission;
            });
            chrome.storage.local.set({ [STORAGE_KEYS.MISSIONS]: existingMissions }, () => {
                if (chrome.runtime.lastError) {
                    reject(chrome.runtime.lastError);
                }
                else {
                    // Notify background script that missions changed
                    chrome.runtime.sendMessage({
                        type: 'MISSIONS_UPDATED',
                    }).catch(() => {
                        // Ignore errors if no listeners
                    });
                    resolve();
                }
            });
        });
    });
}
/**
 * Get all saved missions
 * Automatically migrates old nested format to new flat format
 */
async function getAllMissions() {
    return new Promise((resolve, reject) => {
        chrome.storage.local.get([_storageTypes__WEBPACK_IMPORTED_MODULE_0__/* .STORAGE_KEYS */ .d.MISSIONS], (result) => {
            if (chrome.runtime.lastError) {
                reject(chrome.runtime.lastError);
            }
            else {
                const rawMissions = result[_storageTypes__WEBPACK_IMPORTED_MODULE_0__/* .STORAGE_KEYS */ .d.MISSIONS] || {};
                // Migrate any old format missions to new flat format
                const migratedMissions = {};
                for (const postId in rawMissions) {
                    migratedMissions[postId] = (0,_utils_missionRecordMigration__WEBPACK_IMPORTED_MODULE_2__/* .normalizeMissionRecord */ .tV)(rawMissions[postId]);
                }
                resolve(migratedMissions);
            }
        });
    });
}
/**
 * Get a specific mission by postId
 */
async function getMission(postId) {
    const missions = await getAllMissions();
    return missions[postId] || null;
}
/**
 * Delete a mission
 */
async function deleteMission(postId) {
    return new Promise((resolve, reject) => {
        chrome.storage.local.get([STORAGE_KEYS.MISSIONS], (result) => {
            const missions = result[STORAGE_KEYS.MISSIONS] || {};
            delete missions[postId];
            chrome.storage.local.set({ [STORAGE_KEYS.MISSIONS]: missions }, () => {
                if (chrome.runtime.lastError) {
                    reject(chrome.runtime.lastError);
                }
                else {
                    resolve();
                }
            });
        });
    });
}
/**
 * Clear all missions
 */
async function clearAllMissions() {
    return new Promise((resolve, reject) => {
        chrome.storage.local.remove(STORAGE_KEYS.MISSIONS, () => {
            if (chrome.runtime.lastError) {
                reject(chrome.runtime.lastError);
            }
            else {
                resolve();
            }
        });
    });
}
/**
 * Mark all missions as incomplete (cleared = false, remove clearedAt)
 * Now delegates to userProgress to clear all progress data
 */
async function markAllMissionsIncomplete() {
    return userProgressOps.clearAllUserProgress();
}
/**
 * Mark a mission as cleared
 * Now delegates to userProgress storage
 */
async function markMissionCleared(postId) {
    return userProgressOps.markMissionCleared(postId);
}
/**
 * Accumulate loot from an encounter to mission's total loot
 * Now delegates to userProgress storage
 */
async function accumulateMissionLoot(postId, encounterLoot) {
    return userProgressOps.accumulateMissionLoot(postId, encounterLoot);
}
/**
 * Set mission disabled state (skipped by automation when disabled)
 * Now delegates to userProgress storage
 */
async function setMissionDisabled(postId, disabled) {
    return userProgressOps.setMissionDisabled(postId, disabled);
}
/**
 * Import missions from JSON data
 */
async function importMissions(jsonData, mode = 'merge') {
    const stats = { imported: 0, skipped: 0, errors: [] };
    try {
        // Parse JSON if it's a string
        let data;
        if (typeof jsonData === 'string') {
            data = JSON.parse(jsonData);
        }
        else {
            data = jsonData;
        }
        // Get existing missions
        const existingMissions = mode === 'merge' ? await getAllMissions() : {};
        // Handle different data formats
        let missionsToImport = {};
        if (Array.isArray(data)) {
            // Array of missions
            data.forEach((mission) => {
                if (mission.postId) {
                    missionsToImport[mission.postId] = mission;
                }
            });
        }
        else if (typeof data === 'object') {
            // Could be object with postId keys or wrapped data
            if (data.missions) {
                missionsToImport = data.missions;
            }
            else {
                missionsToImport = data;
            }
        }
        // Validate and import missions
        for (const [postId, mission] of Object.entries(missionsToImport)) {
            try {
                // Basic validation
                if (!mission.postId || !mission.timestamp) {
                    stats.errors.push(`Invalid mission data for ${postId}`);
                    stats.skipped++;
                    continue;
                }
                // Check if already exists in merge mode
                if (mode === 'merge' && existingMissions[postId]) {
                    stats.skipped++;
                    continue;
                }
                // Add to existing missions
                existingMissions[postId] = mission;
                stats.imported++;
            }
            catch (err) {
                stats.errors.push(`Error importing ${postId}: ${err}`);
                stats.skipped++;
            }
        }
        // Save all missions back to storage
        await new Promise((resolve, reject) => {
            chrome.storage.local.set({ [STORAGE_KEYS.MISSIONS]: existingMissions }, () => {
                if (chrome.runtime.lastError) {
                    reject(chrome.runtime.lastError);
                }
                else {
                    resolve();
                }
            });
        });
        return stats;
    }
    catch (err) {
        stats.errors.push(`Parse error: ${err}`);
        return stats;
    }
}


/***/ }),

/***/ 1772:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   tV: () => (/* binding */ normalizeMissionRecord)
/* harmony export */ });
/* unused harmony exports isLegacyFormat, migrateLegacyRecord, normalizeMissionRecords, mapTitleGenerator */
/**
 * Mission Record Format Migration Utilities
 * Handles backward compatibility with old nested metadata format
 */
/**
 * Detect if a mission record is in old nested format
 */
function isLegacyFormat(record) {
    return record && typeof record === 'object' &&
        'metadata' in record &&
        record.metadata !== undefined;
}
/**
 * Convert old nested format to new flat format
 */
function migrateLegacyRecord(legacy) {
    const mission = legacy.metadata?.mission;
    // Build flat record from nested data
    const record = {
        // Core identification
        postId: legacy.postId,
        timestamp: legacy.timestamp,
        permalink: legacy.permalink,
        // Mission metadata
        missionTitle: legacy.metadata?.missionTitle || legacy.missionTitle || `Mission ${legacy.postId.slice(3)}`,
        missionAuthorName: legacy.metadata?.missionAuthorName || 'Unknown',
        // Mission data (from nested mission object or top-level fields)
        environment: (mission?.environment || legacy.environment || 'haunted_forest'),
        encounters: mission?.encounters || [],
        minLevel: mission?.minLevel || legacy.minLevel || 1,
        maxLevel: mission?.maxLevel || legacy.maxLevel || 340,
        difficulty: mission?.difficulty || legacy.difficulty || 0,
        foodImage: mission?.foodImage || '',
        foodName: mission?.foodName || legacy.foodName || '',
        authorWeaponId: mission?.authorWeaponId || '',
        chef: mission?.chef || '',
        cart: mission?.cart || '',
        rarity: (mission?.rarity || 'common'),
        type: mission?.type,
    };
    return record;
}
/**
 * Normalize a mission record - converts legacy format if needed
 */
function normalizeMissionRecord(record) {
    if (isLegacyFormat(record)) {
        return migrateLegacyRecord(record);
    }
    return record;
}
/**
 * Bulk normalize an array of mission records
 */
function normalizeMissionRecords(records) {
    return records.map(normalizeMissionRecord);
}
/**
 * Generate a display title for missions when creating maps
 * Format: "2* | 121 - 140 | haunted_forest | Lemon Pistachio Swirl"
 */
function mapTitleGenerator(difficulty, minLevel, maxLevel, environment, foodName) {
    const parts = [];
    if (difficulty > 0) {
        parts.push(`${difficulty}*`);
    }
    else {
        parts.push('?');
    }
    parts.push(`${minLevel} - ${maxLevel}`);
    if (environment) {
        parts.push(environment);
    }
    else {
        parts.push('?');
    }
    if (foodName) {
        parts.push(foodName);
    }
    return parts.join(' | ');
}


/***/ }),

/***/ 5551:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   d: () => (/* binding */ STORAGE_KEYS)
/* harmony export */ });
/* unused harmony export DEFAULT_AUTOMATION_FILTERS */
/**
 * Extension-specific storage types
 * For shared mission types, import from @lazyfrog/types
 */
const DEFAULT_AUTOMATION_FILTERS = {
    stars: [1, 2, 3, 4, 5],
    minLevel: 1,
    maxLevel: 340,
};
const STORAGE_KEYS = {
    MISSIONS: 'missions', // Mission data (static, from database)
    USER_PROGRESS: 'userProgress', // User-specific progress tracking
    USER_OPTIONS: 'userOptions',
    AUTOMATION_FILTERS: 'automationFilters',
    AUTOMATION_CONFIG: 'automationConfig',
    REDDIT_API_CACHE: 'redditApiCache',
};


/***/ }),

/***/ 6853:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* unused harmony exports isMissionCleared, isMissionDisabled, getAllUserProgress, markMissionCleared, setMissionDisabled, accumulateMissionLoot, clearAllUserProgress, exportUserProgress, importUserProgress, exportAllUsersProgress, getUserProgressForUser */
/* harmony import */ var _storageTypes__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5551);
/**
 * User progress tracking operations
 * Manages cleared status, loot, and disabled missions separately from mission data
 * Progress is scoped per Reddit user, with "default" for non-logged-in users
 */


/**
 * Get empty progress data structure
 */
function createEmptyProgressData() {
    return {
        cleared: [],
        disabled: [],
        clearedAt: {},
        loot: {},
    };
}
/**
 * Get the entire multi-user progress structure from storage
 */
async function getMultiUserProgress() {
    return new Promise((resolve, reject) => {
        chrome.storage.local.get([STORAGE_KEYS.USER_PROGRESS], (result) => {
            if (chrome.runtime.lastError) {
                reject(chrome.runtime.lastError);
            }
            else {
                resolve(result[STORAGE_KEYS.USER_PROGRESS] || {});
            }
        });
    });
}
/**
 * Set the entire multi-user progress structure to storage
 */
async function setMultiUserProgress(data) {
    return new Promise((resolve, reject) => {
        chrome.storage.local.set({ [STORAGE_KEYS.USER_PROGRESS]: data }, () => {
            if (chrome.runtime.lastError) {
                reject(chrome.runtime.lastError);
            }
            else {
                resolve();
            }
        });
    });
}
/**
 * Check if a mission is cleared
 */
async function isMissionCleared(postId) {
    const progress = await getAllUserProgress();
    return progress.cleared.includes(postId);
}
/**
 * Check if a mission is disabled
 */
async function isMissionDisabled(postId) {
    const progress = await getAllUserProgress();
    return progress.disabled.includes(postId);
}
/**
 * Get all user progress for the current user
 */
async function getAllUserProgress() {
    const username = await getCurrentRedditUser();
    const multiUserData = await getMultiUserProgress();
    return multiUserData[username] || createEmptyProgressData();
}
/**
 * Mark a mission as cleared
 */
async function markMissionCleared(postId) {
    const username = await getCurrentRedditUser();
    const multiUserData = await getMultiUserProgress();
    // Get or create user's progress
    const userProgress = multiUserData[username] || createEmptyProgressData();
    // Add to cleared array if not already there
    if (!userProgress.cleared.includes(postId)) {
        userProgress.cleared.push(postId);
    }
    // Record clear timestamp
    userProgress.clearedAt[postId] = Date.now();
    // Update multi-user structure
    multiUserData[username] = userProgress;
    // Save back to storage
    await setMultiUserProgress(multiUserData);
}
/**
 * Mark a mission as disabled (e.g., deleted post)
 */
async function setMissionDisabled(postId, disabled) {
    const username = await getCurrentRedditUser();
    const multiUserData = await getMultiUserProgress();
    // Get or create user's progress
    const userProgress = multiUserData[username] || createEmptyProgressData();
    if (disabled) {
        // Add to disabled array if not already there
        if (!userProgress.disabled.includes(postId)) {
            userProgress.disabled.push(postId);
        }
    }
    else {
        // Remove from disabled array
        const index = userProgress.disabled.indexOf(postId);
        if (index > -1) {
            userProgress.disabled.splice(index, 1);
        }
    }
    // Update multi-user structure
    multiUserData[username] = userProgress;
    // Save back to storage
    await setMultiUserProgress(multiUserData);
}
/**
 * Accumulate loot for a mission
 */
async function accumulateMissionLoot(postId, newLoot) {
    const username = await getCurrentRedditUser();
    const multiUserData = await getMultiUserProgress();
    // Get or create user's progress
    const userProgress = multiUserData[username] || createEmptyProgressData();
    // Get existing loot for this mission
    const totalLoot = userProgress.loot[postId] || [];
    // Accumulate loot
    for (const item of newLoot) {
        const existingItem = totalLoot.find((l) => l.id === item.id);
        if (existingItem) {
            existingItem.quantity += item.quantity;
        }
        else {
            totalLoot.push({ ...item });
        }
    }
    // Update loot
    userProgress.loot[postId] = totalLoot;
    // Update multi-user structure
    multiUserData[username] = userProgress;
    // Save back to storage
    await setMultiUserProgress(multiUserData);
}
/**
 * Clear all user progress for the current user (useful for starting fresh)
 */
async function clearAllUserProgress() {
    const username = await getCurrentRedditUser();
    const multiUserData = await getMultiUserProgress();
    // Clear current user's progress
    multiUserData[username] = createEmptyProgressData();
    // Save back to storage
    await setMultiUserProgress(multiUserData);
}
/**
 * Export user progress for backup/transfer (current user only)
 */
async function exportUserProgress() {
    const progress = await getAllUserProgress();
    const username = await getCurrentRedditUser();
    return JSON.stringify({ username, progress }, null, 2);
}
/**
 * Validate that the imported data has the required UserProgressData structure
 */
function isValidUserProgressData(data) {
    return (data &&
        typeof data === 'object' &&
        Array.isArray(data.cleared) &&
        Array.isArray(data.disabled) &&
        typeof data.clearedAt === 'object' &&
        typeof data.loot === 'object');
}
/**
 * Import user progress from backup (for current user)
 */
async function importUserProgress(jsonData) {
    const data = JSON.parse(jsonData);
    const progress = data.progress || data; // Support both old and new formats
    // Validate the structure
    if (!isValidUserProgressData(progress)) {
        throw new Error('Invalid progress data structure. Expected object with arrays: cleared, disabled, and objects: clearedAt, loot');
    }
    const username = await getCurrentRedditUser();
    const multiUserData = await getMultiUserProgress();
    // Set current user's progress
    multiUserData[username] = progress;
    // Save back to storage
    await setMultiUserProgress(multiUserData);
}
/**
 * Export all users' progress (admin/debug function)
 */
async function exportAllUsersProgress() {
    const multiUserData = await getMultiUserProgress();
    return JSON.stringify(multiUserData, null, 2);
}
/**
 * Get progress for a specific user (useful for switching contexts or admin)
 */
async function getUserProgressForUser(username) {
    const multiUserData = await getMultiUserProgress();
    return multiUserData[username] || createEmptyProgressData();
}


/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};

;// ./src/utils/logger.ts
/**
 * Unified logging utility for the AutoSupper extension
 * Logs to both console and optional remote server for debugging
 */
// Default number of logs to keep in storage
const DEFAULT_MAX_STORED_LOGS = 10000;
class Logger {
    constructor(context, config, parentContext) {
        this.parentContext = parentContext;
        this.config = {
            context,
            remoteLogging: config?.remoteLogging ?? true,
            remoteUrl: config?.remoteUrl ?? 'http://localhost:7856/log',
            consoleLogging: config?.consoleLogging ?? true,
            storeLogs: config?.storeLogs ?? true,
            maxStoredLogs: config?.maxStoredLogs ?? DEFAULT_MAX_STORED_LOGS,
        };
        // Load logging settings from storage
        if (typeof chrome !== 'undefined' && chrome.storage) {
            chrome.storage.local.get(['automationConfig'], (result) => {
                if (result.automationConfig?.remoteLogging !== undefined) {
                    this.config.remoteLogging = result.automationConfig.remoteLogging;
                }
                if (result.automationConfig?.storeLogs !== undefined) {
                    this.config.storeLogs = result.automationConfig.storeLogs;
                }
                if (result.automationConfig?.maxStoredLogs !== undefined) {
                    this.config.maxStoredLogs = result.automationConfig.maxStoredLogs;
                }
            });
            // Listen for changes to logging settings
            chrome.storage.onChanged.addListener((changes, areaName) => {
                if (areaName === 'local' && changes.automationConfig?.newValue) {
                    const newConfig = changes.automationConfig.newValue;
                    if (newConfig.remoteLogging !== undefined) {
                        this.config.remoteLogging = newConfig.remoteLogging;
                    }
                    if (newConfig.storeLogs !== undefined) {
                        this.config.storeLogs = newConfig.storeLogs;
                    }
                    if (newConfig.maxStoredLogs !== undefined) {
                        this.config.maxStoredLogs = newConfig.maxStoredLogs;
                    }
                }
            });
        }
    }
    /**
     * Send log to remote server
     */
    async sendToRemote(entry) {
        if (!this.config.remoteLogging)
            return;
        try {
            await fetch(this.config.remoteUrl, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify(entry),
            }).catch(() => {
                // Silently fail if remote server is not available
                // We don't want to break the extension if the debug server is down
            });
        }
        catch (error) {
            // Silently fail
        }
    }
    /**
     * Store log entry in chrome.storage
     */
    storeLog(entry) {
        if (!this.config.storeLogs)
            return;
        if (typeof chrome === 'undefined' || !chrome.storage)
            return;
        try {
            // Use callback-based API for better compatibility
            chrome.storage.local.get(['debugLogs'], (result) => {
                if (chrome.runtime.lastError) {
                    console.error('[LF] Failed to get logs:', chrome.runtime.lastError);
                    return;
                }
                const logs = result.debugLogs || [];
                // Add new log
                logs.push(entry);
                // Trim to max size (keep most recent logs)
                if (logs.length > this.config.maxStoredLogs) {
                    logs.splice(0, logs.length - this.config.maxStoredLogs);
                }
                // Save back to storage
                chrome.storage.local.set({ debugLogs: logs }, () => {
                    if (chrome.runtime.lastError) {
                        console.error('[LF] Failed to store log:', chrome.runtime.lastError);
                    }
                });
            });
        }
        catch (error) {
            // Silently fail - don't break the extension if storage fails
            console.error('[LF] Failed to store log:', error);
        }
    }
    /**
     * Format message with prefix
     */
    formatMessage(message) {
        const fullContext = this.parentContext
            ? `${this.parentContext}][${this.config.context}`
            : this.config.context;
        return `[LF][${fullContext}] ${message}`;
    }
    /**
     * Serialize data for logging
     */
    serializeData(data) {
        if (data === undefined)
            return undefined;
        try {
            // Try to stringify and parse to clean up circular references
            return JSON.parse(JSON.stringify(data));
        }
        catch (error) {
            // If that fails, return a string representation
            return String(data);
        }
    }
    /**
     * Core logging function
     */
    logInternal(level, ...args) {
        // Create formatted message for remote logging
        const message = args
            .map((arg) => {
            if (typeof arg === 'string')
                return arg;
            if (typeof arg === 'object') {
                try {
                    return JSON.stringify(arg);
                }
                catch (error) {
                    // Handle circular references gracefully
                    return '[Circular Reference]';
                }
            }
            return String(arg);
        })
            .join(' ');
        const entry = {
            timestamp: new Date().toISOString(),
            context: this.config.context,
            level,
            message,
            data: args.length > 1 ? this.serializeData(args.slice(1)) : undefined,
        };
        // Log to console using appropriate method with native object inspection
        if (this.config.consoleLogging) {
            const consoleMethod = console[level] || console.log;
            // Add LazyFrog and context prefix but preserve native console behavior
            const fullContext = this.parentContext
                ? `${this.parentContext}][${this.config.context}`
                : this.config.context;
            consoleMethod(`[LF][${fullContext}]`, ...args);
        }
        // Store in chrome.storage (non-blocking)
        this.storeLog(entry);
        // Send to remote server (non-blocking)
        this.sendToRemote(entry);
    }
    /**
     * Public logging methods - support unlimited parameters like console.log()
     */
    log(...args) {
        this.logInternal('log', ...args);
    }
    info(...args) {
        this.logInternal('info', ...args);
    }
    warn(...args) {
        this.logInternal('warn', ...args);
    }
    error(...args) {
        this.logInternal('error', ...args);
    }
    debug(...args) {
        this.logInternal('debug', ...args);
    }
    /**
     * Update logger configuration
     */
    setConfig(config) {
        this.config = { ...this.config, ...config };
    }
    /**
     * Enable/disable remote logging
     */
    setRemoteLogging(enabled) {
        this.config.remoteLogging = enabled;
    }
    /**
     * Enable/disable console logging
     */
    setConsoleLogging(enabled) {
        this.config.consoleLogging = enabled;
    }
    /**
     * Create a nested logger with additional context
     */
    createNestedLogger(nestedContext) {
        const fullContext = this.parentContext
            ? `${this.parentContext}][${this.config.context}`
            : this.config.context;
        return new Logger(nestedContext, {
            remoteLogging: this.config.remoteLogging,
            remoteUrl: this.config.remoteUrl,
            consoleLogging: this.config.consoleLogging,
        }, fullContext);
    }
}
/**
 * Factory function to create loggers for different contexts
 */
function createLogger(context, config, parentContext) {
    return new Logger(context, config, parentContext);
}
/**
 * Export stored logs as JSON
 */
async function exportLogs() {
    if (typeof chrome === 'undefined' || !chrome.storage) {
        throw new Error('Chrome storage not available');
    }
    const result = await chrome.storage.local.get(['debugLogs']);
    const logs = result.debugLogs || [];
    return JSON.stringify({
        exportDate: new Date().toISOString(),
        logCount: logs.length,
        logs,
    }, null, 2);
}
/**
 * Clear all stored logs
 */
async function clearLogs() {
    if (typeof chrome === 'undefined' || !chrome.storage) {
        throw new Error('Chrome storage not available');
    }
    await chrome.storage.local.set({ debugLogs: [] });
}
/**
 * Get log statistics
 */
async function getLogStats() {
    if (typeof chrome === 'undefined' || !chrome.storage) {
        return { count: 0 };
    }
    const result = await chrome.storage.local.get(['debugLogs']);
    const logs = result.debugLogs || [];
    return {
        count: logs.length,
        oldestLog: logs.length > 0 ? logs[0].timestamp : undefined,
        newestLog: logs.length > 0 ? logs[logs.length - 1].timestamp : undefined,
    };
}
/**
 * Pre-configured loggers for each context
 *
 * Example usage for nested contexts:
 * const gameLogger = redditLogger.createNestedLogger('GAME');
 * const combatLogger = gameLogger.createNestedLogger('COMBAT');
 *
 * This will produce logs like:
 * [LF][REDDIT][GAME] Starting mission
 * [LF][REDDIT][GAME][COMBAT] Enemy defeated
 */
const popupLogger = createLogger('POPUP');
const extensionLogger = createLogger('SW');
const redditLogger = createLogger('REDDIT');
const devvitLogger = createLogger('DEVVIT');
const devvitGIAELogger = createLogger('DEVVIT-GIAE');

;// ./src/automation/GameState.ts
/**
 * V2 Game State Tracker
 * Simple DOM-based state tracking
 */

class GameState {
    constructor() {
        // Player state
        this.livesRemaining = 3;
        // Mission progress
        this.currentEncounter = 0;
        this.totalEncounters = 0;
        // Mission info
        this.postId = null;
        this.difficulty = null;
        this.missionMetadata = null; // Full mission metadata including encounters
        // Current screen type
        this.currentScreen = 'unknown';
        // Track if we've tried loading from storage to avoid infinite loops
        this._storageLoadAttempted = false;
    }
    /**
     * Update state from DOM (called every tick)
     */
    updateFromDOM() {
        this.livesRemaining = this.readLivesFromDOM();
    }
    /**
     * Read lives from .lives-container in DOM
     */
    readLivesFromDOM() {
        const livesContainer = document.querySelector('.lives-container');
        if (!livesContainer)
            return 3; // Default
        // Count filled hearts
        const filledHearts = livesContainer.querySelectorAll('img[src*="Heart_Full.png"]').length;
        return filledHearts;
    }
    /**
     * Set mission data from initialData message
     */
    setMissionData(metadata, postId) {
        this.postId = postId;
        this.missionMetadata = metadata;
        this.totalEncounters = metadata?.mission?.encounters?.length || 0;
        this.difficulty = metadata?.mission?.difficulty || null;
        // Mission always starts with an initial battle (not in encounters array)
        // Set index to -1 to indicate we haven't started the encounters array yet
        this.currentEncounter = -1;
        devvitGIAELogger.log('[GameState] Mission data set from initialData', {
            postId,
            totalEncounters: this.totalEncounters,
            startingEncounter: this.currentEncounter,
            firstEncounterType: metadata?.mission?.encounters?.[0]?.type,
            note: 'Starting at -1 (initial battle not in encounters array)',
            hasMetadata: !!metadata,
            hasMission: !!metadata?.mission,
            hasEncounters: !!metadata?.mission?.encounters,
            encountersLength: metadata?.mission?.encounters?.length || 0,
        });
    }
    /**
     * Load mission metadata from storage as fallback
     * Called if initialData message doesn't have complete data
     */
    async loadMissionDataFromStorage(postId) {
        this._storageLoadAttempted = true;
        try {
            const { getMission } = await Promise.resolve(/* import() */).then(__webpack_require__.bind(__webpack_require__, 630));
            const mission = await getMission(postId);
            if (!mission?.encounters) {
                devvitGIAELogger.warn('[GameState] No encounters in storage for', postId);
                return false;
            }
            // Build metadata structure from MissionRecord
            const storageMetadata = {
                mission: {
                    encounters: mission.encounters,
                    difficulty: mission.difficulty,
                    environment: mission.environment,
                    minLevel: mission.minLevel,
                    maxLevel: mission.maxLevel,
                    foodImage: mission.foodImage,
                    foodName: mission.foodName,
                    authorWeaponId: mission.authorWeaponId || '',
                    chef: mission.chef || '',
                    cart: mission.cart || '',
                    rarity: mission.rarity,
                },
                missionAuthorName: mission.missionAuthorName,
                missionTitle: mission.missionTitle,
                enemyTauntData: [],
            };
            // Compare with existing data if we have it
            if (this.missionMetadata) {
                const initialDataEncounters = this.missionMetadata?.mission?.encounters?.length || 0;
                const storageEncounters = mission.encounters?.length || 0;
                if (initialDataEncounters !== storageEncounters) {
                    devvitGIAELogger.warn('[GameState] Metadata mismatch!', {
                        postId,
                        initialDataEncounters,
                        storageEncounters,
                        initialDataDifficulty: this.missionMetadata?.mission?.difficulty,
                        storageDifficulty: mission.difficulty,
                    });
                }
                else {
                    devvitGIAELogger.log('[GameState] Storage metadata matches initialData');
                }
            }
            else {
                // No initialData, use storage as fallback
                devvitGIAELogger.log('[GameState] Using storage metadata as fallback', {
                    postId,
                    encountersLength: mission.encounters?.length || 0,
                });
                this.missionMetadata = storageMetadata;
                this.totalEncounters = mission.encounters?.length || 0;
                this.difficulty = mission.difficulty || null;
            }
            return true;
        }
        catch (error) {
            devvitGIAELogger.error('[GameState] Failed to load from storage', { postId, error: String(error) });
            return false;
        }
    }
    /**
     * Get current encounter type from mission metadata
     *
     * Note: Returns null for initial battle (currentEncounter === -1)
     * since the initial battle is not in the encounters array
     */
    getCurrentEncounterType() {
        const encounters = this.missionMetadata?.mission?.encounters;
        devvitGIAELogger.log('[GameState] getCurrentEncounterType called:', {
            currentEncounter: this.currentEncounter,
            isInitialBattle: this.currentEncounter === -1,
            hasMetadata: !!this.missionMetadata,
            hasMission: !!this.missionMetadata?.mission,
            hasEncounters: !!encounters,
            encountersLength: encounters?.length || 0,
            encounterAtCurrentIndex: encounters?.[this.currentEncounter],
            encounterAtNextIndex: encounters?.[this.currentEncounter + 1],
            storageLoadAttempted: this._storageLoadAttempted,
        });
        // Initial battle (not in encounters array)
        if (this.currentEncounter === -1) {
            return null; // Will fall back to DOM detection (advance-button)
        }
        // If no metadata and we haven't tried storage yet, suggest loading from storage
        if (!encounters && !this._storageLoadAttempted && this.postId) {
            devvitGIAELogger.warn('[GameState] No encounter metadata! Suggest calling loadMissionDataFromStorage()');
        }
        if (!encounters || this.currentEncounter >= encounters.length) {
            return null;
        }
        return encounters[this.currentEncounter]?.type || null;
    }
    /**
     * Update when encounter completes
     */
    onEncounterComplete(encounterIndex) {
        devvitGIAELogger.log('[GameState] Encounter complete', {
            previousEncounter: this.currentEncounter,
            newEncounter: encounterIndex,
            totalEncounters: this.totalEncounters,
        });
        this.currentEncounter = encounterIndex;
    }
    /**
     * Get progress string for display
     */
    getProgress() {
        if (this.totalEncounters === 0)
            return 'Starting';
        if (this.currentEncounter === -1)
            return 'Pre-Game';
        return `${this.currentEncounter + 1}/${this.totalEncounters}`;
    }
    /**
     * Should we play safe? (low on lives)
     */
    shouldPlaySafe() {
        return this.livesRemaining <= 1;
    }
    /**
     * Is player still alive?
     */
    isAlive() {
        return this.livesRemaining > 0;
    }
}

;// ./src/automation/DecisionMaker.ts
/**
 * V2 Decision Maker
 * Smart decisions based on player state
 */
class DecisionMaker {
    constructor(gameState, config) {
        this.gameState = gameState;
        this.config = config;
    }
    /**
     * Crossroads: Fight or Skip mini boss
     */
    decideCrossroads() {
        // TODO: Re-enable play-safe logic when health tracking is ready
        // If low on lives, always skip
        // if (this.gameState.shouldPlaySafe()) {
        // 	return 'skip';
        // }
        // Use user config (default: fight)
        return this.config.crossroadsStrategy || 'fight';
    }
    /**
     * Skill Bargain: Accept or Decline
     */
    decideSkillBargain(bargainText) {
        const isPositive = this.isPositiveBargain(bargainText);
        // TODO: Re-enable play-safe logic when health tracking is ready
        // If low on lives, only accept positive bargains
        // if (this.gameState.shouldPlaySafe()) {
        // 	return isPositive ? 'accept' : 'decline';
        // }
        // Use user strategy
        const strategy = this.config.skillBargainStrategy || 'positive-only';
        if (strategy === 'always')
            return 'accept';
        if (strategy === 'never')
            return 'decline';
        // Default: positive-only
        return isPositive ? 'accept' : 'decline';
    }
    /**
     * Pick best ability from choices
     */
    pickAbility(abilities) {
        // Pick first from tier list
        for (const preferred of this.config.abilityTierList || []) {
            if (abilities.includes(preferred)) {
                return preferred;
            }
        }
        // Fallback to first available
        return abilities[0];
    }
    /**
     * Pick best blessing stat from choices
     */
    pickBlessing(blessingStats) {
        // Pick first from priority list
        for (const preferred of this.config.blessingStatPriority || []) {
            // Case-insensitive partial match
            const match = blessingStats.find((stat) => stat.toLowerCase().includes(preferred.toLowerCase()));
            if (match) {
                return match;
            }
        }
        // Fallback to first available
        return blessingStats[0];
    }
    /**
     * Simple heuristic: more + than - means positive
     */
    isPositiveBargain(text) {
        const plusCount = (text.match(/\+/g) || []).length;
        const minusCount = (text.match(/-/g) || []).length;
        return plusCount > minusCount;
    }
}

;// ./src/utils/url.ts
/**
 * Normalize a Reddit post ID to ensure it has the standard t3_ prefix.
 *
 * @param id - The post ID to normalize (with or without t3_ prefix)
 * @returns The normalized post ID with t3_ prefix, or null if invalid
 *
 * @example
 * ```typescript
 * normalizePostId('1od6q1h') // 't3_1od6q1h'
 * normalizePostId('t3_1od6q1h') // 't3_1od6q1h'
 * normalizePostId('invalid') // null
 * ```
 */
function normalizePostId(id) {
    if (!id || typeof id !== 'string') {
        return null;
    }
    // If already prefixed, validate and return
    if (id.startsWith('t3_')) {
        const postIdPart = id.slice(3);
        if (postIdPart && /^[a-z0-9]+$/i.test(postIdPart)) {
            return id;
        }
        return null;
    }
    // If not prefixed, validate and add prefix
    if (/^[a-z0-9]+$/i.test(id)) {
        return `t3_${id}`;
    }
    return null;
}
/**
 * Normalize a Reddit Sword & Supper mission permalink to the canonical format:
 * https://www.reddit.com/r/SwordAndSupperGame/comments/<postId>/
 *
 * Accepts either a URL or a postId (with or without t3_ prefix).
 * The postId parameter should be the raw post ID without t3_ prefix.
 */
function normalizeRedditPermalink(input) {
    const base = 'https://www.reddit.com';
    // Helper to strip t3_ prefix
    const stripT3 = (id) => (id?.startsWith('t3_') ? id.slice(3) : id);
    let postId = '';
    try {
        if (input?.startsWith('http')) {
            const url = new URL(input);
            // Try to extract id from /comments/<id>/ path
            const match = url.pathname.match(/\/comments\/([^/]+)/);
            if (match && match[1]) {
                postId = stripT3(match[1]);
            }
        }
        else if (input) {
            // Treat as postId
            postId = stripT3(input);
        }
    }
    catch {
        // Fallback to treating as postId
        postId = stripT3(input);
    }
    if (!postId) {
        return `${base}/r/SwordAndSupperGame/`;
    }
    return `${base}/r/SwordAndSupperGame/comments/${postId}/`;
}

;// ./src/content/devvit/utils/extractPostIdFromUrl.ts
/**
 * @fileoverview Utility for extracting postId from various URL formats
 *
 * This utility handles different URL structures:
 * - Devvit iframe URLs with context parameter
 * - Devvit iframe URLs with JWT tokens
 * - Legacy Reddit URLs
 */

/**
 * Extract postId from URL as fallback when initialData is missing
 *
 * @param url - The URL to extract the postId from
 * @returns The extracted postId (e.g., "t3_1od6q1h") or null if not found
 *
 * @example
 * ```typescript
 * const url = "https://cabbageidle-eimoap-0-0-50-webview.devvit.net/index.html?context=%7B%22postId%22%3A%22t3_1od6q1h%22%7D";
 * const postId = extractPostIdFromUrl(url);
 * console.log(postId); // "t3_1od6q1h"
 * ```
 *
 * @example
 * ```typescript
 * // JWT token extraction
 * const url = "https://example.devvit.net/index.html?webbit_token=eyJ...";
 * const postId = extractPostIdFromUrl(url);
 * console.log(postId); // "t3_1od6q1h"
 * ```
 */
function extractPostIdFromUrl(url) {
    try {
        // For Devvit iframe URLs, try to extract from context parameter
        // URL format: https://cabbageidle-eimoap-0-0-50-webview.devvit.net/index.html?context=%7B...%7D
        // Stop at & or # to avoid capturing hash fragments
        const contextMatch = url.match(/context=([^&#]+)/);
        if (contextMatch) {
            try {
                const contextJson = decodeURIComponent(contextMatch[1]);
                const context = JSON.parse(contextJson);
                if (context.postId) {
                    console.log('[extractPostIdFromUrl] Extracted postId from context parameter', {
                        postId: context.postId,
                    });
                    return context.postId;
                }
            }
            catch (parseError) {
                console.warn('[extractPostIdFromUrl] Failed to parse context parameter', {
                    error: String(parseError),
                });
                // Try to extract postId directly from the context string as a fallback
                const postIdMatch = contextMatch[1].match(/%22postId%22%3A%22(t3_[^%]+)%22/);
                if (postIdMatch) {
                    console.log('[extractPostIdFromUrl] Extracted postId from context string fallback', {
                        postId: postIdMatch[1],
                    });
                    return postIdMatch[1];
                }
            }
        }
        // Fallback: try to extract from JWT token in webbit_token parameter
        // Stop at & or # to avoid capturing hash fragments
        const tokenMatch = url.match(/webbit_token=([^&#]+)/);
        if (tokenMatch) {
            try {
                // JWT tokens have 3 parts separated by dots
                const tokenParts = tokenMatch[1].split('.');
                if (tokenParts.length === 3) {
                    // Decode the payload (second part)
                    const payload = JSON.parse(atob(tokenParts[1]));
                    if (payload['devvit-post-id']) {
                        console.log('[extractPostIdFromUrl] Extracted postId from JWT token', {
                            postId: payload['devvit-post-id'],
                        });
                        return payload['devvit-post-id'];
                    }
                }
            }
            catch (tokenError) {
                console.warn('[extractPostIdFromUrl] Failed to parse JWT token', {
                    error: String(tokenError),
                });
            }
        }
        // Legacy fallback for Reddit URLs (probably won't work in Devvit iframe)
        const redditMatch = url.match(/\/comments\/([a-zA-Z0-9]+)/);
        if (redditMatch && redditMatch[1]) {
            return normalizePostId(redditMatch[1]);
        }
    }
    catch (error) {
        console.warn('[extractPostIdFromUrl] Failed to extract postId from URL', {
            error: String(error),
        });
    }
    return null;
}

// EXTERNAL MODULE: ./src/lib/storage/missions.ts
var missions = __webpack_require__(630);
;// ./src/automation/gameInstanceAutomation.ts
/**
 * Game Instance Automation Engine
 * Smart automation for game missions
 */





const DEFAULT_GIAE_CONFIG = {
    enabled: false,
    abilityTierList: ['IceKnifeOnTurnStart', 'LightningOnCrit', 'HealOnFirstTurn'],
    blessingStatPriority: ['Speed', 'Attack', 'Crit', 'Health', 'Defense', 'Dodge'], // Speed first for faster gameplay
    autoAcceptSkillBargains: true,
    skillBargainStrategy: 'positive-only',
    crossroadsStrategy: 'fight', // Fight mini bosses by default
    clickDelay: 1000,
};
class GameInstanceAutomationEngine {
    constructor(config) {
        this.intervalId = null;
        this.isProcessing = false;
        // Public properties for compatibility
        this.currentPostId = null;
        this.missionMetadata = null;
        // Deep merge config, ensuring arrays are properly preserved
        this.config = {
            ...DEFAULT_GIAE_CONFIG,
            ...config,
            // Ensure arrays are properly set, falling back to defaults if not provided
            abilityTierList: Array.isArray(config.abilityTierList)
                ? config.abilityTierList
                : DEFAULT_GIAE_CONFIG.abilityTierList,
            blessingStatPriority: Array.isArray(config.blessingStatPriority)
                ? config.blessingStatPriority
                : DEFAULT_GIAE_CONFIG.blessingStatPriority,
        };
        this.gameState = new GameState();
        this.decisionMaker = new DecisionMaker(this.gameState, this.config);
        this.setupMessageListener();
        devvitGIAELogger.log('Game automation engine initialized');
    }
    setupMessageListener() {
        window.addEventListener('message', (event) => {
            try {
                // initialData
                if (event.data?.type === 'devvit-message' &&
                    event.data?.data?.message?.type === 'initialData') {
                    const data = event.data.data.message.data;
                    this.gameState.setMissionData(data.missionMetadata, data.postId);
                    // Set properties for compatibility
                    this.currentPostId = data.postId;
                    this.missionMetadata = data.missionMetadata;
                    // Verify/fallback to storage data (fire and forget)
                    this.gameState.loadMissionDataFromStorage(data.postId).catch((err) => {
                        devvitGIAELogger.error('[GIAE] Failed to load mission data from storage', err);
                    });
                    devvitGIAELogger.log('Mission started', {
                        postId: data.postId,
                        encounters: this.gameState.totalEncounters,
                        difficulty: this.gameState.difficulty,
                    });
                    // Report initial state to background
                    this.reportGameState();
                }
                // missionComplete
                if (event.data?.data?.message?.type === 'missionComplete') {
                    const postId = event.data.data.message.data?.postId;
                    if (postId) {
                        devvitGIAELogger.log('Mission complete', { postId });
                        chrome.runtime.sendMessage({
                            type: 'MISSION_COMPLETED',
                            postId,
                        });
                    }
                }
            }
            catch (error) {
                devvitGIAELogger.error('Message error', { error: String(error) });
            }
        });
    }
    start() {
        if (this.intervalId)
            return;
        this.config.enabled = true;
        devvitGIAELogger.log('Starting automation');
        this.intervalId = window.setInterval(() => {
            if (this.config.enabled && !this.isProcessing) {
                this.processGame();
            }
        }, 1500);
    }
    stop() {
        devvitGIAELogger.log('Stopping automation');
        this.config.enabled = false;
        if (this.intervalId) {
            clearInterval(this.intervalId);
            this.intervalId = null;
        }
    }
    async processGame() {
        this.isProcessing = true;
        try {
            // Proactively load mission data from storage if we have postId but no metadata
            // This handles the case where automation starts before initialData message arrives
            let postId = this.currentPostId;
            // If no postId yet, try extracting from URL
            if (!postId) {
                postId = extractPostIdFromUrl(window.location.href);
                if (postId) {
                    devvitGIAELogger.log('Extracted postId from URL', { postId });
                    this.currentPostId = postId;
                    this.gameState.postId = postId;
                }
            }
            // Load metadata from storage if we have postId but no metadata
            if (postId && !this.gameState.missionMetadata) {
                if (!this.gameState._storageLoadAttempted) {
                    devvitGIAELogger.log('Loading mission metadata from storage (initialData not yet received)');
                    await this.gameState.loadMissionDataFromStorage(postId);
                }
            }
            // Update state from DOM
            this.gameState.updateFromDOM();
            // Check if dead
            if (!this.gameState.isAlive()) {
                devvitGIAELogger.error('Out of lives');
                this.stop();
                chrome.runtime.sendMessage({
                    type: 'ERROR_OCCURRED',
                    message: 'Out of lives',
                });
                return;
            }
            // Find buttons
            const buttons = this.findAllButtons();
            if (buttons.length === 0)
                return;
            // Detect screen
            const screen = this.detectScreen(buttons);
            const screenChanged = this.gameState.currentScreen !== screen;
            this.gameState.currentScreen = screen;
            // Report state update if screen changed
            if (screenChanged) {
                this.reportGameState();
            }
            // Handle screen (if actionable)
            if (screen !== 'unknown' && screen !== 'in_progress') {
                // Log encounter metadata for debugging (but don't use for detection)
                const encounterType = this.gameState.getCurrentEncounterType();
                devvitGIAELogger.log('Screen', {
                    screen,
                    lives: this.gameState.livesRemaining,
                    playSafe: this.gameState.shouldPlaySafe(),
                    encounter: this.gameState.getProgress(),
                    encounterType, // For debugging - compare with detected screen
                });
                await this.handleScreen(screen, buttons);
                await this.delay(this.config.clickDelay || 300);
            }
        }
        catch (error) {
            devvitGIAELogger.error('Process error', { error: String(error) });
        }
        finally {
            this.isProcessing = false;
        }
    }
    detectScreen(buttons) {
        const texts = buttons.map((b) => b.textContent?.trim().toLowerCase() || '');
        const classes = buttons.map((b) => b.className);
        // Inn check
        const tooltip = document.querySelector('.navbar-tooltip');
        if (tooltip?.textContent?.includes('Find and play missions')) {
            return 'inn';
        }
        // ============================================================================
        // PURE DOM-BASED SCREEN DETECTION
        // We don't use metadata for detection because it gets out of sync when we
        // click buttons and advance the counter before the DOM updates
        // ============================================================================
        // Skip button (intro/story)
        if (classes.some((c) => c.includes('skip-button')))
            return 'skip';
        // Mission end screen
        if (document.querySelector('.mission-end-footer'))
            return 'finish';
        // Battle screen (advance button)
        if (classes.some((c) => c.includes('advance-button'))) {
            return 'battle';
        }
        // Crossroads mini-boss (has both "fight" and "nope" buttons)
        if (texts.some((t) => t.includes('fight')) && texts.some((t) => t.includes('nope'))) {
            return 'crossroads';
        }
        // Skill bargain (has "refuse" or both "accept" and "decline")
        if (texts.includes('refuse') || (texts.includes('accept') && texts.includes('decline'))) {
            return 'bargain';
        }
        // Choice screen (multiple skill buttons - blessing or ability choice)
        if (classes.filter((c) => c.includes('skill-button')).length > 1)
            return 'choice';
        // Continue button
        if (texts.includes('continue'))
            return 'continue';
        // In progress (only UI buttons visible)
        if (classes.some((c) => c.includes('volume-icon-button'))) {
            return 'in_progress';
        }
        return 'unknown';
    }
    async handleScreen(screen, buttons) {
        let actionTaken = false;
        switch (screen) {
            case 'skip': {
                // Skip intro/story
                const skipBtn = buttons.find((b) => b.classList.contains('skip-button'));
                if (skipBtn) {
                    skipBtn.click();
                    actionTaken = true;
                }
                break;
            }
            case 'battle': {
                const advanceBtn = buttons.find((b) => b.classList.contains('advance-button'));
                if (advanceBtn) {
                    devvitGIAELogger.log('Clicking advance button');
                    advanceBtn.click();
                    actionTaken = true;
                }
                break;
            }
            case 'crossroads': {
                const choice = this.decisionMaker.decideCrossroads();
                devvitGIAELogger.log('Crossroads decision', { choice });
                // Button text: "Let's Fight!" or "Nope"
                if (choice === 'fight') {
                    const fightBtn = buttons.find((b) => b.textContent?.toLowerCase().includes('fight'));
                    if (fightBtn) {
                        fightBtn.click();
                        actionTaken = true;
                    }
                }
                else {
                    // choice === 'skip'
                    const skipBtn = buttons.find((b) => b.textContent?.toLowerCase().includes('nope'));
                    if (skipBtn) {
                        skipBtn.click();
                        actionTaken = true;
                    }
                }
                break;
            }
            case 'bargain': {
                // Read bargain text from page
                const bargainText = document.body.textContent || '';
                const choice = this.decisionMaker.decideSkillBargain(bargainText);
                devvitGIAELogger.log('Bargain decision', {
                    choice,
                    bargainText: bargainText.substring(0, 200),
                });
                // Find skill buttons
                const skillButtons = buttons.filter((b) => b.classList.contains('skill-button'));
                devvitGIAELogger.log('Bargain buttons found', {
                    count: skillButtons.length,
                    buttons: skillButtons.map((b) => b.textContent?.trim()),
                });
                if (choice === 'accept') {
                    // Accept: click the bargain button (NOT "Refuse" or "Decline")
                    const acceptBtn = skillButtons.find((b) => {
                        const text = b.textContent?.trim().toLowerCase() || '';
                        return text !== 'refuse' && text !== 'decline';
                    });
                    if (acceptBtn) {
                        devvitGIAELogger.log('Clicking accept button', { text: acceptBtn.textContent?.trim() });
                        acceptBtn.click();
                        actionTaken = true;
                    }
                }
                else {
                    // Decline: click "Refuse" or "Decline" button, or pick last skill button as fallback
                    const declineBtn = skillButtons.find((b) => {
                        const text = b.textContent?.trim().toLowerCase() || '';
                        return text === 'refuse' || text === 'decline';
                    });
                    if (declineBtn) {
                        devvitGIAELogger.log('Clicking decline button', { text: declineBtn.textContent?.trim() });
                        declineBtn.click();
                        actionTaken = true;
                    }
                    else if (skillButtons.length > 0) {
                        // Fallback: if no explicit decline button (like monolith), click last skill button
                        const fallbackBtn = skillButtons[skillButtons.length - 1];
                        devvitGIAELogger.log('No decline button, clicking last skill button as fallback', {
                            text: fallbackBtn.textContent?.trim(),
                        });
                        fallbackBtn.click();
                        actionTaken = true;
                    }
                }
                break;
            }
            case 'choice': {
                const skillButtons = buttons.filter((b) => b.classList.contains('skill-button'));
                // Use DOM to determine blessing vs ability choice
                const panelHeader = document.querySelector('.ui-panel-header');
                const headerText = panelHeader?.textContent?.toLowerCase() || '';
                // Try to extract blessing stats from button text
                const blessingStats = skillButtons
                    .map((b) => {
                    const text = b.textContent?.trim() || '';
                    const match = text.match(/Increase (\w+) by \d+%/);
                    return match ? match[1] : null;
                })
                    .filter((stat) => !!stat);
                let buttonClicked = false;
                // If we found blessing patterns OR header mentions blessing, it's a blessing choice
                if (blessingStats.length > 0 || headerText.includes('blessing') || headerText.includes('boon')) {
                    // Handle blessing (statsChoice)
                    devvitGIAELogger.log('Blessing detected (DOM)', { headerText, blessingStats });
                    if (blessingStats.length > 0) {
                        this.recordDiscoveredBlessingStats(blessingStats);
                        const chosen = this.decisionMaker.pickBlessing(blessingStats);
                        devvitGIAELogger.log('Blessing choice', { chosen, available: blessingStats });
                        const btn = skillButtons.find((b) => b.textContent?.toLowerCase().includes(chosen.toLowerCase()));
                        if (btn) {
                            btn.click();
                            buttonClicked = true;
                        }
                    }
                }
                else {
                    // Handle ability choices
                    devvitGIAELogger.log('Ability choice detected (DOM)', { headerText });
                    const abilities = skillButtons.map((b) => b.textContent?.trim() || '');
                    if (abilities.length > 0) {
                        this.recordDiscoveredAbilities(abilities);
                        const chosen = this.decisionMaker.pickAbility(abilities);
                        devvitGIAELogger.log('Ability choice', { chosen, available: abilities });
                        const btn = buttons.find((b) => b.textContent?.includes(chosen));
                        if (btn) {
                            btn.click();
                            buttonClicked = true;
                        }
                    }
                }
                // Fallback: if no button was clicked, pick the first skill button
                if (!buttonClicked && skillButtons.length > 0) {
                    devvitGIAELogger.log('No specific choice made, picking first button as fallback', {
                        firstButtonText: skillButtons[0].textContent?.trim(),
                    });
                    skillButtons[0].click();
                    buttonClicked = true;
                }
                actionTaken = buttonClicked;
                break;
            }
            case 'continue':
            case 'finish': {
                const btn = buttons.find((b) => b.textContent?.toLowerCase() === 'continue' ||
                    b.classList.contains('end-mission-button'));
                if (btn) {
                    btn.click();
                    actionTaken = true;
                }
                break;
            }
            case 'inn':
                // Mission completion is already handled by the window message listener
                // (setupMessageListener catches 'missionComplete' event from the game)
                // We just need to detect the screen but not send duplicate MISSION_COMPLETED messages
                devvitGIAELogger.log('Inn detected (mission complete)', {
                    postId: this.gameState.postId,
                });
                actionTaken = true; // No action needed, but we handled it
                break;
        }
        // Global fallback: if no action was taken, click the first available button
        if (!actionTaken && buttons.length > 0) {
            devvitGIAELogger.warn('No action taken for screen, clicking first available button as fallback', {
                screen,
                buttonCount: buttons.length,
                firstButton: {
                    text: buttons[0].textContent?.trim(),
                    classes: buttons[0].className,
                },
            });
            buttons[0].click();
        }
    }
    findAllButtons() {
        const selectors = ['.advance-button', '.skill-button', '.skip-button', 'button'];
        const buttons = [];
        for (const selector of selectors) {
            document.querySelectorAll(selector).forEach((el) => {
                const rect = el.getBoundingClientRect();
                if (rect.width > 0 && rect.height > 0) {
                    buttons.push(el);
                }
            });
        }
        return buttons;
    }
    delay(ms) {
        return new Promise((resolve) => setTimeout(resolve, ms));
    }
    // Public API
    updateConfig(config) {
        this.config = { ...this.config, ...config };
    }
    getState() {
        return this.config.enabled ? 'running' : 'stopped';
    }
    getGameState() {
        return {
            enabled: this.config.enabled,
            screen: this.gameState.currentScreen,
            lives: this.gameState.livesRemaining,
            progress: this.gameState.getProgress(),
            postId: this.gameState.postId,
            encounterCurrent: this.gameState.currentEncounter,
            encounterTotal: this.gameState.totalEncounters,
            playSafe: this.gameState.shouldPlaySafe(),
            difficulty: this.gameState.difficulty,
        };
    }
    // Report game state to background service worker
    reportGameState() {
        try {
            chrome.runtime.sendMessage({
                type: 'GAME_STATE_UPDATE',
                gameState: this.getGameState(),
            });
        }
        catch (error) {
            // Silently fail if background is not available
            devvitGIAELogger.error('Failed to report game state', { error: String(error) });
        }
    }
    // Save mission to database
    async saveMissionToDatabase(postId, username, metadata) {
        try {
            const mission = metadata.mission;
            if (!mission)
                return;
            const existingMission = await (0,missions.getMission)(postId);
            // Build permalink URL from postId
            const permalink = postId.startsWith('t3_')
                ? `https://www.reddit.com/r/SwordAndSupperGame/comments/${postId.slice(3)}/`
                : '';
            // Build flat MissionRecord
            const record = {
                postId,
                timestamp: existingMission?.timestamp || Date.now(),
                permalink,
                missionTitle: metadata.missionTitle || mission.foodName || 'Unknown',
                missionAuthorName: metadata.missionAuthorName || 'Unknown',
                environment: mission.environment,
                encounters: mission.encounters || [],
                minLevel: mission.minLevel,
                maxLevel: mission.maxLevel,
                difficulty: mission.difficulty,
                foodImage: mission.foodImage,
                foodName: mission.foodName,
                authorWeaponId: mission.authorWeaponId,
                chef: mission.chef,
                cart: mission.cart,
                rarity: mission.rarity,
                type: mission.type,
            };
            await (0,missions/* saveMission */.aB)(record);
            if (existingMission) {
                devvitGIAELogger.log('Mission data enriched', {
                    postId,
                    difficulty: record.difficulty,
                    environment: record.environment,
                });
            }
            else {
                devvitGIAELogger.log('🆕 NEW MISSION discovered', {
                    postId,
                    difficulty: record.difficulty,
                    foodName: mission.foodName,
                });
            }
        }
        catch (error) {
            devvitGIAELogger.error('Failed to save mission', { error: String(error) });
        }
    }
    /**
     * Record discovered abilities to storage for user reference
     */
    recordDiscoveredAbilities(abilityNames) {
        try {
            chrome.storage.local.get(['discoveredAbilities'], (result) => {
                const existing = new Set(result.discoveredAbilities || []);
                let added = false;
                for (const name of abilityNames) {
                    if (!existing.has(name)) {
                        existing.add(name);
                        added = true;
                    }
                }
                if (added) {
                    chrome.storage.local.set({ discoveredAbilities: Array.from(existing) });
                    devvitGIAELogger.log('Discovered new abilities', {
                        newAbilities: abilityNames.filter((n) => !result.discoveredAbilities?.includes(n)),
                        total: existing.size,
                    });
                }
            });
        }
        catch (error) {
            // Silently fail - this is not critical
            devvitGIAELogger.error('Failed to record discovered abilities', { error: String(error) });
        }
    }
    /**
     * Record discovered blessing stats to storage for user reference
     */
    recordDiscoveredBlessingStats(statNames) {
        try {
            chrome.storage.local.get(['discoveredBlessingStats'], (result) => {
                const existing = new Set(result.discoveredBlessingStats || []);
                let added = false;
                for (const name of statNames) {
                    if (!existing.has(name)) {
                        existing.add(name);
                        added = true;
                    }
                }
                if (added) {
                    chrome.storage.local.set({ discoveredBlessingStats: Array.from(existing) });
                    devvitGIAELogger.log('Discovered new blessing stats', {
                        newStats: statNames.filter((n) => !result.discoveredBlessingStats?.includes(n)),
                        total: existing.size,
                    });
                }
            });
        }
        catch (error) {
            // Silently fail - this is not critical
            devvitGIAELogger.error('Failed to record discovered blessing stats', { error: String(error) });
        }
    }
}

;// ./src/content/devvit/devvit.tsx
/**
 * Game script - Runs inside the game iframe (*.devvit.net)
 * This is where we interact with the actual Sword & Supper game
 */


devvitLogger.log('Devvit content script loaded', {
    version: "0.15.2",
    buildTime: "2025-11-04T09:51:20.867Z",
    url: window.location.href,
    loadTime: new Date().toISOString(),
});
let gameAutomation = null;
// Set up message listener IMMEDIATELY to catch initialData
// This must be before the game sends the message!
window.addEventListener('message', (event) => {
    devvitLogger.log('📨 message event', event);
    try {
        // Check for devvit-message with initialData
        if (event.data?.type === 'devvit-message') {
            const messageType = event.data?.data?.message?.type;
            devvitLogger.log('📨 devvit-message received', {
                messageType,
                origin: event.origin,
                data: event.data?.data?.message?.data || null,
                timestamp: new Date().toISOString(),
            });
            // If it's initialData, store it for later processing
            if (messageType === 'initialData') {
                const postId = event.data?.data?.message?.data?.postId;
                devvitLogger.log(`✅ initialData for ${postId} captured!`, event.data?.data);
                // Store the data globally so we can access it after automation engine initializes
                window.__capturedInitialData = event.data.data.message.data;
            }
        }
    }
    catch (error) {
        devvitLogger.error('Error in early message listener', { error: String(error) });
    }
});
devvitLogger.log('Early message listener installed');
// ============================================================================
// Extension Context Error Handling
// ============================================================================
/**
 * Safely send message to background script with proper error handling
 */
function safeSendMessage(message, callback) {
    try {
        chrome.runtime.sendMessage(message, (response) => {
            if (chrome.runtime.lastError) {
                const errorMsg = String(chrome.runtime.lastError.message || chrome.runtime.lastError);
                if (errorMsg.includes('Extension context invalidated')) {
                    devvitLogger.log('[ExtensionContext] Extension was updated/reloaded', {
                        error: errorMsg,
                    });
                    // Game iframe - no UI to show notification, just log
                }
                else {
                    devvitLogger.error('[ExtensionContext] Runtime error', { error: errorMsg });
                }
                return;
            }
            if (callback) {
                callback(response);
            }
        });
    }
    catch (error) {
        const errorMsg = String(error);
        if (errorMsg.includes('Extension context invalidated')) {
            devvitLogger.log('[ExtensionContext] Extension was updated/reloaded', { error: errorMsg });
        }
        else {
            devvitLogger.error('[ExtensionContext] Runtime error', { error: errorMsg });
        }
    }
}
// Control panel removed - now using BotControlPanel in reddit context
/**
 * Initialize automation engine
 */
function initializeAutomation() {
    if (gameAutomation) {
        devvitLogger.warn('Automation already initialized');
        return;
    }
    devvitLogger.log('Initializing game instance automation engine');
    // Load config from storage
    chrome.storage.local.get(['automationConfig'], async (result) => {
        const config = result.automationConfig || {};
        // Initialize game instance automation engine
        const giaeConfig = {
            enabled: false, // Will be enabled when user clicks button
            abilityTierList: config.abilityTierList || DEFAULT_GIAE_CONFIG.abilityTierList,
            blessingStatPriority: config.blessingStatPriority || DEFAULT_GIAE_CONFIG.blessingStatPriority,
            autoAcceptSkillBargains: config.autoAcceptSkillBargains !== undefined
                ? config.autoAcceptSkillBargains
                : DEFAULT_GIAE_CONFIG.autoAcceptSkillBargains,
            skillBargainStrategy: config.skillBargainStrategy || DEFAULT_GIAE_CONFIG.skillBargainStrategy,
            crossroadsStrategy: config.crossroadsStrategy || DEFAULT_GIAE_CONFIG.crossroadsStrategy,
            clickDelay: 300,
        };
        // Create automation engine
        gameAutomation = new GameInstanceAutomationEngine(giaeConfig);
        devvitLogger.log('Game instance automation engine initialized', { config: giaeConfig });
        // Check if we already captured initialData before the automation engine was ready
        const capturedData = window.__capturedInitialData;
        if (capturedData) {
            devvitLogger.log('Processing previously captured initialData', {
                postId: capturedData.postId,
                username: capturedData.username,
            });
            // Manually trigger the save since the automation engine wasn't listening yet
            const missionMetadata = capturedData.missionMetadata;
            const postId = capturedData.postId;
            const username = capturedData.username;
            if (missionMetadata && postId && gameAutomation) {
                // Save the captured mission data to database
                await gameAutomation.saveMissionToDatabase(postId, username, missionMetadata);
                // IMPORTANT: Set both gameAutomation properties AND gameState
                // This is normally done by the message listener in gameInstanceAutomation.ts
                gameAutomation.currentPostId = postId;
                gameAutomation.missionMetadata = missionMetadata;
                gameAutomation.gameState.setMissionData(missionMetadata, postId);
                // Verify/fallback to storage data (fire and forget)
                gameAutomation.gameState.loadMissionDataFromStorage(postId).catch((err) => {
                    devvitLogger.error('Failed to load mission data from storage', err);
                });
                devvitLogger.debug('Set mission data from captured initialData', {
                    postId,
                    encounters: gameAutomation.gameState.totalEncounters,
                });
            }
            // Clear the captured data
            delete window.__capturedInitialData;
        }
        // Notify background script that automation is ready (initial notification only)
        safeSendMessage({
            type: 'AUTOMATION_READY',
            config: giaeConfig,
        });
        // Process any pending START_MISSION_AUTOMATION message
        if (pendingStartMessage) {
            devvitLogger.log('Processing queued START_MISSION_AUTOMATION message');
            // Read config from storage and update before starting
            chrome.storage.local.get(['automationConfig'], (result) => {
                if (result.automationConfig) {
                    updateAutomationConfig(result.automationConfig);
                }
                toggleAutomation(true);
            });
            pendingStartMessage = null;
        }
    });
}
/**
 * Toggle automation on/off
 */
function toggleAutomation(enabled) {
    devvitLogger.log('toggleAutomation called', { enabled });
    if (!gameAutomation) {
        devvitLogger.error('Automation not initialized');
        return;
    }
    if (enabled) {
        gameAutomation.start();
        devvitLogger.log('Automation started');
    }
    else {
        gameAutomation.stop();
        devvitLogger.log('Automation stopped');
    }
    devvitLogger.log('Automation state', { state: gameAutomation.getState() });
}
/**
 * Update automation configuration
 */
function updateAutomationConfig(config) {
    if (!gameAutomation) {
        devvitLogger.error('Automation not initialized');
        return;
    }
    const giaeConfig = {
        abilityTierList: config.abilityTierList,
        blessingStatPriority: config.blessingStatPriority,
        autoAcceptSkillBargains: config.autoAcceptSkillBargains,
        skillBargainStrategy: config.skillBargainStrategy,
        crossroadsStrategy: config.crossroadsStrategy,
    };
    gameAutomation.updateConfig(giaeConfig);
    // Save to storage
    chrome.storage.local.set({ automationConfig: config });
}
// Queue for messages received before automation is ready
let pendingStartMessage = null;
// Listen for messages from Chrome extension (via background script)
chrome.runtime.onMessage.addListener((message, sender, sendResponse) => {
    devvitLogger.log(`Received ${message.type} message`, {
        message,
    });
    switch (message.type) {
        case 'CHECK_AUTOMATION_STATUS':
            // Respond to query about automation engine state
            const isReady = gameAutomation !== null;
            const automationState = gameAutomation ? gameAutomation.getState() : null;
            sendResponse({
                isReady,
                isRunning: automationState === 'running',
                state: automationState,
            });
            break;
        case 'START_MISSION_AUTOMATION':
            if (!gameAutomation) {
                // Automation not ready yet, queue the message
                devvitLogger.log('Automation not ready, queuing START_MISSION_AUTOMATION');
                pendingStartMessage = message;
                sendResponse({ success: true, queued: true });
            }
            else {
                // Read config from storage and update before starting
                chrome.storage.local.get(['automationConfig'], (result) => {
                    if (result.automationConfig) {
                        updateAutomationConfig(result.automationConfig);
                    }
                    toggleAutomation(true);
                    sendResponse({ success: true });
                });
                return true; // Will respond asynchronously
            }
            break;
        case 'STOP_MISSION_AUTOMATION':
            toggleAutomation(false);
            sendResponse({ success: true });
            break;
        case 'STATE_CHANGED':
            // Ignore state changes - only reddit-content needs these
            sendResponse({ success: true });
            break;
        case 'GET_GAME_STATE':
            // Return current game state for status display
            if (gameAutomation) {
                const state = gameAutomation.getGameState();
                sendResponse({ gameState: state });
            }
            else {
                sendResponse({ gameState: null });
            }
            break;
        default:
            devvitLogger.warn(`Unknown message type: ${message.type}`, { message });
            sendResponse({ error: 'Unknown message type: ' + message.type });
    }
    return true; // Keep channel open for async response
});
// Initial analysis after a delay
setTimeout(() => {
    devvitLogger.log('Running initial game analysis');
    // Initialize mission automation
    initializeAutomation();
}, 2000);

/******/ })()
;
//# sourceMappingURL=devvit-content.js.map