/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ 630:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   aB: () => (/* binding */ saveMission),
/* harmony export */   getMission: () => (/* binding */ getMission),
/* harmony export */   vJ: () => (/* binding */ accumulateMissionLoot)
/* harmony export */ });
/* unused harmony exports saveMissionsBatch, getAllMissions, deleteMission, clearAllMissions, markAllMissionsIncomplete, markMissionCleared, setMissionDisabled, importMissions */
/* harmony import */ var _storageTypes__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5551);
/* harmony import */ var _userProgress__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(6853);
/* harmony import */ var _utils_missionRecordMigration__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(1772);
/**
 * Mission CRUD operations
 */



/**
 * Save a mission to storage
 */
async function saveMission(mission) {
    return new Promise((resolve, reject) => {
        // Check if extension context is still valid
        if (!chrome.runtime?.id) {
            reject(new Error('Extension context invalidated'));
            return;
        }
        chrome.storage.local.get([_storageTypes__WEBPACK_IMPORTED_MODULE_0__/* .STORAGE_KEYS */ .d.MISSIONS], (result) => {
            // Check for errors on get
            if (chrome.runtime.lastError) {
                reject(chrome.runtime.lastError);
                return;
            }
            const missions = result[_storageTypes__WEBPACK_IMPORTED_MODULE_0__/* .STORAGE_KEYS */ .d.MISSIONS] || {};
            // Use postId as key to avoid duplicates
            missions[mission.postId] = mission;
            chrome.storage.local.set({ [_storageTypes__WEBPACK_IMPORTED_MODULE_0__/* .STORAGE_KEYS */ .d.MISSIONS]: missions }, () => {
                if (chrome.runtime.lastError) {
                    reject(chrome.runtime.lastError);
                }
                else {
                    // Notify background script that missions changed
                    chrome.runtime.sendMessage({
                        type: 'MISSIONS_UPDATED',
                    }).catch(() => {
                        // Ignore errors if no listeners
                    });
                    resolve();
                }
            });
        });
    });
}
/**
 * Save multiple missions to storage in a single batch operation
 */
async function saveMissionsBatch(missions) {
    return new Promise((resolve, reject) => {
        // Check if extension context is still valid
        if (!chrome.runtime?.id) {
            reject(new Error('Extension context invalidated'));
            return;
        }
        chrome.storage.local.get([STORAGE_KEYS.MISSIONS], (result) => {
            // Check for errors on get
            if (chrome.runtime.lastError) {
                reject(chrome.runtime.lastError);
                return;
            }
            const existingMissions = result[STORAGE_KEYS.MISSIONS] || {};
            // Add all new missions using postId as key
            missions.forEach((mission) => {
                existingMissions[mission.postId] = mission;
            });
            chrome.storage.local.set({ [STORAGE_KEYS.MISSIONS]: existingMissions }, () => {
                if (chrome.runtime.lastError) {
                    reject(chrome.runtime.lastError);
                }
                else {
                    // Notify background script that missions changed
                    chrome.runtime.sendMessage({
                        type: 'MISSIONS_UPDATED',
                    }).catch(() => {
                        // Ignore errors if no listeners
                    });
                    resolve();
                }
            });
        });
    });
}
/**
 * Get all saved missions
 * Automatically migrates old nested format to new flat format
 */
async function getAllMissions() {
    return new Promise((resolve, reject) => {
        chrome.storage.local.get([_storageTypes__WEBPACK_IMPORTED_MODULE_0__/* .STORAGE_KEYS */ .d.MISSIONS], (result) => {
            if (chrome.runtime.lastError) {
                reject(chrome.runtime.lastError);
            }
            else {
                const rawMissions = result[_storageTypes__WEBPACK_IMPORTED_MODULE_0__/* .STORAGE_KEYS */ .d.MISSIONS] || {};
                // Migrate any old format missions to new flat format
                const migratedMissions = {};
                for (const postId in rawMissions) {
                    migratedMissions[postId] = (0,_utils_missionRecordMigration__WEBPACK_IMPORTED_MODULE_2__/* .normalizeMissionRecord */ .tV)(rawMissions[postId]);
                }
                resolve(migratedMissions);
            }
        });
    });
}
/**
 * Get a specific mission by postId
 */
async function getMission(postId) {
    const missions = await getAllMissions();
    return missions[postId] || null;
}
/**
 * Delete a mission
 */
async function deleteMission(postId) {
    return new Promise((resolve, reject) => {
        chrome.storage.local.get([STORAGE_KEYS.MISSIONS], (result) => {
            const missions = result[STORAGE_KEYS.MISSIONS] || {};
            delete missions[postId];
            chrome.storage.local.set({ [STORAGE_KEYS.MISSIONS]: missions }, () => {
                if (chrome.runtime.lastError) {
                    reject(chrome.runtime.lastError);
                }
                else {
                    resolve();
                }
            });
        });
    });
}
/**
 * Clear all missions
 */
async function clearAllMissions() {
    return new Promise((resolve, reject) => {
        chrome.storage.local.remove(STORAGE_KEYS.MISSIONS, () => {
            if (chrome.runtime.lastError) {
                reject(chrome.runtime.lastError);
            }
            else {
                resolve();
            }
        });
    });
}
/**
 * Mark all missions as incomplete (cleared = false, remove clearedAt)
 * Now delegates to userProgress to clear all progress data
 */
async function markAllMissionsIncomplete() {
    return userProgressOps.clearAllUserProgress();
}
/**
 * Mark a mission as cleared
 * Now delegates to userProgress storage
 */
async function markMissionCleared(postId) {
    return userProgressOps.markMissionCleared(postId);
}
/**
 * Accumulate loot from an encounter to mission's total loot
 * Now delegates to userProgress storage
 */
async function accumulateMissionLoot(postId, encounterLoot) {
    return _userProgress__WEBPACK_IMPORTED_MODULE_1__/* .accumulateMissionLoot */ .vJ(postId, encounterLoot);
}
/**
 * Set mission disabled state (skipped by automation when disabled)
 * Now delegates to userProgress storage
 */
async function setMissionDisabled(postId, disabled) {
    return userProgressOps.setMissionDisabled(postId, disabled);
}
/**
 * Import missions from JSON data
 */
async function importMissions(jsonData, mode = 'merge') {
    const stats = { imported: 0, skipped: 0, errors: [] };
    try {
        // Parse JSON if it's a string
        let data;
        if (typeof jsonData === 'string') {
            data = JSON.parse(jsonData);
        }
        else {
            data = jsonData;
        }
        // Get existing missions
        const existingMissions = mode === 'merge' ? await getAllMissions() : {};
        // Handle different data formats
        let missionsToImport = {};
        if (Array.isArray(data)) {
            // Array of missions
            data.forEach((mission) => {
                if (mission.postId) {
                    missionsToImport[mission.postId] = mission;
                }
            });
        }
        else if (typeof data === 'object') {
            // Could be object with postId keys or wrapped data
            if (data.missions) {
                missionsToImport = data.missions;
            }
            else {
                missionsToImport = data;
            }
        }
        // Validate and import missions
        for (const [postId, mission] of Object.entries(missionsToImport)) {
            try {
                // Basic validation
                if (!mission.postId || !mission.timestamp) {
                    stats.errors.push(`Invalid mission data for ${postId}`);
                    stats.skipped++;
                    continue;
                }
                // Check if already exists in merge mode
                if (mode === 'merge' && existingMissions[postId]) {
                    stats.skipped++;
                    continue;
                }
                // Add to existing missions
                existingMissions[postId] = mission;
                stats.imported++;
            }
            catch (err) {
                stats.errors.push(`Error importing ${postId}: ${err}`);
                stats.skipped++;
            }
        }
        // Save all missions back to storage
        await new Promise((resolve, reject) => {
            chrome.storage.local.set({ [STORAGE_KEYS.MISSIONS]: existingMissions }, () => {
                if (chrome.runtime.lastError) {
                    reject(chrome.runtime.lastError);
                }
                else {
                    resolve();
                }
            });
        });
        return stats;
    }
    catch (err) {
        stats.errors.push(`Parse error: ${err}`);
        return stats;
    }
}


/***/ }),

/***/ 854:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   getCurrentRedditUser: () => (/* binding */ getCurrentRedditUser)
/* harmony export */ });
/* unused harmony exports clearUserCache, refreshCurrentUser */
/**
 * Reddit user detection with caching
 * Detects the currently logged-in Reddit user
 */
const CACHE_DURATION = 5 * 60 * 1000; // 5 minutes
const STORAGE_KEY = 'redditUserCache';
/**
 * Get the currently logged-in Reddit username
 * Returns "default" if not logged in or on error
 * Uses cached value if available (even if expired) in contexts that can't fetch
 */
async function getCurrentRedditUser() {
    // Check cache first (including expired cache)
    const cachedUser = await getCachedUserIncludingExpired();
    const isCacheFresh = cachedUser ? (Date.now() - cachedUser.timestamp < CACHE_DURATION) : false;
    // If cache is fresh, use it
    if (isCacheFresh && cachedUser) {
        return cachedUser.username;
    }
    // Try to fetch from Reddit API (only works in content script context)
    try {
        const response = await fetch('https://www.reddit.com/api/me.json', {
            credentials: 'include',
        });
        if (!response.ok) {
            // Fetch failed - if we have expired cache, use it rather than "default"
            // This handles popup context where fetch always fails
            if (cachedUser) {
                return cachedUser.username;
            }
            return 'default';
        }
        const data = await response.json();
        const username = data?.data?.name;
        if (username && typeof username === 'string') {
            await cacheUser(username);
            return username;
        }
        else {
            // Invalid response - use expired cache if available
            if (cachedUser) {
                return cachedUser.username;
            }
            return 'default';
        }
    }
    catch (error) {
        // Fetch error (e.g., popup context) - use expired cache if available
        if (cachedUser) {
            return cachedUser.username;
        }
        return 'default';
    }
}
/**
 * Get cached user data including expired cache
 * Returns null only if no cache exists at all
 */
async function getCachedUserIncludingExpired() {
    return new Promise((resolve) => {
        chrome.storage.local.get([STORAGE_KEY], (result) => {
            if (chrome.runtime.lastError) {
                resolve(null);
                return;
            }
            const cache = result[STORAGE_KEY];
            resolve(cache || null);
        });
    });
}
/**
 * Cache username with timestamp
 */
async function cacheUser(username) {
    return new Promise((resolve, reject) => {
        const cache = {
            username,
            timestamp: Date.now(),
        };
        chrome.storage.local.set({ [STORAGE_KEY]: cache }, () => {
            if (chrome.runtime.lastError) {
                reject(chrome.runtime.lastError);
            }
            else {
                resolve();
            }
        });
    });
}
/**
 * Clear the user cache (useful for testing or forcing refresh)
 */
async function clearUserCache() {
    return new Promise((resolve, reject) => {
        chrome.storage.local.remove(STORAGE_KEY, () => {
            if (chrome.runtime.lastError) {
                reject(chrome.runtime.lastError);
            }
            else {
                resolve();
            }
        });
    });
}
/**
 * Force refresh the user from Reddit (bypasses cache)
 */
async function refreshCurrentUser() {
    await clearUserCache();
    return getCurrentRedditUser();
}


/***/ }),

/***/ 1772:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   tV: () => (/* binding */ normalizeMissionRecord)
/* harmony export */ });
/* unused harmony exports isLegacyFormat, migrateLegacyRecord, normalizeMissionRecords, mapTitleGenerator */
/**
 * Mission Record Format Migration Utilities
 * Handles backward compatibility with old nested metadata format
 */
/**
 * Detect if a mission record is in old nested format
 */
function isLegacyFormat(record) {
    return record && typeof record === 'object' &&
        'metadata' in record &&
        record.metadata !== undefined;
}
/**
 * Convert old nested format to new flat format
 */
function migrateLegacyRecord(legacy) {
    const mission = legacy.metadata?.mission;
    // Build flat record from nested data
    const record = {
        // Core identification
        postId: legacy.postId,
        timestamp: legacy.timestamp,
        permalink: legacy.permalink,
        // Mission metadata
        missionTitle: legacy.metadata?.missionTitle || legacy.missionTitle || `Mission ${legacy.postId.slice(3)}`,
        missionAuthorName: legacy.metadata?.missionAuthorName || 'Unknown',
        // Mission data (from nested mission object or top-level fields)
        environment: (mission?.environment || legacy.environment || 'haunted_forest'),
        encounters: mission?.encounters || [],
        minLevel: mission?.minLevel || legacy.minLevel || 1,
        maxLevel: mission?.maxLevel || legacy.maxLevel || 340,
        difficulty: mission?.difficulty || legacy.difficulty || 0,
        foodImage: mission?.foodImage || '',
        foodName: mission?.foodName || legacy.foodName || '',
        authorWeaponId: mission?.authorWeaponId || '',
        chef: mission?.chef || '',
        cart: mission?.cart || '',
        rarity: (mission?.rarity || 'common'),
        type: mission?.type,
    };
    return record;
}
/**
 * Normalize a mission record - converts legacy format if needed
 */
function normalizeMissionRecord(record) {
    if (isLegacyFormat(record)) {
        return migrateLegacyRecord(record);
    }
    return record;
}
/**
 * Bulk normalize an array of mission records
 */
function normalizeMissionRecords(records) {
    return records.map(normalizeMissionRecord);
}
/**
 * Generate a display title for missions when creating maps
 * Format: "2* | 121 - 140 | haunted_forest | Lemon Pistachio Swirl"
 */
function mapTitleGenerator(difficulty, minLevel, maxLevel, environment, foodName) {
    const parts = [];
    if (difficulty > 0) {
        parts.push(`${difficulty}*`);
    }
    else {
        parts.push('?');
    }
    parts.push(`${minLevel} - ${maxLevel}`);
    if (environment) {
        parts.push(environment);
    }
    else {
        parts.push('?');
    }
    if (foodName) {
        parts.push(foodName);
    }
    return parts.join(' | ');
}


/***/ }),

/***/ 5551:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   d: () => (/* binding */ STORAGE_KEYS)
/* harmony export */ });
/* unused harmony export DEFAULT_AUTOMATION_FILTERS */
/**
 * Extension-specific storage types
 * For shared mission types, import from @lazyfrog/types
 */
const DEFAULT_AUTOMATION_FILTERS = {
    stars: [1, 2, 3, 4, 5],
    minLevel: 1,
    maxLevel: 340,
};
const STORAGE_KEYS = {
    MISSIONS: 'missions', // Mission data (static, from database)
    USER_PROGRESS: 'userProgress', // User-specific progress tracking
    USER_OPTIONS: 'userOptions',
    AUTOMATION_FILTERS: 'automationFilters',
    AUTOMATION_CONFIG: 'automationConfig',
    REDDIT_API_CACHE: 'redditApiCache',
};


/***/ }),

/***/ 6853:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   vJ: () => (/* binding */ accumulateMissionLoot)
/* harmony export */ });
/* unused harmony exports isMissionCleared, isMissionDisabled, getAllUserProgress, markMissionCleared, setMissionDisabled, clearAllUserProgress, exportUserProgress, importUserProgress, exportAllUsersProgress, getUserProgressForUser */
/* harmony import */ var _storageTypes__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(5551);
/* harmony import */ var _reddit_userDetection__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(854);
/**
 * User progress tracking operations
 * Manages cleared status, loot, and disabled missions separately from mission data
 * Progress is scoped per Reddit user, with "default" for non-logged-in users
 */


/**
 * Get empty progress data structure
 */
function createEmptyProgressData() {
    return {
        cleared: [],
        disabled: [],
        clearedAt: {},
        loot: {},
    };
}
/**
 * Get the entire multi-user progress structure from storage
 */
async function getMultiUserProgress() {
    return new Promise((resolve, reject) => {
        chrome.storage.local.get([_storageTypes__WEBPACK_IMPORTED_MODULE_0__/* .STORAGE_KEYS */ .d.USER_PROGRESS], (result) => {
            if (chrome.runtime.lastError) {
                reject(chrome.runtime.lastError);
            }
            else {
                resolve(result[_storageTypes__WEBPACK_IMPORTED_MODULE_0__/* .STORAGE_KEYS */ .d.USER_PROGRESS] || {});
            }
        });
    });
}
/**
 * Set the entire multi-user progress structure to storage
 */
async function setMultiUserProgress(data) {
    return new Promise((resolve, reject) => {
        chrome.storage.local.set({ [_storageTypes__WEBPACK_IMPORTED_MODULE_0__/* .STORAGE_KEYS */ .d.USER_PROGRESS]: data }, () => {
            if (chrome.runtime.lastError) {
                reject(chrome.runtime.lastError);
            }
            else {
                resolve();
            }
        });
    });
}
/**
 * Check if a mission is cleared
 */
async function isMissionCleared(postId) {
    const progress = await getAllUserProgress();
    return progress.cleared.includes(postId);
}
/**
 * Check if a mission is disabled
 */
async function isMissionDisabled(postId) {
    const progress = await getAllUserProgress();
    return progress.disabled.includes(postId);
}
/**
 * Get all user progress for the current user
 */
async function getAllUserProgress() {
    const username = await getCurrentRedditUser();
    const multiUserData = await getMultiUserProgress();
    return multiUserData[username] || createEmptyProgressData();
}
/**
 * Mark a mission as cleared
 */
async function markMissionCleared(postId) {
    const username = await getCurrentRedditUser();
    const multiUserData = await getMultiUserProgress();
    // Get or create user's progress
    const userProgress = multiUserData[username] || createEmptyProgressData();
    // Add to cleared array if not already there
    if (!userProgress.cleared.includes(postId)) {
        userProgress.cleared.push(postId);
    }
    // Record clear timestamp
    userProgress.clearedAt[postId] = Date.now();
    // Update multi-user structure
    multiUserData[username] = userProgress;
    // Save back to storage
    await setMultiUserProgress(multiUserData);
}
/**
 * Mark a mission as disabled (e.g., deleted post)
 */
async function setMissionDisabled(postId, disabled) {
    const username = await getCurrentRedditUser();
    const multiUserData = await getMultiUserProgress();
    // Get or create user's progress
    const userProgress = multiUserData[username] || createEmptyProgressData();
    if (disabled) {
        // Add to disabled array if not already there
        if (!userProgress.disabled.includes(postId)) {
            userProgress.disabled.push(postId);
        }
    }
    else {
        // Remove from disabled array
        const index = userProgress.disabled.indexOf(postId);
        if (index > -1) {
            userProgress.disabled.splice(index, 1);
        }
    }
    // Update multi-user structure
    multiUserData[username] = userProgress;
    // Save back to storage
    await setMultiUserProgress(multiUserData);
}
/**
 * Accumulate loot for a mission
 */
async function accumulateMissionLoot(postId, newLoot) {
    const username = await (0,_reddit_userDetection__WEBPACK_IMPORTED_MODULE_1__.getCurrentRedditUser)();
    const multiUserData = await getMultiUserProgress();
    // Get or create user's progress
    const userProgress = multiUserData[username] || createEmptyProgressData();
    // Get existing loot for this mission
    const totalLoot = userProgress.loot[postId] || [];
    // Accumulate loot
    for (const item of newLoot) {
        const existingItem = totalLoot.find((l) => l.id === item.id);
        if (existingItem) {
            existingItem.quantity += item.quantity;
        }
        else {
            totalLoot.push({ ...item });
        }
    }
    // Update loot
    userProgress.loot[postId] = totalLoot;
    // Update multi-user structure
    multiUserData[username] = userProgress;
    // Save back to storage
    await setMultiUserProgress(multiUserData);
}
/**
 * Clear all user progress for the current user (useful for starting fresh)
 */
async function clearAllUserProgress() {
    const username = await getCurrentRedditUser();
    const multiUserData = await getMultiUserProgress();
    // Clear current user's progress
    multiUserData[username] = createEmptyProgressData();
    // Save back to storage
    await setMultiUserProgress(multiUserData);
}
/**
 * Export user progress for backup/transfer (current user only)
 */
async function exportUserProgress() {
    const progress = await getAllUserProgress();
    const username = await getCurrentRedditUser();
    return JSON.stringify({ username, progress }, null, 2);
}
/**
 * Validate that the imported data has the required UserProgressData structure
 */
function isValidUserProgressData(data) {
    return (data &&
        typeof data === 'object' &&
        Array.isArray(data.cleared) &&
        Array.isArray(data.disabled) &&
        typeof data.clearedAt === 'object' &&
        typeof data.loot === 'object');
}
/**
 * Import user progress from backup (for current user)
 */
async function importUserProgress(jsonData) {
    const data = JSON.parse(jsonData);
    const progress = data.progress || data; // Support both old and new formats
    // Validate the structure
    if (!isValidUserProgressData(progress)) {
        throw new Error('Invalid progress data structure. Expected object with arrays: cleared, disabled, and objects: clearedAt, loot');
    }
    const username = await getCurrentRedditUser();
    const multiUserData = await getMultiUserProgress();
    // Set current user's progress
    multiUserData[username] = progress;
    // Save back to storage
    await setMultiUserProgress(multiUserData);
}
/**
 * Export all users' progress (admin/debug function)
 */
async function exportAllUsersProgress() {
    const multiUserData = await getMultiUserProgress();
    return JSON.stringify(multiUserData, null, 2);
}
/**
 * Get progress for a specific user (useful for switching contexts or admin)
 */
async function getUserProgressForUser(username) {
    const multiUserData = await getMultiUserProgress();
    return multiUserData[username] || createEmptyProgressData();
}


/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};

;// ./src/utils/logger.ts
/**
 * Unified logging utility for the AutoSupper extension
 * Logs to both console and optional remote server for debugging
 */
// Default number of logs to keep in storage
const DEFAULT_MAX_STORED_LOGS = 10000;
class Logger {
    constructor(context, config, parentContext) {
        this.parentContext = parentContext;
        this.config = {
            context,
            remoteLogging: config?.remoteLogging ?? true,
            remoteUrl: config?.remoteUrl ?? 'http://localhost:7856/log',
            consoleLogging: config?.consoleLogging ?? true,
            storeLogs: config?.storeLogs ?? true,
            maxStoredLogs: config?.maxStoredLogs ?? DEFAULT_MAX_STORED_LOGS,
        };
        // Load logging settings from storage
        if (typeof chrome !== 'undefined' && chrome.storage) {
            chrome.storage.local.get(['automationConfig'], (result) => {
                if (result.automationConfig?.remoteLogging !== undefined) {
                    this.config.remoteLogging = result.automationConfig.remoteLogging;
                }
                if (result.automationConfig?.storeLogs !== undefined) {
                    this.config.storeLogs = result.automationConfig.storeLogs;
                }
                if (result.automationConfig?.maxStoredLogs !== undefined) {
                    this.config.maxStoredLogs = result.automationConfig.maxStoredLogs;
                }
            });
            // Listen for changes to logging settings
            chrome.storage.onChanged.addListener((changes, areaName) => {
                if (areaName === 'local' && changes.automationConfig?.newValue) {
                    const newConfig = changes.automationConfig.newValue;
                    if (newConfig.remoteLogging !== undefined) {
                        this.config.remoteLogging = newConfig.remoteLogging;
                    }
                    if (newConfig.storeLogs !== undefined) {
                        this.config.storeLogs = newConfig.storeLogs;
                    }
                    if (newConfig.maxStoredLogs !== undefined) {
                        this.config.maxStoredLogs = newConfig.maxStoredLogs;
                    }
                }
            });
        }
    }
    /**
     * Send log to remote server
     */
    async sendToRemote(entry) {
        if (!this.config.remoteLogging)
            return;
        try {
            await fetch(this.config.remoteUrl, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify(entry),
            }).catch(() => {
                // Silently fail if remote server is not available
                // We don't want to break the extension if the debug server is down
            });
        }
        catch (error) {
            // Silently fail
        }
    }
    /**
     * Store log entry in chrome.storage
     */
    storeLog(entry) {
        if (!this.config.storeLogs)
            return;
        if (typeof chrome === 'undefined' || !chrome.storage)
            return;
        try {
            // Use callback-based API for better compatibility
            chrome.storage.local.get(['debugLogs'], (result) => {
                if (chrome.runtime.lastError) {
                    console.error('[LF] Failed to get logs:', chrome.runtime.lastError);
                    return;
                }
                const logs = result.debugLogs || [];
                // Add new log
                logs.push(entry);
                // Trim to max size (keep most recent logs)
                if (logs.length > this.config.maxStoredLogs) {
                    logs.splice(0, logs.length - this.config.maxStoredLogs);
                }
                // Save back to storage
                chrome.storage.local.set({ debugLogs: logs }, () => {
                    if (chrome.runtime.lastError) {
                        console.error('[LF] Failed to store log:', chrome.runtime.lastError);
                    }
                });
            });
        }
        catch (error) {
            // Silently fail - don't break the extension if storage fails
            console.error('[LF] Failed to store log:', error);
        }
    }
    /**
     * Format message with prefix
     */
    formatMessage(message) {
        const fullContext = this.parentContext
            ? `${this.parentContext}][${this.config.context}`
            : this.config.context;
        return `[LF][${fullContext}] ${message}`;
    }
    /**
     * Serialize data for logging
     */
    serializeData(data) {
        if (data === undefined)
            return undefined;
        try {
            // Try to stringify and parse to clean up circular references
            return JSON.parse(JSON.stringify(data));
        }
        catch (error) {
            // If that fails, return a string representation
            return String(data);
        }
    }
    /**
     * Core logging function
     */
    logInternal(level, ...args) {
        // Create formatted message for remote logging
        const message = args
            .map((arg) => {
            if (typeof arg === 'string')
                return arg;
            if (typeof arg === 'object') {
                try {
                    return JSON.stringify(arg);
                }
                catch (error) {
                    // Handle circular references gracefully
                    return '[Circular Reference]';
                }
            }
            return String(arg);
        })
            .join(' ');
        const entry = {
            timestamp: new Date().toISOString(),
            context: this.config.context,
            level,
            message,
            data: args.length > 1 ? this.serializeData(args.slice(1)) : undefined,
        };
        // Log to console using appropriate method with native object inspection
        if (this.config.consoleLogging) {
            const consoleMethod = console[level] || console.log;
            // Add LazyFrog and context prefix but preserve native console behavior
            const fullContext = this.parentContext
                ? `${this.parentContext}][${this.config.context}`
                : this.config.context;
            consoleMethod(`[LF][${fullContext}]`, ...args);
        }
        // Store in chrome.storage (non-blocking)
        this.storeLog(entry);
        // Send to remote server (non-blocking)
        this.sendToRemote(entry);
    }
    /**
     * Public logging methods - support unlimited parameters like console.log()
     */
    log(...args) {
        this.logInternal('log', ...args);
    }
    info(...args) {
        this.logInternal('info', ...args);
    }
    warn(...args) {
        this.logInternal('warn', ...args);
    }
    error(...args) {
        this.logInternal('error', ...args);
    }
    debug(...args) {
        this.logInternal('debug', ...args);
    }
    /**
     * Update logger configuration
     */
    setConfig(config) {
        this.config = { ...this.config, ...config };
    }
    /**
     * Enable/disable remote logging
     */
    setRemoteLogging(enabled) {
        this.config.remoteLogging = enabled;
    }
    /**
     * Enable/disable console logging
     */
    setConsoleLogging(enabled) {
        this.config.consoleLogging = enabled;
    }
    /**
     * Create a nested logger with additional context
     */
    createNestedLogger(nestedContext) {
        const fullContext = this.parentContext
            ? `${this.parentContext}][${this.config.context}`
            : this.config.context;
        return new Logger(nestedContext, {
            remoteLogging: this.config.remoteLogging,
            remoteUrl: this.config.remoteUrl,
            consoleLogging: this.config.consoleLogging,
        }, fullContext);
    }
}
/**
 * Factory function to create loggers for different contexts
 */
function createLogger(context, config, parentContext) {
    return new Logger(context, config, parentContext);
}
/**
 * Export stored logs as JSON
 */
async function exportLogs() {
    if (typeof chrome === 'undefined' || !chrome.storage) {
        throw new Error('Chrome storage not available');
    }
    const result = await chrome.storage.local.get(['debugLogs']);
    const logs = result.debugLogs || [];
    return JSON.stringify({
        exportDate: new Date().toISOString(),
        logCount: logs.length,
        logs,
    }, null, 2);
}
/**
 * Clear all stored logs
 */
async function clearLogs() {
    if (typeof chrome === 'undefined' || !chrome.storage) {
        throw new Error('Chrome storage not available');
    }
    await chrome.storage.local.set({ debugLogs: [] });
}
/**
 * Get log statistics
 */
async function getLogStats() {
    if (typeof chrome === 'undefined' || !chrome.storage) {
        return { count: 0 };
    }
    const result = await chrome.storage.local.get(['debugLogs']);
    const logs = result.debugLogs || [];
    return {
        count: logs.length,
        oldestLog: logs.length > 0 ? logs[0].timestamp : undefined,
        newestLog: logs.length > 0 ? logs[logs.length - 1].timestamp : undefined,
    };
}
/**
 * Pre-configured loggers for each context
 *
 * Example usage for nested contexts:
 * const gameLogger = redditLogger.createNestedLogger('GAME');
 * const combatLogger = gameLogger.createNestedLogger('COMBAT');
 *
 * This will produce logs like:
 * [LF][REDDIT][GAME] Starting mission
 * [LF][REDDIT][GAME][COMBAT] Enemy defeated
 */
const popupLogger = createLogger('POPUP');
const extensionLogger = createLogger('SW');
const redditLogger = createLogger('REDDIT');
const devvitLogger = createLogger('DEVVIT');
const devvitGIAELogger = createLogger('DEVVIT-GIAE');

// EXTERNAL MODULE: ./src/lib/storage/missions.ts
var missions = __webpack_require__(630);
;// ./src/lib/storage/domUtils.ts
/**
 * DOM-related utility functions for missions
 */
/**
 * Check if mission is cleared by looking for cleared indicators in the DOM
 * Returns the cleared image element if found, null otherwise
 */
function checkMissionClearedInDOM() {
    // Check for cleared image (the cleared/done banner)
    // This image appears when a mission has been cleared
    const clearedImages = Array.from(document.querySelectorAll('img[src*="fxlui9egtgbf1.png"]'));
    return clearedImages.length > 0 ? clearedImages[0] : null;
}

;// ./src/utils/url.ts
/**
 * Normalize a Reddit post ID to ensure it has the standard t3_ prefix.
 *
 * @param id - The post ID to normalize (with or without t3_ prefix)
 * @returns The normalized post ID with t3_ prefix, or null if invalid
 *
 * @example
 * ```typescript
 * normalizePostId('1od6q1h') // 't3_1od6q1h'
 * normalizePostId('t3_1od6q1h') // 't3_1od6q1h'
 * normalizePostId('invalid') // null
 * ```
 */
function normalizePostId(id) {
    if (!id || typeof id !== 'string') {
        return null;
    }
    // If already prefixed, validate and return
    if (id.startsWith('t3_')) {
        const postIdPart = id.slice(3);
        if (postIdPart && /^[a-z0-9]+$/i.test(postIdPart)) {
            return id;
        }
        return null;
    }
    // If not prefixed, validate and add prefix
    if (/^[a-z0-9]+$/i.test(id)) {
        return `t3_${id}`;
    }
    return null;
}
/**
 * Normalize a Reddit Sword & Supper mission permalink to the canonical format:
 * https://www.reddit.com/r/SwordAndSupperGame/comments/<postId>/
 *
 * Accepts either a URL or a postId (with or without t3_ prefix).
 * The postId parameter should be the raw post ID without t3_ prefix.
 */
function normalizeRedditPermalink(input) {
    const base = 'https://www.reddit.com';
    // Helper to strip t3_ prefix
    const stripT3 = (id) => (id?.startsWith('t3_') ? id.slice(3) : id);
    let postId = '';
    try {
        if (input?.startsWith('http')) {
            const url = new URL(input);
            // Try to extract id from /comments/<id>/ path
            const match = url.pathname.match(/\/comments\/([^/]+)/);
            if (match && match[1]) {
                postId = stripT3(match[1]);
            }
        }
        else if (input) {
            // Treat as postId
            postId = stripT3(input);
        }
    }
    catch {
        // Fallback to treating as postId
        postId = stripT3(input);
    }
    if (!postId) {
        return `${base}/r/SwordAndSupperGame/`;
    }
    return `${base}/r/SwordAndSupperGame/comments/${postId}/`;
}

;// ./src/content/devvit/utils/extractPostIdFromUrl.ts
/**
 * @fileoverview Utility for extracting postId from various URL formats
 *
 * This utility handles different URL structures:
 * - Devvit iframe URLs with context parameter
 * - Devvit iframe URLs with JWT tokens
 * - Legacy Reddit URLs
 */

/**
 * Extract postId from URL as fallback when initialData is missing
 *
 * @param url - The URL to extract the postId from
 * @returns The extracted postId (e.g., "t3_1od6q1h") or null if not found
 *
 * @example
 * ```typescript
 * const url = "https://cabbageidle-eimoap-0-0-50-webview.devvit.net/index.html?context=%7B%22postId%22%3A%22t3_1od6q1h%22%7D";
 * const postId = extractPostIdFromUrl(url);
 * console.log(postId); // "t3_1od6q1h"
 * ```
 *
 * @example
 * ```typescript
 * // JWT token extraction
 * const url = "https://example.devvit.net/index.html?webbit_token=eyJ...";
 * const postId = extractPostIdFromUrl(url);
 * console.log(postId); // "t3_1od6q1h"
 * ```
 */
function extractPostIdFromUrl(url) {
    try {
        // For Devvit iframe URLs, try to extract from context parameter
        // URL format: https://cabbageidle-eimoap-0-0-50-webview.devvit.net/index.html?context=%7B...%7D
        // Stop at & or # to avoid capturing hash fragments
        const contextMatch = url.match(/context=([^&#]+)/);
        if (contextMatch) {
            try {
                const contextJson = decodeURIComponent(contextMatch[1]);
                const context = JSON.parse(contextJson);
                if (context.postId) {
                    console.log('[extractPostIdFromUrl] Extracted postId from context parameter', {
                        postId: context.postId,
                    });
                    return context.postId;
                }
            }
            catch (parseError) {
                console.warn('[extractPostIdFromUrl] Failed to parse context parameter', {
                    error: String(parseError),
                });
                // Try to extract postId directly from the context string as a fallback
                const postIdMatch = contextMatch[1].match(/%22postId%22%3A%22(t3_[^%]+)%22/);
                if (postIdMatch) {
                    console.log('[extractPostIdFromUrl] Extracted postId from context string fallback', {
                        postId: postIdMatch[1],
                    });
                    return postIdMatch[1];
                }
            }
        }
        // Fallback: try to extract from JWT token in webbit_token parameter
        // Stop at & or # to avoid capturing hash fragments
        const tokenMatch = url.match(/webbit_token=([^&#]+)/);
        if (tokenMatch) {
            try {
                // JWT tokens have 3 parts separated by dots
                const tokenParts = tokenMatch[1].split('.');
                if (tokenParts.length === 3) {
                    // Decode the payload (second part)
                    const payload = JSON.parse(atob(tokenParts[1]));
                    if (payload['devvit-post-id']) {
                        console.log('[extractPostIdFromUrl] Extracted postId from JWT token', {
                            postId: payload['devvit-post-id'],
                        });
                        return payload['devvit-post-id'];
                    }
                }
            }
            catch (tokenError) {
                console.warn('[extractPostIdFromUrl] Failed to parse JWT token', {
                    error: String(tokenError),
                });
            }
        }
        // Legacy fallback for Reddit URLs (probably won't work in Devvit iframe)
        const redditMatch = url.match(/\/comments\/([a-zA-Z0-9]+)/);
        if (redditMatch && redditMatch[1]) {
            return normalizePostId(redditMatch[1]);
        }
    }
    catch (error) {
        console.warn('[extractPostIdFromUrl] Failed to extract postId from URL', {
            error: String(error),
        });
    }
    return null;
}

;// ./src/automation/gameInstanceAutomation.ts
/**
 * Simple Button-Clicking Automation
 * No metadata required - just clicks buttons as they appear
 */




const DEFAULT_GIAE_CONFIG = {
    enabled: false,
    abilityTierList: ['IceKnifeOnTurnStart', 'LightningOnCrit', 'HealOnFirstTurn'],
    blessingStatPriority: ['Speed', 'Attack', 'Crit', 'Health', 'Defense', 'Dodge'], // Speed first for faster gameplay
    autoAcceptSkillBargains: true,
    skillBargainStrategy: 'positive-only',
    crossroadsStrategy: 'skip', // Skip mini bosses by default (safer/faster)
    clickDelay: 1000,
};
class GameInstanceAutomationEngine {
    constructor(config) {
        this.intervalId = null;
        this.isProcessing = false;
        this.inCombat = false;
        this.missionMetadata = null;
        this.currentPostId = null;
        // Deep merge config, ensuring arrays are properly preserved
        this.config = {
            ...DEFAULT_GIAE_CONFIG,
            ...config,
            // Ensure arrays are properly set, falling back to defaults if not provided
            abilityTierList: Array.isArray(config.abilityTierList)
                ? config.abilityTierList
                : DEFAULT_GIAE_CONFIG.abilityTierList,
            blessingStatPriority: Array.isArray(config.blessingStatPriority)
                ? config.blessingStatPriority
                : DEFAULT_GIAE_CONFIG.blessingStatPriority,
        };
        this.setupMessageListener();
    }
    /**
     * Emit state change event for UI components
     */
    emitStateChange() {
        window.dispatchEvent(new CustomEvent('SS_AUTOMATION_STATE_CHANGE', {
            detail: this.getState(),
        }));
    }
    /**
     * Broadcast status update to popup
     */
    broadcastStatus(status, missionId, encounter) {
        try {
            chrome.runtime.sendMessage({
                type: 'STATUS_UPDATE',
                status,
                missionId,
                encounter,
            });
        }
        catch (error) {
            // Silently fail if popup is closed
        }
    }
    /**
     * Save mission to Chrome storage database
     * Public so it can be called from content script when initialData is captured early
     */
    async saveMissionToDatabase(postId, username, metadata) {
        try {
            const mission = metadata.mission;
            if (!mission)
                return;
            // Check if mission already exists
            const { getMission } = await Promise.resolve(/* import() */).then(__webpack_require__.bind(__webpack_require__, 630));
            const existingMission = await getMission(postId);
            // Build permalink URL from postId (e.g., t3_1obdqvw -> /r/SwordAndSupperGame/comments/1obdqvw/)
            const permalink = postId.startsWith('t3_')
                ? `https://www.reddit.com/r/SwordAndSupperGame/comments/${postId.slice(3)}/`
                : '';
            // Build flat MissionRecord
            const record = {
                // Core identification
                postId,
                timestamp: existingMission?.timestamp || Date.now(),
                permalink,
                // Mission metadata
                missionTitle: metadata.missionTitle || mission.foodName || 'Unknown',
                missionAuthorName: metadata.missionAuthorName || 'Unknown',
                // Mission data (flattened from mission object)
                environment: mission.environment,
                encounters: mission.encounters || [],
                minLevel: mission.minLevel,
                maxLevel: mission.maxLevel,
                difficulty: mission.difficulty,
                foodImage: mission.foodImage || '',
                foodName: mission.foodName || '',
                authorWeaponId: mission.authorWeaponId || '',
                chef: mission.chef || '',
                cart: mission.cart || '',
                rarity: mission.rarity || 'common',
                type: mission.type,
            };
            await (0,missions/* saveMission */.aB)(record);
            if (existingMission) {
                // Updating existing mission with enriched data
                devvitGIAELogger.log('Mission data enriched', {
                    postId,
                    difficulty: record.difficulty,
                    environment: record.environment,
                    encounters: mission.encounters?.length,
                });
            }
            else {
                // New mission discovered from playing (not previously scanned)
                devvitGIAELogger.log('🆕 NEW MISSION discovered from gameplay', {
                    postId,
                    difficulty: record.difficulty,
                    environment: record.environment,
                    encounters: mission.encounters?.length,
                    permalink,
                    foodName: mission.foodName,
                });
            }
        }
        catch (error) {
            devvitGIAELogger.error('Failed to save mission', { error: String(error) });
        }
    }
    /**
     * Listen to window messages for game state
     */
    setupMessageListener() {
        window.addEventListener('message', (event) => {
            try {
                // Log ALL messages to understand what's coming through
                // if (event.data) {
                // 	// Check if this is a devvit-message (the format the game uses)
                // 	const isDevvitMessage = event.data?.type === 'devvit-message';
                // 	const messageType = event.data?.data?.message?.type;
                // 	// Log devvit-messages with more detail
                // 	if (isDevvitMessage) {
                // 		devvitLogger.log('📨 devvit-message received', {
                // 			origin: event.origin,
                // 			messageType: messageType,
                // 			hasMessageData: !!event.data?.data?.message?.data,
                // 			topLevelKeys: Object.keys(event.data).slice(0, 20),
                // 			messageKeys: event.data?.data?.message
                // 				? Object.keys(event.data.data.message).slice(0, 20)
                // 				: [],
                // 			// Include full data for initialData and encounterResult messages
                // 			fullData:
                // 				messageType === 'initialData' ||
                // 				messageType === 'initialDataInn' ||
                // 				messageType === 'encounterResult'
                // 					? event.data
                // 					: undefined,
                // 		});
                // 	}
                // }
                // Check for initialData message (mission metadata)
                // Using the EXACT structure the game uses: event.data.type === "devvit-message"
                if (event.data?.type === 'devvit-message' &&
                    event.data?.data?.message?.type === 'initialData') {
                    this.missionMetadata = event.data.data.message.data?.missionMetadata;
                    const postId = event.data.data.message.data?.postId;
                    const username = event.data.data.message.data?.username;
                    // Store postId for later use (e.g., marking as cleared)
                    this.currentPostId = postId;
                    devvitGIAELogger.log('Mission metadata received', {
                        postId,
                        difficulty: this.missionMetadata?.mission?.difficulty,
                        environment: this.missionMetadata?.mission?.environment,
                        encounters: this.missionMetadata?.mission?.encounters?.length,
                    });
                    // Broadcast status
                    const encounterCount = this.missionMetadata?.mission?.encounters?.length || 0;
                    this.broadcastStatus('Starting mission clearing', postId, {
                        current: 0,
                        total: encounterCount,
                    });
                    // Save mission to database
                    if (this.missionMetadata && postId) {
                        this.saveMissionToDatabase(postId, username, this.missionMetadata);
                    }
                    this.emitStateChange(); // Notify UI
                }
                // Check for combat events
                if (event.data?.type === 'COMBAT_START') {
                    this.inCombat = true;
                    devvitGIAELogger.log('Combat started - pausing button clicks');
                    this.emitStateChange(); // Notify UI
                }
                if (event.data?.type === 'COMBAT_END') {
                    this.inCombat = false;
                    devvitGIAELogger.log('Combat ended - resuming automation');
                    this.emitStateChange(); // Notify UI
                }
                // Check for encounter result with loot (final encounter)
                // Try both possible message structures
                const encounterResult = (event.data?.data?.message?.type === 'encounterResult' && event.data.data.message.data) ||
                    (event.data?.type === 'devvit-message' &&
                        event.data?.data?.message?.type === 'encounterResult' &&
                        event.data.data.message.data);
                if (encounterResult) {
                    devvitGIAELogger.log('Encounter result received', {
                        victory: encounterResult.victory,
                        encounterIndex: encounterResult.encounterAction?.encounterIndex,
                        lootCount: encounterResult.encounterLoot?.length,
                    });
                    // Update status with encounter progress
                    const encounterIndex = encounterResult.encounterAction?.encounterIndex;
                    const encounterCount = this.missionMetadata?.mission?.encounters?.length || 0;
                    if (encounterIndex !== undefined && encounterCount > 0) {
                        this.broadcastStatus('Clearing %missionId% encounter %current% of %total%', this.currentPostId || undefined, {
                            current: encounterIndex + 1,
                            total: encounterCount,
                        });
                    }
                    // If this is a victory and has loot, accumulate it
                    if (encounterResult.victory &&
                        encounterResult.encounterLoot &&
                        encounterResult.encounterLoot.length > 0 &&
                        this.currentPostId) {
                        devvitGIAELogger.log('Accumulating encounter loot', {
                            postId: this.currentPostId,
                            encounterIndex: encounterResult.encounterAction?.encounterIndex,
                            loot: encounterResult.encounterLoot,
                        });
                        (0,missions/* accumulateMissionLoot */.vJ)(this.currentPostId, encounterResult.encounterLoot).catch((error) => {
                            devvitGIAELogger.error('Failed to accumulate mission loot', {
                                error: String(error),
                            });
                        });
                    }
                }
                // Check for mission completion (missionComplete message)
                // Support both message structures
                if (event.data?.data?.message?.type === 'missionComplete' ||
                    (event.data?.type === 'devvit-message' &&
                        event.data?.data?.message?.type === 'missionComplete')) {
                    const postId = event.data.data.message.data?.postId;
                    if (postId) {
                        devvitGIAELogger.log('Mission cleared!', { postId });
                        this.broadcastStatus('Finished mission, waiting');
                        // Notify background which will mark as cleared
                        chrome.runtime.sendMessage({
                            type: 'MISSION_COMPLETED',
                            postId,
                        });
                    }
                }
            }
            catch (error) {
                // Log parsing errors
                devvitGIAELogger.error('Error parsing message', { error: String(error) });
            }
        });
    }
    /**
     * Start the automation loop
     */
    start() {
        if (this.intervalId) {
            devvitGIAELogger.log('Already running');
            return;
        }
        devvitGIAELogger.log('Starting button-clicking automation');
        this.config.enabled = true;
        this.broadcastStatus('Waiting for mission to be ready');
        // Check for buttons every 1500ms (1.5 seconds)
        // This is a fallback since we're not relying on messages
        // Increased from 500ms to reduce performance impact and logs
        this.intervalId = window.setInterval(() => {
            if (this.config.enabled && !this.isProcessing) {
                this.processButtons();
            }
        }, 1500);
    }
    /**
     * Stop the automation loop
     */
    stop() {
        devvitGIAELogger.log('Stopping automation');
        this.config.enabled = false;
        if (this.intervalId) {
            window.clearInterval(this.intervalId);
            this.intervalId = null;
        }
    }
    /**
     * Update configuration
     */
    updateConfig(config) {
        this.config = { ...this.config, ...config };
    }
    /**
     * Get current state
     */
    getState() {
        return {
            enabled: this.config.enabled,
            isProcessing: this.isProcessing,
            inCombat: this.inCombat,
            hasMissionMetadata: !!this.missionMetadata,
            missionMetadata: this.missionMetadata, // Include full metadata
            missionDifficulty: this.missionMetadata?.mission?.difficulty,
            missionEnvironment: this.missionMetadata?.mission?.environment,
        };
    }
    /**
     * Check if mission is cleared by looking for cleared indicators in the DOM
     */
    checkMissionCleared() {
        // Use utility function to check DOM
        const clearedImage = checkMissionClearedInDOM();
        if (clearedImage) {
            devvitGIAELogger.log('Mission cleared detected via DOM (cleared image found)');
            // Get postId - prioritize the one we stored when initialData was received
            const postId = this.currentPostId;
            if (postId) {
                devvitGIAELogger.log('Mission cleared detected, notifying background', { postId });
                // Notify background which will mark as cleared
                chrome.runtime.sendMessage({
                    type: 'MISSION_COMPLETED',
                    postId,
                });
                // DON'T clear currentPostId here - we need it later when clicking Finish button
                // It will be cleared in tryClickContinue after we trigger navigation
            }
            else {
                devvitGIAELogger.warn('Mission appears cleared but no postId available');
            }
        }
    }
    /**
     * Check if player is dead (out of lives)
     * Looks for .lives-container with empty hearts
     */
    checkPlayerDead() {
        const livesContainer = document.querySelector('.lives-container');
        if (!livesContainer) {
            return false; // No lives container means we're not in a mission or lives UI isn't visible
        }
        // Check for empty hearts (Heart_Empty.png)
        const emptyHearts = livesContainer.querySelectorAll('img[src*="Heart_Empty.png"]');
        const totalHearts = livesContainer.querySelectorAll('.liveheart').length;
        // If we have hearts displayed and they're all empty, player is dead
        if (totalHearts > 0 && emptyHearts.length === totalHearts) {
            devvitGIAELogger.log('Player is dead - all hearts empty', {
                totalHearts,
                emptyHearts: emptyHearts.length,
            });
            return true;
        }
        // Also check for "Recover in" text which indicates no lives
        const recoverText = livesContainer.querySelector('.recover-container');
        if (recoverText && recoverText.textContent?.includes('Recover in')) {
            devvitGIAELogger.log('Player is dead - recovery timer found', {
                recoverText: recoverText.textContent,
            });
            return true;
        }
        return false;
    }
    /**
     * Main logic - detect game state first, then click appropriate button
     */
    async processButtons() {
        this.isProcessing = true;
        try {
            // Check if player is dead (out of lives)
            if (this.checkPlayerDead()) {
                devvitGIAELogger.error('Player is dead, stopping automation');
                this.stop();
                chrome.runtime.sendMessage({
                    type: 'ERROR_OCCURRED',
                    message: 'Out of lives - player is dead. Automation stopped.',
                });
                this.isProcessing = false;
                return;
            }
            // Check for mission completion indicators
            this.checkMissionCleared();
            // Skip if in combat (let the battle play out)
            if (this.inCombat) {
                this.isProcessing = false;
                return;
            }
            const buttons = this.findAllButtons();
            if (buttons.length === 0) {
                this.isProcessing = false;
                return;
            }
            // STEP 1: Detect game state based on available buttons
            const gameState = this.detectGameState(buttons);
            // Skip logging for in-progress state (combat happening) to reduce spam
            if (gameState === 'in_progress') {
                this.isProcessing = false;
                return;
            }
            if (gameState === 'unknown') {
                devvitGIAELogger.log('Unknown game state, skipping', {
                    buttonClasses: buttons.map((b) => b.className),
                });
                this.isProcessing = false;
                return;
            }
            // Log actionable states with button info
            devvitGIAELogger.log('Detected game state', {
                state: gameState,
                buttons: buttons.map((b) => `${b.className}: "${b.textContent?.trim()}"`),
                count: buttons.length,
            });
            // STEP 2: Click the appropriate button based on detected state
            const clickedButton = await this.clickForState(gameState, buttons);
            if (clickedButton) {
                devvitGIAELogger.log('Clicked button', {
                    state: gameState,
                    button: clickedButton,
                });
                // Wait before next check
                await this.delay(this.config.clickDelay);
            }
        }
        catch (error) {
            devvitGIAELogger.error('Error processing buttons', { error });
        }
        finally {
            this.isProcessing = false;
        }
    }
    /**
     * Detect current game state based on available buttons
     */
    detectGameState(buttons) {
        const buttonTexts = buttons.map((b) => b.textContent?.trim().toLowerCase() || '');
        const buttonClasses = buttons.map((b) => b.className);
        // Check for Inn Instance - mission was already completed
        // Check both navbar tooltip and battle log welcome message
        const navbarTooltip = document.querySelector('.navbar-tooltip');
        const hasInnTooltip = navbarTooltip?.textContent?.trim() === 'Find and play missions';
        // Check for "Welcome to the Inn!" text in battle log
        const battleLogMessages = document.querySelectorAll('.battle-log-message-inner');
        const hasInnWelcome = Array.from(battleLogMessages).some((msg) => msg.textContent?.includes('Welcome to the Inn!'));
        if (hasInnTooltip || hasInnWelcome) {
            return 'inn';
        }
        // Check for skip button (intro/dialogue)
        if (buttonClasses.some((c) => c.includes('skip-button'))) {
            return 'skip';
        }
        // Check for mission end button (play next) - mission complete
        // This should come before 'continue' check to prioritize mission completion
        // Look for .end-mission-button or button_playnext.png
        const missionEndFooter = document.querySelector('.mission-end-footer');
        if (missionEndFooter) {
            const endButton = missionEndFooter.querySelector('.end-mission-button');
            if (endButton) {
                return 'finish';
            }
        }
        // Fallback: check for button_playnext.png image
        const playNextButton = document.querySelector('img[src*="button_playnext.png"]');
        if (playNextButton) {
            return 'finish';
        }
        // Check for continue button (intermediate screens)
        if (buttonTexts.some((t) => t === 'continue') ||
            buttonClasses.some((c) => c.includes('continue-button'))) {
            return 'continue';
        }
        // Check for crossroads (Fight/Skip mini boss)
        if (buttonTexts.includes('fight') && buttonTexts.includes('skip')) {
            return 'crossroads';
        }
        // Check for skill bargains (Accept/Decline)
        if (buttonTexts.includes('accept') && buttonTexts.includes('decline')) {
            return 'skill_bargain';
        }
        // Check for ability choices (multiple skill buttons)
        if (buttonClasses.filter((c) => c.includes('skill-button')).length > 1) {
            return 'ability_choice';
        }
        // Check for battle/advance buttons
        if (buttonClasses.some((c) => c.includes('advance-button'))) {
            return 'battle';
        }
        // Check for in-progress state (combat happening, showing volume/settings buttons)
        if (buttonClasses.some((c) => c.includes('volume-icon-button') || c.includes('ui-settings-button'))) {
            return 'in_progress';
        }
        return 'unknown';
    }
    /**
     * Click the appropriate button for the detected game state
     */
    async clickForState(state, buttons) {
        switch (state) {
            case 'skip':
                return this.tryClickSkip(buttons);
            case 'finish':
                return await this.tryClickContinue(buttons); // Handles finish button
            case 'continue':
                return await this.tryClickContinue(buttons);
            case 'crossroads':
                return this.tryClickCrossroads(buttons);
            case 'skill_bargain':
                return this.tryClickSkillBargain(buttons);
            case 'ability_choice':
                return this.tryClickAbility(buttons);
            case 'battle':
                return this.tryClickBattle(buttons);
            case 'inn':
                return await this.handleInnState();
            default:
                return null;
        }
    }
    /**
     * Handle inn state - mission was already completed
     * Notify background which will mark it as cleared and find next mission
     */
    async handleInnState() {
        devvitGIAELogger.log('Inn detected - mission was already completed');
        // Get postId from URL or stored value
        let postId = this.currentPostId;
        if (!postId) {
            postId = extractPostIdFromUrl(window.location.href);
            devvitGIAELogger.log('Extracted postId from URL for inn state', { postId });
        }
        if (postId) {
            // Notify background that mission is completed
            // Background will handle marking as cleared and finding next mission
            chrome.runtime.sendMessage({
                type: 'MISSION_COMPLETED',
                postId,
            });
            devvitGIAELogger.log('MISSION_COMPLETED event sent to background', { postId });
        }
        else {
            devvitGIAELogger.error('Cannot handle inn state - no postId available');
        }
        return 'inn-handled';
    }
    /**
     * Find all clickable game buttons (matching working userscript pattern)
     */
    findAllButtons() {
        const buttons = [];
        // Match the working userscript pattern exactly
        // Look for: .advance-button, .skill-button, .skip-button
        const selectors = [
            '.advance-button',
            '.skill-button',
            '.skip-button',
            'button', // Also include regular buttons
        ];
        for (const selector of selectors) {
            const elements = Array.from(document.querySelectorAll(selector));
            for (const element of elements) {
                // For advance-button, check if parent wrapper has button-hidden class
                // If it does, skip this button (it's not clickable yet)
                if (selector === '.advance-button') {
                    const parent = element.parentElement;
                    if (parent && parent.classList.contains('advance-button-wrapper')) {
                        if (parent.classList.contains('button-hidden')) {
                            continue; // Skip hidden advance buttons
                        }
                    }
                }
                // Check if element is visible
                const rect = element.getBoundingClientRect();
                const isVisible = rect.width > 0 && rect.height > 0;
                if (isVisible && !buttons.includes(element)) {
                    buttons.push(element);
                }
            }
        }
        return buttons;
    }
    /**
     * Try to click skip button
     */
    tryClickSkip(buttons) {
        const skipButton = buttons.find((b) => b.classList.contains('skip-button'));
        if (skipButton) {
            this.clickElement(skipButton);
            return 'skip-button';
        }
        return null;
    }
    /**
     * Try to click "Battle" button (or any advance-button)
     */
    tryClickBattle(buttons) {
        // Priority 1: Look for "Battle" text
        let battleButton = buttons.find((b) => b.textContent?.trim().toLowerCase() === 'battle');
        // Priority 2: If no "Battle" text, look for .advance-button class
        if (!battleButton) {
            battleButton = buttons.find((b) => b.classList.contains('advance-button'));
        }
        if (battleButton) {
            this.clickElement(battleButton);
            return battleButton.textContent?.trim() || 'advance-button';
        }
        return null;
    }
    /**
     * Click an element (simple native click like working userscript)
     */
    clickElement(element) {
        // Just use native click - this is what works in the userscript
        element.click();
    }
    /**
     * Try to click crossroads mini boss encounter button (Let's Fight / Skip)
     */
    tryClickCrossroads(buttons) {
        // Look for "Let's Fight" and "Skip" buttons (crossroads encounter)
        const fightButton = buttons.find((b) => {
            const text = b.textContent?.trim().toLowerCase() || '';
            return text.includes("let's fight") || text.includes('fight');
        });
        const skipButton = buttons.find((b) => {
            const text = b.textContent?.trim().toLowerCase() || '';
            // Only match "Skip" in crossroads context (not general skip-button)
            return text === 'skip' && !b.classList.contains('skip-button');
        });
        // Only process if we have both buttons (it's a crossroads encounter)
        if (fightButton && skipButton) {
            if (this.config.crossroadsStrategy === 'fight') {
                this.clickElement(fightButton);
                return `Crossroads: ${fightButton.textContent?.trim()} (fight strategy)`;
            }
            else {
                this.clickElement(skipButton);
                return `Crossroads: ${skipButton.textContent?.trim()} (skip strategy)`;
            }
        }
        return null;
    }
    /**
     * Try to click ability button based on tier list (skill-button class)
     * Also handles blessing stat choices
     */
    tryClickAbility(buttons) {
        // Look for skill buttons
        const skillButtons = buttons.filter((b) => b.classList.contains('skill-button'));
        if (skillButtons.length === 0) {
            return null;
        }
        // Check if this is a blessing encounter (stat choices like "Increase Speed by X%")
        const isBlessing = skillButtons.some((b) => {
            const text = b.textContent?.trim() || '';
            return /Increase (Speed|Attack|Defense|Health|Crit|Dodge) by \d+%/.test(text);
        });
        if (isBlessing) {
            // Extract stat names from blessing buttons (e.g., "Speed" from "Increase Speed by 10%")
            const blessingStats = skillButtons
                .map((b) => {
                const text = b.textContent?.trim() || '';
                const match = text.match(/Increase (\w+) by \d+%/);
                return match ? match[1] : null;
            })
                .filter((stat) => !!stat);
            if (blessingStats.length > 0) {
                this.recordDiscoveredBlessingStats(blessingStats);
            }
            // Handle blessing stat choices based on priority
            // Safety check: ensure blessingStatPriority is an array
            const statPriority = Array.isArray(this.config.blessingStatPriority)
                ? this.config.blessingStatPriority
                : DEFAULT_GIAE_CONFIG.blessingStatPriority;
            // Match blessing stats by partial text (case-insensitive)
            for (const preferredStat of statPriority) {
                const blessingButton = skillButtons.find((b) => {
                    const text = (b.textContent?.trim() || '').toLowerCase();
                    const search = preferredStat.toLowerCase();
                    return text.includes(search);
                });
                if (blessingButton) {
                    this.clickElement(blessingButton);
                    return `Blessing: ${blessingButton.textContent?.trim()}`;
                }
            }
        }
        // Record all ability names we see
        const abilityNames = skillButtons
            .map((b) => b.textContent?.trim())
            .filter((text) => !!text);
        if (abilityNames.length > 0) {
            this.recordDiscoveredAbilities(abilityNames);
        }
        // Look for ability names from our tier list
        // Safety check: ensure abilityTierList is an array
        const abilityList = Array.isArray(this.config.abilityTierList)
            ? this.config.abilityTierList
            : DEFAULT_GIAE_CONFIG.abilityTierList;
        // Match abilities by partial text (case-insensitive)
        for (const preferredAbility of abilityList) {
            const abilityButton = skillButtons.find((b) => {
                const text = (b.textContent?.trim() || '').toLowerCase();
                const search = preferredAbility.toLowerCase();
                return text.includes(search);
            });
            if (abilityButton) {
                this.clickElement(abilityButton);
                return abilityButton.textContent?.trim() || preferredAbility;
            }
        }
        // If no preferred ability found, click the first skill button
        if (skillButtons.length > 0) {
            this.clickElement(skillButtons[0]);
            return skillButtons[0].textContent?.trim() || 'skill-button';
        }
        return null;
    }
    /**
     * Record discovered abilities to storage for user reference
     */
    recordDiscoveredAbilities(abilityNames) {
        try {
            chrome.storage.local.get(['discoveredAbilities'], (result) => {
                const existing = new Set(result.discoveredAbilities || []);
                let added = false;
                for (const name of abilityNames) {
                    if (!existing.has(name)) {
                        existing.add(name);
                        added = true;
                    }
                }
                if (added) {
                    chrome.storage.local.set({ discoveredAbilities: Array.from(existing) });
                }
            });
        }
        catch (error) {
            // Silently fail - this is not critical
            devvitGIAELogger.error('Failed to record discovered abilities', { error: String(error) });
        }
    }
    /**
     * Record discovered blessing stats to storage for user reference
     */
    recordDiscoveredBlessingStats(statNames) {
        try {
            chrome.storage.local.get(['discoveredBlessingStats'], (result) => {
                const existing = new Set(result.discoveredBlessingStats || []);
                let added = false;
                for (const name of statNames) {
                    if (!existing.has(name)) {
                        existing.add(name);
                        added = true;
                    }
                }
                if (added) {
                    chrome.storage.local.set({ discoveredBlessingStats: Array.from(existing) });
                }
            });
        }
        catch (error) {
            // Silently fail - this is not critical
            devvitGIAELogger.error('Failed to record discovered blessing stats', { error: String(error) });
        }
    }
    /**
     * Try to click skill bargain button (Accept/Decline)
     */
    tryClickSkillBargain(buttons) {
        const acceptButton = buttons.find((b) => b.textContent?.trim().toLowerCase() === 'accept');
        const declineButton = buttons.find((b) => b.textContent?.trim().toLowerCase() === 'decline');
        // Only process if we have both buttons (it's a skill bargain)
        if (acceptButton && declineButton) {
            if (this.config.skillBargainStrategy === 'always') {
                this.clickElement(acceptButton);
                return 'Accept (always strategy)';
            }
            else if (this.config.skillBargainStrategy === 'never') {
                this.clickElement(declineButton);
                return 'Decline (never strategy)';
            }
            else if (this.config.skillBargainStrategy === 'positive-only') {
                // For now, default to accept if auto-accept is enabled
                // TODO: Parse the bargain text to determine if it's positive
                if (this.config.autoAcceptSkillBargains) {
                    this.clickElement(acceptButton);
                    return 'Accept (positive-only strategy - default accept)';
                }
                else {
                    this.clickElement(declineButton);
                    return 'Decline (positive-only strategy - default decline)';
                }
            }
        }
        return null;
    }
    /**
     * Try to click "Continue" or "Finish" button
     */
    async tryClickContinue(buttons) {
        // Check for mission end button (play next) - mission complete
        // Look for .end-mission-button with button_playnext.png
        const missionEndFooter = document.querySelector('.mission-end-footer');
        let finishButton;
        if (missionEndFooter) {
            const endButton = missionEndFooter.querySelector('.end-mission-button');
            if (endButton instanceof HTMLElement) {
                finishButton = endButton;
            }
        }
        // Fallback: look for button_playnext.png in any button
        if (!finishButton) {
            finishButton = buttons.find((b) => {
                const img = b.querySelector('img[src*="button_playnext.png"]');
                return img !== null;
            });
        }
        if (finishButton) {
            this.clickElement(finishButton);
            // Get postId for mission completion
            let postId = this.currentPostId || this.missionMetadata?.postId;
            // Fallback: try to extract postId from URL if still null
            if (!postId) {
                postId = extractPostIdFromUrl(window.location.href);
                devvitGIAELogger.log('Extracted postId from URL as fallback', { postId });
            }
            devvitGIAELogger.log('Finish button clicked, checking postId', {
                currentPostId: this.currentPostId,
                metadataPostId: this.missionMetadata?.postId,
                finalPostId: postId,
            });
            if (postId) {
                devvitGIAELogger.log('Mission cleared! Clicking Finish/Dismiss button', {
                    postId,
                });
                // Notify background that mission is completed
                // Background will mark as cleared and handle finding next mission
                chrome.runtime.sendMessage({
                    type: 'MISSION_COMPLETED',
                    postId,
                });
                // Clear the postId now that background will handle navigation
                this.currentPostId = null;
            }
            else {
                devvitGIAELogger.warn('Finish button clicked but no postId available!', {
                    currentPostId: this.currentPostId,
                    metadataPostId: this.missionMetadata?.postId,
                    hasMissionMetadata: !!this.missionMetadata,
                    url: window.location.href,
                });
            }
            this.stop();
            return 'Finish (Mission Complete!)';
        }
        // Then check for "Continue" button
        const continueButton = buttons.find((b) => {
            // Check text content
            const text = b.textContent?.trim().toLowerCase() || '';
            if (text === 'continue')
                return true;
            // Check for continue-button class
            if (b.classList.contains('continue-button'))
                return true;
            // Check for img with alt="Continue"
            const img = b.querySelector('img[alt="Continue"]');
            if (img)
                return true;
            return false;
        });
        if (continueButton) {
            this.clickElement(continueButton);
            return 'Continue';
        }
        return null;
    }
    /**
     * Delay helper
     */
    delay(ms) {
        return new Promise((resolve) => setTimeout(resolve, ms));
    }
}

;// ./src/content/devvit/utils/dom.ts
/**
 * Game DOM utility functions
 * Functions for analyzing, extracting state, and interacting with the game DOM
 */
/**
 * Analyze the game page structure (debug function)
 */
function analyzeGamePage() {
    console.log('[DEVVIT] 📊 Analyzing game page...');
    console.log('[DEVVIT] Document title:', document.title);
    console.log('[DEVVIT] Body HTML (first 1000 chars):', document.body.innerHTML.substring(0, 1000));
    // Look for common game elements
    const buttons = document.querySelectorAll('button');
    console.log('[DEVVIT] Buttons found:', buttons.length);
    buttons.forEach((btn, i) => {
        if (i < 10) {
            console.log(`[DEVVIT] Button ${i}:`, btn.textContent, btn.className);
        }
    });
    // Look for canvas (games often use canvas)
    const canvases = document.querySelectorAll('canvas');
    console.log('[DEVVIT] Canvas elements:', canvases.length);
    // Look for divs that might contain game state
    const allDivs = document.querySelectorAll('div');
    console.log('[DEVVIT] Total divs:', allDivs.length);
    // Look for text that might indicate level/difficulty
    const bodyText = document.body.textContent || '';
    console.log('[DEVVIT] Body contains "level":', bodyText.toLowerCase().includes('level'));
    console.log('[DEVVIT] Body contains "star":', bodyText.toLowerCase().includes('star'));
    console.log('[DEVVIT] Body contains "mission":', bodyText.toLowerCase().includes('mission'));
    // Log all elements with IDs
    const elementsWithIds = document.querySelectorAll('[id]');
    console.log('[DEVVIT] Elements with IDs:', elementsWithIds.length);
    elementsWithIds.forEach((el, i) => {
        if (i < 20) {
            console.log(`[DEVVIT] ID ${i}:`, el.id, el.tagName, el.textContent?.substring(0, 50));
        }
    });
    // Log all elements with classes
    const elementsWithClasses = document.querySelectorAll('[class]');
    console.log('[DEVVIT] Elements with classes (first 20):', elementsWithClasses.length);
    Array.from(elementsWithClasses).slice(0, 20).forEach((el, i) => {
        console.log(`[DEVVIT] Class ${i}:`, el.className, el.tagName, el.textContent?.substring(0, 50));
    });
}
/**
 * Extract game state from the page
 */
function extractGameState() {
    console.log('[DEVVIT] 🔍 Extracting game state...');
    const state = {
        url: window.location.href,
        title: document.title,
        levelInfo: null,
        stars: null,
        buttons: [],
    };
    // Look for level information in the page
    const bodyText = document.body.textContent || '';
    // Try to find level number
    const levelMatch = bodyText.match(/level\s*(\d+)/i);
    if (levelMatch) {
        state.levelInfo = levelMatch[0];
    }
    // Try to find star rating
    const starMatch = bodyText.match(/(\d+)\s*stars?/i);
    if (starMatch) {
        state.stars = parseInt(starMatch[1]);
    }
    // Get all clickable buttons
    const buttons = document.querySelectorAll('button');
    buttons.forEach((btn) => {
        const text = btn.textContent?.trim();
        if (text && text.length < 100) {
            state.buttons.push(text);
        }
    });
    console.log('[DEVVIT] Extracted game state:', state);
    return state;
}
/**
 * Click a button by text content
 */
function clickButton(buttonText) {
    const buttons = Array.from(document.querySelectorAll('button'));
    const targetButton = buttons.find((btn) => btn.textContent?.trim().toLowerCase().includes(buttonText.toLowerCase()));
    if (targetButton) {
        console.log('[DEVVIT] 🖱️ Clicking button:', buttonText);
        targetButton.click();
        return true;
    }
    else {
        console.log('[DEVVIT] ❌ Button not found:', buttonText);
        return false;
    }
}
/**
 * Get all clickable elements
 */
function getClickableElements() {
    const clickable = [];
    // Buttons
    clickable.push(...Array.from(document.querySelectorAll('button')));
    // Links
    clickable.push(...Array.from(document.querySelectorAll('a')));
    // Elements with click handlers
    clickable.push(...Array.from(document.querySelectorAll('[onclick]')));
    return clickable;
}

;// ./src/content/devvit/devvit.tsx
/**
 * Game script - Runs inside the game iframe (*.devvit.net)
 * This is where we interact with the actual Sword & Supper game
 */



devvitLogger.log('Devvit content script loaded', {
    version: "0.15.0",
    buildTime: "2025-10-31T14:38:14.251Z",
    url: window.location.href,
    loadTime: new Date().toISOString(),
});
let gameAutomation = null;
// Set up message listener IMMEDIATELY to catch initialData
// This must be before the game sends the message!
window.addEventListener('message', (event) => {
    try {
        // Check for devvit-message with initialData
        if (event.data?.type === 'devvit-message') {
            const messageType = event.data?.data?.message?.type;
            devvitLogger.log('📨 devvit-message received (early listener)', {
                messageType,
                origin: event.origin,
                hasMessageData: !!event.data?.data?.message?.data,
                timestamp: new Date().toISOString(),
            });
            // If it's initialData, store it for later processing
            if (messageType === 'initialData') {
                const postId = event.data?.data?.message?.data?.postId;
                devvitLogger.log(`✅ initialData for ${postId} captured!`, event.data?.data);
                // Store the data globally so we can access it after automation engine initializes
                window.__capturedInitialData = event.data.data.message.data;
            }
        }
    }
    catch (error) {
        devvitLogger.error('Error in early message listener', { error: String(error) });
    }
});
devvitLogger.log('Early message listener installed');
// ============================================================================
// Extension Context Error Handling
// ============================================================================
/**
 * Safely send message to background script with proper error handling
 */
function safeSendMessage(message, callback) {
    try {
        chrome.runtime.sendMessage(message, (response) => {
            if (chrome.runtime.lastError) {
                const errorMsg = String(chrome.runtime.lastError.message || chrome.runtime.lastError);
                if (errorMsg.includes('Extension context invalidated')) {
                    devvitLogger.log('[ExtensionContext] Extension was updated/reloaded', {
                        error: errorMsg,
                    });
                    // Game iframe - no UI to show notification, just log
                }
                else {
                    devvitLogger.error('[ExtensionContext] Runtime error', { error: errorMsg });
                }
                return;
            }
            if (callback) {
                callback(response);
            }
        });
    }
    catch (error) {
        const errorMsg = String(error);
        if (errorMsg.includes('Extension context invalidated')) {
            devvitLogger.log('[ExtensionContext] Extension was updated/reloaded', { error: errorMsg });
        }
        else {
            devvitLogger.error('[ExtensionContext] Runtime error', { error: errorMsg });
        }
    }
}
// Control panel removed - now using BotControlPanel in reddit context
/**
 * Initialize automation engine
 */
function initializeAutomation() {
    if (gameAutomation) {
        devvitLogger.warn('Automation already initialized');
        return;
    }
    devvitLogger.log('Initializing game instance automation engine');
    // Load config from storage
    chrome.storage.local.get(['automationConfig'], async (result) => {
        const config = result.automationConfig || {};
        // Initialize game instance automation engine
        const giaeConfig = {
            enabled: false, // Will be enabled when user clicks button
            abilityTierList: config.abilityTierList || DEFAULT_GIAE_CONFIG.abilityTierList,
            blessingStatPriority: config.blessingStatPriority || DEFAULT_GIAE_CONFIG.blessingStatPriority,
            autoAcceptSkillBargains: config.autoAcceptSkillBargains !== undefined
                ? config.autoAcceptSkillBargains
                : DEFAULT_GIAE_CONFIG.autoAcceptSkillBargains,
            skillBargainStrategy: config.skillBargainStrategy || DEFAULT_GIAE_CONFIG.skillBargainStrategy,
            crossroadsStrategy: config.crossroadsStrategy || DEFAULT_GIAE_CONFIG.crossroadsStrategy,
            clickDelay: 300,
        };
        gameAutomation = new GameInstanceAutomationEngine(giaeConfig);
        devvitLogger.log('Game instance automation engine initialized');
        devvitLogger.log('Config', { config: giaeConfig });
        // Check if we already captured initialData before the automation engine was ready
        const capturedData = window.__capturedInitialData;
        if (capturedData) {
            devvitLogger.log('Processing previously captured initialData', {
                postId: capturedData.postId,
                username: capturedData.username,
            });
            // Manually trigger the save since the automation engine wasn't listening yet
            const missionMetadata = capturedData.missionMetadata;
            const postId = capturedData.postId;
            const username = capturedData.username;
            if (missionMetadata && postId && gameAutomation) {
                // Save the captured mission data to database
                await gameAutomation.saveMissionToDatabase(postId, username, missionMetadata);
                // IMPORTANT: Also set currentPostId so it's available when mission completes
                // This is normally set by the message listener, but since we captured it early, we need to set it manually
                gameAutomation.currentPostId = postId;
                gameAutomation.missionMetadata = missionMetadata;
                devvitLogger.log('Set currentPostId from captured initialData', { postId });
            }
            // Clear the captured data
            delete window.__capturedInitialData;
        }
        // Notify background script that automation is ready (initial notification only)
        safeSendMessage({
            type: 'AUTOMATION_READY',
            config: giaeConfig,
        });
        // Process any pending START_MISSION_AUTOMATION message
        if (pendingStartMessage) {
            devvitLogger.log('Processing queued START_MISSION_AUTOMATION message');
            // Read config from storage and update before starting
            chrome.storage.local.get(['automationConfig'], (result) => {
                if (result.automationConfig) {
                    updateAutomationConfig(result.automationConfig);
                }
                toggleAutomation(true);
            });
            pendingStartMessage = null;
        }
    });
}
/**
 * Toggle automation on/off
 */
function toggleAutomation(enabled) {
    devvitLogger.log('toggleAutomation called', { enabled });
    if (!gameAutomation) {
        devvitLogger.error('Automation not initialized');
        return;
    }
    if (enabled) {
        gameAutomation.start();
        devvitLogger.log('Automation started');
    }
    else {
        gameAutomation.stop();
        devvitLogger.log('Automation stopped');
    }
    devvitLogger.log('Automation state', { state: gameAutomation.getState() });
}
/**
 * Update automation configuration
 */
function updateAutomationConfig(config) {
    if (!gameAutomation) {
        devvitLogger.error('Automation not initialized');
        return;
    }
    const giaeConfig = {
        abilityTierList: config.abilityTierList,
        blessingStatPriority: config.blessingStatPriority,
        autoAcceptSkillBargains: config.autoAcceptSkillBargains,
        skillBargainStrategy: config.skillBargainStrategy,
        crossroadsStrategy: config.crossroadsStrategy,
    };
    gameAutomation.updateConfig(giaeConfig);
    // Save to storage
    chrome.storage.local.set({ automationConfig: config });
}
// Queue for messages received before automation is ready
let pendingStartMessage = null;
// Listen for messages from Chrome extension (via background script)
chrome.runtime.onMessage.addListener((message, sender, sendResponse) => {
    devvitLogger.log(`Received ${message.type} message`, {
        message,
    });
    switch (message.type) {
        case 'CHECK_AUTOMATION_STATUS':
            // Respond to query about automation engine state
            const isReady = gameAutomation !== null;
            const automationState = gameAutomation ? gameAutomation.getState() : null;
            sendResponse({
                isReady,
                isRunning: automationState === 'running',
                state: automationState,
            });
            break;
        case 'START_MISSION_AUTOMATION':
            if (!gameAutomation) {
                // Automation not ready yet, queue the message
                devvitLogger.log('Automation not ready, queuing START_MISSION_AUTOMATION');
                pendingStartMessage = message;
                sendResponse({ success: true, queued: true });
            }
            else {
                // Read config from storage and update before starting
                chrome.storage.local.get(['automationConfig'], (result) => {
                    if (result.automationConfig) {
                        updateAutomationConfig(result.automationConfig);
                    }
                    toggleAutomation(true);
                    sendResponse({ success: true });
                });
                return true; // Will respond asynchronously
            }
            break;
        case 'STOP_MISSION_AUTOMATION':
            toggleAutomation(false);
            sendResponse({ success: true });
            break;
        case 'STATE_CHANGED':
            // Ignore state changes - only reddit-content needs these
            sendResponse({ success: true });
            break;
        default:
            devvitLogger.warn(`Unknown message type: ${message.type}`, { message });
            sendResponse({ error: 'Unknown message type: ' + message.type });
    }
    return true; // Keep channel open for async response
});
// Initial analysis after a delay
setTimeout(() => {
    devvitLogger.log('Running initial game analysis');
    analyzeGamePage();
    extractGameState();
    // Initialize mission automation
    initializeAutomation();
}, 2000);

/******/ })()
;
//# sourceMappingURL=devvit-content.js.map