"use strict";
(self["webpackChunklazyfrog"] = self["webpackChunklazyfrog"] || []).push([[74],{

/***/ 74:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   generateMissionMarkdown: () => (/* binding */ generateMissionMarkdown)
/* harmony export */ });
// Enemy name mappings
const enemyNames = {
    golemBaby: 'Baby Golem',
    slimeKnight: 'Slime Knight',
    slimeBigMouth: 'Chomp Slime',
    slimeCat: 'Cat Slime',
    slimeGems: 'Crystal Slime',
    skeleton: 'Warrior Skeleton',
    skelNoHead: 'Headless Skeleton',
    golemMountain: 'Mountain Golem',
    golemMountainLucky: 'Loaded Mountain Golem',
    golemBoar: 'Boar Golem',
    skelFireHead: 'Flaming Skeleton',
    skelIceHead: 'Ice Flame Skeleton',
    skelArcher: 'Ranger Skeleton',
    skel2Axe: 'Barbarian Skeleton',
    slimeBone: 'Bone Slime',
    slimeBoneLucky: 'Loaded Bone Slime',
    mushroomSmall: 'Bitey Shroom',
    mushroomLarge: 'Erin-guy',
    mushroomLargeBoss: 'Boss Mushroom',
    skelWizard: 'Wizard Skeleton',
    skelGreatSword: 'Swordsman Skeleton',
    skelGreatSwordLucky: 'Loaded Swordsman Skeleton',
    skelAssassin: 'Assassin Skeleton',
    cannibal: 'Shadowbearer',
    darkBat: 'Shadow Wing',
    darkShaman: 'Shadowbringer',
    darkChild: 'Shadowkin',
    darkBigGuy: 'Shadow Brute',
    darkBigGuyLucky: 'Loaded Shadow Brute',
    darkHand: 'Arm of Shadow',
    darkWizard: 'Shadow Conjurer',
    darkGiantHorns: 'Hollowhorn',
    darkWorm: 'Shadow Hatchling',
    darkSpider: 'Skittering Shadow',
    darkDemon: 'Umbral Winged Shadeborn',
    mushroomChild: 'Shroomkin',
    mushroomFrog: 'Sporehead',
    mushroomSoldierLucky: 'Loaded Sporehead',
    mushroomSoldier: 'Sporewarden',
    livingArmor: 'Steel Revenant',
    mushroomMonster: 'Sturdy Sporeborn',
    mushroomTeeth: 'Mawcap',
    woodGolem: 'Heartroot Guardian',
    icyWoodGolem: 'Frostroot Guardian',
    woodOctopus: 'Branchclutch',
    woodRoof: 'Stumpkin',
    robotNo1: 'Y5-Sentry',
    robotNo2: 'KRG-01',
    robotNo3: 'Gen5-HVY',
    robotNo4: 'Medibot-Mark IV',
    robotNo5: 'WasteLogic LX-9',
    robotNo5Lucky: 'Loaded WasteLogic LX-9',
    robotNo6: 'BRX-7 Sentry Chassis',
    robotNo7: 'Minifax Model B',
    robotBoss: 'Slumbering Guardian-X5',
};
// Map name mappings
const mapNames = {
    fields: 'Fields',
    outer_temple: 'Outer Temple',
    forbidden_city: 'Forbidden City',
    mossy_forest: 'Mossy Forest',
    mountain_pass: 'Mountain Pass',
    new_eden: 'New Eden',
    ruined_path: 'Ruined Path',
    seaside_cliffs: 'Seaside Cliffs',
};
/**
 * Generate markdown for a mission's metadata in Reddit-friendly format
 */
function generateMissionMarkdown(mission) {
    const metadata = mission.metadata;
    const missionData = metadata?.mission;
    if (!missionData) {
        return null;
    }
    const encounters = missionData.encounters || [];
    const stars = '⭐'.repeat(mission.difficulty || 0);
    const mapName = mapNames[mission.environment || ''] || mission.environment || 'Unknown';
    // Build title and header info (use missionTitle which is the Reddit post title)
    const title = mission.missionTitle || mission.foodName || 'Mission';
    let markdown = `### ${stars} ${title}\n`;
    markdown += `**Map:** ${mapName} | **Level:** ${mission.minLevel}-${mission.maxLevel}\n\n`;
    // Build table
    markdown += `| # | Room | Details |\n`;
    markdown += `|---|------|----------|\n`;
    // Process each encounter
    encounters.forEach((enc, index) => {
        const roomNum = index + 1;
        const roomIcon = getEncounterIcon(enc.type);
        const roomType = getEncounterTypeName(enc.type);
        const details = getEncounterDetails(enc, missionData.foodName);
        markdown += `| ${roomNum} | ${roomIcon} ${roomType} | ${details} |\n`;
    });
    return markdown;
}
/**
 * Get emoji icon for encounter type
 */
function getEncounterIcon(type) {
    const icons = {
        enemy: '⚔️',
        boss: '👑',
        rushBoss: '👑',
        crossroadsFight: '🔱',
        skillBargain: '🔮',
        abilityChoice: '⛩',
        treasure: '💎',
        investigate: '🏚️',
        statsChoice: '📊',
        blessing: '🙏',
        shopEquipment: '🛒',
        shopAbility: '🛒',
    };
    return icons[type] || '❓';
}
/**
 * Get readable name for encounter type
 */
function getEncounterTypeName(type) {
    const names = {
        enemy: 'Battle',
        boss: 'Boss',
        rushBoss: 'Boss',
        crossroadsFight: 'Miniboss',
        skillBargain: 'Monolith',
        abilityChoice: 'Shrine',
        treasure: 'Treasure',
        investigate: 'Hut',
        statsChoice: 'Stat Choice',
        blessing: 'Blessing',
        shopEquipment: 'Vending',
        shopAbility: 'Vending',
    };
    return names[type] || type;
}
/**
 * Get detailed description of encounter
 */
function getEncounterDetails(enc, foodName) {
    switch (enc.type) {
        case 'enemy':
        case 'boss':
        case 'rushBoss':
        case 'crossroadsFight':
            return formatEnemies(enc.enemies || []);
        case 'skillBargain':
            return formatSkillBargain(enc);
        case 'abilityChoice':
            return formatAbilityChoice(enc);
        case 'shopEquipment':
        case 'shopAbility':
            return formatShop(enc);
        case 'treasure':
            return foodName || 'Treasure!';
        case 'investigate':
            return 'Hut';
        default:
            return '';
    }
}
/**
 * Format enemy list
 */
function formatEnemies(enemies) {
    if (!enemies || enemies.length === 0)
        return '???';
    // Count duplicates
    const enemyCounts = {};
    enemies.forEach((enemy) => {
        const name = enemyNames[enemy.type] || enemy.type;
        enemyCounts[name] = (enemyCounts[name] || 0) + 1;
    });
    // Format output
    const parts = Object.entries(enemyCounts).map(([name, count]) => {
        if (count > 1) {
            return `${count}× ${name}`;
        }
        return name;
    });
    return parts.join(' · ');
}
/**
 * Format skill bargain details
 */
function formatSkillBargain(enc) {
    const positive = enc.positiveEffect;
    const negative = enc.negativeEffect;
    const posStat = formatStatName(positive?.stat);
    const negStat = formatStatName(negative?.stat);
    return `⬆️${posStat} + ⬇️${negStat}`;
}
/**
 * Format ability choice options
 */
function formatAbilityChoice(enc) {
    const abilities = [];
    // Extract ability IDs from optionA, optionB, optionC
    if (enc.optionA?.abilityId)
        abilities.push(formatAbilityName(enc.optionA.abilityId));
    if (enc.optionB?.abilityId)
        abilities.push(formatAbilityName(enc.optionB.abilityId));
    if (enc.optionC?.abilityId)
        abilities.push(formatAbilityName(enc.optionC.abilityId));
    if (abilities.length === 0)
        return '???';
    // Show enchanted indicator if present
    const enchanted = enc.isEnchanted ? '✨ Enchanted  \n' : '';
    // Format as bullet list with proper line breaks
    // Using two spaces + newline for markdown line breaks
    return `${enchanted}• ${abilities.join(' • ')}`;
}
/**
 * Format ability ID to readable name
 */
function formatAbilityName(abilityId) {
    // Convert camelCase to readable format
    // e.g., "IceKnifeOnTurnStart" -> "Ice Knife On Turn Start"
    const readable = abilityId
        .replace(/([A-Z])/g, ' $1')
        .trim()
        .replace(/On Turn Start/i, '(Start)')
        .replace(/On Turn End/i, '(End)')
        .replace(/On Crit/i, '(Crit)')
        .replace(/On Hit/i, '(Hit)')
        .replace(/On Kill/i, '(Kill)');
    return readable;
}
/**
 * Format shop options
 */
function formatShop(enc) {
    // We don't have shop item details in metadata typically
    return 'Shop items available';
}
/**
 * Format stat names for readability
 */
function formatStatName(stat) {
    if (!stat)
        return '???';
    const names = {
        attack: 'Attack',
        defense: 'Defense',
        speed: 'Speed',
        dodge: 'Dodge',
        maxHp: 'HP',
        critChance: 'Crit',
    };
    return names[stat] || stat;
}
/**
 * Format loot item names for readability
 */
function formatLootName(itemId) {
    // Convert camelCase/PascalCase to readable format
    // e.g., "BatteredBroadsword" -> "Battered Broadsword"
    const readable = itemId.replace(/([A-Z])/g, ' $1').trim();
    return readable;
}


/***/ })

}]);
//# sourceMappingURL=74.js.map