/******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ 52:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   d: () => (/* binding */ STORAGE_KEYS)
/* harmony export */ });
/* unused harmony export DEFAULT_AUTOMATION_FILTERS */
/**
 * Storage types and interfaces
 */
const DEFAULT_AUTOMATION_FILTERS = {
    stars: [1, 2, 3, 4, 5],
    minLevel: 1,
    maxLevel: 340,
};
const STORAGE_KEYS = {
    MISSIONS: 'missions',
    USER_OPTIONS: 'userOptions',
    AUTOMATION_FILTERS: 'automationFilters',
    AUTOMATION_CONFIG: 'automationConfig',
    REDDIT_API_CACHE: 'redditApiCache',
};


/***/ }),

/***/ 460:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   normalizePostId: () => (/* binding */ normalizePostId),
/* harmony export */   normalizeRedditPermalink: () => (/* binding */ normalizeRedditPermalink)
/* harmony export */ });
/**
 * Normalize a Reddit post ID to ensure it has the standard t3_ prefix.
 *
 * @param id - The post ID to normalize (with or without t3_ prefix)
 * @returns The normalized post ID with t3_ prefix, or null if invalid
 *
 * @example
 * ```typescript
 * normalizePostId('1od6q1h') // 't3_1od6q1h'
 * normalizePostId('t3_1od6q1h') // 't3_1od6q1h'
 * normalizePostId('invalid') // null
 * ```
 */
function normalizePostId(id) {
    if (!id || typeof id !== 'string') {
        return null;
    }
    // If already prefixed, validate and return
    if (id.startsWith('t3_')) {
        const postIdPart = id.slice(3);
        if (postIdPart && /^[a-z0-9]+$/i.test(postIdPart)) {
            return id;
        }
        return null;
    }
    // If not prefixed, validate and add prefix
    if (/^[a-z0-9]+$/i.test(id)) {
        return `t3_${id}`;
    }
    return null;
}
/**
 * Normalize a Reddit Sword & Supper mission permalink to the canonical format:
 * https://www.reddit.com/r/SwordAndSupperGame/comments/<postId>/
 *
 * Accepts either a URL or a postId (with or without t3_ prefix).
 * The postId parameter should be the raw post ID without t3_ prefix.
 */
function normalizeRedditPermalink(input) {
    const base = 'https://www.reddit.com';
    // Helper to strip t3_ prefix
    const stripT3 = (id) => (id?.startsWith('t3_') ? id.slice(3) : id);
    let postId = '';
    try {
        if (input?.startsWith('http')) {
            const url = new URL(input);
            // Try to extract id from /comments/<id>/ path
            const match = url.pathname.match(/\/comments\/([^/]+)/);
            if (match && match[1]) {
                postId = stripT3(match[1]);
            }
        }
        else if (input) {
            // Treat as postId
            postId = stripT3(input);
        }
    }
    catch {
        // Fallback to treating as postId
        postId = stripT3(input);
    }
    if (!postId) {
        return `${base}/r/SwordAndSupperGame/`;
    }
    return `${base}/r/SwordAndSupperGame/comments/${postId}/`;
}


/***/ }),

/***/ 890:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   F4: () => (/* binding */ getAllMissions),
/* harmony export */   aB: () => (/* binding */ saveMission),
/* harmony export */   getMission: () => (/* binding */ getMission),
/* harmony export */   vJ: () => (/* binding */ accumulateMissionLoot)
/* harmony export */ });
/* unused harmony exports saveMissionsBatch, deleteMission, clearAllMissions, markAllMissionsIncomplete, markMissionCleared, setMissionDisabled, importMissions */
/* harmony import */ var _types__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(52);
/**
 * Mission CRUD operations
 */

/**
 * Save a mission to storage
 */
async function saveMission(mission) {
    return new Promise((resolve, reject) => {
        // Check if extension context is still valid
        if (!chrome.runtime?.id) {
            reject(new Error('Extension context invalidated'));
            return;
        }
        chrome.storage.local.get([_types__WEBPACK_IMPORTED_MODULE_0__/* .STORAGE_KEYS */ .d.MISSIONS], (result) => {
            // Check for errors on get
            if (chrome.runtime.lastError) {
                reject(chrome.runtime.lastError);
                return;
            }
            const missions = result[_types__WEBPACK_IMPORTED_MODULE_0__/* .STORAGE_KEYS */ .d.MISSIONS] || {};
            // Use postId as key to avoid duplicates
            missions[mission.postId] = mission;
            chrome.storage.local.set({ [_types__WEBPACK_IMPORTED_MODULE_0__/* .STORAGE_KEYS */ .d.MISSIONS]: missions }, () => {
                if (chrome.runtime.lastError) {
                    reject(chrome.runtime.lastError);
                }
                else {
                    // Notify background script that missions changed
                    chrome.runtime.sendMessage({
                        type: 'MISSIONS_UPDATED',
                    }).catch(() => {
                        // Ignore errors if no listeners
                    });
                    resolve();
                }
            });
        });
    });
}
/**
 * Save multiple missions to storage in a single batch operation
 */
async function saveMissionsBatch(missions) {
    return new Promise((resolve, reject) => {
        // Check if extension context is still valid
        if (!chrome.runtime?.id) {
            reject(new Error('Extension context invalidated'));
            return;
        }
        chrome.storage.local.get([STORAGE_KEYS.MISSIONS], (result) => {
            // Check for errors on get
            if (chrome.runtime.lastError) {
                reject(chrome.runtime.lastError);
                return;
            }
            const existingMissions = result[STORAGE_KEYS.MISSIONS] || {};
            // Add all new missions using postId as key
            missions.forEach((mission) => {
                existingMissions[mission.postId] = mission;
            });
            chrome.storage.local.set({ [STORAGE_KEYS.MISSIONS]: existingMissions }, () => {
                if (chrome.runtime.lastError) {
                    reject(chrome.runtime.lastError);
                }
                else {
                    // Notify background script that missions changed
                    chrome.runtime.sendMessage({
                        type: 'MISSIONS_UPDATED',
                    }).catch(() => {
                        // Ignore errors if no listeners
                    });
                    resolve();
                }
            });
        });
    });
}
/**
 * Get all saved missions
 */
async function getAllMissions() {
    return new Promise((resolve, reject) => {
        chrome.storage.local.get([_types__WEBPACK_IMPORTED_MODULE_0__/* .STORAGE_KEYS */ .d.MISSIONS], (result) => {
            if (chrome.runtime.lastError) {
                reject(chrome.runtime.lastError);
            }
            else {
                resolve(result[_types__WEBPACK_IMPORTED_MODULE_0__/* .STORAGE_KEYS */ .d.MISSIONS] || {});
            }
        });
    });
}
/**
 * Get a specific mission by postId
 */
async function getMission(postId) {
    const missions = await getAllMissions();
    return missions[postId] || null;
}
/**
 * Delete a mission
 */
async function deleteMission(postId) {
    return new Promise((resolve, reject) => {
        chrome.storage.local.get([STORAGE_KEYS.MISSIONS], (result) => {
            const missions = result[STORAGE_KEYS.MISSIONS] || {};
            delete missions[postId];
            chrome.storage.local.set({ [STORAGE_KEYS.MISSIONS]: missions }, () => {
                if (chrome.runtime.lastError) {
                    reject(chrome.runtime.lastError);
                }
                else {
                    resolve();
                }
            });
        });
    });
}
/**
 * Clear all missions
 */
async function clearAllMissions() {
    return new Promise((resolve, reject) => {
        chrome.storage.local.remove(STORAGE_KEYS.MISSIONS, () => {
            if (chrome.runtime.lastError) {
                reject(chrome.runtime.lastError);
            }
            else {
                resolve();
            }
        });
    });
}
/**
 * Mark all missions as incomplete (cleared = false, remove clearedAt)
 */
async function markAllMissionsIncomplete() {
    return new Promise((resolve, reject) => {
        // Check if extension context is still valid
        if (!chrome.runtime?.id) {
            reject(new Error('Extension context invalidated'));
            return;
        }
        chrome.storage.local.get([STORAGE_KEYS.MISSIONS], (result) => {
            if (chrome.runtime.lastError) {
                reject(chrome.runtime.lastError);
                return;
            }
            const missions = result[STORAGE_KEYS.MISSIONS] || {};
            // No missions stored – nothing to do
            if (!missions || Object.keys(missions).length === 0) {
                resolve();
                return;
            }
            for (const postId of Object.keys(missions)) {
                const mission = missions[postId];
                if (mission) {
                    mission.cleared = false;
                    // Remove timestamp to avoid misleading stats of recently cleared
                    if ('clearedAt' in mission) {
                        delete mission.clearedAt;
                    }
                }
            }
            chrome.storage.local.set({ [STORAGE_KEYS.MISSIONS]: missions }, () => {
                if (chrome.runtime.lastError) {
                    reject(chrome.runtime.lastError);
                }
                else {
                    resolve();
                }
            });
        });
    });
}
/**
 * Mark a mission as cleared
 */
async function markMissionCleared(postId) {
    return new Promise((resolve, reject) => {
        // Check if extension context is still valid
        if (!chrome.runtime?.id) {
            reject(new Error('Extension context invalidated'));
            return;
        }
        chrome.storage.local.get([STORAGE_KEYS.MISSIONS], (result) => {
            // Check for errors on get
            if (chrome.runtime.lastError) {
                reject(chrome.runtime.lastError);
                return;
            }
            const missions = result[STORAGE_KEYS.MISSIONS] || {};
            if (missions[postId]) {
                missions[postId].cleared = true;
                missions[postId].clearedAt = Date.now();
                chrome.storage.local.set({ [STORAGE_KEYS.MISSIONS]: missions }, () => {
                    if (chrome.runtime.lastError) {
                        reject(chrome.runtime.lastError);
                    }
                    else {
                        resolve();
                    }
                });
            }
            else {
                reject(new Error(`Mission ${postId} not found`));
            }
        });
    });
}
/**
 * Accumulate loot from an encounter to mission's total loot
 */
async function accumulateMissionLoot(postId, encounterLoot) {
    return new Promise((resolve, reject) => {
        // Check if extension context is still valid
        if (!chrome.runtime?.id) {
            reject(new Error('Extension context invalidated'));
            return;
        }
        chrome.storage.local.get([_types__WEBPACK_IMPORTED_MODULE_0__/* .STORAGE_KEYS */ .d.MISSIONS], (result) => {
            // Check for errors on get
            if (chrome.runtime.lastError) {
                reject(chrome.runtime.lastError);
                return;
            }
            const missions = result[_types__WEBPACK_IMPORTED_MODULE_0__/* .STORAGE_KEYS */ .d.MISSIONS] || {};
            if (missions[postId]) {
                // Initialize totalLoot if not present
                if (!missions[postId].totalLoot) {
                    missions[postId].totalLoot = [];
                }
                // Accumulate loot by combining quantities for same items
                encounterLoot.forEach((newItem) => {
                    const existingItem = missions[postId].totalLoot.find((item) => item.id === newItem.id);
                    if (existingItem) {
                        existingItem.quantity += newItem.quantity;
                    }
                    else {
                        missions[postId].totalLoot.push({ ...newItem });
                    }
                });
                chrome.storage.local.set({ [_types__WEBPACK_IMPORTED_MODULE_0__/* .STORAGE_KEYS */ .d.MISSIONS]: missions }, () => {
                    if (chrome.runtime.lastError) {
                        reject(chrome.runtime.lastError);
                    }
                    else {
                        resolve();
                    }
                });
            }
            else {
                reject(new Error(`Mission ${postId} not found`));
            }
        });
    });
}
/**
 * Set mission disabled state (skipped by automation when disabled)
 */
async function setMissionDisabled(postId, disabled) {
    return new Promise((resolve, reject) => {
        if (!chrome.runtime?.id) {
            reject(new Error('Extension context invalidated'));
            return;
        }
        chrome.storage.local.get([STORAGE_KEYS.MISSIONS], (result) => {
            if (chrome.runtime.lastError) {
                reject(chrome.runtime.lastError);
                return;
            }
            const missions = result[STORAGE_KEYS.MISSIONS] || {};
            if (!missions[postId]) {
                reject(new Error(`Mission ${postId} not found`));
                return;
            }
            missions[postId].disabled = disabled;
            chrome.storage.local.set({ [STORAGE_KEYS.MISSIONS]: missions }, () => {
                if (chrome.runtime.lastError) {
                    reject(chrome.runtime.lastError);
                }
                else {
                    resolve();
                }
            });
        });
    });
}
/**
 * Import missions from JSON data
 */
async function importMissions(jsonData, mode = 'merge') {
    const stats = { imported: 0, skipped: 0, errors: [] };
    try {
        // Parse JSON if it's a string
        let data;
        if (typeof jsonData === 'string') {
            data = JSON.parse(jsonData);
        }
        else {
            data = jsonData;
        }
        // Get existing missions
        const existingMissions = mode === 'merge' ? await getAllMissions() : {};
        // Handle different data formats
        let missionsToImport = {};
        if (Array.isArray(data)) {
            // Array of missions
            data.forEach((mission) => {
                if (mission.postId) {
                    missionsToImport[mission.postId] = mission;
                }
            });
        }
        else if (typeof data === 'object') {
            // Could be object with postId keys or wrapped data
            if (data.missions) {
                missionsToImport = data.missions;
            }
            else {
                missionsToImport = data;
            }
        }
        // Validate and import missions
        for (const [postId, mission] of Object.entries(missionsToImport)) {
            try {
                // Basic validation
                if (!mission.postId || !mission.timestamp) {
                    stats.errors.push(`Invalid mission data for ${postId}`);
                    stats.skipped++;
                    continue;
                }
                // Check if already exists in merge mode
                if (mode === 'merge' && existingMissions[postId]) {
                    stats.skipped++;
                    continue;
                }
                // Add to existing missions
                existingMissions[postId] = mission;
                stats.imported++;
            }
            catch (err) {
                stats.errors.push(`Error importing ${postId}: ${err}`);
                stats.skipped++;
            }
        }
        // Save all missions back to storage
        await new Promise((resolve, reject) => {
            chrome.storage.local.set({ [STORAGE_KEYS.MISSIONS]: existingMissions }, () => {
                if (chrome.runtime.lastError) {
                    reject(chrome.runtime.lastError);
                }
                else {
                    resolve();
                }
            });
        });
        return stats;
    }
    catch (err) {
        stats.errors.push(`Parse error: ${err}`);
        return stats;
    }
}


/***/ })

/******/ 	});
/************************************************************************/
/******/ 	// The module cache
/******/ 	var __webpack_module_cache__ = {};
/******/ 	
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/ 		// Check if module is in cache
/******/ 		var cachedModule = __webpack_module_cache__[moduleId];
/******/ 		if (cachedModule !== undefined) {
/******/ 			return cachedModule.exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = __webpack_module_cache__[moduleId] = {
/******/ 			// no module.id needed
/******/ 			// no module.loaded needed
/******/ 			exports: {}
/******/ 		};
/******/ 	
/******/ 		// Execute the module function
/******/ 		__webpack_modules__[moduleId](module, module.exports, __webpack_require__);
/******/ 	
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/ 	
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = __webpack_modules__;
/******/ 	
/************************************************************************/
/******/ 	/* webpack/runtime/define property getters */
/******/ 	(() => {
/******/ 		// define getter functions for harmony exports
/******/ 		__webpack_require__.d = (exports, definition) => {
/******/ 			for(var key in definition) {
/******/ 				if(__webpack_require__.o(definition, key) && !__webpack_require__.o(exports, key)) {
/******/ 					Object.defineProperty(exports, key, { enumerable: true, get: definition[key] });
/******/ 				}
/******/ 			}
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/ensure chunk */
/******/ 	(() => {
/******/ 		__webpack_require__.f = {};
/******/ 		// This file contains only the entry chunk.
/******/ 		// The chunk loading function for additional chunks
/******/ 		__webpack_require__.e = (chunkId) => {
/******/ 			return Promise.all(Object.keys(__webpack_require__.f).reduce((promises, key) => {
/******/ 				__webpack_require__.f[key](chunkId, promises);
/******/ 				return promises;
/******/ 			}, []));
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/get javascript chunk filename */
/******/ 	(() => {
/******/ 		// This function allow to reference async chunks
/******/ 		__webpack_require__.u = (chunkId) => {
/******/ 			// return url for filenames based on template
/******/ 			return "" + chunkId + ".js";
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/hasOwnProperty shorthand */
/******/ 	(() => {
/******/ 		__webpack_require__.o = (obj, prop) => (Object.prototype.hasOwnProperty.call(obj, prop))
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/load script */
/******/ 	(() => {
/******/ 		var inProgress = {};
/******/ 		var dataWebpackPrefix = "lazyfrog:";
/******/ 		// loadScript function to load a script via script tag
/******/ 		__webpack_require__.l = (url, done, key, chunkId) => {
/******/ 			if(inProgress[url]) { inProgress[url].push(done); return; }
/******/ 			var script, needAttach;
/******/ 			if(key !== undefined) {
/******/ 				var scripts = document.getElementsByTagName("script");
/******/ 				for(var i = 0; i < scripts.length; i++) {
/******/ 					var s = scripts[i];
/******/ 					if(s.getAttribute("src") == url || s.getAttribute("data-webpack") == dataWebpackPrefix + key) { script = s; break; }
/******/ 				}
/******/ 			}
/******/ 			if(!script) {
/******/ 				needAttach = true;
/******/ 				script = document.createElement('script');
/******/ 		
/******/ 				script.charset = 'utf-8';
/******/ 				if (__webpack_require__.nc) {
/******/ 					script.setAttribute("nonce", __webpack_require__.nc);
/******/ 				}
/******/ 				script.setAttribute("data-webpack", dataWebpackPrefix + key);
/******/ 		
/******/ 				script.src = url;
/******/ 			}
/******/ 			inProgress[url] = [done];
/******/ 			var onScriptComplete = (prev, event) => {
/******/ 				// avoid mem leaks in IE.
/******/ 				script.onerror = script.onload = null;
/******/ 				clearTimeout(timeout);
/******/ 				var doneFns = inProgress[url];
/******/ 				delete inProgress[url];
/******/ 				script.parentNode && script.parentNode.removeChild(script);
/******/ 				doneFns && doneFns.forEach((fn) => (fn(event)));
/******/ 				if(prev) return prev(event);
/******/ 			}
/******/ 			var timeout = setTimeout(onScriptComplete.bind(null, undefined, { type: 'timeout', target: script }), 120000);
/******/ 			script.onerror = onScriptComplete.bind(null, script.onerror);
/******/ 			script.onload = onScriptComplete.bind(null, script.onload);
/******/ 			needAttach && document.head.appendChild(script);
/******/ 		};
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/publicPath */
/******/ 	(() => {
/******/ 		__webpack_require__.p = "";
/******/ 	})();
/******/ 	
/******/ 	/* webpack/runtime/jsonp chunk loading */
/******/ 	(() => {
/******/ 		// no baseURI
/******/ 		
/******/ 		// object to store loaded and loading chunks
/******/ 		// undefined = chunk not loaded, null = chunk preloaded/prefetched
/******/ 		// [resolve, reject, Promise] = chunk loading, 0 = chunk loaded
/******/ 		var installedChunks = {
/******/ 			129: 0
/******/ 		};
/******/ 		
/******/ 		__webpack_require__.f.j = (chunkId, promises) => {
/******/ 				// JSONP chunk loading for javascript
/******/ 				var installedChunkData = __webpack_require__.o(installedChunks, chunkId) ? installedChunks[chunkId] : undefined;
/******/ 				if(installedChunkData !== 0) { // 0 means "already installed".
/******/ 		
/******/ 					// a Promise means "currently loading".
/******/ 					if(installedChunkData) {
/******/ 						promises.push(installedChunkData[2]);
/******/ 					} else {
/******/ 						if(true) { // all chunks have JS
/******/ 							// setup Promise in chunk cache
/******/ 							var promise = new Promise((resolve, reject) => (installedChunkData = installedChunks[chunkId] = [resolve, reject]));
/******/ 							promises.push(installedChunkData[2] = promise);
/******/ 		
/******/ 							// start chunk loading
/******/ 							var url = __webpack_require__.p + __webpack_require__.u(chunkId);
/******/ 							// create error before stack unwound to get useful stacktrace later
/******/ 							var error = new Error();
/******/ 							var loadingEnded = (event) => {
/******/ 								if(__webpack_require__.o(installedChunks, chunkId)) {
/******/ 									installedChunkData = installedChunks[chunkId];
/******/ 									if(installedChunkData !== 0) installedChunks[chunkId] = undefined;
/******/ 									if(installedChunkData) {
/******/ 										var errorType = event && (event.type === 'load' ? 'missing' : event.type);
/******/ 										var realSrc = event && event.target && event.target.src;
/******/ 										error.message = 'Loading chunk ' + chunkId + ' failed.\n(' + errorType + ': ' + realSrc + ')';
/******/ 										error.name = 'ChunkLoadError';
/******/ 										error.type = errorType;
/******/ 										error.request = realSrc;
/******/ 										installedChunkData[1](error);
/******/ 									}
/******/ 								}
/******/ 							};
/******/ 							__webpack_require__.l(url, loadingEnded, "chunk-" + chunkId, chunkId);
/******/ 						}
/******/ 					}
/******/ 				}
/******/ 		};
/******/ 		
/******/ 		// no prefetching
/******/ 		
/******/ 		// no preloaded
/******/ 		
/******/ 		// no HMR
/******/ 		
/******/ 		// no HMR manifest
/******/ 		
/******/ 		// no on chunks loaded
/******/ 		
/******/ 		// install a JSONP callback for chunk loading
/******/ 		var webpackJsonpCallback = (parentChunkLoadingFunction, data) => {
/******/ 			var [chunkIds, moreModules, runtime] = data;
/******/ 			// add "moreModules" to the modules object,
/******/ 			// then flag all "chunkIds" as loaded and fire callback
/******/ 			var moduleId, chunkId, i = 0;
/******/ 			if(chunkIds.some((id) => (installedChunks[id] !== 0))) {
/******/ 				for(moduleId in moreModules) {
/******/ 					if(__webpack_require__.o(moreModules, moduleId)) {
/******/ 						__webpack_require__.m[moduleId] = moreModules[moduleId];
/******/ 					}
/******/ 				}
/******/ 				if(runtime) var result = runtime(__webpack_require__);
/******/ 			}
/******/ 			if(parentChunkLoadingFunction) parentChunkLoadingFunction(data);
/******/ 			for(;i < chunkIds.length; i++) {
/******/ 				chunkId = chunkIds[i];
/******/ 				if(__webpack_require__.o(installedChunks, chunkId) && installedChunks[chunkId]) {
/******/ 					installedChunks[chunkId][0]();
/******/ 				}
/******/ 				installedChunks[chunkId] = 0;
/******/ 			}
/******/ 		
/******/ 		}
/******/ 		
/******/ 		var chunkLoadingGlobal = self["webpackChunklazyfrog"] = self["webpackChunklazyfrog"] || [];
/******/ 		chunkLoadingGlobal.forEach(webpackJsonpCallback.bind(null, 0));
/******/ 		chunkLoadingGlobal.push = webpackJsonpCallback.bind(null, chunkLoadingGlobal.push.bind(chunkLoadingGlobal));
/******/ 	})();
/******/ 	
/************************************************************************/
var __webpack_exports__ = {};

;// ./src/utils/logger.ts
/**
 * Unified logging utility for the AutoSupper extension
 * Logs to both console and optional remote server for debugging
 */
class Logger {
    constructor(context, config) {
        this.config = {
            context,
            remoteLogging: config?.remoteLogging ?? true,
            remoteUrl: config?.remoteUrl ?? 'http://localhost:7856/log',
            consoleLogging: config?.consoleLogging ?? true,
        };
        // Load remote logging setting from storage
        if (typeof chrome !== 'undefined' && chrome.storage) {
            chrome.storage.local.get(['automationConfig'], (result) => {
                if (result.automationConfig?.remoteLogging !== undefined) {
                    this.config.remoteLogging = result.automationConfig.remoteLogging;
                }
            });
            // Listen for changes to remote logging setting
            chrome.storage.onChanged.addListener((changes, areaName) => {
                if (areaName === 'local' &&
                    changes.automationConfig?.newValue?.remoteLogging !== undefined) {
                    this.config.remoteLogging = changes.automationConfig.newValue.remoteLogging;
                }
            });
        }
    }
    /**
     * Send log to remote server
     */
    async sendToRemote(entry) {
        if (!this.config.remoteLogging)
            return;
        try {
            await fetch(this.config.remoteUrl, {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify(entry),
            }).catch(() => {
                // Silently fail if remote server is not available
                // We don't want to break the extension if the debug server is down
            });
        }
        catch (error) {
            // Silently fail
        }
    }
    /**
     * Format message with prefix
     */
    formatMessage(message) {
        return `[${this.config.context}] ${message}`;
    }
    /**
     * Serialize data for logging
     */
    serializeData(data) {
        if (data === undefined)
            return undefined;
        try {
            // Try to stringify and parse to clean up circular references
            return JSON.parse(JSON.stringify(data));
        }
        catch (error) {
            // If that fails, return a string representation
            return String(data);
        }
    }
    /**
     * Core logging function
     */
    logInternal(level, ...args) {
        // Create formatted message for remote logging
        const message = args
            .map((arg) => typeof arg === 'string' ? arg : typeof arg === 'object' ? JSON.stringify(arg) : String(arg))
            .join(' ');
        const entry = {
            timestamp: new Date().toISOString(),
            context: this.config.context,
            level,
            message,
            data: args.length > 1 ? this.serializeData(args.slice(1)) : undefined,
        };
        // Log to console using appropriate method with native object inspection
        if (this.config.consoleLogging) {
            const consoleMethod = console[level] || console.log;
            // Add context prefix but preserve native console behavior
            consoleMethod(`[${this.config.context}]`, ...args);
        }
        // Send to remote server (non-blocking)
        this.sendToRemote(entry);
    }
    /**
     * Public logging methods - support unlimited parameters like console.log()
     */
    log(...args) {
        this.logInternal('log', ...args);
    }
    info(...args) {
        this.logInternal('info', ...args);
    }
    warn(...args) {
        this.logInternal('warn', ...args);
    }
    error(...args) {
        this.logInternal('error', ...args);
    }
    debug(...args) {
        this.logInternal('debug', ...args);
    }
    /**
     * Update logger configuration
     */
    setConfig(config) {
        this.config = { ...this.config, ...config };
    }
    /**
     * Enable/disable remote logging
     */
    setRemoteLogging(enabled) {
        this.config.remoteLogging = enabled;
    }
    /**
     * Enable/disable console logging
     */
    setConsoleLogging(enabled) {
        this.config.consoleLogging = enabled;
    }
}
/**
 * Factory function to create loggers for different contexts
 */
function createLogger(context, config) {
    return new Logger(context, config);
}
/**
 * Pre-configured loggers for each context
 */
const popupLogger = createLogger('POPUP');
const extensionLogger = createLogger('EXT');
const redditLogger = createLogger('REDDIT');
const devvitLogger = createLogger('DEVVIT');
const devvitGIAELogger = createLogger('DEVVIT-GIAE');

// EXTERNAL MODULE: ./src/lib/storage/missions.ts
var missions = __webpack_require__(890);
;// ./src/lib/storage/domUtils.ts
/**
 * DOM-related utility functions for missions
 */
/**
 * Check if mission is cleared by looking for cleared indicators in the DOM
 * Returns the cleared image element if found, null otherwise
 */
function checkMissionClearedInDOM() {
    // Check for cleared image (the cleared/done banner)
    // This image appears when a mission has been cleared
    const clearedImages = Array.from(document.querySelectorAll('img[src*="fxlui9egtgbf1.png"]'));
    return clearedImages.length > 0 ? clearedImages[0] : null;
}

;// ./src/data/enemies.ts
/**
 * Enemy name mappings
 * Maps enemy IDs to their display names
 * Source: autotag userscript
 */
const enemyNames = {
    // Golems
    golemBaby: "Baby Golem",
    golemMountain: "Mountain Golem",
    golemMountainLucky: "Loaded Mountain Golem",
    golemBoar: "Boar Golem",
    woodGolem: "Heartroot Guardian",
    icyWoodGolem: "Frostroot Guardian",
    // Slimes
    slimeKnight: "Slime Knight",
    slimeBigMouth: "Chomp Slime",
    slimeCat: "Cat Slime",
    slimeGems: "Crystal Slime",
    slimeBone: "Bone Slime",
    slimeBoneLucky: "Loaded Bone Slime",
    // Skeletons
    skeleton: "Warrior Skeleton",
    skelNoHead: "Headless Skeleton",
    skelFireHead: "Flaming Skeleton",
    skelIceHead: "Ice Flame Skeleton",
    skelArcher: "Ranger Skeleton",
    skel2Axe: "Barbarian Skeleton",
    skelWizard: "Wizard Skeleton",
    skelGreatSword: "Swordsman Skeleton",
    skelGreatSwordLucky: "Loaded Swordsman Skeleton",
    skelAssassin: "Assassin Skeleton",
    // Mushrooms
    mushroomSmall: "Bitey Shroom",
    mushroomChild: "Shroomkin",
    mushroomFrog: "Sporehead",
    mushroomSoldier: "Sporewarden",
    mushroomSoldierLucky: "Loaded Sporehead",
    mushroomLarge: "Erin-guy",
    mushroomLargeBoss: "Boss Mushroom",
    mushroomMonster: "Sturdy Sporeborn",
    mushroomTeeth: "Mawcap",
    // Dark/Shadow enemies
    cannibal: "Shadowbearer",
    darkBat: "Shadow Wing",
    darkShaman: "Shadowbringer",
    darkChild: "Shadowkin",
    darkBigGuy: "Shadow Brute",
    darkBigGuyLucky: "",
    darkHand: "Arm of Shadow",
    darkWizard: "Shadow Conjurer",
    darkGiantHorns: "Hollowhorn",
    darkWorm: "Shadow Hatchling",
    darkSpider: "Skittering Shadow",
    darkDemon: "Umbral Winged Shadeborn",
    // Wood enemies
    woodOctopus: "Branchclutch",
    woodRoof: "Stumpkin",
    // Robots
    robotNo1: "Y5-Sentry",
    robotNo2: "KRG-01",
    robotNo3: "Gen5-HVY",
    robotNo4: "Medibot-Mark IV",
    robotNo5: "WasteLogic LX-9",
    robotNo5Lucky: "Loaded WasteLogic LX-9",
    robotNo6: "BRX-7 Sentry Chassis",
    robotNo7: "Minifax Model B",
    robotBoss: "Slumbering Guardian-X5",
    // Other
    livingArmor: "Steel Revenant",
};
/**
 * Get enemy display name by ID
 * Returns the ID if no mapping is found
 */
function getEnemyName(enemyId) {
    return enemyNames[enemyId] || enemyId;
}
/**
 * Check if an enemy ID exists
 */
function isKnownEnemy(enemyId) {
    return enemyId in enemyNames;
}

;// ./src/data/maps.ts
/**
 * Map/Environment name mappings
 * Maps environment IDs to their display names
 * Source: autotag userscript
 */
const mapNames = {
    fields: "Fields",
    outer_temple: "Outer Temple",
    forbidden_city: "Forbidden City",
    mossy_forest: "Mossy Forest",
    mountain_pass: "Mountain Pass",
    new_eden: "New Eden",
    ruined_path: "Ruined Path",
    seaside_cliffs: "Seaside Cliffs",
};
/**
 * Get map display name by ID
 * Returns the ID if no mapping is found
 */
function getMapName(mapId) {
    return mapNames[mapId] || mapId;
}
/**
 * Check if a map ID exists
 */
function isKnownMap(mapId) {
    return mapId in mapNames;
}
/**
 * Get all map IDs
 */
function getAllMapIds() {
    return Object.keys(mapNames);
}
/**
 * Get all map display names
 */
function getAllMapNames() {
    return Object.values(mapNames);
}

;// ./src/data/index.ts
/**
 * Game Data Module
 * Centralized location for all game data (enemies, maps, items, etc.)
 */




// EXTERNAL MODULE: ./src/utils/url.ts
var utils_url = __webpack_require__(460);
;// ./src/content/devvit/utils/extractPostIdFromUrl.ts
/**
 * @fileoverview Utility for extracting postId from various URL formats
 *
 * This utility handles different URL structures:
 * - Devvit iframe URLs with context parameter
 * - Devvit iframe URLs with JWT tokens
 * - Legacy Reddit URLs
 */

/**
 * Extract postId from URL as fallback when initialData is missing
 *
 * @param url - The URL to extract the postId from
 * @returns The extracted postId (e.g., "t3_1od6q1h") or null if not found
 *
 * @example
 * ```typescript
 * const url = "https://cabbageidle-eimoap-0-0-50-webview.devvit.net/index.html?context=%7B%22postId%22%3A%22t3_1od6q1h%22%7D";
 * const postId = extractPostIdFromUrl(url);
 * console.log(postId); // "t3_1od6q1h"
 * ```
 *
 * @example
 * ```typescript
 * // JWT token extraction
 * const url = "https://example.devvit.net/index.html?webbit_token=eyJ...";
 * const postId = extractPostIdFromUrl(url);
 * console.log(postId); // "t3_1od6q1h"
 * ```
 */
function extractPostIdFromUrl(url) {
    try {
        // For Devvit iframe URLs, try to extract from context parameter
        // URL format: https://cabbageidle-eimoap-0-0-50-webview.devvit.net/index.html?context=%7B...%7D
        // Stop at & or # to avoid capturing hash fragments
        const contextMatch = url.match(/context=([^&#]+)/);
        if (contextMatch) {
            try {
                const contextJson = decodeURIComponent(contextMatch[1]);
                const context = JSON.parse(contextJson);
                if (context.postId) {
                    console.log('[extractPostIdFromUrl] Extracted postId from context parameter', {
                        postId: context.postId,
                    });
                    return context.postId;
                }
            }
            catch (parseError) {
                console.warn('[extractPostIdFromUrl] Failed to parse context parameter', {
                    error: String(parseError),
                });
                // Try to extract postId directly from the context string as a fallback
                const postIdMatch = contextMatch[1].match(/%22postId%22%3A%22(t3_[^%]+)%22/);
                if (postIdMatch) {
                    console.log('[extractPostIdFromUrl] Extracted postId from context string fallback', {
                        postId: postIdMatch[1],
                    });
                    return postIdMatch[1];
                }
            }
        }
        // Fallback: try to extract from JWT token in webbit_token parameter
        // Stop at & or # to avoid capturing hash fragments
        const tokenMatch = url.match(/webbit_token=([^&#]+)/);
        if (tokenMatch) {
            try {
                // JWT tokens have 3 parts separated by dots
                const tokenParts = tokenMatch[1].split('.');
                if (tokenParts.length === 3) {
                    // Decode the payload (second part)
                    const payload = JSON.parse(atob(tokenParts[1]));
                    if (payload['devvit-post-id']) {
                        console.log('[extractPostIdFromUrl] Extracted postId from JWT token', {
                            postId: payload['devvit-post-id'],
                        });
                        return payload['devvit-post-id'];
                    }
                }
            }
            catch (tokenError) {
                console.warn('[extractPostIdFromUrl] Failed to parse JWT token', {
                    error: String(tokenError),
                });
            }
        }
        // Legacy fallback for Reddit URLs (probably won't work in Devvit iframe)
        const redditMatch = url.match(/\/comments\/([a-zA-Z0-9]+)/);
        if (redditMatch && redditMatch[1]) {
            return (0,utils_url.normalizePostId)(redditMatch[1]);
        }
    }
    catch (error) {
        console.warn('[extractPostIdFromUrl] Failed to extract postId from URL', {
            error: String(error),
        });
    }
    return null;
}

;// ./src/automation/gameInstanceAutomation.ts
/**
 * Simple Button-Clicking Automation
 * No metadata required - just clicks buttons as they appear
 */





const DEFAULT_GIAE_CONFIG = {
    enabled: false,
    abilityTierList: ['IceKnifeOnTurnStart', 'LightningOnCrit', 'HealOnFirstTurn'],
    blessingStatPriority: ['Speed', 'Attack', 'Crit', 'Health', 'Defense', 'Dodge'], // Speed first for faster gameplay
    autoAcceptSkillBargains: true,
    skillBargainStrategy: 'positive-only',
    crossroadsStrategy: 'skip', // Skip mini bosses by default (safer/faster)
    clickDelay: 1000,
};
class GameInstanceAutomationEngine {
    constructor(config) {
        this.intervalId = null;
        this.isProcessing = false;
        this.inCombat = false;
        this.missionMetadata = null;
        this.currentPostId = null;
        // Deep merge config, ensuring arrays are properly preserved
        this.config = {
            ...DEFAULT_GIAE_CONFIG,
            ...config,
            // Ensure arrays are properly set, falling back to defaults if not provided
            abilityTierList: Array.isArray(config.abilityTierList)
                ? config.abilityTierList
                : DEFAULT_GIAE_CONFIG.abilityTierList,
            blessingStatPriority: Array.isArray(config.blessingStatPriority)
                ? config.blessingStatPriority
                : DEFAULT_GIAE_CONFIG.blessingStatPriority,
        };
        this.setupMessageListener();
    }
    /**
     * Emit state change event for UI components
     */
    emitStateChange() {
        window.dispatchEvent(new CustomEvent('SS_AUTOMATION_STATE_CHANGE', {
            detail: this.getState(),
        }));
    }
    /**
     * Broadcast status update to popup
     */
    broadcastStatus(status, missionId, encounter) {
        try {
            chrome.runtime.sendMessage({
                type: 'STATUS_UPDATE',
                status,
                missionId,
                encounter,
            });
        }
        catch (error) {
            // Silently fail if popup is closed
        }
    }
    /**
     * Save mission to Chrome storage database
     * Public so it can be called from content script when initialData is captured early
     */
    async saveMissionToDatabase(postId, username, metadata) {
        try {
            const mission = metadata.mission;
            if (!mission)
                return;
            // Check if mission already exists
            const { getMission } = await Promise.resolve(/* import() */).then(__webpack_require__.bind(__webpack_require__, 890));
            const existingMission = await getMission(postId);
            // Generate tags for the mission
            const tags = this.generateMissionTags(metadata);
            // Build permalink URL from postId (e.g., t3_1obdqvw -> /r/SwordAndSupperGame/comments/1obdqvw/)
            const permalink = postId.startsWith('t3_')
                ? `https://www.reddit.com/r/SwordAndSupperGame/comments/${postId.slice(3)}/`
                : undefined;
            // Use mission author from metadata if available, otherwise use the provided username
            // When enriching, preserve the original author from existing mission
            const missionAuthor = existingMission?.username || metadata.missionAuthorName || username;
            const record = {
                postId,
                username: missionAuthor,
                timestamp: existingMission?.timestamp || Date.now(), // Keep original timestamp if updating
                metadata,
                tags,
                difficulty: mission.difficulty,
                environment: mission.environment,
                minLevel: mission.minLevel,
                maxLevel: mission.maxLevel,
                missionTitle: metadata.missionTitle,
                foodName: mission.foodName,
                permalink,
                cleared: existingMission?.cleared || false, // Preserve cleared status
            };
            await (0,missions/* saveMission */.aB)(record);
            if (existingMission) {
                // Updating existing mission with enriched metadata
                devvitGIAELogger.log('Mission metadata enriched', {
                    postId,
                    difficulty: record.difficulty,
                    environment: record.environment,
                    encounters: mission.encounters?.length,
                    tags,
                    hadMetadataBefore: !!existingMission.metadata,
                });
            }
            else {
                // New mission discovered from playing (not previously scanned)
                devvitGIAELogger.log('🆕 NEW MISSION discovered from gameplay', {
                    postId,
                    difficulty: record.difficulty,
                    environment: record.environment,
                    encounters: mission.encounters?.length,
                    tags,
                    permalink,
                    foodName: mission.foodName,
                });
            }
        }
        catch (error) {
            devvitGIAELogger.error('Failed to save mission', { error: String(error) });
        }
    }
    /**
     * Navigate directly to the next uncleared mission
     * This avoids going back to the listing page
     */
    async navigateToNextMission() {
        try {
            devvitGIAELogger.log('Getting next uncleared mission...');
            // Get filters from storage
            const storageData = await chrome.storage.local.get(['automationFilters']);
            const filters = storageData.automationFilters
                ? {
                    stars: storageData.automationFilters.stars,
                    minLevel: storageData.automationFilters.minLevel,
                    maxLevel: storageData.automationFilters.maxLevel,
                }
                : undefined;
            devvitGIAELogger.log('Using filters', { filters });
            // Dynamically import to avoid circular dependencies
            const { getNextUnclearedMission } = await __webpack_require__.e(/* import() */ 159).then(__webpack_require__.bind(__webpack_require__, 159));
            const nextMission = await getNextUnclearedMission(filters);
            if (nextMission && nextMission.permalink) {
                const { normalizeRedditPermalink } = await Promise.resolve(/* import() */).then(__webpack_require__.bind(__webpack_require__, 460));
                const targetUrl = normalizeRedditPermalink(nextMission.permalink);
                devvitGIAELogger.log('Navigating to next mission', {
                    postId: nextMission.postId,
                    tags: nextMission.tags,
                    permalink: targetUrl,
                });
                this.broadcastStatus('Navigating to mission %missionId%', nextMission.postId);
                // Keep bot session active so automation continues after navigation
                chrome.storage.local.set({
                    activeBotSession: true,
                    automationConfig: this.config,
                });
                // Navigate directly to next mission (avoids listing page reload)
                window.location.href = targetUrl;
            }
            else {
                devvitGIAELogger.log('No more uncleared missions - automation complete!');
                this.broadcastStatus('Idle');
                alert('No more uncleared missions available. Automation stopped.');
                this.stop();
            }
        }
        catch (error) {
            devvitGIAELogger.error('Failed to navigate to next mission', { error: String(error) });
        }
    }
    /**
     * Generate mission tags (same logic as GameControlPanel)
     */
    generateMissionTags(metadata) {
        if (!metadata?.mission)
            return '';
        const mission = metadata.mission;
        const encounters = mission.encounters || [];
        const tags = [];
        // Stars
        tags.push(`${mission.difficulty}*`);
        // Level range
        tags.push(`${mission.minLevel} - ${mission.maxLevel}`);
        // Map name
        if (mission.environment && mapNames[mission.environment]) {
            tags.push(mapNames[mission.environment]);
        }
        // Food name
        if (mission.foodName) {
            tags.push(mission.foodName);
        }
        // Boss rush
        if (mission.type === 'bossRush') {
            tags.push('boss rush');
        }
        // Process encounters
        encounters.forEach((encounter) => {
            if (encounter.type === 'crossroadsFight' && encounter.enemies?.[0]) {
                let minibossTag = `miniboss ${enemyNames[encounter.enemies[0].type] || encounter.enemies[0].type}`;
                if (mission.minLevel > 60) {
                    minibossTag = '2k ' + minibossTag;
                }
                else if (mission.minLevel > 40) {
                    minibossTag = '1k ' + minibossTag;
                }
                tags.push(minibossTag);
            }
            else if ((encounter.type === 'boss' || encounter.type === 'rushBoss') &&
                encounter.enemies?.[0]) {
                tags.push(`${enemyNames[encounter.enemies[0].type] || encounter.enemies[0].type} boss`);
            }
            else if (encounter.type === 'investigate') {
                tags.push('hut');
            }
        });
        return tags.join(' | ');
    }
    /**
     * Listen to window messages for game state
     */
    setupMessageListener() {
        window.addEventListener('message', (event) => {
            try {
                // Log ALL messages to understand what's coming through
                // if (event.data) {
                // 	// Check if this is a devvit-message (the format the game uses)
                // 	const isDevvitMessage = event.data?.type === 'devvit-message';
                // 	const messageType = event.data?.data?.message?.type;
                // 	// Log devvit-messages with more detail
                // 	if (isDevvitMessage) {
                // 		devvitLogger.log('📨 devvit-message received', {
                // 			origin: event.origin,
                // 			messageType: messageType,
                // 			hasMessageData: !!event.data?.data?.message?.data,
                // 			topLevelKeys: Object.keys(event.data).slice(0, 20),
                // 			messageKeys: event.data?.data?.message
                // 				? Object.keys(event.data.data.message).slice(0, 20)
                // 				: [],
                // 			// Include full data for initialData and encounterResult messages
                // 			fullData:
                // 				messageType === 'initialData' ||
                // 				messageType === 'initialDataInn' ||
                // 				messageType === 'encounterResult'
                // 					? event.data
                // 					: undefined,
                // 		});
                // 	}
                // }
                // Check for initialData message (mission metadata)
                // Using the EXACT structure the game uses: event.data.type === "devvit-message"
                if (event.data?.type === 'devvit-message' &&
                    event.data?.data?.message?.type === 'initialData') {
                    this.missionMetadata = event.data.data.message.data?.missionMetadata;
                    const postId = event.data.data.message.data?.postId;
                    const username = event.data.data.message.data?.username;
                    // Store postId for later use (e.g., marking as cleared)
                    this.currentPostId = postId;
                    devvitGIAELogger.log('Mission metadata received', {
                        postId,
                        difficulty: this.missionMetadata?.mission?.difficulty,
                        environment: this.missionMetadata?.mission?.environment,
                        encounters: this.missionMetadata?.mission?.encounters?.length,
                    });
                    // Broadcast status
                    const encounterCount = this.missionMetadata?.mission?.encounters?.length || 0;
                    this.broadcastStatus('Starting mission clearing', postId, {
                        current: 0,
                        total: encounterCount,
                    });
                    // Save mission to database
                    if (this.missionMetadata && postId) {
                        this.saveMissionToDatabase(postId, username, this.missionMetadata);
                    }
                    this.emitStateChange(); // Notify UI
                }
                // Check for combat events
                if (event.data?.type === 'COMBAT_START') {
                    this.inCombat = true;
                    devvitGIAELogger.log('Combat started - pausing button clicks');
                    this.emitStateChange(); // Notify UI
                }
                if (event.data?.type === 'COMBAT_END') {
                    this.inCombat = false;
                    devvitGIAELogger.log('Combat ended - resuming automation');
                    this.emitStateChange(); // Notify UI
                }
                // Check for encounter result with loot (final encounter)
                // Try both possible message structures
                const encounterResult = (event.data?.data?.message?.type === 'encounterResult' && event.data.data.message.data) ||
                    (event.data?.type === 'devvit-message' &&
                        event.data?.data?.message?.type === 'encounterResult' &&
                        event.data.data.message.data);
                if (encounterResult) {
                    devvitGIAELogger.log('Encounter result received', {
                        victory: encounterResult.victory,
                        encounterIndex: encounterResult.encounterAction?.encounterIndex,
                        lootCount: encounterResult.encounterLoot?.length,
                    });
                    // Update status with encounter progress
                    const encounterIndex = encounterResult.encounterAction?.encounterIndex;
                    const encounterCount = this.missionMetadata?.mission?.encounters?.length || 0;
                    if (encounterIndex !== undefined && encounterCount > 0) {
                        this.broadcastStatus('Clearing %missionId% encounter %current% of %total%', this.currentPostId || undefined, {
                            current: encounterIndex + 1,
                            total: encounterCount,
                        });
                    }
                    // If this is a victory and has loot, accumulate it
                    if (encounterResult.victory &&
                        encounterResult.encounterLoot &&
                        encounterResult.encounterLoot.length > 0 &&
                        this.currentPostId) {
                        devvitGIAELogger.log('Accumulating encounter loot', {
                            postId: this.currentPostId,
                            encounterIndex: encounterResult.encounterAction?.encounterIndex,
                            loot: encounterResult.encounterLoot,
                        });
                        (0,missions/* accumulateMissionLoot */.vJ)(this.currentPostId, encounterResult.encounterLoot).catch((error) => {
                            devvitGIAELogger.error('Failed to accumulate mission loot', {
                                error: String(error),
                            });
                        });
                    }
                }
                // Check for mission completion (missionComplete message)
                // Support both message structures
                if (event.data?.data?.message?.type === 'missionComplete' ||
                    (event.data?.type === 'devvit-message' &&
                        event.data?.data?.message?.type === 'missionComplete')) {
                    const postId = event.data.data.message.data?.postId;
                    if (postId) {
                        devvitGIAELogger.log('Mission cleared!', { postId });
                        this.broadcastStatus('Finished mission, waiting');
                        // Notify background which will mark as cleared
                        chrome.runtime.sendMessage({
                            type: 'MISSION_COMPLETED',
                            postId,
                        });
                    }
                }
            }
            catch (error) {
                // Log parsing errors
                devvitGIAELogger.error('Error parsing message', { error: String(error) });
            }
        });
    }
    /**
     * Start the automation loop
     */
    start() {
        if (this.intervalId) {
            devvitGIAELogger.log('Already running');
            return;
        }
        devvitGIAELogger.log('Starting button-clicking automation');
        this.config.enabled = true;
        this.broadcastStatus('Waiting for mission to be ready');
        // Check for buttons every 1500ms (1.5 seconds)
        // This is a fallback since we're not relying on messages
        // Increased from 500ms to reduce performance impact and logs
        this.intervalId = window.setInterval(() => {
            if (this.config.enabled && !this.isProcessing) {
                this.processButtons();
            }
        }, 1500);
    }
    /**
     * Stop the automation loop
     */
    stop() {
        devvitGIAELogger.log('Stopping automation');
        this.config.enabled = false;
        if (this.intervalId) {
            window.clearInterval(this.intervalId);
            this.intervalId = null;
        }
    }
    /**
     * Update configuration
     */
    updateConfig(config) {
        this.config = { ...this.config, ...config };
    }
    /**
     * Get current state
     */
    getState() {
        return {
            enabled: this.config.enabled,
            isProcessing: this.isProcessing,
            inCombat: this.inCombat,
            hasMissionMetadata: !!this.missionMetadata,
            missionMetadata: this.missionMetadata, // Include full metadata
            missionDifficulty: this.missionMetadata?.mission?.difficulty,
            missionEnvironment: this.missionMetadata?.mission?.environment,
        };
    }
    /**
     * Check if mission is cleared by looking for cleared indicators in the DOM
     */
    checkMissionCleared() {
        // Use utility function to check DOM
        const clearedImage = checkMissionClearedInDOM();
        if (clearedImage) {
            devvitGIAELogger.log('Mission cleared detected via DOM (cleared image found)');
            // Get postId - prioritize the one we stored when initialData was received
            const postId = this.currentPostId;
            if (postId) {
                devvitGIAELogger.log('Mission cleared detected, notifying background', { postId });
                // Notify background which will mark as cleared
                chrome.runtime.sendMessage({
                    type: 'MISSION_COMPLETED',
                    postId,
                });
                // DON'T clear currentPostId here - we need it later when clicking Finish button
                // It will be cleared in tryClickContinue after we trigger navigation
            }
            else {
                devvitGIAELogger.warn('Mission appears cleared but no postId available');
            }
        }
    }
    /**
     * Check if player is dead (out of lives)
     * Looks for .lives-container with empty hearts
     */
    checkPlayerDead() {
        const livesContainer = document.querySelector('.lives-container');
        if (!livesContainer) {
            return false; // No lives container means we're not in a mission or lives UI isn't visible
        }
        // Check for empty hearts (Heart_Empty.png)
        const emptyHearts = livesContainer.querySelectorAll('img[src*="Heart_Empty.png"]');
        const totalHearts = livesContainer.querySelectorAll('.liveheart').length;
        // If we have hearts displayed and they're all empty, player is dead
        if (totalHearts > 0 && emptyHearts.length === totalHearts) {
            devvitGIAELogger.log('Player is dead - all hearts empty', {
                totalHearts,
                emptyHearts: emptyHearts.length,
            });
            return true;
        }
        // Also check for "Recover in" text which indicates no lives
        const recoverText = livesContainer.querySelector('.recover-container');
        if (recoverText && recoverText.textContent?.includes('Recover in')) {
            devvitGIAELogger.log('Player is dead - recovery timer found', {
                recoverText: recoverText.textContent,
            });
            return true;
        }
        return false;
    }
    /**
     * Main logic - detect game state first, then click appropriate button
     */
    async processButtons() {
        this.isProcessing = true;
        try {
            // Check if player is dead (out of lives)
            if (this.checkPlayerDead()) {
                devvitGIAELogger.error('Player is dead, stopping automation');
                this.stop();
                chrome.runtime.sendMessage({
                    type: 'ERROR_OCCURRED',
                    message: 'Out of lives - player is dead. Automation stopped.',
                });
                this.isProcessing = false;
                return;
            }
            // Check for mission completion indicators
            this.checkMissionCleared();
            // Skip if in combat (let the battle play out)
            if (this.inCombat) {
                this.isProcessing = false;
                return;
            }
            const buttons = this.findAllButtons();
            if (buttons.length === 0) {
                this.isProcessing = false;
                return;
            }
            // STEP 1: Detect game state based on available buttons
            const gameState = this.detectGameState(buttons);
            // Skip logging for in-progress state (combat happening) to reduce spam
            if (gameState === 'in_progress') {
                this.isProcessing = false;
                return;
            }
            if (gameState === 'unknown') {
                devvitGIAELogger.log('Unknown game state, skipping', {
                    buttonClasses: buttons.map((b) => b.className),
                });
                this.isProcessing = false;
                return;
            }
            // Log actionable states with button info
            devvitGIAELogger.log('Detected game state', {
                state: gameState,
                buttons: buttons.map((b) => `${b.className}: "${b.textContent?.trim()}"`),
                count: buttons.length,
            });
            // STEP 2: Click the appropriate button based on detected state
            const clickedButton = await this.clickForState(gameState, buttons);
            if (clickedButton) {
                devvitGIAELogger.log('Clicked button', {
                    state: gameState,
                    button: clickedButton,
                });
                // Wait before next check
                await this.delay(this.config.clickDelay);
            }
        }
        catch (error) {
            devvitGIAELogger.error('Error processing buttons', { error });
        }
        finally {
            this.isProcessing = false;
        }
    }
    /**
     * Detect current game state based on available buttons
     */
    detectGameState(buttons) {
        const buttonTexts = buttons.map((b) => b.textContent?.trim().toLowerCase() || '');
        const buttonClasses = buttons.map((b) => b.className);
        // Check for Inn Instance - mission was already completed
        // Check both navbar tooltip and battle log welcome message
        const navbarTooltip = document.querySelector('.navbar-tooltip');
        const hasInnTooltip = navbarTooltip?.textContent?.trim() === 'Find and play missions';
        // Check for "Welcome to the Inn!" text in battle log
        const battleLogMessages = document.querySelectorAll('.battle-log-message-inner');
        const hasInnWelcome = Array.from(battleLogMessages).some((msg) => msg.textContent?.includes('Welcome to the Inn!'));
        if (hasInnTooltip || hasInnWelcome) {
            return 'inn';
        }
        // Check for skip button (intro/dialogue)
        if (buttonClasses.some((c) => c.includes('skip-button'))) {
            return 'skip';
        }
        // Check for mission end button (play next) - mission complete
        // This should come before 'continue' check to prioritize mission completion
        // Look for .end-mission-button or button_playnext.png
        const missionEndFooter = document.querySelector('.mission-end-footer');
        if (missionEndFooter) {
            const endButton = missionEndFooter.querySelector('.end-mission-button');
            if (endButton) {
                return 'finish';
            }
        }
        // Fallback: check for button_playnext.png image
        const playNextButton = document.querySelector('img[src*="button_playnext.png"]');
        if (playNextButton) {
            return 'finish';
        }
        // Check for continue button (intermediate screens)
        if (buttonTexts.some((t) => t === 'continue') ||
            buttonClasses.some((c) => c.includes('continue-button'))) {
            return 'continue';
        }
        // Check for crossroads (Fight/Skip mini boss)
        if (buttonTexts.includes('fight') && buttonTexts.includes('skip')) {
            return 'crossroads';
        }
        // Check for skill bargains (Accept/Decline)
        if (buttonTexts.includes('accept') && buttonTexts.includes('decline')) {
            return 'skill_bargain';
        }
        // Check for ability choices (multiple skill buttons)
        if (buttonClasses.filter((c) => c.includes('skill-button')).length > 1) {
            return 'ability_choice';
        }
        // Check for battle/advance buttons
        if (buttonClasses.some((c) => c.includes('advance-button'))) {
            return 'battle';
        }
        // Check for in-progress state (combat happening, showing volume/settings buttons)
        if (buttonClasses.some((c) => c.includes('volume-icon-button') || c.includes('ui-settings-button'))) {
            return 'in_progress';
        }
        return 'unknown';
    }
    /**
     * Click the appropriate button for the detected game state
     */
    async clickForState(state, buttons) {
        switch (state) {
            case 'skip':
                return this.tryClickSkip(buttons);
            case 'finish':
                return await this.tryClickContinue(buttons); // Handles finish button
            case 'continue':
                return await this.tryClickContinue(buttons);
            case 'crossroads':
                return this.tryClickCrossroads(buttons);
            case 'skill_bargain':
                return this.tryClickSkillBargain(buttons);
            case 'ability_choice':
                return this.tryClickAbility(buttons);
            case 'battle':
                return this.tryClickBattle(buttons);
            case 'inn':
                return await this.handleInnState();
            default:
                return null;
        }
    }
    /**
     * Handle inn state - mission was already completed
     * Notify background which will mark it as cleared and find next mission
     */
    async handleInnState() {
        devvitGIAELogger.log('Inn detected - mission was already completed');
        // Get postId from URL or stored value
        let postId = this.currentPostId;
        if (!postId) {
            postId = extractPostIdFromUrl(window.location.href);
            devvitGIAELogger.log('Extracted postId from URL for inn state', { postId });
        }
        if (postId) {
            // Notify background that mission is completed
            // Background will handle marking as cleared and finding next mission
            chrome.runtime.sendMessage({
                type: 'MISSION_COMPLETED',
                postId,
            });
            devvitGIAELogger.log('MISSION_COMPLETED event sent to background', { postId });
        }
        else {
            devvitGIAELogger.error('Cannot handle inn state - no postId available');
        }
        return 'inn-handled';
    }
    /**
     * Find all clickable game buttons (matching working userscript pattern)
     */
    findAllButtons() {
        const buttons = [];
        // Match the working userscript pattern exactly
        // Look for: .advance-button, .skill-button, .skip-button
        const selectors = [
            '.advance-button',
            '.skill-button',
            '.skip-button',
            'button', // Also include regular buttons
        ];
        for (const selector of selectors) {
            const elements = Array.from(document.querySelectorAll(selector));
            for (const element of elements) {
                // For advance-button, check if parent wrapper has button-hidden class
                // If it does, skip this button (it's not clickable yet)
                if (selector === '.advance-button') {
                    const parent = element.parentElement;
                    if (parent && parent.classList.contains('advance-button-wrapper')) {
                        if (parent.classList.contains('button-hidden')) {
                            continue; // Skip hidden advance buttons
                        }
                    }
                }
                // Check if element is visible
                const rect = element.getBoundingClientRect();
                const isVisible = rect.width > 0 && rect.height > 0;
                if (isVisible && !buttons.includes(element)) {
                    buttons.push(element);
                }
            }
        }
        return buttons;
    }
    /**
     * Try to click skip button
     */
    tryClickSkip(buttons) {
        const skipButton = buttons.find((b) => b.classList.contains('skip-button'));
        if (skipButton) {
            this.clickElement(skipButton);
            return 'skip-button';
        }
        return null;
    }
    /**
     * Try to click "Battle" button (or any advance-button)
     */
    tryClickBattle(buttons) {
        // Priority 1: Look for "Battle" text
        let battleButton = buttons.find((b) => b.textContent?.trim().toLowerCase() === 'battle');
        // Priority 2: If no "Battle" text, look for .advance-button class
        if (!battleButton) {
            battleButton = buttons.find((b) => b.classList.contains('advance-button'));
        }
        if (battleButton) {
            this.clickElement(battleButton);
            return battleButton.textContent?.trim() || 'advance-button';
        }
        return null;
    }
    /**
     * Click an element (simple native click like working userscript)
     */
    clickElement(element) {
        // Just use native click - this is what works in the userscript
        element.click();
    }
    /**
     * Try to click crossroads mini boss encounter button (Let's Fight / Skip)
     */
    tryClickCrossroads(buttons) {
        // Look for "Let's Fight" and "Skip" buttons (crossroads encounter)
        const fightButton = buttons.find((b) => {
            const text = b.textContent?.trim().toLowerCase() || '';
            return text.includes("let's fight") || text.includes('fight');
        });
        const skipButton = buttons.find((b) => {
            const text = b.textContent?.trim().toLowerCase() || '';
            // Only match "Skip" in crossroads context (not general skip-button)
            return text === 'skip' && !b.classList.contains('skip-button');
        });
        // Only process if we have both buttons (it's a crossroads encounter)
        if (fightButton && skipButton) {
            if (this.config.crossroadsStrategy === 'fight') {
                this.clickElement(fightButton);
                return `Crossroads: ${fightButton.textContent?.trim()} (fight strategy)`;
            }
            else {
                this.clickElement(skipButton);
                return `Crossroads: ${skipButton.textContent?.trim()} (skip strategy)`;
            }
        }
        return null;
    }
    /**
     * Try to click ability button based on tier list (skill-button class)
     * Also handles blessing stat choices
     */
    tryClickAbility(buttons) {
        // Look for skill buttons
        const skillButtons = buttons.filter((b) => b.classList.contains('skill-button'));
        if (skillButtons.length === 0) {
            return null;
        }
        // Check if this is a blessing encounter (stat choices like "Increase Speed by X%")
        const isBlessing = skillButtons.some((b) => {
            const text = b.textContent?.trim() || '';
            return /Increase (Speed|Attack|Defense|Health|Crit|Dodge) by \d+%/.test(text);
        });
        if (isBlessing) {
            // Handle blessing stat choices based on priority
            // Safety check: ensure blessingStatPriority is an array
            const statPriority = Array.isArray(this.config.blessingStatPriority)
                ? this.config.blessingStatPriority
                : DEFAULT_GIAE_CONFIG.blessingStatPriority;
            for (const stat of statPriority) {
                const blessingButton = skillButtons.find((b) => {
                    const text = b.textContent?.trim() || '';
                    return text.includes(`Increase ${stat}`);
                });
                if (blessingButton) {
                    this.clickElement(blessingButton);
                    return `Blessing: ${blessingButton.textContent?.trim()}`;
                }
            }
        }
        // Look for ability names from our tier list
        // Safety check: ensure abilityTierList is an array
        const abilityList = Array.isArray(this.config.abilityTierList)
            ? this.config.abilityTierList
            : DEFAULT_GIAE_CONFIG.abilityTierList;
        for (const abilityId of abilityList) {
            const abilityButton = skillButtons.find((b) => {
                const text = b.textContent?.trim() || '';
                // Match ability ID or readable name
                return text.includes(abilityId) || this.matchesAbilityName(text, abilityId);
            });
            if (abilityButton) {
                this.clickElement(abilityButton);
                return abilityButton.textContent?.trim() || abilityId;
            }
        }
        // If no preferred ability found, click the first skill button
        if (skillButtons.length > 0) {
            this.clickElement(skillButtons[0]);
            return skillButtons[0].textContent?.trim() || 'skill-button';
        }
        return null;
    }
    /**
     * Try to click skill bargain button (Accept/Decline)
     */
    tryClickSkillBargain(buttons) {
        const acceptButton = buttons.find((b) => b.textContent?.trim().toLowerCase() === 'accept');
        const declineButton = buttons.find((b) => b.textContent?.trim().toLowerCase() === 'decline');
        // Only process if we have both buttons (it's a skill bargain)
        if (acceptButton && declineButton) {
            if (this.config.skillBargainStrategy === 'always') {
                this.clickElement(acceptButton);
                return 'Accept (always strategy)';
            }
            else if (this.config.skillBargainStrategy === 'never') {
                this.clickElement(declineButton);
                return 'Decline (never strategy)';
            }
            else if (this.config.skillBargainStrategy === 'positive-only') {
                // For now, default to accept if auto-accept is enabled
                // TODO: Parse the bargain text to determine if it's positive
                if (this.config.autoAcceptSkillBargains) {
                    this.clickElement(acceptButton);
                    return 'Accept (positive-only strategy - default accept)';
                }
                else {
                    this.clickElement(declineButton);
                    return 'Decline (positive-only strategy - default decline)';
                }
            }
        }
        return null;
    }
    /**
     * Try to click "Continue" or "Finish" button
     */
    async tryClickContinue(buttons) {
        // Check for mission end button (play next) - mission complete
        // Look for .end-mission-button with button_playnext.png
        const missionEndFooter = document.querySelector('.mission-end-footer');
        let finishButton;
        if (missionEndFooter) {
            const endButton = missionEndFooter.querySelector('.end-mission-button');
            if (endButton instanceof HTMLElement) {
                finishButton = endButton;
            }
        }
        // Fallback: look for button_playnext.png in any button
        if (!finishButton) {
            finishButton = buttons.find((b) => {
                const img = b.querySelector('img[src*="button_playnext.png"]');
                return img !== null;
            });
        }
        if (finishButton) {
            this.clickElement(finishButton);
            // Get postId for mission completion
            let postId = this.currentPostId || this.missionMetadata?.postId;
            // Fallback: try to extract postId from URL if still null
            if (!postId) {
                postId = extractPostIdFromUrl(window.location.href);
                devvitGIAELogger.log('Extracted postId from URL as fallback', { postId });
            }
            devvitGIAELogger.log('Finish button clicked, checking postId', {
                currentPostId: this.currentPostId,
                metadataPostId: this.missionMetadata?.postId,
                finalPostId: postId,
            });
            if (postId) {
                devvitGIAELogger.log('Mission cleared! Clicking Finish/Dismiss button', {
                    postId,
                });
                // Notify background that mission is completed
                // Background will mark as cleared and handle finding next mission
                chrome.runtime.sendMessage({
                    type: 'MISSION_COMPLETED',
                    postId,
                });
                // Clear the postId now that background will handle navigation
                this.currentPostId = null;
            }
            else {
                devvitGIAELogger.warn('Finish button clicked but no postId available!', {
                    currentPostId: this.currentPostId,
                    metadataPostId: this.missionMetadata?.postId,
                    hasMissionMetadata: !!this.missionMetadata,
                    url: window.location.href,
                });
            }
            return 'Finish (Mission Complete!)';
        }
        // Then check for "Continue" button
        const continueButton = buttons.find((b) => {
            // Check text content
            const text = b.textContent?.trim().toLowerCase() || '';
            if (text === 'continue')
                return true;
            // Check for continue-button class
            if (b.classList.contains('continue-button'))
                return true;
            // Check for img with alt="Continue"
            const img = b.querySelector('img[alt="Continue"]');
            if (img)
                return true;
            return false;
        });
        if (continueButton) {
            this.clickElement(continueButton);
            return 'Continue';
        }
        return null;
    }
    /**
     * Match ability readable name to ability ID
     */
    matchesAbilityName(buttonText, abilityId) {
        const nameMap = {
            IceKnifeOnTurnStart: ['ice knife', 'iceknife'],
            LightningOnCrit: ['lightning', 'crit lightning'],
            HealOnFirstTurn: ['heal', 'healing', 'first turn heal'],
        };
        const variants = nameMap[abilityId] || [];
        const lowerText = buttonText.toLowerCase();
        return variants.some((variant) => lowerText.includes(variant));
    }
    /**
     * Delay helper
     */
    delay(ms) {
        return new Promise((resolve) => setTimeout(resolve, ms));
    }
}

;// ./src/content/devvit/utils/dom.ts
/**
 * Game DOM utility functions
 * Functions for analyzing, extracting state, and interacting with the game DOM
 */
/**
 * Analyze the game page structure (debug function)
 */
function analyzeGamePage() {
    console.log('[DEVVIT] 📊 Analyzing game page...');
    console.log('[DEVVIT] Document title:', document.title);
    console.log('[DEVVIT] Body HTML (first 1000 chars):', document.body.innerHTML.substring(0, 1000));
    // Look for common game elements
    const buttons = document.querySelectorAll('button');
    console.log('[DEVVIT] Buttons found:', buttons.length);
    buttons.forEach((btn, i) => {
        if (i < 10) {
            console.log(`[DEVVIT] Button ${i}:`, btn.textContent, btn.className);
        }
    });
    // Look for canvas (games often use canvas)
    const canvases = document.querySelectorAll('canvas');
    console.log('[DEVVIT] Canvas elements:', canvases.length);
    // Look for divs that might contain game state
    const allDivs = document.querySelectorAll('div');
    console.log('[DEVVIT] Total divs:', allDivs.length);
    // Look for text that might indicate level/difficulty
    const bodyText = document.body.textContent || '';
    console.log('[DEVVIT] Body contains "level":', bodyText.toLowerCase().includes('level'));
    console.log('[DEVVIT] Body contains "star":', bodyText.toLowerCase().includes('star'));
    console.log('[DEVVIT] Body contains "mission":', bodyText.toLowerCase().includes('mission'));
    // Log all elements with IDs
    const elementsWithIds = document.querySelectorAll('[id]');
    console.log('[DEVVIT] Elements with IDs:', elementsWithIds.length);
    elementsWithIds.forEach((el, i) => {
        if (i < 20) {
            console.log(`[DEVVIT] ID ${i}:`, el.id, el.tagName, el.textContent?.substring(0, 50));
        }
    });
    // Log all elements with classes
    const elementsWithClasses = document.querySelectorAll('[class]');
    console.log('[DEVVIT] Elements with classes (first 20):', elementsWithClasses.length);
    Array.from(elementsWithClasses).slice(0, 20).forEach((el, i) => {
        console.log(`[DEVVIT] Class ${i}:`, el.className, el.tagName, el.textContent?.substring(0, 50));
    });
}
/**
 * Extract game state from the page
 */
function extractGameState() {
    console.log('[DEVVIT] 🔍 Extracting game state...');
    const state = {
        url: window.location.href,
        title: document.title,
        levelInfo: null,
        stars: null,
        buttons: [],
    };
    // Look for level information in the page
    const bodyText = document.body.textContent || '';
    // Try to find level number
    const levelMatch = bodyText.match(/level\s*(\d+)/i);
    if (levelMatch) {
        state.levelInfo = levelMatch[0];
    }
    // Try to find star rating
    const starMatch = bodyText.match(/(\d+)\s*stars?/i);
    if (starMatch) {
        state.stars = parseInt(starMatch[1]);
    }
    // Get all clickable buttons
    const buttons = document.querySelectorAll('button');
    buttons.forEach((btn) => {
        const text = btn.textContent?.trim();
        if (text && text.length < 100) {
            state.buttons.push(text);
        }
    });
    console.log('[DEVVIT] Extracted game state:', state);
    return state;
}
/**
 * Click a button by text content
 */
function clickButton(buttonText) {
    const buttons = Array.from(document.querySelectorAll('button'));
    const targetButton = buttons.find((btn) => btn.textContent?.trim().toLowerCase().includes(buttonText.toLowerCase()));
    if (targetButton) {
        console.log('[DEVVIT] 🖱️ Clicking button:', buttonText);
        targetButton.click();
        return true;
    }
    else {
        console.log('[DEVVIT] ❌ Button not found:', buttonText);
        return false;
    }
}
/**
 * Get all clickable elements
 */
function getClickableElements() {
    const clickable = [];
    // Buttons
    clickable.push(...Array.from(document.querySelectorAll('button')));
    // Links
    clickable.push(...Array.from(document.querySelectorAll('a')));
    // Elements with click handlers
    clickable.push(...Array.from(document.querySelectorAll('[onclick]')));
    return clickable;
}

;// ./src/content/devvit/devvit.tsx
/**
 * Game script - Runs inside the game iframe (*.devvit.net)
 * This is where we interact with the actual Sword & Supper game
 */



devvitLogger.log('Devvit content script loaded', {
    version: "0.11.2",
    buildTime: "2025-10-28T09:33:41.381Z",
    url: window.location.href,
    loadTime: new Date().toISOString(),
});
let gameAutomation = null;
// Set up message listener IMMEDIATELY to catch initialData
// This must be before the game sends the message!
window.addEventListener('message', (event) => {
    try {
        // Check for devvit-message with initialData
        if (event.data?.type === 'devvit-message') {
            const messageType = event.data?.data?.message?.type;
            devvitLogger.log('📨 devvit-message received (early listener)', {
                messageType,
                origin: event.origin,
                hasMessageData: !!event.data?.data?.message?.data,
                timestamp: new Date().toISOString(),
            });
            // If it's initialData, store it for later processing
            if (messageType === 'initialData') {
                const postId = event.data?.data?.message?.data?.postId;
                devvitLogger.log(`✅ initialData for ${postId} captured!`, event.data?.data);
                // Store the data globally so we can access it after automation engine initializes
                window.__capturedInitialData = event.data.data.message.data;
            }
        }
    }
    catch (error) {
        devvitLogger.error('[Devvit] Error in early message listener', { error: String(error) });
    }
});
devvitLogger.log('[Devvit] Early message listener installed');
// ============================================================================
// Extension Context Error Handling
// ============================================================================
/**
 * Safely send message to background script with proper error handling
 */
function safeSendMessage(message, callback) {
    try {
        chrome.runtime.sendMessage(message, (response) => {
            if (chrome.runtime.lastError) {
                const errorMsg = String(chrome.runtime.lastError.message || chrome.runtime.lastError);
                if (errorMsg.includes('Extension context invalidated')) {
                    devvitLogger.log('[ExtensionContext] Extension was updated/reloaded', {
                        error: errorMsg,
                    });
                    // Game iframe - no UI to show notification, just log
                }
                else {
                    devvitLogger.error('[ExtensionContext] Runtime error', { error: errorMsg });
                }
                return;
            }
            if (callback) {
                callback(response);
            }
        });
    }
    catch (error) {
        const errorMsg = String(error);
        if (errorMsg.includes('Extension context invalidated')) {
            devvitLogger.log('[ExtensionContext] Extension was updated/reloaded', { error: errorMsg });
        }
        else {
            devvitLogger.error('[ExtensionContext] Runtime error', { error: errorMsg });
        }
    }
}
// Control panel removed - now using BotControlPanel in reddit context
/**
 * Initialize automation engine
 */
function initializeAutomation() {
    if (gameAutomation) {
        devvitLogger.warn('Automation already initialized');
        return;
    }
    devvitLogger.log('Initializing game instance automation engine');
    // Load config from storage
    chrome.storage.local.get(['automationConfig'], async (result) => {
        const config = result.automationConfig || {};
        // Initialize game instance automation engine
        const giaeConfig = {
            enabled: false, // Will be enabled when user clicks button
            abilityTierList: config.abilityTierList || DEFAULT_GIAE_CONFIG.abilityTierList,
            blessingStatPriority: config.blessingStatPriority || DEFAULT_GIAE_CONFIG.blessingStatPriority,
            autoAcceptSkillBargains: config.autoAcceptSkillBargains !== undefined
                ? config.autoAcceptSkillBargains
                : DEFAULT_GIAE_CONFIG.autoAcceptSkillBargains,
            skillBargainStrategy: config.skillBargainStrategy || DEFAULT_GIAE_CONFIG.skillBargainStrategy,
            crossroadsStrategy: config.crossroadsStrategy || DEFAULT_GIAE_CONFIG.crossroadsStrategy,
            clickDelay: 300,
        };
        gameAutomation = new GameInstanceAutomationEngine(giaeConfig);
        devvitLogger.log('Game instance automation engine initialized');
        devvitLogger.log('Config', { config: giaeConfig });
        // Check if we already captured initialData before the automation engine was ready
        const capturedData = window.__capturedInitialData;
        if (capturedData) {
            devvitLogger.log('[Devvit] Processing previously captured initialData', {
                postId: capturedData.postId,
                username: capturedData.username,
            });
            // Manually trigger the save since the automation engine wasn't listening yet
            const missionMetadata = capturedData.missionMetadata;
            const postId = capturedData.postId;
            const username = capturedData.username;
            if (missionMetadata && postId && gameAutomation) {
                // Save the captured mission data to database
                await gameAutomation.saveMissionToDatabase(postId, username, missionMetadata);
                // IMPORTANT: Also set currentPostId so it's available when mission completes
                // This is normally set by the message listener, but since we captured it early, we need to set it manually
                gameAutomation.currentPostId = postId;
                gameAutomation.missionMetadata = missionMetadata;
                devvitLogger.log('[Devvit] Set currentPostId from captured initialData', { postId });
            }
            // Clear the captured data
            delete window.__capturedInitialData;
        }
        // Notify background script that automation is ready
        safeSendMessage({
            type: 'AUTOMATION_READY',
            config: giaeConfig,
        });
        // Process any pending START_MISSION_AUTOMATION message
        if (pendingStartMessage) {
            devvitLogger.log('Processing queued START_MISSION_AUTOMATION message');
            // Read config from storage and update before starting
            chrome.storage.local.get(['automationConfig'], (result) => {
                if (result.automationConfig) {
                    updateAutomationConfig(result.automationConfig);
                }
                toggleAutomation(true);
            });
            pendingStartMessage = null;
        }
    });
}
/**
 * Toggle automation on/off
 */
function toggleAutomation(enabled) {
    devvitLogger.log('toggleAutomation called', { enabled });
    if (!gameAutomation) {
        devvitLogger.error('Automation not initialized');
        return;
    }
    if (enabled) {
        gameAutomation.start();
        devvitLogger.log('Automation started');
    }
    else {
        gameAutomation.stop();
        devvitLogger.log('Automation stopped');
    }
    devvitLogger.log('Automation state', { state: gameAutomation.getState() });
}
/**
 * Update automation configuration
 */
function updateAutomationConfig(config) {
    if (!gameAutomation) {
        devvitLogger.error('Automation not initialized');
        return;
    }
    const giaeConfig = {
        abilityTierList: config.abilityTierList,
        blessingStatPriority: config.blessingStatPriority,
        autoAcceptSkillBargains: config.autoAcceptSkillBargains,
        skillBargainStrategy: config.skillBargainStrategy,
        crossroadsStrategy: config.crossroadsStrategy,
    };
    gameAutomation.updateConfig(giaeConfig);
    // Save to storage
    chrome.storage.local.set({ automationConfig: config });
}
// Queue for messages received before automation is ready
let pendingStartMessage = null;
// Listen for messages from Chrome extension (via background script)
chrome.runtime.onMessage.addListener((message, sender, sendResponse) => {
    devvitLogger.log(`Received ${message.type} message`, {
        message,
    });
    switch (message.type) {
        case 'START_MISSION_AUTOMATION':
            if (!gameAutomation) {
                // Automation not ready yet, queue the message
                devvitLogger.log('Automation not ready, queuing START_MISSION_AUTOMATION');
                pendingStartMessage = message;
                sendResponse({ success: true, queued: true });
            }
            else {
                // Read config from storage and update before starting
                chrome.storage.local.get(['automationConfig'], (result) => {
                    if (result.automationConfig) {
                        updateAutomationConfig(result.automationConfig);
                    }
                    toggleAutomation(true);
                    sendResponse({ success: true });
                });
                return true; // Will respond asynchronously
            }
            break;
        case 'STOP_MISSION_AUTOMATION':
            toggleAutomation(false);
            sendResponse({ success: true });
            break;
        case 'STATE_CHANGED':
            // Ignore state changes - only reddit-content needs these
            sendResponse({ success: true });
            break;
        default:
            devvitLogger.warn(`Unknown message type: ${message.type}`, { message });
            sendResponse({ error: 'Unknown message type: ' + message.type });
    }
    return true; // Keep channel open for async response
});
// Initial analysis after a delay
setTimeout(() => {
    devvitLogger.log('Running initial game analysis');
    analyzeGamePage();
    extractGameState();
    // Initialize mission automation
    initializeAutomation();
}, 2000);

/******/ })()
;
//# sourceMappingURL=devvit-content.js.map